/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.net.workers;

import java.util.Comparator;
import org.tip.puck.net.workers.NetNodeType;
import org.tip.puck.util.MathUtils;

public class NetNodeTypeComparator
implements Comparator<NetNodeType> {
    private Sorting sorting;

    public NetNodeTypeComparator(Sorting sorting) {
        this.sorting = sorting;
    }

    @Override
    public int compare(NetNodeType alpha, NetNodeType bravo) {
        int result = NetNodeTypeComparator.compare(alpha, bravo, this.sorting);
        return result;
    }

    public static int compare(NetNodeType alpha, NetNodeType bravo, Sorting sorting) {
        int result;
        switch (sorting) {
            default: {
                result = NetNodeTypeComparator.compare(alpha, bravo, Sorting.SCOPE);
                if (result != 0) break;
                result = NetNodeTypeComparator.compare(alpha, bravo, Sorting.RELATION_MODEL_NAME);
                break;
            }
            case SCOPE: {
                result = MathUtils.compare(NetNodeTypeComparator.getScopeOrder(alpha), NetNodeTypeComparator.getScopeOrder(bravo));
                break;
            }
            case RELATION_MODEL_NAME: {
                result = NetNodeTypeComparator.compare(NetNodeTypeComparator.getRelationModelname(alpha), NetNodeTypeComparator.getRelationModelname(bravo));
            }
        }
        return result;
    }

    public static int compare(String alpha, String bravo) {
        int result = alpha == null ? -1 : alpha.compareTo(bravo);
        return result;
    }

    public static String getRelationModelname(NetNodeType source) {
        String result = source == null ? null : source.getRelationModelName();
        return result;
    }

    public static Integer getScopeOrder(NetNodeType source) {
        Integer result = source == null ? null : Integer.valueOf(source.getScope().ordinal());
        return result;
    }

    public static enum Sorting {
        DEFAULT,
        SCOPE,
        RELATION_MODEL_NAME;

    }
}

