/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.geo2;

import java.text.Collator;
import java.util.Comparator;
import org.tip.puck.geo2.Place2;

public class Place2Comparator
implements Comparator<Place2> {
    private Sorting sorting;

    public Place2Comparator() {
        this.sorting = Sorting.DEFAULT;
    }

    public Place2Comparator(Sorting sorting) {
        this.sorting = sorting;
    }

    @Override
    public int compare(Place2 alpha, Place2 bravo) {
        int result = Place2Comparator.compare(alpha, bravo, this.sorting);
        return result;
    }

    public String getLabel(Place2 source) {
        String result = source == null ? null : source.getToponym();
        return result;
    }

    public static int compare(Place2 alpha, Place2 bravo, Sorting sorting) {
        int result;
        if (alpha == null && bravo == null) {
            result = 0;
        } else if (alpha == null) {
            result = -1;
        } else if (bravo == null) {
            result = 1;
        } else {
            switch (sorting) {
                case DEFAULT: 
                case TOPONYM: {
                    result = Place2Comparator.compare(alpha.getToponym(), bravo.getToponym());
                    break;
                }
                default: {
                    result = 0;
                }
            }
        }
        return result;
    }

    public static int compare(String alpha, String bravo) {
        int result = alpha == null && bravo == null ? 0 : (alpha == null ? -1 : (bravo == null ? 1 : Collator.getInstance().compare(alpha, bravo)));
        return result;
    }

    public static enum Sorting {
        DEFAULT,
        TOPONYM;

    }
}

