package org.tip.puck.spacetime.workers;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

import org.tip.puck.geo.GeoLevel;
import org.tip.puck.geo.Geography;
import org.tip.puck.geo.Place;
import org.tip.puck.graphs.Graph;
import org.tip.puck.net.Individual;
import org.tip.puck.net.Individuals;
import org.tip.puck.net.relations.Actor;
import org.tip.puck.net.relations.Actors;
import org.tip.puck.net.relations.Relation;
import org.tip.puck.net.relations.Relations;
import org.tip.puck.net.relations.Roles;
import org.tip.puck.net.workers.IndividualValuator;
import org.tip.puck.partitions.Cluster;
import org.tip.puck.partitions.Partition;
import org.tip.puck.report.ReportTable;
import org.tip.puck.spacetime.EgoRelationSequence;
import org.tip.puck.spacetime.EgoRelationSequences;
import org.tip.puck.spacetime.EventTriangle;
import org.tip.puck.spacetime.Ordinal;
import org.tip.puck.spacetime.Sequence;
import org.tip.puck.util.MathUtils;
import org.tip.puck.util.Value;

/**
 * 
 * @author Klaus Hamberger
 *
 */
public class SequenceWorker {

	public static List<String> getProfileByTypes (EgoRelationSequence source){
		List<String> result;
		
		result = new ArrayList<String>();
		
		for (Relation event : source.getStations().values()){
			result.add(source.getStationType(event));
		}
		
		//
		return result;
	}
	
	private static Map<Individual, Relation> getRelationsByAlter(Individual ego, String modelName, String egoRoleName, String alterRoleName){
		Map<Individual, Relation> result;

		result = new TreeMap<Individual, Relation>();
		
		for (Relation event : ego.relations().getByModelName(modelName)){
			if (event.getRoleNames(ego).contains(egoRoleName)){
				String year = IndividualValuator.extractYear(event.getAttributeValue("DATE"));
				for (Actor actor : event.actors()){
					if (actor.getRole().getName().equals(alterRoleName)){
						Individual alter = actor.getIndividual();
						Relation oldEvent = result.get(alter);
						String oldYear = null;
						if (oldEvent!=null){
							oldYear = IndividualValuator.extractYear(oldEvent.getAttributeValue("DATE"));
						}
						if (oldEvent==null || (year!=null && oldYear!=null && year.compareTo(oldYear)<0)){
							result.put(alter, event);
						}
					}
				}
			}
		}
		
		//
		return result;
	}
	
	public static String order(Relation event, Individual ego){
		String result;
		
		result = "";
		
		for (Actor actor : event.actors().getById(ego.getId())) {
			String order = actor.attributes().getValue("ORDER");
			if (order!=null){
				result = order;
				break;
			}
		}
		//
		return result;
	}
	
	/**
	 * replace by SequenceCensus.getPlaceList
	 * @param source
	 * @param geography
	 * @param level
	 * @return
	 * @deprecated
	 */
	public static List<Place> getPlaceList(EgoRelationSequence source, Geography geography, GeoLevel level){
		List<Place> result;
		
		//
		result = new ArrayList<Place>();
		
		for (Relation relation : source.getStations().values()){
			Place place = geography.getPlace(relation.getAttributeValue("END_PLACE"),level);
			if (place==null){
				place = new Place(level,"UNKNOWN");
			}
			result.add(place);
		}
		//
		return result;
	}
	
	public static String getMovement (List<Place> stations, int i){
		String result;
		
		result = null;
		
		if (i==0){
			result = "ORIGIN";
		} else {
			Place here = stations.get(i);
			Place birth = stations.get(0);
			
			if (here.getName().equals("UNKNOWN")){
				result = "UNKNOWN";
			} else {
				for (int j=i-1;j>-1;j--){
					Place there = stations.get(j);
					if (there!=null && there.equals(here)){
						if (j==i-1){
							continue;
						} else if (j==i-2){
							result = "BACK";
						} else {
							result = "RETURN";
						}
						if (here.equals(birth)){
							result += "ORIGIN";
						}
						break;
					}
				}
			}
		}
		
		if (result==null){
			result = "NEW";
		}
		
		//
		return result;

	}
	
	/**
	 * replace by SequenceCensus setEventTypes
	 * @param source
	 * @param criteria
	 * @deprecated
	 */
/*	public static void setEventTypes (Sequence source, SpaceTimeCriteria criteria){
		
		source.eventTypes = new HashMap<Relation,String>();
		Geography geography = null;
		List<Place> placeList = null;
		
		if (criteria.getType()==EventType.HOST || criteria.getType()==EventType.MIG || criteria.getType()==EventType.HOSTMIG){
			source.setAlters();
			source.setAlterRelations(criteria.getMaxDepths(), criteria.getRelationModelNames());
		} else if (criteria.getType()==EventType.DISTANCE || criteria.getType()==EventType.PLACE || criteria.getType()==EventType.MOVEMENT){
			geography = Geography.getInstance();
			if (criteria.getType()==EventType.MOVEMENT){
				placeList = getPlaceList(source, geography, criteria.getLevel());
			}
		} 

		int i = 0;
		for (Relation event : source.getEvents().values()){
			String type;
			if(event.getAttributeValue("START_PLACE")==null){
				type = "<";
			} else if (event.getAttributeValue("START_PLACE")==null){
				type = ">";
			} else {
				if (criteria.getType()==EventType.HOST){
					type = source.getType(event,"HOST");
				} else if (criteria.getType()==EventType.MIG) {
					type = source.getType(event,"MIG");
				} else if (criteria.getType()==EventType.HOSTMIG) {
					type = source.getType(event,"HOST")+":"+source.getType(event,"MIG");
				} else if (criteria.getType()==EventType.DISTANCE){
					GeoLevel distance = Sequence.getDistance(geography, event);
					if (distance != null){
						type = distance.toString();
					} else {
						type = "UNKNOWN";
					}
				} else if (criteria.getType()==EventType.PLACE){
					Place place = geography.getPlace(event.getAttributeValue("END_PLACE"),criteria.getLevel());
					if (place!=null){
						type = place.getName();
					} else {
						type = "UNKNOWN";
					}
				} else if (criteria.getType()==EventType.MOVEMENT){
					type = getMovement(placeList, i);		
				} else {
					type = null;
				}
			}
			source.eventTypes.put(event, type);
			i++;
			
		}
	}*/
	
	public static double jacquardDistance (Individual alter, Individual ego, String relationModelName, String egoRoleName, String alterRoleName){
		double result;
		
		int totalEvents = 0;
		int totalSharedEvents = 0;
		
		for (Relation event : ego.relations().getByModelName(relationModelName)){
			if (event.getIndividuals(egoRoleName).contains(ego)){
				totalEvents++;
				if (event.getIndividuals(alterRoleName).contains(alter) || ((alterRoleName.equals("ALL") && event.getIndividuals().contains(alter)))){
					totalSharedEvents++;
				}
			}
		}
		for (Relation event : alter.relations().getByModelName(relationModelName)){
			if (event.getIndividuals(alterRoleName).contains(alter) || ((alterRoleName.equals("ALL") && event.getIndividuals().contains(alter)))){
				totalEvents++;
			}
		}
		totalEvents = totalEvents - totalSharedEvents;
		
		result = MathUtils.percent(totalSharedEvents,totalEvents);
				
		//
		return result;
		
	}
	
	public static Partition<EventTriangle> getTriangles(Individuals individuals, String relationModelName){
		Partition<EventTriangle> result;
		
		result = new Partition<EventTriangle>();
		
		String[][] types = new String[][]{{"HOST","MIG"},{"MIG","HOST"},{"MIG","MIG"}};
		
		for (Individual indi1 : individuals){
			for (String[] type1 : types){
				Map<Individual,Relation> events1 = getRelationsByAlter(indi1, relationModelName, type1[0], type1[1]);
				if (events1!=null){
					for (Individual indi2 : events1.keySet()){
						if (indi2.getId()<indi1.getId()){
							for (String[] type2 : types){
								Map<Individual,Relation> events2 = getRelationsByAlter(indi2, relationModelName, type2[0], type2[1]);
								if (events2!=null){
									for (Individual indi3 : events2.keySet()){
										if (indi3==indi1){
											if (!type1[0].equals(type2[1]) || !type1[1].equals(type2[0])){
												EventTriangle dyad = new EventTriangle(new Individual[]{indi1,indi2},new String[][]{type1,type2},new Relation[]{events1.get(indi2), events2.get(indi3)}).sortByYear(); 
												result.put(dyad, new Value(dyad.getRolePattern()));
											}
										} else if (indi3!=indi1 && indi3!=indi2){
											for (String[] type3 : types){
												Map<Individual,Relation> events3 = getRelationsByAlter(indi3,relationModelName, type3[0], type3[1]);
												if (events3!=null && events3.containsKey(indi1)){
													EventTriangle triangle = new EventTriangle(new Individual[]{indi1,indi2,indi3},new String[][]{type1,type2,type3},new Relation[]{events1.get(indi2), events2.get(indi3), events3.get(indi1)}).sortByYear();
													result.put(triangle, new Value(triangle.getRolePattern()));
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
		//
		return result;
	}	
	
	public static Partition<String> getEventPartition (EgoRelationSequences source){
		Partition<String> result;
		
		result = new Partition<String>();
		result.setLabel("Events "+source.getLabel());
		
		for (EgoRelationSequence biography : source){
			for (Relation event : biography.getStations().values()){
				result.put(biography.getEgo().getId()+" "+event.getTypedId(), new Value(biography.getStationType(event)));
			}
		}
		
		//
		return result;
	}
	
	public static Partition<String> getSubsequencePartition (EgoRelationSequences source){
		Partition<String> result;
		
		result = new Partition<String>();
		result.setLabel("Subsequences "+source.getLabel());
		
		for (EgoRelationSequence biography : source){
			String type = null;
			for (Relation event : biography.getStations().values()){
				if (type == null){
					type = biography.getStationType(event);
				} else {
					type += "-"+biography.getStationType(event);
				}
				result.put(biography.getEgo().getId()+" "+event.getTypedId(), new Value(type));
			}
		}
		
		//
		return result;
	}
	
	public static Graph<Cluster<String>> getSequenceNetwork (EgoRelationSequences source, Partition<String> partition){
		Graph<Cluster<String>> result;
		
		if (source == null) {
			throw new IllegalArgumentException("Null parameter detected.");
		} else {
			
			result = new Graph<Cluster<String>>("Network " + source.getLabel());
			
			//
			for (Cluster<String> cluster : partition.getClusters().toListSortedByDescendingSize()) {
				if (!cluster.isNull()) {
					result.addNode(cluster);
				}
			}
			
			//
			for (EgoRelationSequence biography : source){
				Cluster<String> previous = null;
				for (Relation event : biography.getStations().values()){
					Cluster<String> next = partition.getCluster(biography.getEgo().getId()+" "+event.getTypedId());
					if (previous!=null){
						result.incArcWeight(previous, next);
					}
					previous = next;
				}
			}
		}
		
		//
		return result;
	}
	
	public static Partition<String> getSequencePartition (EgoRelationSequences source){
		Partition<String> result;
		
		result = new Partition<String>();
		result.setLabel("Sequences "+source.getLabel());
		
		for (EgoRelationSequence biography : source){
			String previousType = null;
			for (Relation event : biography.getStations().values()){
				if (previousType == null){
					previousType = biography.getStationType(event);
				} else {
					String nextType = biography.getStationType(event);
					result.put(biography.getEgo().getId()+" "+event.getTypedId(), new Value(new String[]{previousType,nextType}));
					previousType = nextType;
				}
			}
		}
		
		
		//
		return result;
	}
	
	
	
	public static EgoRelationSequence getCoherentItinerarySegment (Individual ego, SpaceTimeCriteria criteria){
		EgoRelationSequence result;
		
		int minAge = criteria.getMinAge();
		int maxAge = criteria.getMaxAge();
		
		EgoRelationSequence fullBiography = SequenceMaker.createPersonalSequence(ego, criteria);
		EgoRelationSequence sortedBiography = split(fullBiography).getById(1);
		result = truncate(sortedBiography, minAge, maxAge);

		//
		return result;
	}
	
	public static boolean follows (Relation firstEvent, Relation secondEvent){
		boolean result;
		
		result = false;
		
		if (firstEvent!=null && secondEvent!=null && firstEvent!=secondEvent){
			String arrival = firstEvent.getAttributeValue("END_PLACE");
			String departure = secondEvent.getAttributeValue("START_PLACE");
			String firstDate = firstEvent.getAttributeValue("DATE");
			String secondDate = secondEvent.getAttributeValue("DATE");
			if (firstDate!=null && secondDate!=null && firstDate.compareTo(secondDate)>0) {
				result = false;
			} else {
				result = (arrival !=null && arrival.equals(departure));
			}
		}
		//
		return result;
	}
	
	public static Ordinal getFollowingKey (Ordinal currentKey, EgoRelationSequence itinerary, Set<Ordinal> filter){
		Ordinal result;
		
		result = getFirstKey(itinerary, filter);

		while (result!=null && !follows(itinerary.getStation(currentKey),itinerary.getStation(result))) {
			result = itinerary.getNextFreeTime(result, filter);
		}
		//
		return result;
	}
	
	public static Ordinal getFirstKey (EgoRelationSequence itinerary, Set<Ordinal> keySet){
		Ordinal result;
		
		result = null;
		
		for (Ordinal key : itinerary.getStations().keySet()){
			if (!keySet.contains(key)){
				result = key;
				break;
			}
		}
		//
		return result;
	}
	
	public static EgoRelationSequence truncate (EgoRelationSequence source, int minAge, int maxAge){
		EgoRelationSequence result;
		
		result = new EgoRelationSequence(source.getEgo(),source.getId());
//		result.setEgoRoleName(source.getEgoRoleName());
		
		for (Ordinal key : source.getStations().keySet()){
			Relation event = source.getStation(key);
			if (key.getYear()!=null && source.getEgoAge(key.getYear())>=minAge && source.getEgoAge(key.getYear())<maxAge){
				result.put(key, event);
			}
		}
		
//		result.setAlters();
		
		//
		return result;
	}
	
	public static EgoRelationSequences split (EgoRelationSequence source){
		EgoRelationSequences result;
		
		result = new EgoRelationSequences();
		
		SpaceTimeCriteria criteria = new SpaceTimeCriteria();
				
		EgoRelationSequence partialSequence = new EgoRelationSequence(source.getEgo(),result.size()+1);
//		partialSequence.setEgoRoleName(source.getEgoRoleName());
//		partialSequence.setDateLabel(source.dateLabel());
		
		String previousEndPlace = null;
		
		for (Ordinal key : source.getStations().keySet()){
			
			Relation event = source.getStation(key);
			
			if (previousEndPlace!=null){
				String currentStartPlace = event.getAttributeValue(criteria.getStartPlaceLabel());
				if (!previousEndPlace.equals(currentStartPlace)){
					result.add(partialSequence.clone());
					partialSequence = new EgoRelationSequence(source.getEgo(),result.size()+1); 
//					partialSequence.setEgoRoleName(source.getEgoRoleName());
//					partialSequence.setDateLabel(source.dateLabel());
}
			}
			partialSequence.getStations().put(key, event);

//			partialSequence.putInOrder(event, previousEndPlace, SequenceType.ALL_EVENTS, true, criteria);
			previousEndPlace = event.getAttributeValue(criteria.getEndPlaceLabel());
		}
		result.add(partialSequence);
		
		for (EgoRelationSequence sequence : result){
//			sequence.alters = source.alters;
//			sequence.alterRelations = source.alterRelations;
			sequence.setStationTypes(source.getStationTypes());
		}
		
		//
		return result;
	}

/*	public static Sequences sortAndSplit (Sequence source){
		Sequences result;
		
		result = new Sequences();
				
		Sequence preResult = new Sequence(result.size()+1);
		preResult.setEgo(source.getEgo());
		preResult.setEgoRoleName(source.getEgoRoleName());
		preResult.setDateLabel(source.dateLabel());
		
		Ordinal currentKey = null;
		Relation currentEvent = null;
		Set<Ordinal> sortedKeys = new HashSet<Ordinal>();
		
		for (Ordinal key : source.getEvents().keySet()){
			currentEvent = source.getEvent(key);
			if (currentEvent.getAttributeValue("START_PLACE")==null){
				preResult.putInOrder(currentEvent);
				currentKey = key;
				sortedKeys.add(currentKey);
				break;
			}
		}
		
		while (source.getEvents().size()>sortedKeys.size()) {
			Ordinal nextKey = getFollowingKey(currentKey,source, sortedKeys);
			if (nextKey == null){
				result.add(preResult.clone());
				preResult = new Sequence(result.size()+1); 
				preResult.setEgo(source.getEgo());
				preResult.setEgoRoleName(source.getEgoRoleName());
				nextKey = getFirstKey(source,sortedKeys);
			}
			preResult.putInOrder(source.getEvent(nextKey));
			currentKey = nextKey;
			sortedKeys.add(currentKey);
		}
		result.add(preResult);
		
		for (Sequence sequence : result){
			sequence.alters = source.alters;
			sequence.alterRelations = source.alterRelations;
			sequence.eventTypes = source.eventTypes;
		}
		
		//
		return result;
	}*/
	
	
	public static Relations getCommonEvents (Individual ego, Individual alter, String label){
		Relations result;
		
		Relations egoEvents = ego.relations().getByModelName(label);
		Relations alterEvents = alter.relations().getByModelName(label);
		
		result = new Relations();
		for  (Relation event : egoEvents){
			if (alterEvents.contains(event)){
				result.add(event);
			}
		}
		
		//
		return result;
	}

	static String getStatus(Sequence<Relations> slices, Individual individual, Ordinal time, SpaceTimeCriteria criteria){
			String result;
	
			result = "";
			Relations slice = slices.getStation(time);
			
			if (slice!=null){
	
				Relation relation = null;
				Relations relations = slice.getByIndividual(individual);
				if (relations != null){
					relation = relations.getFirst();
				}
	//			Relation relation = slice.relationsByIndividuals().get(individual);
				
				if (relation!=null){
					
					String idValue = relation.getAttributeValue(criteria.getLocalUnitLabel());
					String placeValue = relation.getAttributeValue(criteria.getPlaceLabel());
	
					if (idValue!=null){
						result += idValue;
					} else if (placeValue!=null){
						result += placeValue;
					}
					
					Actors actors = relation.actors().getById(individual.getId());
					if (actors.size()>0){
	
						Actor actor = actors.get(0);
						
						if (actor.getAttributeValue("MODE")!=null){
							result += " "+actor.getAttributeValue("MODE");
						}
	
						result+="\t";
	
						String startDate = actor.getAttributeValue(criteria.getStartDateLabel());
						String endDate = actor.getAttributeValue(criteria.getEndDateLabel());
						String note = actor.getAttributeValue("NOTE");
						
						if (startDate!=null){
							result += startDate;
						}
						if (endDate!=null){
							result += "-"+endDate;
						}
						if (note!=null){
							result += " ["+note+"]";
						}
					}
				}
			}
			
			//
			return result;
		}

	/**
	 * 
	 * @param partitions
	 * @return
	 */
	public static ReportTable interactionTable(Sequence<Relation> sequence) {
		ReportTable result;
		
		Individuals individuals = sequence.getIndividuals();
	
		//
		result = new ReportTable(individuals.size() + 1, individuals.size() + 1);
	
		//
		{
			result.set(0, 0, sequence.getId());
			int columnIndex = 1;
			for (Individual individual: individuals) {
				result.set(0, columnIndex, individual.getName());
				columnIndex += 1;
			}
	
			//
			int rowIndex = 1;
			for (Individual individual1: individuals) {
				result.set(rowIndex, 0, individual1.getName());
				columnIndex = 1;
				for (Individual individual2: individuals) {
					if (columnIndex>=rowIndex){
						break;
					}
					String roles1AsString = "";
					String roles2AsString = "";
					for (Ordinal time : sequence.getTimes()){
						Relation station = sequence.getStation(time);
						Roles roles1 = station.actors().getRoles(individual1.getId());
						Roles roles2 = station.actors().getRoles(individual2.getId());
						if (roles1 != null && roles1.size()>0 && roles2 != null && roles2.size()>0){
							roles1AsString += roles1.nameList().toString();
							roles2AsString += roles2.nameList().toString();
						}
					}
					result.set(rowIndex, columnIndex, roles1AsString);
					result.set(columnIndex, rowIndex, roles2AsString);
					columnIndex += 1;
				}
				rowIndex += 1;
			}
		}
		//
		return result;
	}

	/**
	 * 
	 * @param partitions
	 * @return
	 */
	public static ReportTable roleTable(Sequence<Relation> sequence) {
		ReportTable result;
		
		Individuals individuals = sequence.getIndividuals();
	
		//
		result = new ReportTable(sequence.getNrStations() + 1, individuals.size() + 1);
	
		//
		{
			result.set(0, 0, sequence.getId());
			int columnIndex = 1;
			for (Individual individual: individuals) {
				result.set(0, columnIndex, individual.getName());
				columnIndex += 1;
			}
	
			//
			int rowIndex = 1;
			for (Ordinal time : sequence.getTimes()) {
				result.set(rowIndex, 0, time);
				columnIndex = 1;
				Relation station = sequence.getStation(time);
				for (Individual individual: individuals) {
					String rolesAsString = " - ";
					Roles roles = station.actors().getRoles(individual.getId());
					if (roles != null && roles.size()>0){
						rolesAsString = roles.nameList().toString();
					}
					result.set(rowIndex, columnIndex, rolesAsString);
					columnIndex += 1;
				}
				rowIndex += 1;
			}
		}
		//
		return result;
	}
	
	

}
