package org.tip.puck.spacetime.workers;

import oldcore.trash.RelationSequence;

import org.tip.puck.PuckException;
import org.tip.puck.net.FiliationType;
import org.tip.puck.net.Individual;
import org.tip.puck.net.Net;
import org.tip.puck.net.relations.Relation;
import org.tip.puck.net.relations.Relations;
import org.tip.puck.net.workers.ExpansionMode;
import org.tip.puck.net.workers.NetUtils;
import org.tip.puck.segmentation.Segmentation;
import org.tip.puck.spacetime.EgoRelationSequence;
import org.tip.puck.spacetime.Ordinal;
import org.tip.puck.spacetime.Sequences;
import org.tip.puck.spacetime.Sequence;
import org.tip.puck.spacetime.SequenceType;
import org.tip.puck.spacetime.EgoRelationSequences;

public class SequenceMaker {


	/**
	 * creates sequence with variable ego roles
	 * @param ego
	 * @return
	 */
	public static EgoRelationSequence createSequence (Individual ego, SpaceTimeCriteria criteria){
		EgoRelationSequence result;
		
		result = new EgoRelationSequence(ego);
//		result.setDateLabel(criteria.getDateLabel());
		
/*		for (Relation relation : ego.relations()){
			if ((relation.getAttributeValue("START_PLACE")==null || relation.getAttributeValue("END_PLACE")==null) && !(relation.getAttributeValue("START_PLACE")==null && relation.getAttributeValue("END_PLACE")==null)){
				continue;
			}
			result.putInOrder(relation);
		}*/
		
		result.putInOrder(ego.relations(), SequenceType.MOVES);

		
		//
		return result;
	}
	
	/**
	 * creates sequence with constant ego role
	 * @param ego
	 * @param criteria
	 * @return
	 */
	public static EgoRelationSequence createPersonalSequence (Individual ego, SpaceTimeCriteria criteria){
		EgoRelationSequence result;
		
		String egoRoleName = criteria.getEgoRoleName();
		
		result = new EgoRelationSequence(ego);
//		result.setEgoRoleName(egoRoleName);
//		result.setDateLabel(criteria.getDateLabel());
		
		Relations relations = new Relations();
		
		for (Relation relation : ego.relations()){
			if (relation.getRoleNames(ego).contains(egoRoleName)){
				relations.add(relation);
			}
		}
		
/*		Collections.sort(list,new EventComparator(criteria));
		for (Relation event : relations){
			result.putInOrder(event);
		}*/
		
		result.putInOrder(relations, SequenceType.EVENTS);

		
//		result.setAlters();
		
		//
		return result;
	}
	
	public static EgoRelationSequences createPersonalSequences (Segmentation segmentation, SpaceTimeCriteria criteria){
		EgoRelationSequences result;
		
		result = new EgoRelationSequences();
		
		for (Individual individual : segmentation.getCurrentIndividuals().toSortedList()){
			result.add(createPersonalSequence(individual, criteria));
		}
		//
		return result;
	}


	/**
	 * creates sequences including life events
	 * @param net
	 * @param segmentation
	 * @return
	 * @throws PuckException
	 */
	public static EgoRelationSequences createBiographies (Net net, Segmentation segmentation, SpaceTimeCriteria criteria) throws PuckException{
		EgoRelationSequences result;
		
		result = new EgoRelationSequences();
		
		net.getFamilyEvents(segmentation);
		
		for (Individual individual : segmentation.getCurrentIndividuals()){
			result.add(createSequence(individual, criteria));
		}
	
		net.removeFamilyEvents();
		
		//
		return result;
		
	}

	/**
	 * create sequence for multiple egos
	 * @param individual
	 * @param criteria
	 * @return
	 */
	public static EgoRelationSequence createExtendedSequence (Individual individual, SpaceTimeCriteria criteria){
		EgoRelationSequence result;
		
		result = new EgoRelationSequence(individual);
//		result.setDateLabel(criteria.getDateLabel());
		
		result.putInOrder(individual.relations(), SequenceType.EVENTS);
		
/*		for (Relation relation : individual.relations()){
			result.putInOrder(relation);
		}*/
		
		ExpansionMode expansionMode = criteria.getExpansionMode();
		FiliationType filiationType = criteria.getFiliationType();

		for (Individual relative : NetUtils.neighbors(individual, expansionMode, filiationType)){
			
/*			for (Relation relation : relative.relations()){
				result.putInOrder(relation);
			}*/
			
			result.putInOrder(relative.relations(), SequenceType.EVENTS);
		}
		
		//
		return result;
	}
	
	public static EgoRelationSequences createExtendedBiographies (Net net, Segmentation segmentation, SpaceTimeCriteria criteria) throws PuckException{
		EgoRelationSequences result;
		
		result = new EgoRelationSequences();
		
		net.getFamilyEvents(segmentation);
		
		for (Individual individual : segmentation.getCurrentIndividuals()){
			result.add(SequenceMaker.createExtendedSequence(individual,criteria));
		}
	
		net.removeFamilyEvents();

		//
		return result;
		
	}
	
	public static Sequences<Relation> createRelationSequences(Segmentation segmentation, SpaceTimeCriteria criteria){
		Sequences<Relation> result;
		
		result = new Sequences<Relation>();
		
		for (Relation relation : segmentation.getCurrentRelations().getByModelName(criteria.getRelationModelName())){
			
			String stringId = relation.getAttributeValue(criteria.getLocalUnitLabel());
			if (stringId != null){
				
				int id = Integer.parseInt(stringId);
				Sequence<Relation> house = result.getById(id);
				if (house == null){
					house = new Sequence<Relation>(criteria.getLocalUnitLabel(), id);
					result.put(house);
				}
				
				String stringTime = relation.getAttributeValue(criteria.getDateLabel());
				if (stringTime != null){
					
					int time = Integer.parseInt(stringTime);
					house.put(new Ordinal(time),relation);

				}
			}
		}
		//
		return result;
	}

	public static Sequence<Relations> createRelationSetSequence(Segmentation segmentation, SpaceTimeCriteria criteria) throws PuckException{
		Sequence<Relations> result;
		
		result = new Sequence<Relations>(criteria.getLocalUnitLabel(),0);
		
		for (int time : criteria.getDates()){
			Relations relations = new Relations();
			relations.setId(time);
			result.put(new Ordinal(time), relations);
		}
	
		for (Relation relation : segmentation.getCurrentRelations().getByModelName(criteria.getRelationModelName()).getByAttribute(criteria.getLocalUnitLabel(), null)){
			
			Integer time = relation.getTime(criteria.getDateLabel());
						
			if (time!=null && result.getTimes().contains(new Ordinal(time))){
	
				result.getStation(new Ordinal(time)).put(relation); 
			}
		}
		
		
		//
		return result;
		
	}		



}
