package org.tip.puck.spacetime;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

import org.tip.puck.net.Attributable;
import org.tip.puck.net.Individual;
import org.tip.puck.net.Individuals;
import org.tip.puck.net.Populatable;
import org.tip.puck.net.relations.Relation;
import org.tip.puck.util.Numberable;
import org.tip.puck.util.NumberablesHashMap;

public class Sequence<E> implements Comparable<Sequence<E>>, Numberable, Sequenceable<E> {
	
	int id;
	Map<Ordinal,E> stations;
	String idLabel;
	private Map<E,String> stationTypes;
	
//	SequenceType type;
	
	public Sequence (){
		this.stations = new TreeMap<Ordinal,E>(); 
	}
	
	public Sequence(String idLabel, int id){
		
		this.stations = new TreeMap<Ordinal,E>(); 
		this.idLabel = idLabel;
		this.id = id;
		
	}

	public int getId() {
		return id;
	}

	public void setId(int id) {
		this.id = id;
	}
	
	public String idLabel() {
		return idLabel;
	}

/*	public void setIdLabel(String idLabel) {
		this.idLabel = idLabel;
	}*/
	
	public E getStation (Ordinal time){
		E result;
		
		if (time!=null){
			result = stations.get(time);
		} else {
			result = null;
		}
		return result;
	}


	@Override
	public String hashKey() {
		return id + "";
	}

	@Override
	public int compareTo(Sequence<E> sequence) {
		return Integer.valueOf(this.id).compareTo(Integer.valueOf(sequence.id));
	}
	
	public Ordinal getFirstTime (){
		Ordinal result;
		
		result = ((TreeMap<Ordinal,E>)stations).firstKey();
		
		//
		return result;
	}
	
	public Ordinal getNextTime (Ordinal key){
		Ordinal result;
		
		if (key!=null){
			result = ((TreeMap<Ordinal,E>)stations).higherKey(key);
		} else {
			result = null;
		}
		//
		return result;
	}
	
	public Ordinal getNextFreeTime (Ordinal key, Set<Ordinal> filter){
		Ordinal result;
		
		if (key!=null){
			result = ((TreeMap<Ordinal,E>)stations).higherKey(key);
			if (result !=null && filter.contains(result)){
				result = getNextFreeTime(result,filter);
			}
		} else {
			result = null;
		}
		//
		return result;
	}
	
	public List<String> getStationTypesAsSortedList(){
		List<String> result;
		
		result = new ArrayList<String>();
		for (String type : getStationTypes().values()){
			if (!result.contains(type)){
				result.add(type);
			}
		}
		Collections.sort(result);
		
		//
		return result;
	}
	
	public String getStationTypesAsString (){
		String result;
		
		result ="";
		boolean first = true;
		List<String> list = getStationTypesAsSortedList();
		
		if (getStationTypes() != null){
			for (String type : list){
				if (first){
					result += type;
					first = false;
				} else {
					result += ";"+type;
				}
			}
		}
		
		//
		return result;
	}
	
	public int getNrStations(){
		return stations.size();
	}
	
	public int getNrStationTypes(){
		int result;
		
		if (getStationTypes() != null){
			result = getStationTypesAsSortedList().size();
		} else {
			result = 0;
		}
		//
		return result;
	}
	
	public String getStationType (E station){
		String result;
		
		result = getStationTypes().get(station);

		//
		return result;
		
	}
	
/*	public Partition<E> getStationTypes (){
		Partition<E> result;
		
		result = new Partition<E>();
		
		for (E station : stations.values()){
			result.put(station, new Value(getStationType(station)));
		}
		
		//
		return result;
	}*/
	
	public Map<Ordinal, E> getStations() {
		return stations;
	}
	
	public void put(Ordinal ordinal, E station){
		stations.put(ordinal, station);
	}
	
	public List<E> toList(){
		List<E> result;
		
		//
		result = new ArrayList<E>(stations.values());
		
		//
		return result;
	}
	
	public String toValueString(){
		String result;
		
		result = "";
		
		for (E value : toList()){
			if (value!=null){
				result += value +" ";
			} else {
				result += "_ ";
			}
		}
		//
		return result;
	}
	
	
	public List<Ordinal> getTimes(){
		List<Ordinal> result;
		
		result = new ArrayList<Ordinal>(stations.keySet());
		Collections.sort(result);
		
		//
		return result;
	}
	
	public List<Integer> getYears(){
		List<Integer> result;
		
		result = new ArrayList<Integer>();
		
		for (Ordinal time : getTimes()){
			if (result.contains(time.getYear())){
				result.add(time.getYear());
			} else {
				System.err.println("Warning: multiple occurence of year "+time.getYear());
			}
		}
		//
		return result;
	}
	
	public String toString(){
		
//		return idLabel+" "+id;
		return id+"";
	}

	public Map<E,String> getStationTypes() {
		return stationTypes;
	}

	public void setStationTypes(Map<E,String> stationTypes) {
		this.stationTypes = stationTypes;
	}
	
	public Individuals getIndividuals(){
		Individuals result;
		
		result = new Individuals();
		
		for (E station : stations.values()){
			
			if (station instanceof Populatable) {
				
				result.add(((Populatable)station).getIndividuals());
			}
		}
		
		//
		return result;
	}
	
	public <V extends Numberable> List<String> idValues(){
		List<String> result;
		
		result = new ArrayList<String>();
		
		for (E station : stations.values()){
			
			if (station instanceof NumberablesHashMap<?>){
				
				for (V stationItem : (NumberablesHashMap<V>)station){
			
					if (stationItem instanceof Attributable){
						
						String idValue = ((Attributable)stationItem).getAttributeValue(idLabel);
						
						if (!result.contains(idValue)){
							result.add(idValue);
						}
					} 
				}
			}
		}
		Collections.sort(result);
		
		//
		return result;
	}
	
	public <V extends Numberable> Map<String,Individuals> membersByRelationId (){
		Map<String,Individuals> result;
		
		result = new TreeMap<String,Individuals>();
		
		for (E station : stations.values()) {
			
			if (station instanceof NumberablesHashMap<?>){
				
				for (V stationItem : (NumberablesHashMap<V>)station){
			
					if (stationItem instanceof Populatable & stationItem instanceof Attributable){
						
						String idValue = ((Attributable)stationItem).getAttributeValue(idLabel);
						
						if (idValue != null){
							Individuals members = result.get(idValue);
							if (members == null){
								members = new Individuals();
								result.put(idValue, members);
							}
							members.add(((Populatable)stationItem).getIndividuals());
						}
					}
				}
			}
		}
		
		//
		return result;
	}
	
	// Unchecked casts
	public <V extends Numberable> Sequences<V> toSequencesByIdValue (){
		Sequences<V> result;
		
		result = new Sequences<V>();
		
		for (Ordinal time : getTimes()){
			
			E station = stations.get(time);

			if (station instanceof NumberablesHashMap<?>){
				
				for (V stationItem : (NumberablesHashMap<V>)station){
					String idValue = ((Attributable)stationItem).getAttributeValue(idLabel);
					
					if (idValue != null){
						Integer id = Integer.parseInt(idValue);
						Sequence<V> sequence = result.getById(id);
						if (sequence==null){
							sequence = new Sequence<V>(idLabel,id);
							// Temporary method, since census methods are gender sensitive (separate index for genders necessary)
//							groupSequence.setEgo(new Individual(id,id+"",Gender.UNKNOWN));
							result.put(sequence);
						}
						sequence.put(time, stationItem);
					}
				}
/*			} else {
				System.err.println("Invalid local unit parameter "+idValue);*/
//				throw PuckExceptions.INVALID_PARAMETER.create("Invalid local unit label.");
			}
		}
		
		//
		return result;
	}
	
	// Unchecked casts
	public <V extends Numberable> EgoRelationSequences toSequencesByEgo (){
		EgoRelationSequences result;
		
		result = new EgoRelationSequences();
		
		for (Ordinal time : getTimes()){
			
			E station = stations.get(time);

			if (station instanceof NumberablesHashMap<?>){
				
				for (V stationItem : (NumberablesHashMap<V>)station){
					
					for (Individual ego: ((Populatable)stationItem).getIndividuals()){
						EgoRelationSequence indiSequence = result.getById(ego.getId());
						if (indiSequence==null){
							indiSequence = new EgoRelationSequence(ego);
							result.put(indiSequence);
						}
						indiSequence.put(time, (Relation)stationItem);
					}
				}
			}
		}
		
		//
		return result;
	}
	


	

}
