package org.tip.puck.net.workers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import oldcore.trash.RelationSet;

import org.tip.puck.census.workers.CensusCriteria;
import org.tip.puck.census.workers.RestrictionType;
import org.tip.puck.census.workers.SymmetryType;
import org.tip.puck.geo.GeoLevel;
import org.tip.puck.geo.Geography;
import org.tip.puck.geo.Place;
import org.tip.puck.net.Attribute;
import org.tip.puck.net.Individual;
import org.tip.puck.net.relations.Relation;
import org.tip.puck.net.relations.Relations;
import org.tip.puck.net.relations.workers.RelationWorker;
import org.tip.puck.segmentation.Segmentation;
import org.tip.puck.spacetime.EgoRelationSequence;
import org.tip.puck.spacetime.workers.SpaceTimeCriteria;
import org.tip.puck.util.NumberedValues;
import org.tip.puck.util.Value;

/**
 * 
 * @author TIP
 */
public class RelationValuator {

	public enum EndogenousLabel {
		ID,
		DISTANCE
	}

	public static final Pattern YEAR_PATTERN = Pattern.compile("(\\d\\d\\d\\d)");

	/**
	 * 
	 * @param source
	 * @return
	 */
	public static String extractYear(final String source) {
		String result;

		Matcher matcher = YEAR_PATTERN.matcher(source);
		if ((matcher.find()) && (matcher.groupCount() > 0)) {
			//
			result = matcher.group(1);
		} else {
			result = null;
		}

		//
		return result;
	}

	/**
	 * 
	 * @param individual
	 * @param label
	 * @return
	 */
	public static Value get(final Relation source, final String label) {
		Value result;

		result = get(source, label, null);

		//
		return result;
	}

	/**
	 * 
	 * @param individual
	 * @param label
	 * 
	 * @return
	 */
	public static Value get(final Relation source, final String label, final Object parameter) {
		Value result;

		//
		EndogenousLabel endogenousLabel;
		try {
			endogenousLabel = EndogenousLabel.valueOf(label.replace(" ", "_"));
		} catch (IllegalArgumentException exception) {
			endogenousLabel = null;
		}

		if (endogenousLabel == null) {
			String attributeValue = source.getAttributeValue(label);

			if (attributeValue == null) {
				result = null;
			} else if (label.toUpperCase().contains("DATE")) {
				String year = extractYear(attributeValue);
				if (year == null) {
					result = null;
				} else {
					result = new Value(Integer.parseInt(year));
				}
				
			} else if (label.toUpperCase().equals("TIME")){
				
				if (source.getAttributeValue("TIME")!=null){
					try {
						result = new Value(Integer.parseInt(source.getAttributeValue("TIME")));
					} catch (NumberFormatException nfe){
						System.err.println("time value is not an integer");
						result = null;
					}
				} else {
					result = null;
				}

			} else if (label.toUpperCase().contains("PLACE")){
				String level;
				if (parameter==null){
					level = "LOCAL";
				} else {
					level = (String)parameter;
				}
				String homonym = source.getAttributeValue(label);
				if (Geography.getInstance()!=null){
					Place place = Geography.getInstance().getPlace(homonym, level);
					if (place == null || place.getName() == null){
						result = null;
					} else {
						result = new Value(place.getName());
					}
				} else {
					result = new Value(attributeValue);
				}
			} else {
				result = new Value(attributeValue);
			}
			
		} else {
			
			switch (endogenousLabel) {
				case ID:
					result = new Value(source.getId());
				break;
				case DISTANCE:
					GeoLevel distance = getDistance(Geography.getInstance(),source);
					if (distance == null) {
						result = null;
					} else {
						result = new Value(distance);
					}
				break;
				default:
					result = null;
			}
		}

		//
		return result;
	}
	
	/**
	 * @param geography
	 * @param event
	 * @return
	 */
	public static GeoLevel getDistance (Geography geography, Relation event){
		GeoLevel result;
		
		result = null;
		
		if (event.getAttributeValue("START_PLACE")!=null && event.getAttributeValue("END_PLACE")!=null){
			Place start = geography.getByHomonym(event.getAttributeValue("START_PLACE"));
			Place end = geography.getByHomonym(event.getAttributeValue("END_PLACE"));
			if (start != null && end != null){
				Place commonAncestor = geography.getCommonAncestor(start, end);
				result = commonAncestor.getLevel();
			}
		}
		
		//
		return result;
	}
	
	// Reduce parameters...
	public static Value get (final Relation relation, final String indicator, final Segmentation segmentation, final SpaceTimeCriteria criteria){
		Value result;
		
		if (indicator.equals("REFERENT_CHAIN")){
			result = new Value(RelationWorker.getReferentChainCensus(relation, criteria.getGroupAffiliationLabel()));
		} else if (indicator.equals("REFERENT_KIN")){
			result = new Value(RelationWorker.getReferentKinCensus(relation, criteria.getPattern(), criteria.getGroupAffiliationLabel()));
		} else if (indicator.equals("ALL_KIN")){
			CensusCriteria censusCriteria = new CensusCriteria();
			censusCriteria.setPattern(criteria.getPattern());
			censusCriteria.setChainClassification(criteria.getChainClassification());
			censusCriteria.setRelationAttributeLabel(criteria.getLocalUnitLabel());
			censusCriteria.setRestrictionType(RestrictionType.ALL);
			censusCriteria.setSymmetryType(SymmetryType.INVERTIBLE);
			censusCriteria.setClosingRelation("TOTAL");
			result = new Value(RelationWorker.getAllKinCensus(segmentation, relation, censusCriteria));
		} else {
			result = null;
		}
		//
		return result;
	}
	
	/**
	 * 
	 * @param individual
	 * @param label
	 * @return
	 */
/*	public static NumberedValues get(final RelationSet slice, final String label, final Object parameter) {
		NumberedValues result;

		//
		result = new NumberedValues();

		for (Individual individual : slice.getIndividuals()) {
			
			result.put(individual.getId(), get(slice.getRelation(individual), label, parameter));
		}

		//
		return result;
	}*/

	/**
	 * Presupposes unique relation by individual
	 * @param individual
	 * @param label
	 * @return
	 */
	public static NumberedValues getByIndividuals(final Relations source, final String label, final Object parameter) {
		NumberedValues result;

		//
		result = new NumberedValues();

		for (Relation relation : source) {
			for (Individual individual : relation.getIndividuals()){
				if (result.containsKey(individual.getId())){
					System.err.println("Multiple relation entries for "+individual);
				}
				result.put(individual.getId(), get(relation, label, parameter));
			}
		}

		//
		return result;
	}



	/**
	 * This method is a helper one.
	 * 
	 * @param individual
	 * @param label
	 * @return
	 */
	public static NumberedValues get(final Relations source, final String label) {
		NumberedValues result;

		result = get(source, label, null);

		//
		return result;
	}

	/**
	 * 
	 * @param individual
	 * @param label
	 * @return
	 */
	public static NumberedValues get(final Relations source, final String label, final Object parameter) {
		NumberedValues result;

		//
		result = new NumberedValues();

		for (Relation relation : source) {
			result.put(relation.getId(), get(relation, label, parameter));
		}

		//
		return result;
	}

	/**
	 * 
	 * @param individuals
	 * @return
	 */
	public static List<String> getAttributeLabels(final Relations source) {
		List<String> result;

		result = getAttributeLabels(source, null);

		//
		return result;
	}

	/**
	 * @param individuals
	 * @return
	 */
	public static List<String> getAttributeLabels(final Relations source, final Integer limit) {
		List<String> result;

		//
		result = new ArrayList<String>(20);

		//
		for (EndogenousLabel label : EndogenousLabel.values()) {
			result.add(label.toString());
		}

		//
		result.addAll(getExogenousAttributeLabels(source, limit));

		//
		Collections.sort(result);

		//
		return result;
	}

	/**
	 * 
	 * @param individuals
	 * @return
	 */
	public static List<String> getAttributeLabelSample(final Relations source) {
		List<String> result;

		result = getAttributeLabels(source, 10000);

		//
		return result;
	}

	/**
	 * @param individuals
	 * @return
	 */
	public static List<String> getExogenousAttributeLabels(final Relations source) {
		List<String> result;

		//
		result = getExogenousAttributeLabels(source, null);

		//
		return result;
	}

	/**
	 * @param individuals
	 * @return
	 */
	public static List<String> getExogenousAttributeLabels(final Relations source, final Integer limit) {
		List<String> result;

		//
		result = new ArrayList<String>(20);

		//
		HashSet<String> buffer = new HashSet<String>();
		if (source != null) {
			int index = 0;
			Iterator<Relation> iterator = source.iterator();
			while ((iterator.hasNext()) && ((limit == null) || (index < limit))) {
				Relation relation = iterator.next();
				for (Attribute attribute : relation.attributes()) {
					buffer.add(attribute.getLabel());
				}
			}
		}

		for (String string : buffer) {
			result.add(string);
		}

		//
		Collections.sort(result);

		//
		return result;
	}

}
