package org.tip.puck.net.relations;

import org.apache.commons.lang3.StringUtils;
import org.tip.puck.net.Individual;

/**
 * 
 * @author TIP
 */
public class RelationModel {

	private String name;
	private Roles roles;
	private RoleDefinitions roleDefinitions;

	/**
	 * 
	 * @param source
	 */
	public RelationModel(final RelationModel source) {
		//
		this.name = source.getName();
		this.roles = new Roles(source.roles());
	}

	/**
	 * 
	 * @param name
	 * @param role
	 */
	public RelationModel(final String name) {
		//
		this.name = name;
		this.roles = new Roles();
	}

	public String getName() {
		return this.name;
	}

	public Role role(final Individual indi) {
		Role result;

		if (indi == null) {
			result = null;
		} else {
			result = this.roles.getByName(indi.getName());
			if (result == null) {
				result = new Role(indi.getName());
				this.roles.add(result);
			}
		}
		//
		return result;
	}

	public Role role(final String item) {
		Role result;

		if (StringUtils.isEmpty(item)) {
			result = null;
		} else {
			String roleName = item.trim();
			result = this.roles.getByName(roleName);
			if (result == null) {
				result = new Role(roleName);
				this.roles.add(result);
			}
		}
		//
		return result;
	}

	public RoleDefinitions roleDefinitions() {
		return this.roleDefinitions;
	}

	public Roles roles() {
		return this.roles;
	}

	public void setName(final String name) {
		this.name = name;
	}

	public void setRoleDefinitions(final RoleDefinitions roleDefinitions) {
		this.roleDefinitions = roleDefinitions;
	}

	@Override
	public String toString() {
		return this.name;
	}

}
