package org.tip.puck.graphs;

import java.util.Map;

import org.tip.puck.matrix.Matrix;
import org.tip.puck.util.Value;

public class GraphMaker {
	
	public static Graph<Node<String>> createGraph(String name, Matrix matrix, Map<Value,Double> vector, String vectorLabel){
		Graph<Node<String>> result;
		
		result = new Graph<Node<String>>(name);
		
		for (int row=0;row<matrix.getRowDim();row++){
			Node<String> node = new Node<String>(row,matrix.getRowLabel(row));
			Double value = vector.get(new Value(matrix.getRowLabel(row)));
			if (value==null){
				node.setAttribute(vectorLabel,"0.");
			} else {
				node.setAttribute(vectorLabel, value+"");
			}
			result.addNode(row,node);
		}
		
		for (int row=0;row<matrix.getRowDim();row++){
			for (int col=0;col<matrix.getRowDim();col++){
				if (matrix.get(row, col) > 0){
					result.addArcWeight(row, col, matrix.get(row,col));
				}
			}
		}

		
		//
		return result;
	}

}
