/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.spacetime.workers;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.tip.puck.geo.GeoLevel;
import org.tip.puck.geo.Geography;
import org.tip.puck.geo.Place;
import org.tip.puck.graphs.Graph;
import org.tip.puck.net.Individual;
import org.tip.puck.net.Individuals;
import org.tip.puck.net.relations.Actor;
import org.tip.puck.net.relations.Actors;
import org.tip.puck.net.relations.Relation;
import org.tip.puck.net.relations.Relations;
import org.tip.puck.net.relations.Roles;
import org.tip.puck.net.workers.IndividualValuator;
import org.tip.puck.partitions.Cluster;
import org.tip.puck.partitions.Partition;
import org.tip.puck.report.ReportTable;
import org.tip.puck.spacetime.EgoRelationSequence;
import org.tip.puck.spacetime.EgoRelationSequences;
import org.tip.puck.spacetime.EventTriangle;
import org.tip.puck.spacetime.Ordinal;
import org.tip.puck.spacetime.Sequence;
import org.tip.puck.spacetime.workers.SequenceMaker;
import org.tip.puck.spacetime.workers.SpaceTimeCriteria;
import org.tip.puck.util.MathUtils;
import org.tip.puck.util.Value;

public class SequenceWorker {
    public static List<String> getProfileByTypes(EgoRelationSequence source) {
        ArrayList<String> result = new ArrayList<String>();
        for (Relation event : source.getStations().values()) {
            result.add(source.getStationType(event));
        }
        return result;
    }

    private static Map<Individual, Relation> getRelationsByAlter(Individual ego, String modelName, String egoRoleName, String alterRoleName) {
        TreeMap<Individual, Relation> result = new TreeMap<Individual, Relation>();
        for (Relation event : ego.relations().getByModelName(modelName)) {
            if (!event.getRoleNames(ego).contains(egoRoleName)) continue;
            String year = IndividualValuator.extractYear(event.getAttributeValue("DATE"));
            for (Actor actor : event.actors()) {
                if (!actor.getRole().getName().equals(alterRoleName)) continue;
                Individual alter = actor.getIndividual();
                Relation oldEvent = (Relation)result.get(alter);
                String oldYear = null;
                if (oldEvent != null) {
                    oldYear = IndividualValuator.extractYear(oldEvent.getAttributeValue("DATE"));
                }
                if (oldEvent != null && (year == null || oldYear == null || year.compareTo(oldYear) >= 0)) continue;
                result.put(alter, event);
            }
        }
        return result;
    }

    public static String order(Relation event, Individual ego) {
        String result = "";
        for (Actor actor : event.actors().getById(ego.getId())) {
            String order = actor.attributes().getValue("ORDER");
            if (order == null) continue;
            result = order;
            break;
        }
        return result;
    }

    public static List<Place> getPlaceList(EgoRelationSequence source, Geography geography, GeoLevel level) {
        ArrayList<Place> result = new ArrayList<Place>();
        for (Relation relation : source.getStations().values()) {
            Place place = geography.getPlace(relation.getAttributeValue("END_PLACE"), level);
            if (place == null) {
                place = new Place(level, "UNKNOWN");
            }
            result.add(place);
        }
        return result;
    }

    public static String getMovement(List<Place> stations, int i) {
        String result = null;
        if (i == 0) {
            result = "ORIGIN";
        } else {
            Place here = stations.get(i);
            Place birth = stations.get(0);
            if (here.getName().equals("UNKNOWN")) {
                result = "UNKNOWN";
            } else {
                int j = i - 1;
                while (j > -1) {
                    Place there = stations.get(j);
                    if (there != null && there.equals(here) && j != i - 1) {
                        result = j == i - 2 ? "BACK" : "RETURN";
                        if (!here.equals(birth)) break;
                        result = String.valueOf(result) + "ORIGIN";
                        break;
                    }
                    --j;
                }
            }
        }
        if (result == null) {
            result = "NEW";
        }
        return result;
    }

    public static double jacquardDistance(Individual alter, Individual ego, String relationModelName, String egoRoleName, String alterRoleName) {
        int totalEvents = 0;
        int totalSharedEvents = 0;
        for (Relation event : ego.relations().getByModelName(relationModelName)) {
            if (!event.getIndividuals(egoRoleName).contains(ego)) continue;
            ++totalEvents;
            if (!event.getIndividuals(alterRoleName).contains(alter) && (!alterRoleName.equals("ALL") || !event.getIndividuals().contains(alter))) continue;
            ++totalSharedEvents;
        }
        for (Relation event : alter.relations().getByModelName(relationModelName)) {
            if (!event.getIndividuals(alterRoleName).contains(alter) && (!alterRoleName.equals("ALL") || !event.getIndividuals().contains(alter))) continue;
            ++totalEvents;
        }
        double result = MathUtils.percent(totalSharedEvents, totalEvents -= totalSharedEvents);
        return result;
    }

    public static Partition<EventTriangle> getTriangles(Individuals individuals, String relationModelName) {
        Partition<EventTriangle> result = new Partition<EventTriangle>();
        String[][] types = new String[][]{{"HOST", "MIG"}, {"MIG", "HOST"}, {"MIG", "MIG"}};
        for (Individual indi1 : individuals) {
            String[][] stringArrayArray = types;
            int n = types.length;
            int n2 = 0;
            while (n2 < n) {
                String[] type1 = stringArrayArray[n2];
                Map<Individual, Relation> events1 = SequenceWorker.getRelationsByAlter(indi1, relationModelName, type1[0], type1[1]);
                if (events1 != null) {
                    for (Individual indi2 : events1.keySet()) {
                        if (indi2.getId() >= indi1.getId()) continue;
                        String[][] stringArrayArray2 = types;
                        int n3 = types.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            String[] type2 = stringArrayArray2[n4];
                            Map<Individual, Relation> events2 = SequenceWorker.getRelationsByAlter(indi2, relationModelName, type2[0], type2[1]);
                            if (events2 != null) {
                                for (Individual indi3 : events2.keySet()) {
                                    if (indi3 == indi1) {
                                        if (type1[0].equals(type2[1]) && type1[1].equals(type2[0])) continue;
                                        EventTriangle dyad = new EventTriangle(new Individual[]{indi1, indi2}, new String[][]{type1, type2}, new Relation[]{events1.get(indi2), events2.get(indi3)}).sortByYear();
                                        result.put(dyad, new Value(dyad.getRolePattern()));
                                        continue;
                                    }
                                    if (indi3 == indi1 || indi3 == indi2) continue;
                                    String[][] stringArrayArray3 = types;
                                    int n5 = types.length;
                                    int n6 = 0;
                                    while (n6 < n5) {
                                        String[] type3 = stringArrayArray3[n6];
                                        Map<Individual, Relation> events3 = SequenceWorker.getRelationsByAlter(indi3, relationModelName, type3[0], type3[1]);
                                        if (events3 != null && events3.containsKey(indi1)) {
                                            EventTriangle triangle = new EventTriangle(new Individual[]{indi1, indi2, indi3}, new String[][]{type1, type2, type3}, new Relation[]{events1.get(indi2), events2.get(indi3), events3.get(indi1)}).sortByYear();
                                            result.put(triangle, new Value(triangle.getRolePattern()));
                                        }
                                        ++n6;
                                    }
                                }
                            }
                            ++n4;
                        }
                    }
                }
                ++n2;
            }
        }
        return result;
    }

    public static Partition<String> getEventPartition(EgoRelationSequences source) {
        Partition<String> result = new Partition<String>();
        result.setLabel("Events " + source.getLabel());
        for (EgoRelationSequence biography : source) {
            for (Relation event : biography.getStations().values()) {
                result.put(String.valueOf(biography.getEgo().getId()) + " " + event.getTypedId(), new Value(biography.getStationType(event)));
            }
        }
        return result;
    }

    public static Partition<String> getSubsequencePartition(EgoRelationSequences source) {
        Partition<String> result = new Partition<String>();
        result.setLabel("Subsequences " + source.getLabel());
        for (EgoRelationSequence biography : source) {
            String type = null;
            for (Relation event : biography.getStations().values()) {
                type = type == null ? biography.getStationType(event) : String.valueOf(type) + "-" + biography.getStationType(event);
                result.put(String.valueOf(biography.getEgo().getId()) + " " + event.getTypedId(), new Value(type));
            }
        }
        return result;
    }

    public static Graph<Cluster<String>> getSequenceNetwork(EgoRelationSequences source, Partition<String> partition) {
        if (source == null) {
            throw new IllegalArgumentException("Null parameter detected.");
        }
        Graph<Cluster<String>> result = new Graph<Cluster<String>>("Network " + source.getLabel());
        for (Cluster<String> cluster : partition.getClusters().toListSortedByDescendingSize()) {
            if (cluster.isNull()) continue;
            result.addNode(cluster);
        }
        for (EgoRelationSequence biography : source) {
            Cluster<String> previous = null;
            for (Relation event : biography.getStations().values()) {
                Cluster<String> next = partition.getCluster(String.valueOf(biography.getEgo().getId()) + " " + event.getTypedId());
                if (previous != null) {
                    result.incArcWeight(previous, next);
                }
                previous = next;
            }
        }
        return result;
    }

    public static Partition<String> getSequencePartition(EgoRelationSequences source) {
        Partition<String> result = new Partition<String>();
        result.setLabel("Sequences " + source.getLabel());
        for (EgoRelationSequence biography : source) {
            String previousType = null;
            for (Relation event : biography.getStations().values()) {
                if (previousType == null) {
                    previousType = biography.getStationType(event);
                    continue;
                }
                String nextType = biography.getStationType(event);
                result.put(String.valueOf(biography.getEgo().getId()) + " " + event.getTypedId(), new Value(new String[]{previousType, nextType}));
                previousType = nextType;
            }
        }
        return result;
    }

    public static EgoRelationSequence getCoherentItinerarySegment(Individual ego, SpaceTimeCriteria criteria) {
        int minAge = criteria.getMinAge();
        int maxAge = criteria.getMaxAge();
        EgoRelationSequence fullBiography = SequenceMaker.createPersonalSequence(ego, criteria);
        EgoRelationSequence sortedBiography = (EgoRelationSequence)SequenceWorker.split(fullBiography).getById(1);
        EgoRelationSequence result = SequenceWorker.truncate(sortedBiography, minAge, maxAge);
        return result;
    }

    public static boolean follows(Relation firstEvent, Relation secondEvent) {
        boolean result = false;
        if (firstEvent != null && secondEvent != null && firstEvent != secondEvent) {
            String arrival = firstEvent.getAttributeValue("END_PLACE");
            String departure = secondEvent.getAttributeValue("START_PLACE");
            String firstDate = firstEvent.getAttributeValue("DATE");
            String secondDate = secondEvent.getAttributeValue("DATE");
            result = firstDate != null && secondDate != null && firstDate.compareTo(secondDate) > 0 ? false : arrival != null && arrival.equals(departure);
        }
        return result;
    }

    public static Ordinal getFollowingKey(Ordinal currentKey, EgoRelationSequence itinerary, Set<Ordinal> filter) {
        Ordinal result = SequenceWorker.getFirstKey(itinerary, filter);
        while (result != null && !SequenceWorker.follows((Relation)itinerary.getStation(currentKey), (Relation)itinerary.getStation(result))) {
            result = itinerary.getNextFreeTime(result, filter);
        }
        return result;
    }

    public static Ordinal getFirstKey(EgoRelationSequence itinerary, Set<Ordinal> keySet) {
        Ordinal result = null;
        for (Ordinal key : itinerary.getStations().keySet()) {
            if (keySet.contains(key)) continue;
            result = key;
            break;
        }
        return result;
    }

    public static EgoRelationSequence truncate(EgoRelationSequence source, int minAge, int maxAge) {
        EgoRelationSequence result = new EgoRelationSequence(source.getEgo(), source.getId());
        for (Ordinal key : source.getStations().keySet()) {
            Relation event = (Relation)source.getStation(key);
            if (key.getYear() == null || source.getEgoAge(key.getYear()) < minAge || source.getEgoAge(key.getYear()) >= maxAge) continue;
            result.put(key, event);
        }
        return result;
    }

    public static EgoRelationSequences split(EgoRelationSequence source) {
        EgoRelationSequences result = new EgoRelationSequences();
        SpaceTimeCriteria criteria = new SpaceTimeCriteria();
        EgoRelationSequence partialSequence = new EgoRelationSequence(source.getEgo(), result.size() + 1);
        String previousEndPlace = null;
        for (Ordinal key : source.getStations().keySet()) {
            String currentStartPlace;
            Relation event = (Relation)source.getStation(key);
            if (previousEndPlace != null && !previousEndPlace.equals(currentStartPlace = event.getAttributeValue(criteria.getStartPlaceLabel()))) {
                result.add(partialSequence.clone());
                partialSequence = new EgoRelationSequence(source.getEgo(), result.size() + 1);
            }
            partialSequence.getStations().put(key, event);
            previousEndPlace = event.getAttributeValue(criteria.getEndPlaceLabel());
        }
        result.add(partialSequence);
        for (EgoRelationSequence sequence : result) {
            sequence.setStationTypes(source.getStationTypes());
        }
        return result;
    }

    public static Relations getCommonEvents(Individual ego, Individual alter, String label) {
        Relations egoEvents = ego.relations().getByModelName(label);
        Relations alterEvents = alter.relations().getByModelName(label);
        Relations result = new Relations();
        for (Relation event : egoEvents) {
            if (!alterEvents.contains(event)) continue;
            result.add(event);
        }
        return result;
    }

    static String getStatus(Sequence<Relations> slices, Individual individual, Ordinal time, SpaceTimeCriteria criteria) {
        String result = "";
        Relations slice = slices.getStation(time);
        if (slice != null) {
            Relation relation = null;
            Relations relations = slice.getByIndividual(individual);
            if (relations != null) {
                relation = (Relation)relations.getFirst();
            }
            if (relation != null) {
                String idValue = relation.getAttributeValue(criteria.getLocalUnitLabel());
                String placeValue = relation.getAttributeValue(criteria.getPlaceLabel());
                if (idValue != null) {
                    result = String.valueOf(result) + idValue;
                } else if (placeValue != null) {
                    result = String.valueOf(result) + placeValue;
                }
                Actors actors = relation.actors().getById(individual.getId());
                if (actors.size() > 0) {
                    Actor actor = (Actor)actors.get(0);
                    if (actor.getAttributeValue("MODE") != null) {
                        result = String.valueOf(result) + " " + actor.getAttributeValue("MODE");
                    }
                    result = String.valueOf(result) + "\t";
                    String startDate = actor.getAttributeValue(criteria.getStartDateLabel());
                    String endDate = actor.getAttributeValue(criteria.getEndDateLabel());
                    String note = actor.getAttributeValue("NOTE");
                    if (startDate != null) {
                        result = String.valueOf(result) + startDate;
                    }
                    if (endDate != null) {
                        result = String.valueOf(result) + "-" + endDate;
                    }
                    if (note != null) {
                        result = String.valueOf(result) + " [" + note + "]";
                    }
                }
            }
        }
        return result;
    }

    public static ReportTable interactionTable(Sequence<Relation> sequence) {
        Individuals individuals = sequence.getIndividuals();
        ReportTable result = new ReportTable(individuals.size() + 1, individuals.size() + 1);
        result.set(0, 0, sequence.getId());
        int columnIndex = 1;
        for (Individual individual : individuals) {
            result.set(0, columnIndex, individual.getName());
            ++columnIndex;
        }
        int rowIndex = 1;
        for (Individual individual1 : individuals) {
            result.set(rowIndex, 0, individual1.getName());
            columnIndex = 1;
            for (Individual individual2 : individuals) {
                if (columnIndex >= rowIndex) break;
                String roles1AsString = "";
                String roles2AsString = "";
                for (Ordinal time : sequence.getTimes()) {
                    Relation station = sequence.getStation(time);
                    Roles roles1 = station.actors().getRoles(individual1.getId());
                    Roles roles2 = station.actors().getRoles(individual2.getId());
                    if (roles1 == null || roles1.size() <= 0 || roles2 == null || roles2.size() <= 0) continue;
                    roles1AsString = String.valueOf(roles1AsString) + roles1.nameList().toString();
                    roles2AsString = String.valueOf(roles2AsString) + roles2.nameList().toString();
                }
                result.set(rowIndex, columnIndex, roles1AsString);
                result.set(columnIndex, rowIndex, roles2AsString);
                ++columnIndex;
            }
            ++rowIndex;
        }
        return result;
    }

    public static ReportTable roleTable(Sequence<Relation> sequence) {
        Individuals individuals = sequence.getIndividuals();
        ReportTable result = new ReportTable(sequence.getNrStations() + 1, individuals.size() + 1);
        result.set(0, 0, sequence.getId());
        int columnIndex = 1;
        for (Individual individual : individuals) {
            result.set(0, columnIndex, individual.getName());
            ++columnIndex;
        }
        int rowIndex = 1;
        for (Ordinal time : sequence.getTimes()) {
            result.set(rowIndex, 0, time);
            columnIndex = 1;
            Relation station = sequence.getStation(time);
            for (Individual individual : individuals) {
                String rolesAsString = " - ";
                Roles roles = station.actors().getRoles(individual.getId());
                if (roles != null && roles.size() > 0) {
                    rolesAsString = roles.nameList().toString();
                }
                result.set(rowIndex, columnIndex, rolesAsString);
                ++columnIndex;
            }
            ++rowIndex;
        }
        return result;
    }
}

