/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.spacetime.workers;

import fr.devinsy.util.StringList;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Stack;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.tip.puck.PuckException;
import org.tip.puck.PuckExceptions;
import org.tip.puck.census.workers.CensusCriteria;
import org.tip.puck.census.workers.RestrictionType;
import org.tip.puck.census.workers.SymmetryType;
import org.tip.puck.geo.GeoLevel;
import org.tip.puck.geo.Geography;
import org.tip.puck.geo.Place;
import org.tip.puck.geo.graphs.GeoNetworkUtils;
import org.tip.puck.geo2.Geography2;
import org.tip.puck.geo2.Place2;
import org.tip.puck.geo2.workers.GeocodingWorker;
import org.tip.puck.graphs.Graph;
import org.tip.puck.graphs.GraphMaker;
import org.tip.puck.graphs.GraphProfile;
import org.tip.puck.graphs.Link;
import org.tip.puck.graphs.Node;
import org.tip.puck.graphs.workers.GraphReporter;
import org.tip.puck.io.paj.PAJFile;
import org.tip.puck.matrix.Matrix;
import org.tip.puck.matrix.MatrixStatistics;
import org.tip.puck.net.Attributable;
import org.tip.puck.net.Attribute;
import org.tip.puck.net.Gender;
import org.tip.puck.net.Individual;
import org.tip.puck.net.IndividualComparator;
import org.tip.puck.net.Individuals;
import org.tip.puck.net.Net;
import org.tip.puck.net.relations.Relation;
import org.tip.puck.net.relations.Relations;
import org.tip.puck.net.relations.workers.RelationWorker;
import org.tip.puck.net.workers.IndividualValuator;
import org.tip.puck.net.workers.NetUtils;
import org.tip.puck.partitions.Cluster;
import org.tip.puck.partitions.Partition;
import org.tip.puck.partitions.PartitionCriteria;
import org.tip.puck.partitions.PartitionMaker;
import org.tip.puck.report.Report;
import org.tip.puck.report.ReportChart;
import org.tip.puck.report.ReportRawData;
import org.tip.puck.report.ReportTable;
import org.tip.puck.segmentation.Segmentation;
import org.tip.puck.spacetime.CorrelationMatrix;
import org.tip.puck.spacetime.EgoRelationSequence;
import org.tip.puck.spacetime.EgoRelationSequences;
import org.tip.puck.spacetime.EventTriangle;
import org.tip.puck.spacetime.Ordinal;
import org.tip.puck.spacetime.Sequence;
import org.tip.puck.spacetime.Sequences;
import org.tip.puck.spacetime.workers.MissingTestimoniesCriteria;
import org.tip.puck.spacetime.workers.SequenceCensus;
import org.tip.puck.spacetime.workers.SequenceMaker;
import org.tip.puck.spacetime.workers.SequenceStatistics;
import org.tip.puck.spacetime.workers.SequenceWorker;
import org.tip.puck.spacetime.workers.SequencesCensus;
import org.tip.puck.spacetime.workers.SpaceTimeCriteria;
import org.tip.puck.spacetime.workers.UnknownPlacesCriteria;
import org.tip.puck.statistics.StatisticsCriteria;
import org.tip.puck.statistics.StatisticsReporter;
import org.tip.puck.util.Chronometer;
import org.tip.puck.util.MathUtils;
import org.tip.puck.util.NumberedValues;
import org.tip.puck.util.PuckUtils;
import org.tip.puck.util.ToolBox;
import org.tip.puck.util.Value;

public class SequenceReporter {
    private static StringList getStories(Relation event) {
        StringList result = new StringList();
        for (Attribute attribute : event.attributes()) {
            String story = "";
            if (!attribute.getLabel().contains("NOTE")) continue;
            String[] label = attribute.getLabel().split("_");
            if (label.length > 1 && StringUtils.isNumeric((CharSequence)label[1])) {
                int id = Integer.parseInt(label[1]);
                Individual indi = (Individual)event.getIndividuals().getById(id);
                story = String.valueOf(story) + indi.signature() + ": ";
            }
            story = String.valueOf(story) + attribute.getValue();
            result.appendln(story);
        }
        return result;
    }

    public static Report reportDiscontinuousItineraries(Segmentation segmentation, SpaceTimeCriteria criteria, ResourceBundle bundle) {
        Chronometer chrono = new Chronometer();
        int errorCount = 0;
        StringList errors = new StringList();
        Report result = new Report();
        result.setTitle("Discontinuous Itineraries");
        result.setOrigin("Control reporter");
        result.setTarget(segmentation.getLabel());
        for (EgoRelationSequence itinerary : SequenceMaker.createPersonalSequences(segmentation, criteria).toSortedList()) {
            EgoRelationSequences partials = SequenceWorker.split(itinerary);
            if (partials.size() <= 1) continue;
            ++errorCount;
            errors.appendln(itinerary.getEgo().signature());
            int j = 0;
            for (EgoRelationSequence partial : partials) {
                if (partial.getStations().size() != 0 && j > 0) {
                    errors.appendln(partial.getFirstTime() + "\t" + partial.getStations().get(partial.getFirstTime()));
                }
                ++j;
            }
            errors.appendln();
        }
        errors.add(0, (Object)(String.valueOf(errorCount) + " " + Report.translate(bundle, "Discontinuous Itineraries") + "\n"));
        result.outputs().append(errors.toString());
        result.setStatus(errorCount);
        result.setTimeSpent(chrono.stop().interval());
        return result;
    }

    public static Report reportUnknownRelations(Segmentation segmentation, SpaceTimeCriteria criteria, ResourceBundle bundle) {
        Chronometer chrono = new Chronometer();
        int errorCount = 0;
        StringList errors = new StringList();
        Report result = new Report();
        result.setTitle("Unknown Relations");
        result.setOrigin("Control reporter");
        result.setTarget(segmentation.getLabel());
        TreeMap<Individual, Individuals> unknownRelations = new TreeMap<Individual, Individuals>();
        for (EgoRelationSequence itinerary : SequenceMaker.createPersonalSequences(segmentation, criteria).toSortedList()) {
            SequenceCensus census = new SequenceCensus(itinerary, criteria);
            for (Individual alter : census.getAllAlters()) {
                if (census.getRelationsByAlter().get(alter).size() != 0) continue;
                Individuals unknowns = (Individuals)unknownRelations.get(itinerary.getEgo());
                if (unknowns == null) {
                    unknowns = new Individuals();
                    unknownRelations.put(itinerary.getEgo(), unknowns);
                }
                unknowns.put(alter);
                ++errorCount;
            }
        }
        errors.add(0, (Object)(String.valueOf(errorCount) + " " + Report.translate(bundle, "Unknown Relations") + "\n"));
        for (Individual ego : unknownRelations.keySet()) {
            for (Individual alter : ((Individuals)unknownRelations.get(ego)).toSortedList()) {
                errors.add((Object)(ego + "\t" + alter + "\n"));
            }
        }
        result.outputs().append(errors.toString());
        result.setStatus(errorCount);
        result.setTimeSpent(chrono.stop().interval());
        return result;
    }

    public static Report reportDiscontinuousBiographies(Net net, Segmentation segmentation, SpaceTimeCriteria criteria, ResourceBundle bundle) throws PuckException {
        Chronometer chrono = new Chronometer();
        int errorCount = 0;
        StringList errors = new StringList();
        Report result = new Report();
        result.setTitle("Discontinuous Itineraries");
        result.setOrigin("Control reporter");
        result.setTarget(segmentation.getLabel());
        for (EgoRelationSequence itinerary : SequenceMaker.createBiographies(net, segmentation, criteria).toSortedList()) {
            EgoRelationSequences partials = SequenceWorker.split(itinerary);
            if (partials.size() <= 1) continue;
            ++errorCount;
            errors.appendln(itinerary.getEgo().signature());
            int j = 0;
            for (EgoRelationSequence partial : partials) {
                if (partial.getStations().size() != 0 && j > 0) {
                    errors.appendln(partial.getFirstTime() + "\t" + partial.getStations().get(partial.getFirstTime()));
                }
                ++j;
            }
            errors.appendln();
        }
        errors.add(0, (Object)(String.valueOf(errorCount) + " " + Report.translate(bundle, "Discontinuous Itineraries") + "\n"));
        result.outputs().append(errors.toString());
        result.setStatus(errorCount);
        result.setTimeSpent(chrono.stop().interval());
        return result;
    }

    public static Report reportMissingTestimonies(Segmentation segmentation, MissingTestimoniesCriteria criteria, ResourceBundle bundle) {
        Chronometer chrono = new Chronometer();
        int errorCount = 0;
        StringList errors = new StringList();
        Report result = new Report();
        result.setTitle("Missing Testimonies");
        result.setOrigin("Control reporter");
        result.setTarget(segmentation.getLabel());
        for (Relation event : segmentation.getCurrentRelations().getByModelName(criteria.getRelationModelName())) {
            for (Individual witness : event.getIndividuals(criteria.getEgoRoleName())) {
                if (!segmentation.getCurrentIndividuals().contains(witness)) continue;
                boolean missing = true;
                for (Attribute attribute : event.attributes()) {
                    if (!attribute.getLabel().contains("NOTE")) continue;
                    String signature = String.valueOf(witness.getId()) + ":";
                    if (!attribute.getValue().contains(signature)) continue;
                    missing = false;
                    break;
                }
                if (!missing) continue;
                ++errorCount;
                errors.appendln(String.valueOf(witness.signature()) + "\t" + event.getTypedId() + "\t" + event.getName());
            }
        }
        errors.add(0, (Object)(String.valueOf(errorCount) + " " + Report.translate(bundle, "Missing Testimonies") + "\n"));
        result.outputs().append(errors.toString());
        result.setStatus(errorCount);
        result.setTimeSpent(chrono.stop().interval());
        return result;
    }

    public static Report reportGeneralSequenceCensus(Segmentation segmentation, SpaceTimeCriteria censusCriteria) throws PuckException {
        Chronometer chrono = new Chronometer();
        Report result = new Report("General ");
        result.setOrigin("Sequence reporter");
        Report overallReport = new Report("Survey");
        Report diagramReport = new Report("Diagrams");
        Report detailReport = new Report("Details");
        ArrayList<ReportChart> charts = new ArrayList<ReportChart>();
        ArrayList<ReportTable> tables = new ArrayList<ReportTable>();
        EgoRelationSequences sequences = new EgoRelationSequences();
        for (Individual ego : segmentation.getCurrentIndividuals().toSortedList()) {
            sequences.addRenumbered(SequenceWorker.getCoherentItinerarySegment(ego, censusCriteria));
        }
        SequencesCensus census = new SequencesCensus(sequences, censusCriteria);
        overallReport.outputs().appendln("Measure\tAverage (Male)\tAverage Pos. (Male)\tMedian (Male)\tMaximum (Male)\tSum (Male)\tAverage (Female)\tAverage Pos. (Female)\tMedian (Female)\tMaximum (Female)\tSum (Female)\tAverage (All)\tAverage Pos. (All)\tMedian (All)\tMaximum (All)\tSum (All)");
        for (String label : censusCriteria.getCensusOperationLabels()) {
            PartitionCriteria partitionCriteria = new PartitionCriteria(label);
            if (label.equals("NREVENTS") || label.contains("NRSTATIONS")) {
                partitionCriteria.setType(PartitionCriteria.PartitionType.FREE_GROUPING);
                partitionCriteria.setIntervals(PartitionMaker.getIntervals("1 5 10 15 20 25"));
            } else if (label.contains("AGEFIRST")) {
                partitionCriteria.setType(PartitionCriteria.PartitionType.SIZED_GROUPING);
                partitionCriteria.setStart(0.0);
                partitionCriteria.setSize(5.0);
            } else if (label.equals("ECCENTRICITY")) {
                partitionCriteria.setType(PartitionCriteria.PartitionType.SIZED_GROUPING);
                partitionCriteria.setStart(-100.0);
                partitionCriteria.setSize(20.0);
            } else if (label.contains("COVERAGE") || label.contains("SAME") || label.contains("NORM") || label.contains("DENSITY") || label.contains("BETWEENNESS") || label.contains("EFFICIENCY") || label.contains("CONCENTRATION")) {
                partitionCriteria.setType(PartitionCriteria.PartitionType.SIZED_GROUPING);
                partitionCriteria.setStart(0.0);
                partitionCriteria.setSize(20.0);
            } else if (label.contains("MEAN") || label.contains("COVERAGE") || label.contains("PEREVENT") || label.contains("BETWEENNESS") || label.contains("BROKERAGE") || label.contains("EFFICIENT_SIZE")) {
                partitionCriteria.setType(PartitionCriteria.PartitionType.SIZED_GROUPING);
                partitionCriteria.setStart(0.0);
                partitionCriteria.setSize(1.0);
            } else {
                partitionCriteria.setType(PartitionCriteria.PartitionType.RAW);
            }
            Object chart = null;
            if (!(label.contains("ALTERS") || label.contains("PROFILE") || label.equals("MEAN_NR_MOVES"))) {
                NumberedValues values = census.getValues(label);
                Partition<Individual> partition = PartitionMaker.create(label, segmentation.getCurrentIndividuals(), values, partitionCriteria);
                PartitionCriteria splitCriteria = new PartitionCriteria(censusCriteria.getPartitionLabel());
                chart = StatisticsReporter.createPartitionChart(partition, partitionCriteria, splitCriteria);
                if (label.substring(0, 3).equals("AGE")) {
                    partitionCriteria.setType(PartitionCriteria.PartitionType.RAW);
                    partitionCriteria.setSizeFilter(PartitionCriteria.SizeFilter.HOLES);
                    partitionCriteria.setValueFilter(PartitionCriteria.ValueFilter.NULL);
                    partition = PartitionMaker.create(label, segmentation.getCurrentIndividuals(), values, partitionCriteria);
                    if (partition.maxValue() != null) {
                        ReportChart survivalChart = StatisticsReporter.createSurvivalChart(partition, splitCriteria);
                        charts.add(survivalChart);
                    } else {
                        System.err.println(String.valueOf(label) + " no max value");
                    }
                }
                NumberedValues[] genderedValues = PuckUtils.getGenderedNumberedValues(values, segmentation.getCurrentIndividuals());
                overallReport.outputs().append(String.valueOf(label) + "\t");
                int gender = 0;
                while (gender < 3) {
                    String sum = "";
                    if (label.startsWith("NR")) {
                        sum = String.valueOf(new Double(genderedValues[gender].sum()).intValue());
                    }
                    overallReport.outputs().append(String.valueOf(MathUtils.round(genderedValues[gender].average(), 2)) + "\t" + MathUtils.round(genderedValues[gender].averagePositives(), 2) + "\t" + values.median() + "\t" + genderedValues[gender].max() + "\t" + sum + "\t");
                    ++gender;
                }
                overallReport.outputs().appendln();
            }
            if (label.equals("MEAN_NR_MOVES")) {
                Map<Value, Double[]> map = census.getMeanNrMoves();
                chart = StatisticsReporter.createMapChart(map, label, new String[]{"MALE", "FEMALE"}, ReportChart.GraphType.STACKED_BARS);
            }
            if (chart == null) continue;
            charts.add((ReportChart)chart);
            ReportTable table = ReportTable.transpose(((ReportChart)chart).createReportTableWithSum());
            tables.add(table);
            if (label.contains("EVENTS_")) continue;
            label.contains("RELATIONS");
        }
        overallReport.outputs().appendln();
        detailReport.outputs().append("Nr\tEgo\tGender");
        for (String partitionLabel : censusCriteria.getCensusOperationLabels()) {
            detailReport.outputs().append("\t" + partitionLabel);
        }
        detailReport.outputs().appendln();
        for (Individual ego : segmentation.getCurrentIndividuals().toSortedList()) {
            if (census.getValues("NREVENTS").get(ego.getId()) == null) continue;
            detailReport.outputs().append(String.valueOf(ego.getId()) + "\t" + ego + "\t" + (Object)((Object)ego.getGender()));
            for (String label : censusCriteria.getCensusOperationLabels()) {
                detailReport.outputs().append("\t" + census.getValues(label).get(ego.getId()));
            }
            detailReport.outputs().appendln();
        }
        int chartIndex = 0;
        while (chartIndex < charts.size()) {
            diagramReport.outputs().append((ReportChart)charts.get(chartIndex));
            if (chartIndex % 4 == 3) {
                diagramReport.outputs().appendln();
            }
            ++chartIndex;
        }
        for (ReportTable table : tables) {
            diagramReport.outputs().appendln(table.getTitle());
            diagramReport.outputs().appendln(table);
        }
        result.outputs().append(overallReport);
        result.outputs().append(diagramReport);
        result.outputs().append(detailReport);
        Map<String, StringList> pajekBuffers = census.getPajekBuffers();
        for (String title : pajekBuffers.keySet()) {
            StringList pajekBuffer = pajekBuffers.get(title);
            if (pajekBuffer.length() == 0) continue;
            File targetFile = ToolBox.setExtension(ToolBox.addToName(new File(segmentation.getLabel()), "-" + title), ".paj");
            ReportRawData rawData = new ReportRawData("Export " + title + "s to Pajek", "Pajek", "paj", targetFile);
            rawData.setData(PAJFile.convertToMicrosoftEndOfLine(pajekBuffer.toString()));
            result.outputs().appendln();
            result.outputs().append(rawData);
        }
        result.setTimeSpent(chrono.stop().interval());
        return result;
    }

    public static Report reportEgoNetworksCensus(Segmentation segmentation, SpaceTimeCriteria censusCriteria) throws PuckException {
        Chronometer chrono = new Chronometer();
        Report result = new Report("Ego Networks");
        result.setOrigin("Sequence reporter");
        Report overallReport = new Report("Survey");
        Report diagramReport = new Report("Diagrams");
        Report detailReport = new Report("Details");
        Report componentReport = null;
        if (censusCriteria.getEgoNetworksOperations().contains((Object)SpaceTimeCriteria.EgoNetworksOperation.COHESION)) {
            componentReport = new Report("Components");
        }
        ArrayList<Object> charts = new ArrayList<Object>();
        ArrayList<ReportTable> tables = new ArrayList<ReportTable>();
        EgoRelationSequences sequences = new EgoRelationSequences();
        for (Individual ego : segmentation.getCurrentIndividuals().toSortedList()) {
            sequences.addRenumbered(SequenceWorker.getCoherentItinerarySegment(ego, censusCriteria));
        }
        SequencesCensus census = new SequencesCensus(sequences, censusCriteria);
        overallReport.outputs().appendln("Measure\tAverage (Male)\tAverage Pos. (Male)\tMedian (Male)\tMaximum (Male)\tSum (Male)\tAverage (Female)\tAverage Pos. (Female)\tMedian (Female)\tMaximum (Female)\tSum (Female)\tAverage (All)\tAverage Pos. (All)\tMedian (All)\tMaximum (All)\tSum (All)");
        for (String label : censusCriteria.getCensusOperationLabels()) {
            PartitionCriteria partitionCriteria = new PartitionCriteria(label);
            if (label.equals("NREVENTS")) {
                partitionCriteria.setType(PartitionCriteria.PartitionType.RAW);
            } else if (label.contains("AGEFIRST")) {
                partitionCriteria.setType(PartitionCriteria.PartitionType.SIZED_GROUPING);
                partitionCriteria.setStart(0.0);
                partitionCriteria.setSize(5.0);
            } else if (label.equals("ECCENTRICITY")) {
                partitionCriteria.setType(PartitionCriteria.PartitionType.SIZED_GROUPING);
                partitionCriteria.setStart(-100.0);
                partitionCriteria.setSize(20.0);
            } else if (label.contains("COVERAGE") || label.contains("SAME") || label.contains("NORM") || label.contains("DENSITY") || label.contains("BETWEENNESS") || label.contains("EFFICIENCY") || label.contains("CONCENTRATION")) {
                partitionCriteria.setType(PartitionCriteria.PartitionType.SIZED_GROUPING);
                partitionCriteria.setStart(0.0);
                partitionCriteria.setSize(20.0);
            } else if (label.contains("MEAN") || label.contains("COVERAGE") || label.contains("PEREVENT") || label.contains("BETWEENNESS") || label.contains("BROKERAGE") || label.contains("EFFICIENT_SIZE")) {
                partitionCriteria.setType(PartitionCriteria.PartitionType.SIZED_GROUPING);
                partitionCriteria.setStart(0.0);
                partitionCriteria.setSize(1.0);
            } else {
                partitionCriteria.setType(PartitionCriteria.PartitionType.RAW);
            }
            Iterator<String> chart = null;
            if (!label.contains("ALTERS") && !label.contains("PROFILE")) {
                NumberedValues values = census.getValues(label);
                Object partition = PartitionMaker.create(label, segmentation.getCurrentIndividuals(), values, partitionCriteria);
                PartitionCriteria splitCriteria = new PartitionCriteria(censusCriteria.getPartitionLabel());
                chart = StatisticsReporter.createPartitionChart(partition, partitionCriteria, splitCriteria);
                if (label.substring(0, 3).equals("AGE")) {
                    partitionCriteria.setType(PartitionCriteria.PartitionType.RAW);
                    partitionCriteria.setSizeFilter(PartitionCriteria.SizeFilter.HOLES);
                    partitionCriteria.setValueFilter(PartitionCriteria.ValueFilter.NULL);
                    partition = PartitionMaker.create(label, segmentation.getCurrentIndividuals(), values, partitionCriteria);
                    if (((Partition)partition).maxValue() != null) {
                        ReportChart survivalChart = StatisticsReporter.createSurvivalChart(partition, splitCriteria);
                        charts.add(survivalChart);
                    } else {
                        System.err.println(String.valueOf(label) + " no max value");
                    }
                }
                NumberedValues[] genderedValues = PuckUtils.getGenderedNumberedValues(values, segmentation.getCurrentIndividuals());
                overallReport.outputs().append(String.valueOf(label) + "\t");
                int gender = 0;
                while (gender < 3) {
                    String sum = "";
                    if (label.startsWith("NR")) {
                        sum = String.valueOf(new Double(genderedValues[gender].sum()).intValue());
                    }
                    overallReport.outputs().append(String.valueOf(MathUtils.round(genderedValues[gender].average(), 2)) + "\t" + MathUtils.round(genderedValues[gender].averagePositives(), 2) + "\t" + values.median() + "\t" + genderedValues[gender].max() + "\t" + sum + "\t");
                    ++gender;
                }
                overallReport.outputs().appendln();
            }
            if (chart == null) continue;
            charts.add(chart);
            ReportTable table = ReportTable.transpose(((ReportChart)((Object)chart)).createReportTableWithSum());
            tables.add(table);
            if (label.contains("EVENTS_")) continue;
            label.contains("RELATIONS");
        }
        overallReport.outputs().appendln();
        detailReport.outputs().append("Nr\tEgo\tGender");
        for (String partitionLabel : censusCriteria.getCensusOperationLabels()) {
            detailReport.outputs().append("\t" + partitionLabel);
        }
        TreeMap componentChartMaps = new TreeMap();
        TreeMap componentChartSizeMaps = new TreeMap();
        for (String networkTitle : censusCriteria.getNetworkTitles()) {
            componentChartMaps.put(networkTitle, new TreeMap());
            componentChartSizeMaps.put(networkTitle, new TreeMap());
        }
        detailReport.outputs().appendln();
        for (Individual ego : segmentation.getCurrentIndividuals().toSortedList()) {
            if (census.getValues("SIZE").get(ego.getId()) != null) {
                detailReport.outputs().append(String.valueOf(ego.getId()) + "\t" + ego + "\t" + (Object)((Object)ego.getGender()));
                for (String label : censusCriteria.getCensusOperationLabels()) {
                    detailReport.outputs().append("\t" + census.getValues(label).get(ego.getId()));
                }
                detailReport.outputs().appendln();
            }
            if (!censusCriteria.getEgoNetworksOperations().contains((Object)SpaceTimeCriteria.EgoNetworksOperation.COHESION)) continue;
            for (String networkTitle : censusCriteria.getNetworkTitles()) {
                Map<Integer, Partition<Node<Individual>>> componentsMap = census.getComponents(networkTitle);
                Map componentChartMap = (Map)componentChartMaps.get(networkTitle);
                Map componentChartSizeMap = (Map)componentChartSizeMaps.get(networkTitle);
                if (componentsMap == null) continue;
                Partition<Node<Individual>> components = componentsMap.get(ego.getId());
                componentReport.outputs().appendln("Components " + networkTitle);
                componentReport.outputs().appendln(ego + "\t" + components.size());
                int i = 1;
                for (Cluster<Node<Individual>> cluster : components.getClusters().toListSortedByValue()) {
                    componentReport.outputs().appendln("\t" + i + "\t" + cluster.getValue() + "\t(" + cluster.size() + ")\t" + cluster.getItemsAsString());
                    ++i;
                }
                componentReport.outputs().appendln();
                for (Value value : components.getValues()) {
                    Double[] map = (Double[])componentChartMap.get(value);
                    Double[] map2 = (Double[])componentChartSizeMap.get(value);
                    if (map == null) {
                        map = new Double[]{0.0, 0.0, 0.0};
                        componentChartMap.put(value, map);
                        map2 = new Double[]{0.0, 0.0, 0.0};
                        componentChartSizeMap.put(value, map2);
                    }
                    int n = ego.getGender().toInt();
                    map[n] = map[n] + 1.0;
                    map[2] = map[2] + 1.0;
                    int n2 = ego.getGender().toInt();
                    map2[n2] = map2[n2] + (double)components.getCluster(value).size();
                    map2[2] = map2[2] + (double)components.getCluster(value).size();
                }
            }
        }
        for (String networkTitle : censusCriteria.getNetworkTitles()) {
            Map componentChartMap = (Map)componentChartMaps.get(networkTitle);
            Map componentChartSizeMap = (Map)componentChartSizeMaps.get(networkTitle);
            for (Value value : componentChartMap.keySet()) {
                Double[] sums = (Double[])componentChartSizeMap.get(value);
                int i = 0;
                while (i < 3) {
                    sums[i] = new Double(sums[i] / ((Double[])componentChartMap.get(value))[i]);
                    ++i;
                }
            }
            ReportChart componentChart = StatisticsReporter.createMapChart(componentChartMap, "COMPONENTS", new String[]{"MALE", "FEMALE"}, ReportChart.GraphType.STACKED_BARS);
            charts.add(componentChart);
            tables.add(ReportTable.transpose(componentChart.createReportTableWithSum()));
            ReportChart componentSizeChart = StatisticsReporter.createMapChart(componentChartSizeMap, "COMPONENTS", new String[]{"MALE", "FEMALE"}, ReportChart.GraphType.STACKED_BARS);
            charts.add(componentSizeChart);
            tables.add(ReportTable.transpose(componentSizeChart.createReportTableWithSum()));
        }
        int chartIndex = 0;
        while (chartIndex < charts.size()) {
            diagramReport.outputs().append((ReportChart)charts.get(chartIndex));
            if (chartIndex % 4 == 3) {
                diagramReport.outputs().appendln();
            }
            ++chartIndex;
        }
        for (ReportTable table : tables) {
            diagramReport.outputs().appendln(table.getTitle());
            diagramReport.outputs().appendln(table);
        }
        result.outputs().append(overallReport);
        result.outputs().append(diagramReport);
        result.outputs().append(detailReport);
        if (componentReport != null) {
            result.outputs().append(componentReport);
        }
        if (censusCriteria.getEgoNetworksOperations().contains((Object)SpaceTimeCriteria.EgoNetworksOperation.EXPORT_EGO_NETWORKS)) {
            Map<String, StringList> pajekBuffers = census.getPajekBuffers();
            for (String title : pajekBuffers.keySet()) {
                StringList pajekBuffer = pajekBuffers.get(title);
                if (pajekBuffer.length() == 0) continue;
                File targetFile = ToolBox.setExtension(ToolBox.addToName(new File(segmentation.getLabel()), "-" + title), ".paj");
                ReportRawData rawData = new ReportRawData("Export " + title + "s to Pajek", "Pajek", "paj", targetFile);
                rawData.setData(PAJFile.convertToMicrosoftEndOfLine(pajekBuffer.toString()));
                result.outputs().appendln();
                result.outputs().append(rawData);
            }
        }
        result.setTimeSpent(chrono.stop().interval());
        return result;
    }

    public static Report reportParcoursNetworksCensus(Segmentation segmentation, SpaceTimeCriteria censusCriteria) throws PuckException {
        Object relationClassificationType;
        Chronometer chrono = new Chronometer();
        Report result = new Report("Parcours Networks");
        result.setOrigin("Sequence reporter");
        Report overallReport = new Report("Survey");
        Report diagramReport = new Report("Diagrams");
        Report detailReport = new Report("Details");
        Report componentReport = null;
        if (censusCriteria.getParcoursNetworksOperations().contains((Object)SpaceTimeCriteria.ParcoursNetworksOperation.COHESION)) {
            componentReport = new Report("Components");
        }
        ArrayList<ReportChart> charts = new ArrayList<ReportChart>();
        ArrayList<ReportTable> tables = new ArrayList<ReportTable>();
        EgoRelationSequences sequences = new EgoRelationSequences();
        for (Individual ego : segmentation.getCurrentIndividuals().toSortedList()) {
            sequences.addRenumbered(SequenceWorker.getCoherentItinerarySegment(ego, censusCriteria));
        }
        SequencesCensus census = new SequencesCensus(sequences, censusCriteria);
        overallReport.outputs().appendln("Measure\tAverage (Male)\tAverage Pos. (Male)\tMedian (Male)\tMaximum (Male)\tSum (Male)\tAverage (Female)\tAverage Pos. (Female)\tMedian (Female)\tMaximum (Female)\tSum (Female)\tAverage (All)\tAverage Pos. (All)\tMedian (All)\tMaximum (All)\tSum (All)");
        for (String label : censusCriteria.getCensusOperationLabels()) {
            PartitionCriteria partitionCriteria = new PartitionCriteria(label);
            if (label.equals("NREVENTS")) {
                partitionCriteria.setType(PartitionCriteria.PartitionType.RAW);
            } else if (label.contains("AGEFIRST")) {
                partitionCriteria.setType(PartitionCriteria.PartitionType.SIZED_GROUPING);
                partitionCriteria.setStart(0.0);
                partitionCriteria.setSize(5.0);
            } else if (label.equals("ECCENTRICITY")) {
                partitionCriteria.setType(PartitionCriteria.PartitionType.SIZED_GROUPING);
                partitionCriteria.setStart(-100.0);
                partitionCriteria.setSize(20.0);
            } else if (label.contains("COVERAGE") || label.contains("SAME") || label.contains("NORM") || label.contains("DENSITY") || label.contains("BETWEENNESS") || label.contains("EFFICIENCY") || label.contains("CONCENTRATION")) {
                partitionCriteria.setType(PartitionCriteria.PartitionType.SIZED_GROUPING);
                partitionCriteria.setStart(0.0);
                partitionCriteria.setSize(20.0);
            } else if (label.contains("MEAN") || label.contains("COVERAGE") || label.contains("PEREVENT") || label.contains("BETWEENNESS") || label.contains("BROKERAGE") || label.contains("EFFICIENT_SIZE")) {
                partitionCriteria.setType(PartitionCriteria.PartitionType.SIZED_GROUPING);
                partitionCriteria.setStart(0.0);
                partitionCriteria.setSize(1.0);
            } else {
                partitionCriteria.setType(PartitionCriteria.PartitionType.RAW);
            }
            ReportChart chart = null;
            if (label.contains("SIMILARITY")) {
                relationClassificationType = SpaceTimeCriteria.RelationClassificationType.valueOf(label.substring(label.lastIndexOf("_") + 1));
                Map<Value, Double[]> similaritiesMap = census.getSimilaritiesMap((SpaceTimeCriteria.RelationClassificationType)((Object)relationClassificationType));
                chart = StatisticsReporter.createMapChart(similaritiesMap, label, new String[]{"HH", "FH", "HF", "FF", "All"}, ReportChart.GraphType.LINES);
                for (Value key : similaritiesMap.keySet()) {
                    overallReport.outputs().appendln(String.valueOf(label) + "_" + key + "\t" + MathUtils.percent(similaritiesMap.get(key)[4], 100.0));
                }
            } else if (!label.contains("ALTERS") && !label.contains("PROFILE")) {
                NumberedValues values = census.getValues(label);
                Partition<Individual> partition = PartitionMaker.create(label, segmentation.getCurrentIndividuals(), values, partitionCriteria);
                PartitionCriteria splitCriteria = new PartitionCriteria(censusCriteria.getPartitionLabel());
                chart = StatisticsReporter.createPartitionChart(partition, partitionCriteria, splitCriteria);
                if (label.substring(0, 3).equals("AGE")) {
                    partitionCriteria.setType(PartitionCriteria.PartitionType.RAW);
                    partitionCriteria.setSizeFilter(PartitionCriteria.SizeFilter.HOLES);
                    partitionCriteria.setValueFilter(PartitionCriteria.ValueFilter.NULL);
                    partition = PartitionMaker.create(label, segmentation.getCurrentIndividuals(), values, partitionCriteria);
                    if (partition.maxValue() != null) {
                        ReportChart survivalChart = StatisticsReporter.createSurvivalChart(partition, splitCriteria);
                        charts.add(survivalChart);
                    } else {
                        System.err.println(String.valueOf(label) + " no max value");
                    }
                }
                NumberedValues[] genderedValues = PuckUtils.getGenderedNumberedValues(values, segmentation.getCurrentIndividuals());
                overallReport.outputs().append(String.valueOf(label) + "\t");
                int gender = 0;
                while (gender < 3) {
                    String sum = "";
                    if (label.startsWith("NR")) {
                        sum = String.valueOf(new Double(genderedValues[gender].sum()).intValue());
                    }
                    overallReport.outputs().append(String.valueOf(MathUtils.round(genderedValues[gender].average(), 2)) + "\t" + MathUtils.round(genderedValues[gender].averagePositives(), 2) + "\t" + values.median() + "\t" + genderedValues[gender].max() + "\t" + sum + "\t");
                    ++gender;
                }
                overallReport.outputs().appendln();
            }
            if (chart == null) continue;
            charts.add(chart);
            if (label.equals("SIMILARITY")) {
                tables.add(ReportTable.transpose(chart.createReportTable()));
                continue;
            }
            ReportTable table = ReportTable.transpose(chart.createReportTableWithSum());
            tables.add(table);
            if (label.contains("EVENTS_") || label.contains("RELATIONS")) continue;
            tables.add(ReportTable.normalize(table));
        }
        overallReport.outputs().appendln();
        Map<String, Map<String, Map<String, Value>>> parcoursNetworkStatistics = census.getParcoursNetworkStatistics();
        ArrayList<String> clusterValues = new ArrayList<String>(parcoursNetworkStatistics.keySet());
        if (parcoursNetworkStatistics != null) {
            overallReport.outputs().appendln("Parcours Network Statistics");
            String headLine = null;
            boolean first = true;
            for (String nodeLabel : parcoursNetworkStatistics.get("Total").keySet()) {
                Object line = nodeLabel;
                headLine = "Node";
                for (String genderLabel : clusterValues) {
                    Map<String, Value> statistics = parcoursNetworkStatistics.get(genderLabel).get(nodeLabel);
                    for (String statisticsLabel : censusCriteria.getNodeStatisticsLabels()) {
                        if (first) {
                            headLine = String.valueOf(headLine) + "\t" + statisticsLabel + " (" + genderLabel + ")";
                        }
                        line = statistics != null ? String.valueOf(line) + "\t" + statistics.get(statisticsLabel) : String.valueOf(line) + "\t";
                    }
                }
                if (first) {
                    overallReport.outputs().appendln(headLine);
                    first = false;
                }
                overallReport.outputs().appendln(line);
            }
        }
        detailReport.outputs().append("Nr\tEgo\tGender");
        for (String partitionLabel : censusCriteria.getCensusOperationLabels()) {
            if (partitionLabel.contains("SIMILARITY")) {
                relationClassificationType = SpaceTimeCriteria.RelationClassificationType.valueOf(partitionLabel.substring(partitionLabel.lastIndexOf("_") + 1));
                detailReport.outputs().append("\tSIMILARITY_PARENT_" + relationClassificationType + "\tSIMILARITY_CHILD_" + relationClassificationType + "\tSIMILARITY_SIBLING_" + relationClassificationType + "\tSIMILARITY_SPOUSE_" + relationClassificationType);
                continue;
            }
            detailReport.outputs().append("\t" + partitionLabel);
        }
        TreeMap componentChartMaps = new TreeMap();
        for (String networkTitle : censusCriteria.getNetworkTitles()) {
            componentChartMaps.put(networkTitle, new TreeMap());
        }
        detailReport.outputs().appendln();
        for (Individual ego : segmentation.getCurrentIndividuals().toSortedList()) {
            if (census.getValues("NREVENTS").get(ego.getId()) != null) {
                detailReport.outputs().append(String.valueOf(ego.getId()) + "\t" + ego + "\t" + (Object)((Object)ego.getGender()));
                for (String label : censusCriteria.getCensusOperationLabels()) {
                    if (label.contains("SIMILARITY")) {
                        String[] keys;
                        Value value = (Value)census.getValues(label).get(ego.getId());
                        Map indiSimilaritiesMap = value.mapValue();
                        String[] stringArray = keys = new String[]{"PARENT", "CHILD", "SIBLING", "SPOUSE"};
                        int n = keys.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String key = stringArray[n2];
                            Double[] sim = (Double[])indiSimilaritiesMap.get(new Value(key));
                            if (sim != null) {
                                detailReport.outputs().append("\t" + MathUtils.round(sim[4], 2));
                            }
                            ++n2;
                        }
                        continue;
                    }
                    detailReport.outputs().append("\t" + census.getValues(label).get(ego.getId()));
                }
                detailReport.outputs().appendln();
            }
            if (componentReport == null) continue;
            for (String networkTitle : censusCriteria.getNetworkTitles()) {
                Map<Integer, Partition<Node<Individual>>> componentsMap = census.getComponents(networkTitle);
                Map componentChartMap = (Map)componentChartMaps.get(networkTitle);
                if (componentsMap == null) continue;
                Partition<Node<Individual>> components = componentsMap.get(ego.getId());
                componentReport.outputs().appendln("Components " + networkTitle);
                componentReport.outputs().appendln(ego + "\t" + components.size());
                int i = 1;
                for (Cluster<Node<Individual>> cluster : components.getClusters().toListSortedByValue()) {
                    componentReport.outputs().appendln("\t" + i + "\t" + cluster.getValue() + "\t(" + cluster.size() + ")\t" + cluster.getItemsAsString());
                    ++i;
                }
                componentReport.outputs().appendln();
                for (Value value : components.getValues()) {
                    Double[] map = (Double[])componentChartMap.get(value);
                    if (map == null) {
                        map = new Double[]{0.0, 0.0, 0.0};
                        componentChartMap.put(value, map);
                    }
                    int n = ego.getGender().toInt();
                    map[n] = map[n] + 1.0;
                    map[2] = map[2] + 1.0;
                }
            }
        }
        for (String networkTitle : censusCriteria.getNetworkTitles()) {
            ReportChart componentChart = StatisticsReporter.createMapChart((Map)componentChartMaps.get(networkTitle), "COMPONENTS", new String[]{"MALE", "FEMALE"}, ReportChart.GraphType.STACKED_BARS);
            charts.add(componentChart);
            tables.add(ReportTable.transpose(componentChart.createReportTableWithSum()));
            if (census.getRelationConnectionMatrix() == null) continue;
            for (ReportChart chart : census.getRelationConnectionMatrix().getCharts()) {
                charts.add(chart);
            }
            tables.add(census.getRelationConnectionMatrix().getTable("Component Connections"));
        }
        int chartIndex = 0;
        while (chartIndex < charts.size()) {
            diagramReport.outputs().append((ReportChart)charts.get(chartIndex));
            if (chartIndex % 4 == 3) {
                diagramReport.outputs().appendln();
            }
            ++chartIndex;
        }
        for (ReportTable table : tables) {
            diagramReport.outputs().appendln(table.getTitle());
            diagramReport.outputs().appendln(table);
        }
        result.outputs().append(overallReport);
        result.outputs().append(diagramReport);
        result.outputs().append(detailReport);
        result.outputs().append(componentReport);
        Map<String, StringList> pajekBuffers = census.getPajekBuffers();
        for (String title : pajekBuffers.keySet()) {
            StringList pajekBuffer = pajekBuffers.get(title);
            if (pajekBuffer.length() == 0) continue;
            File targetFile = ToolBox.setExtension(ToolBox.addToName(new File(segmentation.getLabel()), "-" + title), ".paj");
            ReportRawData rawData = new ReportRawData("Export " + title + "s to Pajek", "Pajek", "paj", targetFile);
            rawData.setData(PAJFile.convertToMicrosoftEndOfLine(pajekBuffer.toString()));
            result.outputs().appendln();
            result.outputs().append(rawData);
        }
        result.setTimeSpent(chrono.stop().interval());
        return result;
    }

    public static Report reportTrajectoriesCensus(Segmentation segmentation, SpaceTimeCriteria censusCriteria) throws PuckException {
        Chronometer chrono = new Chronometer();
        Report result = new Report("Trajectories");
        result.setOrigin("Sequence reporter");
        Report overallReport = new Report("Survey");
        Report diagramReport = new Report("Diagrams");
        Report detailReport = new Report("Details");
        Report treeReport = null;
        if (censusCriteria.getTrajectoriesOperations().contains((Object)SpaceTimeCriteria.TrajectoriesOperation.LIST_TREES)) {
            treeReport = new Report("Trees");
        }
        ArrayList<ReportChart> charts = new ArrayList<ReportChart>();
        ArrayList<ReportTable> tables = new ArrayList<ReportTable>();
        EgoRelationSequences sequences = new EgoRelationSequences();
        for (Individual ego : segmentation.getCurrentIndividuals().toSortedList()) {
            sequences.addRenumbered(SequenceWorker.getCoherentItinerarySegment(ego, censusCriteria));
        }
        SequencesCensus census = new SequencesCensus(sequences, censusCriteria);
        overallReport.outputs().appendln("Measure\tAverage (Male)\tAverage Pos. (Male)\tMedian (Male)\tMaximum (Male)\tSum (Male)\tAverage (Female)\tAverage Pos. (Female)\tMedian (Female)\tMaximum (Female)\tSum (Female)\tAverage (All)\tAverage Pos. (All)\tMedian (All)\tMaximum (All)\tSum (All)");
        for (String label : censusCriteria.getCensusOperationLabels()) {
            PartitionCriteria partitionCriteria = new PartitionCriteria(label);
            if (label.equals("NREVENTS") || label.contains("NRSTATIONS")) {
                partitionCriteria.setType(PartitionCriteria.PartitionType.RAW);
            } else if (label.contains("AGEFIRST")) {
                partitionCriteria.setType(PartitionCriteria.PartitionType.SIZED_GROUPING);
                partitionCriteria.setStart(0.0);
                partitionCriteria.setSize(5.0);
            } else if (label.equals("ECCENTRICITY")) {
                partitionCriteria.setType(PartitionCriteria.PartitionType.SIZED_GROUPING);
                partitionCriteria.setStart(-100.0);
                partitionCriteria.setSize(20.0);
            } else if (label.contains("COVERAGE") || label.contains("SAME") || label.contains("NORM") || label.contains("DENSITY") || label.contains("BETWEENNESS") || label.contains("EFFICIENCY") || label.contains("CONCENTRATION")) {
                partitionCriteria.setType(PartitionCriteria.PartitionType.SIZED_GROUPING);
                partitionCriteria.setStart(0.0);
                partitionCriteria.setSize(20.0);
            } else if (label.contains("MEAN") || label.contains("COVERAGE") || label.contains("PEREVENT") || label.contains("BETWEENNESS") || label.contains("BROKERAGE") || label.contains("EFFICIENT_SIZE")) {
                partitionCriteria.setType(PartitionCriteria.PartitionType.SIZED_GROUPING);
                partitionCriteria.setStart(0.0);
                partitionCriteria.setSize(1.0);
            } else {
                partitionCriteria.setType(PartitionCriteria.PartitionType.RAW);
            }
            ReportChart chart = null;
            if (!label.contains("ALTERS") && !label.contains("PROFILE")) {
                NumberedValues values = census.getValues(label);
                Partition<Individual> partition = PartitionMaker.create(label, segmentation.getCurrentIndividuals(), values, partitionCriteria);
                Iterator<Object> splitCriteria = new PartitionCriteria(censusCriteria.getPartitionLabel());
                chart = StatisticsReporter.createPartitionChart(partition, partitionCriteria, (PartitionCriteria)((Object)splitCriteria));
                if (label.substring(0, 3).equals("AGE")) {
                    partitionCriteria.setType(PartitionCriteria.PartitionType.RAW);
                    partitionCriteria.setSizeFilter(PartitionCriteria.SizeFilter.HOLES);
                    partitionCriteria.setValueFilter(PartitionCriteria.ValueFilter.NULL);
                    partition = PartitionMaker.create(label, segmentation.getCurrentIndividuals(), values, partitionCriteria);
                    if (partition.maxValue() != null) {
                        ReportChart reportChart = StatisticsReporter.createSurvivalChart(partition, splitCriteria);
                        charts.add(reportChart);
                    } else {
                        System.err.println(String.valueOf(label) + " no max value");
                    }
                }
                NumberedValues[] numberedValuesArray = PuckUtils.getGenderedNumberedValues(values, segmentation.getCurrentIndividuals());
                overallReport.outputs().append(String.valueOf(label) + "\t");
                int gender = 0;
                while (gender < 3) {
                    String sum = "";
                    if (label.startsWith("NR")) {
                        sum = String.valueOf(new Double(numberedValuesArray[gender].sum()).intValue());
                    }
                    overallReport.outputs().append(String.valueOf(MathUtils.round(numberedValuesArray[gender].average(), 2)) + "\t" + MathUtils.round(numberedValuesArray[gender].averagePositives(), 2) + "\t" + values.median() + "\t" + numberedValuesArray[gender].max() + "\t" + sum + "\t");
                    ++gender;
                }
                overallReport.outputs().appendln();
            }
            if (chart == null) continue;
            charts.add(chart);
            ReportTable table = ReportTable.transpose(chart.createReportTableWithSum());
            tables.add(table);
            if (label.contains("EVENTS_") || label.contains("RELATIONS")) continue;
            tables.add(ReportTable.normalize(table));
        }
        overallReport.outputs().appendln();
        TreeMap<String, StringList> rStateBuffers = new TreeMap<String, StringList>();
        TreeMap<String, StringList> rEventBuffers = new TreeMap<String, StringList>();
        TreeMap<String, Integer> rSizes = new TreeMap<String, Integer>();
        NumberedValues dateProfiles = census.getValues("PROFILE_" + censusCriteria.getDateLabel());
        NumberedValues ageProfiles = census.getValues("PROFILE_AGE");
        detailReport.outputs().append("Nr\tEgo\tGender");
        for (String partitionLabel : censusCriteria.getCensusOperationLabels()) {
            detailReport.outputs().append("\t" + partitionLabel);
            if (!partitionLabel.contains("PROFILE")) continue;
            rStateBuffers.put(partitionLabel.substring(8), new StringList());
            rSizes.put(partitionLabel.substring(8), 0);
            StringList stringList = new StringList();
            stringList.appendln("Id\tStep\tDate\tAge\t" + partitionLabel.substring(8));
            rEventBuffers.put(partitionLabel.substring(8), stringList);
        }
        detailReport.outputs().appendln();
        for (Individual ego : segmentation.getCurrentIndividuals().toSortedList()) {
            StringList rEventBuffer;
            if (census.getValues("NREVENTS").get(ego.getId()) != null) {
                detailReport.outputs().append(String.valueOf(ego.getId()) + "\t" + ego + "\t" + (Object)((Object)ego.getGender()));
                List list = ((Value)dateProfiles.get(ego.getId())).listValue();
                List ages = ((Value)ageProfiles.get(ego.getId())).listValue();
                for (String label : censusCriteria.getCensusOperationLabels()) {
                    Value value = (Value)census.getValues(label).get(ego.getId());
                    detailReport.outputs().append("\t" + value);
                    if (!label.contains("PROFILE")) continue;
                    Iterator rStateBuffer = (StringList)rStateBuffers.get(label.substring(8));
                    rEventBuffer = (StringList)rEventBuffers.get(label.substring(8));
                    int rSize = (Integer)rSizes.get(label.substring(8));
                    String rStateLine = String.valueOf(ego.getId()) + "\t" + ego + "\t" + (Object)((Object)ego.getGender());
                    List rItems = value.listValue();
                    if (rItems.size() > rSize) {
                        rSizes.put(label.substring(8), rItems.size());
                    }
                    int time = 0;
                    for (String rItem : rItems) {
                        rStateLine = String.valueOf(rStateLine) + "\t" + rItem;
                        rEventBuffer.appendln(String.valueOf(ego.getId()) + "\t" + time + "\t" + (String)list.get(time) + "\t" + (String)ages.get(time) + "\t" + rItem);
                        ++time;
                    }
                    rStateBuffer.append(rStateLine);
                }
                detailReport.outputs().appendln();
            }
            for (SpaceTimeCriteria.RelationClassificationType relationClassificationType : censusCriteria.getMainRelationClassificationTypes()) {
                CorrelationMatrix subSequenceMatrix;
                if (censusCriteria.getNetworkTitles().contains("Event Type Network")) {
                    CorrelationMatrix eventSequenceMatrix = census.getEventSequenceMatrix(relationClassificationType.toString());
                    if (eventSequenceMatrix != null) {
                        for (ReportChart chart : eventSequenceMatrix.getCharts()) {
                            charts.add(chart);
                        }
                        tables.add(eventSequenceMatrix.getTable("Event Type Sequences"));
                    }
                    overallReport.outputs().appendln();
                    overallReport.outputs().appendln("Sequence Network Statistics " + (Object)((Object)relationClassificationType));
                    overallReport.outputs().appendln("\tDensity\tInertia\t(Divergence)\tConcentration\t(Divergence)\tSymmetry\t(Divergence)\tCentral nodes");
                    rEventBuffer = Gender.values();
                    int rStateBuffer = ((Gender[])rEventBuffer).length;
                    int value = 0;
                    while (value < rStateBuffer) {
                        Gender gender = rEventBuffer[value];
                        GraphProfile<Cluster<String>> profile = eventSequenceMatrix.getProfile(gender);
                        String centralReferents = "";
                        for (Cluster<String> centralReferent : profile.getCentralReferents()) {
                            centralReferents = String.valueOf(centralReferents) + centralReferent.getValue() + " ";
                        }
                        double maxBetweenness = profile.getMaxBetweenness();
                        double density = profile.density();
                        double endo = MathUtils.round(profile.getStatistics(MatrixStatistics.Indicator.LOOPS, MatrixStatistics.Mode.NORMALIZED), 2);
                        double endoExp = MathUtils.round(profile.getStatistics(MatrixStatistics.Indicator.LOOPS, MatrixStatistics.Mode.DIVERGENCE_NORMALIZED), 2);
                        double conc = MathUtils.round(profile.getStatistics(MatrixStatistics.Indicator.CONCENTRATION, MatrixStatistics.Mode.SIMPLE), 2);
                        double concExp = MathUtils.round(profile.getStatistics(MatrixStatistics.Indicator.CONCENTRATION, MatrixStatistics.Mode.DIVERGENCE), 2);
                        double sym = MathUtils.round(profile.getStatistics(MatrixStatistics.Indicator.SYMMETRY, MatrixStatistics.Mode.SIMPLE), 2);
                        double symExp = MathUtils.round(profile.getStatistics(MatrixStatistics.Indicator.SYMMETRY, MatrixStatistics.Mode.DIVERGENCE), 2);
                        overallReport.outputs().appendln((Object)((Object)gender) + "\t" + density + "\t" + endo + "\t" + endoExp + "\t" + conc + "\t" + concExp + "\t" + sym + "\t" + symExp + "\t" + centralReferents + "(" + maxBetweenness + ") betweenness centrality");
                        ++value;
                    }
                    overallReport.outputs().appendln();
                }
                if (!censusCriteria.getNetworkTitles().contains("Sequence Type Network") || (subSequenceMatrix = census.getSubSequenceMatrix(relationClassificationType.toString())) == null) continue;
                charts.add(subSequenceMatrix.getRamificationChart());
            }
        }
        int chartIndex = 0;
        while (chartIndex < charts.size()) {
            diagramReport.outputs().append((ReportChart)charts.get(chartIndex));
            if (chartIndex % 4 == 3) {
                diagramReport.outputs().appendln();
            }
            ++chartIndex;
        }
        for (ReportTable table : tables) {
            diagramReport.outputs().appendln(table.getTitle());
            diagramReport.outputs().appendln(table);
        }
        result.outputs().append(overallReport);
        result.outputs().append(diagramReport);
        result.outputs().append(detailReport);
        if (treeReport != null) {
            result.outputs().append(treeReport);
        }
        if (censusCriteria.getTrajectoriesOperations().contains((Object)SpaceTimeCriteria.TrajectoriesOperation.EXPORT_EVENT_TYPE_NETWORK) || censusCriteria.getTrajectoriesOperations().contains((Object)SpaceTimeCriteria.TrajectoriesOperation.EXPORT_SEQUENCE_TYPE_NETWORK)) {
            Map<String, StringList> pajekBuffers = census.getPajekBuffers();
            for (String title : pajekBuffers.keySet()) {
                StringList pajekBuffer = pajekBuffers.get(title);
                if (pajekBuffer.length() == 0) continue;
                File targetFile = ToolBox.setExtension(ToolBox.addToName(new File(segmentation.getLabel()), "-" + title), ".paj");
                ReportRawData rawData = new ReportRawData("Export " + title + "s to Pajek", "Pajek", "paj", targetFile);
                rawData.setData(PAJFile.convertToMicrosoftEndOfLine(pajekBuffer.toString()));
                result.outputs().appendln();
                result.outputs().append(rawData);
            }
        }
        if (censusCriteria.getTrajectoriesOperations().contains((Object)SpaceTimeCriteria.TrajectoriesOperation.GENERAL)) {
            for (String title : rStateBuffers.keySet()) {
                StringList rEventBuffer;
                StringList stringList = (StringList)rStateBuffers.get(title);
                StringList rStateBufferCompleted = new StringList();
                int rSize = (Integer)rSizes.get(title);
                String rStateHeadLine = "Id\tName\tGender";
                int i = 0;
                while (i < rSize) {
                    rStateHeadLine = String.valueOf(rStateHeadLine) + "\t" + title + i;
                    ++i;
                }
                rStateBufferCompleted.appendln(rStateHeadLine);
                for (String rStateLine : stringList) {
                    String rStateLineCompleted = "";
                    String[] rStateItems = rStateLine.split("\t");
                    int i2 = 0;
                    while (i2 < 3 + rSize) {
                        rStateLineCompleted = i2 < rStateItems.length ? String.valueOf(rStateLineCompleted) + rStateItems[i2] + "\t" : String.valueOf(rStateLineCompleted) + "NA\t";
                        ++i2;
                    }
                    rStateBufferCompleted.appendln(rStateLineCompleted);
                }
                if (stringList.length() != 0) {
                    File targetFile = ToolBox.setExtension(ToolBox.addToName(new File(segmentation.getLabel()), "-States-" + title), ".txt");
                    ReportRawData rawData = new ReportRawData("Export " + title + "s to RData (States)", "Text", "txt", targetFile);
                    rawData.setData(PAJFile.convertToMicrosoftEndOfLine(rStateBufferCompleted.toString()));
                    result.outputs().appendln();
                    result.outputs().append(rawData);
                }
                if ((rEventBuffer = (StringList)rEventBuffers.get(title)).length() == 0) continue;
                File targetFile = ToolBox.setExtension(ToolBox.addToName(new File(segmentation.getLabel()), "-Events-" + title), ".txt");
                ReportRawData rawData = new ReportRawData("Export " + title + "s to RData (Events)", "Text", "txt", targetFile);
                rawData.setData(PAJFile.convertToMicrosoftEndOfLine(rEventBuffer.toString()));
                result.outputs().appendln();
                result.outputs().append(rawData);
            }
        }
        result.setTimeSpent(chrono.stop().interval());
        return result;
    }

    public static Graph<Place> getTrajectoryGraph(Segmentation segmentation, SpaceTimeCriteria censusCriteria) throws PuckException {
        Graph<Place> result = null;
        ArrayList charts = new ArrayList();
        ArrayList tables = new ArrayList();
        EgoRelationSequences sequences = new EgoRelationSequences();
        for (Individual ego : segmentation.getCurrentIndividuals().toSortedList()) {
            sequences.addRenumbered(SequenceWorker.getCoherentItinerarySegment(ego, censusCriteria));
        }
        SequencesCensus census = new SequencesCensus(sequences, censusCriteria);
        if (censusCriteria.getTrajectoriesOperations().contains((Object)SpaceTimeCriteria.TrajectoriesOperation.DRAW)) {
            CorrelationMatrix eventSequenceMatrix = census.getEventSequenceMatrix("PLACE");
            Graph drawGraph = eventSequenceMatrix.getSequenceNetwork("PLACE", Gender.UNKNOWN);
            result = GeoNetworkUtils.createGeoNetwork(drawGraph, censusCriteria.getLevel());
        }
        return result;
    }

    public static Graph<Place2> getTrajectoryGraph2(Geography2 geography, Segmentation segmentation, SpaceTimeCriteria censusCriteria) throws PuckException {
        Graph<Place2> result = null;
        ArrayList charts = new ArrayList();
        ArrayList tables = new ArrayList();
        EgoRelationSequences sequences = new EgoRelationSequences();
        for (Individual ego : segmentation.getCurrentIndividuals().toSortedList()) {
            sequences.addRenumbered(SequenceWorker.getCoherentItinerarySegment(ego, censusCriteria));
        }
        SequencesCensus census = new SequencesCensus(sequences, censusCriteria);
        if (censusCriteria.getTrajectoriesOperations().contains((Object)SpaceTimeCriteria.TrajectoriesOperation.DRAW)) {
            CorrelationMatrix eventSequenceMatrix = census.getEventSequenceMatrix("PLACE");
            Graph drawGraph = eventSequenceMatrix.getSequenceNetwork("PLACE", Gender.UNKNOWN);
            Graph<String> placeNameGraph = GeoNetworkUtils.createGeoNetwork2(drawGraph, censusCriteria.getLevel());
            result = GeocodingWorker.geocodeGraph(geography, placeNameGraph);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public static Report reportSequenceCensus(Segmentation segmentation, SpaceTimeCriteria.CensusType censusType) throws PuckException {
        Iterator<String> partitionCriteria;
        Chronometer chrono = new Chronometer();
        Report result = new Report(censusType.toString());
        result.setOrigin("Sequence reporter");
        Report overallReport = new Report("Survey");
        Report diagramReport = new Report("Diagrams");
        Report detailReport = new Report("Details");
        Report componentReport = new Report("Components");
        Report treeReport = new Report("Trees");
        ArrayList<Object> charts = new ArrayList<Object>();
        ArrayList<ReportTable> tables = new ArrayList<ReportTable>();
        SpaceTimeCriteria censusCriteria = new SpaceTimeCriteria(censusType);
        EgoRelationSequences sequences = new EgoRelationSequences();
        for (Individual ego : segmentation.getCurrentIndividuals().toSortedList()) {
            sequences.addRenumbered(SequenceWorker.getCoherentItinerarySegment(ego, censusCriteria));
        }
        SequencesCensus census = new SequencesCensus(sequences, censusCriteria);
        overallReport.outputs().appendln("Measure\tAverage (Male)\tAverage Pos. (Male)\tMedian (Male)\tMaximum (Male)\tSum (Male)\tAverage (Female)\tAverage Pos. (Female)\tMedian (Female)\tMaximum (Female)\tSum (Female)\tAverage (All)\tAverage Pos. (All)\tMedian (All)\tMaximum (All)\tSum (All)");
        for (String label : censusCriteria.getCensusOperationLabels()) {
            void var17_20;
            partitionCriteria = new PartitionCriteria(label);
            if (label.equals("NREVENTS")) {
                ((PartitionCriteria)((Object)partitionCriteria)).setType(PartitionCriteria.PartitionType.RAW);
            } else if (label.contains("AGEFIRST")) {
                ((PartitionCriteria)((Object)partitionCriteria)).setType(PartitionCriteria.PartitionType.SIZED_GROUPING);
                ((PartitionCriteria)((Object)partitionCriteria)).setStart(0.0);
                ((PartitionCriteria)((Object)partitionCriteria)).setSize(5.0);
            } else if (label.equals("ECCENTRICITY")) {
                ((PartitionCriteria)((Object)partitionCriteria)).setType(PartitionCriteria.PartitionType.SIZED_GROUPING);
                ((PartitionCriteria)((Object)partitionCriteria)).setStart(-100.0);
                ((PartitionCriteria)((Object)partitionCriteria)).setSize(20.0);
            } else if (label.contains("COVERAGE") || label.contains("SAME") || label.contains("NORM") || label.contains("DENSITY") || label.contains("BETWEENNESS") || label.contains("EFFICIENCY") || label.contains("CONCENTRATION")) {
                ((PartitionCriteria)((Object)partitionCriteria)).setType(PartitionCriteria.PartitionType.SIZED_GROUPING);
                ((PartitionCriteria)((Object)partitionCriteria)).setStart(0.0);
                ((PartitionCriteria)((Object)partitionCriteria)).setSize(20.0);
            } else if (label.contains("MEAN") || label.contains("COVERAGE") || label.contains("PEREVENT") || label.contains("BETWEENNESS") || label.contains("BROKERAGE") || label.contains("EFFICIENT_SIZE")) {
                ((PartitionCriteria)((Object)partitionCriteria)).setType(PartitionCriteria.PartitionType.SIZED_GROUPING);
                ((PartitionCriteria)((Object)partitionCriteria)).setStart(0.0);
                ((PartitionCriteria)((Object)partitionCriteria)).setSize(1.0);
            } else {
                ((PartitionCriteria)((Object)partitionCriteria)).setType(PartitionCriteria.PartitionType.RAW);
            }
            Object var17_21 = null;
            if (label.contains("SIMILARITY")) {
                SpaceTimeCriteria.RelationClassificationType relationClassificationType = SpaceTimeCriteria.RelationClassificationType.valueOf(label.substring(label.lastIndexOf("_") + 1));
                Map<Value, Double[]> similaritiesMap = census.getSimilaritiesMap(relationClassificationType);
                ReportChart reportChart = StatisticsReporter.createMapChart(similaritiesMap, label, new String[]{"HH", "FH", "HF", "FF", "All"}, ReportChart.GraphType.LINES);
                for (Value key : similaritiesMap.keySet()) {
                    overallReport.outputs().appendln(String.valueOf(label) + "_" + key + "\t" + MathUtils.percent(similaritiesMap.get(key)[4], 100.0));
                }
            } else if (!label.contains("ALTERS") && !label.contains("PROFILE")) {
                NumberedValues numberedValues = census.getValues(label);
                Iterator<String> partition = PartitionMaker.create(label, segmentation.getCurrentIndividuals(), numberedValues, partitionCriteria);
                PartitionCriteria splitCriteria = new PartitionCriteria(censusCriteria.getPartitionLabel());
                ReportChart reportChart = StatisticsReporter.createPartitionChart(partition, partitionCriteria, splitCriteria);
                if (label.substring(0, 3).equals("AGE")) {
                    ((PartitionCriteria)((Object)partitionCriteria)).setType(PartitionCriteria.PartitionType.RAW);
                    ((PartitionCriteria)((Object)partitionCriteria)).setSizeFilter(PartitionCriteria.SizeFilter.HOLES);
                    ((PartitionCriteria)((Object)partitionCriteria)).setValueFilter(PartitionCriteria.ValueFilter.NULL);
                    partition = PartitionMaker.create(label, segmentation.getCurrentIndividuals(), numberedValues, partitionCriteria);
                    if (((Partition)((Object)partition)).maxValue() != null) {
                        ReportChart survivalChart = StatisticsReporter.createSurvivalChart(partition, splitCriteria);
                        charts.add(survivalChart);
                    } else {
                        System.err.println(String.valueOf(label) + " no max value");
                    }
                }
                NumberedValues[] genderedValues = PuckUtils.getGenderedNumberedValues(numberedValues, segmentation.getCurrentIndividuals());
                overallReport.outputs().append(String.valueOf(label) + "\t");
                int gender = 0;
                while (gender < 3) {
                    String sum = "";
                    if (label.startsWith("NR")) {
                        sum = String.valueOf(new Double(genderedValues[gender].sum()).intValue());
                    }
                    overallReport.outputs().append(String.valueOf(MathUtils.round(genderedValues[gender].average(), 2)) + "\t" + MathUtils.round(genderedValues[gender].averagePositives(), 2) + "\t" + numberedValues.median() + "\t" + genderedValues[gender].max() + "\t" + sum + "\t");
                    ++gender;
                }
                overallReport.outputs().appendln();
            }
            if (var17_20 == null) continue;
            charts.add(var17_20);
            if (label.equals("SIMILARITY")) {
                tables.add(ReportTable.transpose(var17_20.createReportTable()));
                continue;
            }
            ReportTable reportTable = ReportTable.transpose(var17_20.createReportTableWithSum());
            tables.add(reportTable);
            if (label.contains("EVENTS_") || label.contains("RELATIONS")) continue;
            tables.add(ReportTable.normalize(reportTable));
        }
        overallReport.outputs().appendln();
        Map<String, Map<String, Map<String, Value>>> parcoursNetworkStatistics = census.getParcoursNetworkStatistics();
        if (parcoursNetworkStatistics != null) {
            overallReport.outputs().appendln("Parcours Network Statistics");
            partitionCriteria = parcoursNetworkStatistics.get("Total").keySet().iterator();
            while (partitionCriteria.hasNext()) {
                void var17_26;
                String nodeLabel;
                String string = nodeLabel = partitionCriteria.next();
                for (String string2 : parcoursNetworkStatistics.get("Total").get(nodeLabel).keySet()) {
                    for (String genderLabel : parcoursNetworkStatistics.keySet()) {
                        String string3 = String.valueOf(var17_26) + "\t" + parcoursNetworkStatistics.get(genderLabel).get(nodeLabel).get(string2);
                    }
                }
                overallReport.outputs().appendln(var17_26);
            }
        }
        detailReport.outputs().append("Nr\tEgo\tGender");
        for (String partitionLabel : censusCriteria.getCensusOperationLabels()) {
            if (partitionLabel.contains("SIMILARITY")) {
                SpaceTimeCriteria.RelationClassificationType relationClassificationType = SpaceTimeCriteria.RelationClassificationType.valueOf(partitionLabel.substring(partitionLabel.lastIndexOf("_") + 1));
                detailReport.outputs().append("\tSIMILARITY_PARENT_" + (Object)((Object)relationClassificationType) + "\tSIMILARITY_CHILD_" + (Object)((Object)relationClassificationType) + "\tSIMILARITY_SIBLING_" + (Object)((Object)relationClassificationType) + "\tSIMILARITY_SPOUSE_" + (Object)((Object)relationClassificationType));
                continue;
            }
            detailReport.outputs().append("\t" + partitionLabel);
        }
        TreeMap<Value, Double[]> componentChartMap = new TreeMap<Value, Double[]>();
        detailReport.outputs().appendln();
        for (Individual ego : segmentation.getCurrentIndividuals().toSortedList()) {
            if ((censusType == SpaceTimeCriteria.CensusType.GENERAL || censusType == SpaceTimeCriteria.CensusType.PARCOURS || censusType == SpaceTimeCriteria.CensusType.PARCOURSNETWORKS) && census.getValues("NREVENTS").get(ego.getId()) != null || censusType == SpaceTimeCriteria.CensusType.EGONETWORKS && census.getValues("SIZE").get(ego.getId()) != null) {
                detailReport.outputs().append(String.valueOf(ego.getId()) + "\t" + ego + "\t" + (Object)((Object)ego.getGender()));
                for (String string : censusCriteria.getCensusOperationLabels()) {
                    if (string.contains("SIMILARITY")) {
                        String[] keys;
                        Value value = (Value)census.getValues(string).get(ego.getId());
                        Map indiSimilaritiesMap = value.mapValue();
                        String[] stringArray = keys = new String[]{"PARENT", "CHILD", "SIBLING", "SPOUSE"};
                        int n = keys.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String key = stringArray[n2];
                            Double[] sim = (Double[])indiSimilaritiesMap.get(new Value(key));
                            if (sim != null) {
                                detailReport.outputs().append("\t" + MathUtils.round(sim[4], 2));
                            }
                            ++n2;
                        }
                        continue;
                    }
                    detailReport.outputs().append("\t" + census.getValues(string).get(ego.getId()));
                }
                detailReport.outputs().appendln();
            }
            if (censusType != SpaceTimeCriteria.CensusType.EGONETWORKS && censusType != SpaceTimeCriteria.CensusType.PARCOURSNETWORKS) continue;
            for (String string : censusCriteria.getNetworkTitles()) {
                Map<Integer, Partition<Node<Individual>>> componentsMap = census.getComponents(string);
                if (componentsMap == null) continue;
                Partition<Node<Individual>> components = componentsMap.get(ego.getId());
                componentReport.outputs().appendln("Components " + string);
                componentReport.outputs().appendln(ego + "\t" + components.size());
                int i = 1;
                for (Cluster<Node<Individual>> cluster : components.getClusters().toListSortedByValue()) {
                    componentReport.outputs().appendln("\t" + i + "\t" + cluster.getValue() + "\t(" + cluster.size() + ")\t" + cluster.getItemsAsString());
                    ++i;
                }
                componentReport.outputs().appendln();
                for (Value value : components.getValues()) {
                    Double[] map = (Double[])componentChartMap.get(value);
                    if (map == null) {
                        map = new Double[]{0.0, 0.0, 0.0};
                        componentChartMap.put(value, map);
                    }
                    int n = ego.getGender().toInt();
                    map[n] = map[n] + 1.0;
                    map[2] = map[2] + 1.0;
                }
            }
        }
        if (censusType == SpaceTimeCriteria.CensusType.EGONETWORKS || censusType == SpaceTimeCriteria.CensusType.PARCOURSNETWORKS) {
            ReportChart componentChart = StatisticsReporter.createMapChart(componentChartMap, "COMPONENTS", new String[]{"MALE", "FEMALE"}, ReportChart.GraphType.STACKED_BARS);
            charts.add(componentChart);
            tables.add(ReportTable.transpose(componentChart.createReportTableWithSum()));
            if (census.getRelationConnectionMatrix() != null) {
                for (ReportChart reportChart : census.getRelationConnectionMatrix().getCharts()) {
                    charts.add(reportChart);
                }
                tables.add(census.getRelationConnectionMatrix().getTable("Component Connections"));
            }
        }
        if (censusType == SpaceTimeCriteria.CensusType.PARCOURS) {
            for (SpaceTimeCriteria.RelationClassificationType relationClassificationType : censusCriteria.getMainRelationClassificationTypes()) {
                CorrelationMatrix correlationMatrix;
                if (censusCriteria.getNetworkTitles().contains("Event Type Network")) {
                    CorrelationMatrix correlationMatrix2 = census.getEventSequenceMatrix(relationClassificationType.toString());
                    if (correlationMatrix2 != null) {
                        for (ReportChart chart : correlationMatrix2.getCharts()) {
                            charts.add(chart);
                        }
                        tables.add(correlationMatrix2.getTable("Event Type Sequences"));
                    }
                    overallReport.outputs().appendln();
                    overallReport.outputs().appendln("Sequence Network Statistics " + (Object)((Object)relationClassificationType));
                    overallReport.outputs().appendln("\tDensity\tInertia\t(Divergence)\tConcentration\t(Divergence)\tSymmetry\t(Divergence)\tCentral nodes");
                    Gender[] genderArray = Gender.values();
                    int components = genderArray.length;
                    int componentsMap = 0;
                    while (componentsMap < components) {
                        Gender gender = genderArray[componentsMap];
                        GraphProfile<Cluster<String>> profile = correlationMatrix2.getProfile(gender);
                        String centralReferents = "";
                        for (Cluster<String> centralReferent : profile.getCentralReferents()) {
                            centralReferents = String.valueOf(centralReferents) + centralReferent.getValue() + " ";
                        }
                        double maxBetweenness = profile.getMaxBetweenness();
                        double density = profile.density();
                        double endo = MathUtils.round(profile.getStatistics(MatrixStatistics.Indicator.LOOPS, MatrixStatistics.Mode.NORMALIZED), 2);
                        double endoExp = MathUtils.round(profile.getStatistics(MatrixStatistics.Indicator.LOOPS, MatrixStatistics.Mode.DIVERGENCE_NORMALIZED), 2);
                        double conc = MathUtils.round(profile.getStatistics(MatrixStatistics.Indicator.CONCENTRATION, MatrixStatistics.Mode.SIMPLE), 2);
                        double concExp = MathUtils.round(profile.getStatistics(MatrixStatistics.Indicator.CONCENTRATION, MatrixStatistics.Mode.DIVERGENCE), 2);
                        double sym = MathUtils.round(profile.getStatistics(MatrixStatistics.Indicator.SYMMETRY, MatrixStatistics.Mode.SIMPLE), 2);
                        double symExp = MathUtils.round(profile.getStatistics(MatrixStatistics.Indicator.SYMMETRY, MatrixStatistics.Mode.DIVERGENCE), 2);
                        overallReport.outputs().appendln((Object)((Object)gender) + "\t" + density + "\t" + endo + "\t" + endoExp + "\t" + conc + "\t" + concExp + "\t" + sym + "\t" + symExp + "\t" + centralReferents + "(" + maxBetweenness + ") betweenness centrality");
                        ++componentsMap;
                    }
                    overallReport.outputs().appendln();
                }
                if (!censusCriteria.getNetworkTitles().contains("Sequence Type Network") || (correlationMatrix = census.getSubSequenceMatrix(relationClassificationType.toString())) == null) continue;
                charts.add(correlationMatrix.getRamificationChart());
            }
        }
        int chartIndex = 0;
        while (chartIndex < charts.size()) {
            diagramReport.outputs().append((ReportChart)charts.get(chartIndex));
            if (chartIndex % 4 == 3) {
                diagramReport.outputs().appendln();
            }
            ++chartIndex;
        }
        for (ReportTable table : tables) {
            diagramReport.outputs().appendln(table.getTitle());
            diagramReport.outputs().appendln(table);
        }
        result.outputs().append(overallReport);
        result.outputs().append(diagramReport);
        result.outputs().append(detailReport);
        if (censusType == SpaceTimeCriteria.CensusType.EGONETWORKS || censusType == SpaceTimeCriteria.CensusType.PARCOURSNETWORKS) {
            result.outputs().append(componentReport);
        }
        if (censusType == SpaceTimeCriteria.CensusType.PARCOURS) {
            result.outputs().append(treeReport);
        }
        Map<String, StringList> pajekBuffers = census.getPajekBuffers();
        for (String string : pajekBuffers.keySet()) {
            StringList pajekBuffer = pajekBuffers.get(string);
            if (pajekBuffer.length() == 0) continue;
            File targetFile = ToolBox.setExtension(ToolBox.addToName(new File(segmentation.getLabel()), "-" + string), ".paj");
            ReportRawData rawData = new ReportRawData("Export " + string + "s to Pajek", "Pajek", "paj", targetFile);
            rawData.setData(PAJFile.convertToMicrosoftEndOfLine(pajekBuffer.toString()));
            result.outputs().appendln();
            result.outputs().append(rawData);
        }
        result.setTimeSpent(chrono.stop().interval());
        return result;
    }

    public static Report reportSequences(Net net, Segmentation segmentation, SpaceTimeCriteria censusCriteria) throws PuckException {
        Relation event;
        Individual ego;
        String spouseFilterLabel = "INTERV";
        Chronometer chrono = new Chronometer();
        Report result = new Report("Sequence Report");
        result.setOrigin("Sequence reporter");
        Report surveyReport = null;
        Report detailedReport = null;
        Report actorEventTableReport = null;
        Report interactionTableReport = null;
        Report biographyReport = null;
        Report extendedBiographyReport = null;
        ArrayList<Report> reports = new ArrayList<Report>();
        if (censusCriteria.getSequenceReportTypes().contains((Object)SpaceTimeCriteria.SequenceReportType.ITINERARIES_SURVEY)) {
            surveyReport = new Report("Survey");
            reports.add(surveyReport);
        }
        if (censusCriteria.getSequenceReportTypes().contains((Object)SpaceTimeCriteria.SequenceReportType.ITINERARIES_DETAILS)) {
            detailedReport = new Report("Details");
            reports.add(detailedReport);
        }
        if (censusCriteria.getSequenceReportTypes().contains((Object)SpaceTimeCriteria.SequenceReportType.ACTOR_EVENT_TABLES)) {
            actorEventTableReport = new Report("Actor-Event tables");
            reports.add(actorEventTableReport);
        }
        if (censusCriteria.getSequenceReportTypes().contains((Object)SpaceTimeCriteria.SequenceReportType.INTERACTION_TABLES)) {
            interactionTableReport = new Report("Interaction tables");
            reports.add(interactionTableReport);
        }
        Geography geography = censusCriteria.getGeography();
        EgoRelationSequences sequences = new EgoRelationSequences();
        for (Individual ego2 : segmentation.getCurrentIndividuals().toSortedList()) {
            if (surveyReport != null) {
                surveyReport.outputs().appendln(ego2.signature());
                surveyReport.outputs().appendln();
            }
            if (detailedReport != null) {
                detailedReport.outputs().appendln(ego2.signature());
                detailedReport.outputs().appendln();
            }
            EgoRelationSequence sequence = SequenceMaker.createPersonalSequence(ego2, censusCriteria);
            sequences.add(sequence);
            for (Individual spouse : ego2.spouses()) {
                spouse.getAttributeValue(spouseFilterLabel);
            }
            if (actorEventTableReport != null) {
                actorEventTableReport.outputs().append(SequenceWorker.roleTable(sequence));
            }
            if (interactionTableReport != null) {
                interactionTableReport.outputs().append(SequenceWorker.interactionTable(sequence));
            }
            EgoRelationSequences subSequences = SequenceWorker.split(sequence);
            for (Iterator<Ordinal> subSequence : subSequences) {
                if (subSequences.size() > 1) {
                    if (surveyReport != null) {
                        surveyReport.outputs().appendln(((Sequence)((Object)subSequence)).getId());
                    }
                    if (detailedReport != null) {
                        detailedReport.outputs().appendln(((Sequence)((Object)subSequence)).getId());
                    }
                }
                for (Ordinal key : ((Sequence)((Object)subSequence)).getStations().keySet()) {
                    Relation event2 = (Relation)((Sequence)((Object)subSequence)).getStations().get(key);
                    Place start = geography.getByHomonym(event2.getAttributeValue("START_PLACE"));
                    Place end = geography.getByHomonym(event2.getAttributeValue("END_PLACE"));
                    Place ancestor = geography.getCommonAncestor(start, end);
                    GeoLevel commonLevel = null;
                    String commonPlaceName = null;
                    String startPlaceLabel = censusCriteria.getStartPlaceLabel();
                    String endPlaceLabel = censusCriteria.getEndPlaceLabel();
                    if (ancestor != null) {
                        commonLevel = ancestor.getLevel();
                        commonPlaceName = ancestor.getName();
                    }
                    String order = SequenceWorker.order(event2, ego2);
                    if (surveyReport != null) {
                        surveyReport.outputs().appendln(key + "\t" + order + "\t" + key.getYear() + "\t(" + ((EgoRelationSequence)((Object)subSequence)).getEgoAge(key.getYear()) + ")\t" + event2.getTypedId() + "\t" + event2.getAttributeValue(startPlaceLabel) + "\t" + event2.getAttributeValue(endPlaceLabel) + "\t" + (Object)((Object)commonLevel) + "\t(" + commonPlaceName + ")\t");
                    }
                    if (detailedReport == null) continue;
                    detailedReport.outputs().appendln(key + "\t" + order + "\t" + key.getYear() + "\t(" + ((EgoRelationSequence)((Object)subSequence)).getEgoAge(key.getYear()) + ")\t" + event2.getTypedId() + "\t" + event2.getAttributeValue(startPlaceLabel) + "\t" + event2.getAttributeValue(endPlaceLabel) + "\t" + (Object)((Object)commonLevel) + "\t(" + commonPlaceName + ")\t");
                    detailedReport.outputs().appendln();
                    detailedReport.outputs().appendln(SequenceReporter.getStories(event2));
                }
                for (Report report : reports) {
                    report.outputs().appendln();
                }
            }
        }
        if (censusCriteria.getSequenceReportTypes().contains((Object)SpaceTimeCriteria.SequenceReportType.BIOGRAPHIES)) {
            biographyReport = new Report("Biographies");
            reports.add(biographyReport);
            for (EgoRelationSequence biography : SequenceMaker.createBiographies(net, segmentation, censusCriteria).toSortedList()) {
                ego = (Individual)segmentation.getCurrentIndividuals().getById(biography.getId());
                biographyReport.outputs().appendln(ego.signature());
                for (Ordinal key : biography.getStations().keySet()) {
                    event = (Relation)biography.getStation(key);
                    biographyReport.outputs().appendln(key + "\t" + event.getRoles(ego).toString() + " (" + biography.getEgoAge(key.getYear()) + ")\t" + event.getName() + "\t" + SequenceCensus.getEgoRolePartners(event, censusCriteria, ego));
                }
                biographyReport.outputs().appendln();
            }
        }
        if (censusCriteria.getSequenceReportTypes().contains((Object)SpaceTimeCriteria.SequenceReportType.EXTENDED_BIOGRAPHIES)) {
            extendedBiographyReport = new Report("Extended biographies");
            reports.add(extendedBiographyReport);
            for (EgoRelationSequence extendedBiography : SequenceMaker.createExtendedBiographies(net, segmentation, censusCriteria).toSortedList()) {
                ego = (Individual)segmentation.getCurrentIndividuals().getById(extendedBiography.getId());
                extendedBiographyReport.outputs().appendln(ego.signature());
                for (Ordinal key : extendedBiography.getStations().keySet()) {
                    event = (Relation)extendedBiography.getStation(key);
                    extendedBiographyReport.outputs().appendln(key + "\t" + event.getRoles(ego).toString() + " (" + extendedBiography.getEgoAge(key.getYear()) + ")\t" + event.getName() + " " + SequenceCensus.getEgoRolePartners(event, censusCriteria, ego));
                }
                extendedBiographyReport.outputs().appendln();
            }
        }
        if (censusCriteria.getSequenceReportTypes().contains((Object)SpaceTimeCriteria.SequenceReportType.EXPORT_RELATION_GRAPH)) {
            Graph<Individual> graph = NetUtils.createRelationGraph(segmentation, censusCriteria.getRelationModelName());
            ArrayList<String> partitionLabels = new ArrayList<String>();
            StringList pajekBuffer = new StringList();
            pajekBuffer.addAll((Collection)PuckUtils.writePajekNetwork(graph, partitionLabels));
            pajekBuffer.appendln();
            if (pajekBuffer.length() != 0) {
                File targetFile = ToolBox.setExtension(ToolBox.addToName(new File(segmentation.getLabel()), "-Relation Network"), ".paj");
                ReportRawData rawData = new ReportRawData("Export Relation Network to Pajek", "Pajek", "paj", targetFile);
                rawData.setData(PAJFile.convertToMicrosoftEndOfLine(pajekBuffer.toString()));
                result.outputs().appendln();
                result.outputs().append(rawData);
            }
        }
        for (Report report : reports) {
            result.outputs().append(report);
        }
        result.setTimeSpent(chrono.stop().interval());
        return result;
    }

    private static void reportSequenceTree(Report report, String value, Graph<Cluster<String>> sequenceTypeNetwork) {
        report.outputs().appendln("Sequence Tree " + value);
        Node<Cluster<String>> start = sequenceTypeNetwork.getNode(1);
        Stack stack = new Stack();
        report.outputs().appendln(start.getReferent() + "\t" + start.getReferent().size());
        stack.push(start);
        while (!stack.isEmpty()) {
            Node node = (Node)stack.pop();
            for (Node next : node.getOutNodes().toListSortedByLabel()) {
                report.outputs().appendln(next.getReferent() + "\t" + ((Cluster)next.getReferent()).size());
                stack.push(next);
            }
        }
        report.outputs().appendln();
    }

    private static void reportTriangles(Report report, Segmentation segmentation) throws PuckException {
        HashMap<Integer, Partition<EventTriangle>> trianglesMap = new HashMap<Integer, Partition<EventTriangle>>();
        Partition<EventTriangle> allTriangles = new Partition<EventTriangle>();
        Partition<Individual> triangleTypes = new Partition<Individual>();
        for (Individual ego : segmentation.getCurrentIndividuals()) {
            Individuals individuals = ego.getRelated("Migevent");
            individuals.add(ego);
            Partition<EventTriangle> triangles = SequenceWorker.getTriangles(individuals, "Migevent");
            allTriangles.add(triangles);
            trianglesMap.put(ego.getId(), triangles);
            for (Cluster<EventTriangle> cluster : triangles.getClusters()) {
                triangleTypes.put(ego, cluster.getValue());
            }
        }
        Report trianglesReport = new Report("Triangles");
        trianglesReport.outputs().appendln("Type\tnrTriangles\tnrEgoNetworks");
        for (Cluster cluster : allTriangles.getClusters().toListSortedByValue()) {
            trianglesReport.outputs().appendln(cluster.getValue() + "\t" + cluster.size() + "\t" + triangleTypes.getCluster(cluster.getValue()).size());
        }
        trianglesReport.outputs().appendln();
        PartitionCriteria partitionCriteria = new PartitionCriteria("Triangles");
        ReportChart chart5 = StatisticsReporter.createPartitionChart(allTriangles, partitionCriteria, null);
        trianglesReport.outputs().appendln(chart5);
        for (Individual ego : segmentation.getCurrentIndividuals().toSortedList()) {
            Partition triangles = (Partition)trianglesMap.get(ego.getId());
            trianglesReport.outputs().appendln(ego + "\t" + triangles.size() + " types");
            for (Cluster cluster : triangles.getClusters().toListSortedByValue()) {
                trianglesReport.outputs().appendln(cluster.getValue() + "\t" + cluster.size());
                for (EventTriangle triangle : cluster.getItems()) {
                    trianglesReport.outputs().appendln(triangle.getEventPattern());
                }
                trianglesReport.outputs().appendln();
            }
            trianglesReport.outputs().appendln();
        }
    }

    public static Report reportUnknownPlaces(Segmentation segmentation, ResourceBundle bundle) {
        UnknownPlacesCriteria criteria = new UnknownPlacesCriteria();
        criteria.setIncludedIndividual(true);
        criteria.setIncludedAllRelations(true);
        Report result = SequenceReporter.reportUnknownPlaces(segmentation, criteria, bundle);
        return result;
    }

    public static Report reportUncodedPlaces(Segmentation segmentation, ResourceBundle bundle) {
        UnknownPlacesCriteria criteria = new UnknownPlacesCriteria();
        criteria.setIncludedIndividual(true);
        criteria.setIncludedAllRelations(true);
        Report result = SequenceReporter.reportUncodedPlaces(segmentation, criteria, bundle);
        return result;
    }

    public static Report reportUnknownPlaces(Segmentation segmentation, UnknownPlacesCriteria criteria, ResourceBundle bundle) {
        Chronometer chrono = new Chronometer();
        Geography geography = Geography.getInstance();
        Partition<String> unknownPlaces = new Partition<String>();
        int errorCount = 0;
        StringList errors = new StringList();
        if (criteria.isIncludedIndividual()) {
            for (Individual individual : segmentation.getCurrentIndividuals()) {
                for (Attribute attribute : individual.attributes()) {
                    if (!attribute.getLabel().contains("PLAC") || geography.getByHomonym(attribute.getValue()) != null) continue;
                    unknownPlaces.put(attribute.getValue(), new Value(attribute.getLabel()));
                    ++errorCount;
                }
            }
        }
        Relations relations = criteria.isIncludedAllRelations() ? segmentation.getCurrentRelations() : (criteria.getRelationNames().isEmpty() ? new Relations() : segmentation.getCurrentRelations().getByModelNames(criteria.getRelationNames()));
        for (Relation relation : relations) {
            for (Attribute attribute : relation.attributes()) {
                if (!attribute.getLabel().contains("PLAC") || geography.getByHomonym(attribute.getValue()) != null) continue;
                unknownPlaces.put(attribute.getValue(), new Value(attribute.getLabel()));
                ++errorCount;
            }
        }
        for (Cluster cluster : unknownPlaces.getClusters()) {
            errors.appendln(cluster.getValue().toString());
            for (String placeName : cluster.getItems()) {
                errors.appendln("\t" + placeName);
            }
            errors.appendln();
        }
        Report result = new Report();
        result.setTitle("Unknown Places");
        result.setOrigin("Control reporter");
        result.setTarget(segmentation.getLabel());
        errors.add(0, (Object)(String.valueOf(errorCount) + " " + Report.translate(bundle, "Unknown Places") + "\n"));
        result.outputs().append(errors.toString());
        result.setStatus(errorCount);
        result.setTimeSpent(chrono.stop().interval());
        return result;
    }

    public static Report reportUncodedPlaces(Segmentation segmentation, UnknownPlacesCriteria criteria, ResourceBundle bundle) {
        Chronometer chrono = new Chronometer();
        Geography geography = Geography.getInstance();
        Partition<Object> uncodedPlaces = new Partition<Object>();
        int errorCount = 0;
        StringList errors = new StringList();
        if (criteria.isIncludedIndividual()) {
            for (Individual individual : segmentation.getCurrentIndividuals()) {
                for (Attribute attribute : individual.attributes()) {
                    Object place;
                    if (!attribute.getLabel().contains("PLAC") || (place = geography.getByHomonym(attribute.getValue())) == null || ((Place)place).getCoordinate() != null) continue;
                    uncodedPlaces.put(place, new Value(((Place)place).getLevel()));
                    Place sup = ((Place)place).getSup();
                    while (sup.getCoordinate() == null) {
                        uncodedPlaces.put(sup, new Value(sup.getLevel()));
                        sup = sup.getSup();
                    }
                }
            }
        }
        Relations relations = criteria.isIncludedAllRelations() ? segmentation.getCurrentRelations() : (criteria.getRelationNames().isEmpty() ? new Relations() : segmentation.getCurrentRelations().getByModelNames(criteria.getRelationNames()));
        for (Relation relation : relations) {
            for (Attribute attribute : relation.attributes()) {
                Place place;
                if (!attribute.getLabel().contains("PLAC") || (place = geography.getByHomonym(attribute.getValue())) == null || place.getCoordinate() != null) continue;
                uncodedPlaces.put(place, new Value(place.getLevel()));
                Place sup = place.getSup();
                while (sup.getCoordinate() == null) {
                    uncodedPlaces.put(sup, new Value(sup.getLevel()));
                    sup = sup.getSup();
                }
            }
        }
        for (Cluster cluster : uncodedPlaces.getClusters().toListSortedByValue()) {
            errors.appendln(String.valueOf(cluster.getValue().toString()) + " " + cluster.size());
            errorCount += cluster.size();
            ArrayList<String> toponyms = new ArrayList<String>();
            for (Object place : cluster.getItems()) {
                toponyms.add(((Place)place).getToponym());
            }
            Collections.sort(toponyms);
            for (String toponym : toponyms) {
                errors.appendln("\t" + toponym);
            }
            errors.appendln();
        }
        Report result = new Report();
        result.setTitle("Uncoded Places");
        result.setOrigin("Control reporter");
        result.setTarget(segmentation.getLabel());
        errors.add(0, (Object)(String.valueOf(errorCount) + " " + Report.translate(bundle, "Uncoded Places") + "\n"));
        result.outputs().append(errors.toString());
        result.setStatus(errorCount);
        result.setTimeSpent(chrono.stop().interval());
        return result;
    }

    private static int sequenceNumber(Cluster<String> cluster) {
        HashSet<String> set = new HashSet<String>();
        for (String string : cluster.getItems()) {
            set.add(string.split("\\s")[0]);
        }
        int result = set.size();
        return result;
    }

    public static Report reportMembers(Sequence<Relations> slices, SpaceTimeCriteria criteria) {
        Report result = new Report(String.valueOf(criteria.getRelationModelName()) + " Slices");
        StringList list = new StringList();
        Map<String, Individuals> membersByRelationId = slices.membersByRelationId();
        for (String idValue : slices.idValues()) {
            list.appendln(idValue);
            list.appendln();
            List<Individual> members = membersByRelationId.get(idValue).toSortedList(IndividualComparator.Sorting.BIRT_YEAR);
            for (Individual member : members) {
                list.append(String.valueOf(member.signature()) + " (" + IndividualValuator.lifeStatusAtYear(member, criteria.getReferenceYear()) + ")\t");
                for (Ordinal time : slices.getTimes()) {
                    String status = SequenceWorker.getStatus(slices, member, time, criteria);
                    if (status != null) {
                        list.append(String.valueOf(status) + "\t");
                        continue;
                    }
                    Integer deathYear = IndividualValuator.getDeathYear(member);
                    Integer birthYear = IndividualValuator.getBirthYear(member);
                    if (deathYear != null && deathYear <= time.getYear()) {
                        list.append("+" + deathYear + "\t\t");
                        continue;
                    }
                    if (birthYear != null && birthYear >= time.getYear()) {
                        list.append("*" + birthYear + "\t\t");
                        continue;
                    }
                    list.append("?\t\t");
                }
                list.appendln();
            }
            list.appendln();
        }
        result.outputs().append(list);
        return result;
    }

    public static Report reportIndividualDynamics(Segmentation segmentation, Sequence<Relations> slices, SpaceTimeCriteria spaceTimeCriteria, StatisticsCriteria statisticsCriteria) throws PuckException {
        if (slices == null || statisticsCriteria == null) {
            throw PuckExceptions.INVALID_PARAMETER.create("Null parameter detected.", new Object[0]);
        }
        Report result = new Report("Population Dynamics " + spaceTimeCriteria.getRelationModelName());
        Chronometer chrono = new Chronometer();
        result.setOrigin("Space reporter");
        List<Ordinal> times = slices.getTimes();
        ArrayList<ReportChart> charts = new ArrayList<ReportChart>(20);
        ArrayList<ReportTable> tables = new ArrayList<ReportTable>(20);
        SequenceStatistics sequenceStatistics = new SequenceStatistics(segmentation, slices, spaceTimeCriteria);
        Map<String, Map<Ordinal, Partition<Individual>>> census = sequenceStatistics.getDynamicIndividualCensus(spaceTimeCriteria, statisticsCriteria);
        int i = 0;
        while (i < times.size() - 1) {
            Ordinal startTime = times.get(i);
            Ordinal endTime = times.get(i + 1);
            PartitionCriteria partitionCriteria = new PartitionCriteria();
            partitionCriteria.setLabel(String.valueOf(spaceTimeCriteria.getRelationModelName()) + " " + startTime + "-" + endTime);
            ReportChart chartChanges = StatisticsReporter.createPartitionChart(census.get("MIGRATIONS").get(endTime), partitionCriteria, statisticsCriteria.getSplitCriteria());
            charts.add(chartChanges);
            ReportTable tableChanges = ReportTable.transpose(chartChanges.createReportTableWithSum());
            tables.add(tableChanges);
            ReportChart chartDestinations = StatisticsReporter.createPartitionChart(census.get("DESTINATIONS").get(startTime), partitionCriteria, statisticsCriteria.getSplitCriteria());
            charts.add(chartDestinations);
            ReportTable tableDestinations = ReportTable.transpose(chartDestinations.createReportTableWithSum());
            tables.add(tableDestinations);
            ReportChart chartOrigins = StatisticsReporter.createPartitionChart(census.get("ORIGINS").get(endTime), partitionCriteria, statisticsCriteria.getSplitCriteria());
            charts.add(chartOrigins);
            ReportTable tableOrigins = ReportTable.transpose(chartOrigins.createReportTableWithSum());
            tables.add(tableOrigins);
            ++i;
        }
        int nr = Math.min(4, 2 * times.size());
        int chartIndex = 0;
        while (chartIndex < charts.size()) {
            result.outputs().append((ReportChart)charts.get(chartIndex));
            if (chartIndex % nr == nr - 1) {
                result.outputs().appendln();
            }
            ++chartIndex;
        }
        for (ReportTable table : tables) {
            result.outputs().appendln(table);
        }
        result.setTimeSpent(chrono.stop().interval());
        return result;
    }

    public static Report reportIndividualStatics(Segmentation segmentation, Sequence<Relations> slices, SpaceTimeCriteria spaceTimeCriteria, StatisticsCriteria criteria) throws PuckException {
        if (criteria == null) {
            throw PuckExceptions.INVALID_PARAMETER.create("Null parameter detected.", new Object[0]);
        }
        Report result = new Report("Population Statics " + spaceTimeCriteria.getRelationModelName());
        Chronometer chrono = new Chronometer();
        result.setOrigin("Relation reporter");
        for (PartitionCriteria partitionCriteria : criteria.getPartitionCriterias()) {
            if (StringUtils.isEmpty((CharSequence)partitionCriteria.getLabel())) continue;
            ArrayList<ReportChart> charts = new ArrayList<ReportChart>(20);
            ArrayList<ReportTable> tables = new ArrayList<ReportTable>(20);
            SequenceStatistics sequenceStatistics = new SequenceStatistics(segmentation, slices, spaceTimeCriteria);
            Map<Ordinal, Partition<Individual>> census = sequenceStatistics.getDatedIndividualCensus(spaceTimeCriteria, partitionCriteria);
            for (Ordinal time : slices.getTimes()) {
                Partition<Individual> partition = census.get(time);
                ReportChart chart = StatisticsReporter.createPartitionChart(partition, partitionCriteria, criteria.getSplitCriteria());
                charts.add(chart);
                ReportTable table = ReportTable.transpose(chart.createReportTableWithSum());
                tables.add(table);
            }
            int nr = Math.min(4, slices.getNrStations());
            int chartIndex = 0;
            while (chartIndex < charts.size()) {
                result.outputs().append((ReportChart)charts.get(chartIndex));
                if (chartIndex % nr == nr - 1) {
                    result.outputs().appendln();
                }
                ++chartIndex;
            }
            for (ReportTable table : tables) {
                result.outputs().appendln(table);
            }
        }
        result.setTimeSpent(chrono.stop().interval());
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public static Report reportEgoNetworks(Sequence<Relations> slices, StatisticsCriteria criteria, SpaceTimeCriteria spaceTimeCriteria) throws PuckException {
        ReportTable table;
        PartitionCriteria splitCriteria;
        Partition<Attributable> partition;
        NumberedValues values;
        Object partitionCriteria;
        if (slices == null || criteria == null) {
            throw PuckExceptions.INVALID_PARAMETER.create("Null parameter detected.", new Object[0]);
        }
        Report result = new Report("Ego Networks " + spaceTimeCriteria.getRelationModelName());
        Chronometer chrono = new Chronometer();
        result.setOrigin("Space reporter");
        SequencesCensus census = new SequencesCensus(slices.toSequencesByEgo(), spaceTimeCriteria);
        Individuals members = slices.getIndividuals();
        Report overallReport = new Report("Survey");
        Report diagramReport = new Report("Diagrams");
        Report detailReport = new Report("Details");
        Report componentReport = new Report("Components");
        ArrayList<Object> charts = new ArrayList<Object>();
        ArrayList<ReportTable> tables = new ArrayList<ReportTable>();
        overallReport.outputs().appendln("Measure\tAverage (Male)\tAverage Pos. (Male)\tMedian (Male)\tMaximum (Male)\tSum (Male)\tAverage (Female)\tAverage Pos. (Female)\tMedian (Female)\tMaximum (Female)\tSum (Female)\tAverage (All)\tAverage Pos. (All)\tMedian (All)\tMaximum (All)\tSum (All)");
        for (String label : spaceTimeCriteria.getCensusOperationLabels()) {
            void var16_19;
            partitionCriteria = new PartitionCriteria(label);
            Object var16_20 = null;
            if (!label.contains("ALTERS") && !label.contains("PROFILE")) {
                values = census.getValues(label);
                partition = PartitionMaker.create(label, slices.getStation(slices.getTimes().get(0)), values, (PartitionCriteria)partitionCriteria);
                splitCriteria = new PartitionCriteria(spaceTimeCriteria.getPartitionLabel());
                ReportChart reportChart = StatisticsReporter.createPartitionChart(partition, (PartitionCriteria)partitionCriteria, null);
                overallReport.outputs().append(String.valueOf(label) + "\t");
                String sum = "";
                if (label.startsWith("NR")) {
                    sum = String.valueOf(new Double(values.sum()).intValue());
                }
                overallReport.outputs().append(String.valueOf(MathUtils.round(values.average(), 2)) + "\t" + MathUtils.round(values.averagePositives(), 2) + "\t" + values.median() + "\t" + values.max() + "\t" + sum + "\t");
                overallReport.outputs().appendln();
            }
            if (var16_19 == null) continue;
            charts.add(var16_19);
            table = ReportTable.transpose(var16_19.createReportTableWithSum());
            tables.add(table);
            if (label.contains("EVENTS_") || label.contains("RELATIONS")) continue;
            tables.add(ReportTable.normalize(table));
        }
        overallReport.outputs().appendln();
        overallReport.outputs().appendln("Measure\tAverage (Male)\tAverage Pos. (Male)\tMedian (Male)\tMaximum (Male)\tSum (Male)\tAverage (Female)\tAverage Pos. (Female)\tMedian (Female)\tMaximum (Female)\tSum (Female)\tAverage (All)\tAverage Pos. (All)\tMedian (All)\tMaximum (All)\tSum (All)");
        for (String label : spaceTimeCriteria.getCensusOperationLabels()) {
            void var16_25;
            partitionCriteria = new PartitionCriteria(label);
            if (label.equals("NREVENTS")) {
                ((PartitionCriteria)partitionCriteria).setType(PartitionCriteria.PartitionType.RAW);
            } else if (label.contains("AGEFIRST")) {
                ((PartitionCriteria)partitionCriteria).setType(PartitionCriteria.PartitionType.SIZED_GROUPING);
                ((PartitionCriteria)partitionCriteria).setStart(0.0);
                ((PartitionCriteria)partitionCriteria).setSize(5.0);
            } else if (label.equals("ECCENTRICITY")) {
                ((PartitionCriteria)partitionCriteria).setType(PartitionCriteria.PartitionType.SIZED_GROUPING);
                ((PartitionCriteria)partitionCriteria).setStart(-100.0);
                ((PartitionCriteria)partitionCriteria).setSize(20.0);
            } else if (label.contains("COVERAGE") || label.contains("SAME") || label.contains("NORM") || label.contains("DENSITY") || label.contains("BETWEENNESS") || label.contains("EFFICIENCY") || label.contains("CONCENTRATION")) {
                ((PartitionCriteria)partitionCriteria).setType(PartitionCriteria.PartitionType.SIZED_GROUPING);
                ((PartitionCriteria)partitionCriteria).setStart(0.0);
                ((PartitionCriteria)partitionCriteria).setSize(20.0);
            } else if (label.contains("MEAN") || label.contains("COVERAGE") || label.contains("PEREVENT") || label.contains("BETWEENNESS") || label.contains("BROKERAGE") || label.contains("EFFICIENT_SIZE")) {
                ((PartitionCriteria)partitionCriteria).setType(PartitionCriteria.PartitionType.SIZED_GROUPING);
                ((PartitionCriteria)partitionCriteria).setStart(0.0);
                ((PartitionCriteria)partitionCriteria).setSize(1.0);
            } else {
                ((PartitionCriteria)partitionCriteria).setType(PartitionCriteria.PartitionType.RAW);
            }
            Object var16_23 = null;
            if (!label.contains("ALTERS") && !label.contains("PROFILE")) {
                values = census.getValues(label);
                partition = PartitionMaker.create(label, members, values, (PartitionCriteria)partitionCriteria);
                splitCriteria = new PartitionCriteria(spaceTimeCriteria.getPartitionLabel());
                ReportChart reportChart = StatisticsReporter.createPartitionChart(partition, (PartitionCriteria)partitionCriteria, splitCriteria);
                if (label.substring(0, 3).equals("AGE")) {
                    ((PartitionCriteria)partitionCriteria).setType(PartitionCriteria.PartitionType.RAW);
                    ((PartitionCriteria)partitionCriteria).setSizeFilter(PartitionCriteria.SizeFilter.HOLES);
                    ((PartitionCriteria)partitionCriteria).setValueFilter(PartitionCriteria.ValueFilter.NULL);
                    partition = PartitionMaker.create(label, members, values, (PartitionCriteria)partitionCriteria);
                    if (partition.maxValue() != null) {
                        ReportChart survivalChart = StatisticsReporter.createSurvivalChart(partition, splitCriteria);
                        charts.add(survivalChart);
                    } else {
                        System.err.println(String.valueOf(label) + " no max value");
                    }
                }
                NumberedValues[] genderedValues = PuckUtils.getGenderedNumberedValues(values, members);
                overallReport.outputs().append(String.valueOf(label) + "\t");
                int gender = 0;
                while (gender < 3) {
                    String sum = "";
                    if (label.startsWith("NR")) {
                        sum = String.valueOf(new Double(genderedValues[gender].sum()).intValue());
                    }
                    overallReport.outputs().append(String.valueOf(MathUtils.round(genderedValues[gender].average(), 2)) + "\t" + MathUtils.round(genderedValues[gender].averagePositives(), 2) + "\t" + values.median() + "\t" + genderedValues[gender].max() + "\t" + sum + "\t");
                    ++gender;
                }
                overallReport.outputs().appendln();
            }
            if (var16_25 == null) continue;
            charts.add(var16_25);
            table = ReportTable.transpose(var16_25.createReportTableWithSum());
            tables.add(table);
            if (label.contains("EVENTS_") || label.contains("RELATIONS")) continue;
            tables.add(ReportTable.normalize(table));
        }
        overallReport.outputs().appendln();
        detailReport.outputs().append("Nr\tEgo\tGender");
        for (String partitionLabel : spaceTimeCriteria.getCensusOperationLabels()) {
            detailReport.outputs().append("\t" + partitionLabel);
        }
        TreeMap<String, Map<String, Double>> componentChartMap = new TreeMap<String, Map<String, Double>>();
        detailReport.outputs().appendln();
        for (Individual ego : members.toSortedList()) {
            if (census.getValues("SIZE").get(ego.getId()) != null) {
                detailReport.outputs().append(String.valueOf(ego.getId()) + "\t" + ego + "\t" + (Object)((Object)ego.getGender()));
                for (String string : spaceTimeCriteria.getCensusOperationLabels()) {
                    detailReport.outputs().append("\t" + census.getValues(string).get(ego.getId()));
                }
                detailReport.outputs().appendln();
            }
            for (String string : spaceTimeCriteria.getNetworkTitles()) {
                Map<Integer, Partition<Node<Individual>>> componentsMap = census.getComponents(string);
                if (componentsMap == null) continue;
                Partition<Node<Individual>> components = componentsMap.get(ego.getId());
                componentReport.outputs().appendln("Components " + string);
                componentReport.outputs().appendln(ego + "\t" + components.size());
                int i = 1;
                for (Cluster<Node<Individual>> cluster : components.getClusters().toListSortedByValue()) {
                    componentReport.outputs().appendln("\t" + i + "\t" + cluster.getValue() + "\t(" + cluster.size() + ")\t" + cluster.getItemsAsString());
                    ++i;
                }
                componentReport.outputs().appendln();
                for (Value value : components.getValues()) {
                    String label = value.toString();
                    TreeMap<String, Double> map = (TreeMap<String, Double>)componentChartMap.get(label);
                    if (map == null) {
                        map = new TreeMap<String, Double>();
                        Gender[] genderArray = Gender.values();
                        int n = genderArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Gender gender = genderArray[n2];
                            map.put(gender.toString(), 0.0);
                            ++n2;
                        }
                        componentChartMap.put(label, map);
                    }
                    map.put(ego.getGender().toString(), (Double)map.get(ego.getGender().toString()) + 1.0);
                }
            }
        }
        ReportChart componentChart = StatisticsReporter.createChart("COMPONENTS", componentChartMap);
        charts.add(componentChart);
        tables.add(ReportTable.transpose(componentChart.createReportTableWithSum()));
        if (census.getRelationConnectionMatrix() != null) {
            for (ReportChart chart2 : census.getRelationConnectionMatrix().getCharts()) {
                charts.add(chart2);
            }
            tables.add(census.getRelationConnectionMatrix().getTable("Component Connections"));
        }
        int chartIndex = 0;
        while (chartIndex < charts.size()) {
            diagramReport.outputs().append((ReportChart)charts.get(chartIndex));
            if (chartIndex % 4 == 3) {
                diagramReport.outputs().appendln();
            }
            ++chartIndex;
        }
        for (ReportTable table2 : tables) {
            diagramReport.outputs().appendln(table2.getTitle());
            diagramReport.outputs().appendln(table2);
        }
        result.outputs().append(overallReport);
        result.outputs().append(diagramReport);
        result.outputs().append(detailReport);
        result.outputs().append(componentReport);
        Map<String, StringList> pajekBuffers = census.getPajekBuffers();
        for (String string : pajekBuffers.keySet()) {
            StringList pajekBuffer = pajekBuffers.get(string);
            if (pajekBuffer.length() == 0) continue;
            File targetFile = ToolBox.setExtension(ToolBox.addToName(new File(spaceTimeCriteria.getRelationModelName()), "-" + string), ".paj");
            ReportRawData rawData = new ReportRawData("Export " + string + "s to Pajek", "Pajek", "paj", targetFile);
            rawData.setData(PAJFile.convertToMicrosoftEndOfLine(pajekBuffer.toString()));
            result.outputs().appendln();
            result.outputs().append(rawData);
        }
        result.setTimeSpent(chrono.stop().interval());
        return result;
    }

    public static Report reportGeneralSequenceCensus(Sequence<Relations> sequence, StatisticsCriteria statisticsCriteria, SpaceTimeCriteria spaceTimeCriteria) throws PuckException {
        throw new Error("Unresolved compilation problems: \n\tThe constructor SequencesCensus(Sequences<Numberable>, SpaceTimeCriteria) is undefined\n\tego cannot be resolved\n\tego cannot be resolved to a variable\n\tego cannot be resolved\n\tego cannot be resolved\n");
    }

    public static Report reportItineraries(Segmentation segmentation, SpaceTimeCriteria criteria) throws PuckException {
        if (segmentation == null || criteria.getRelationModelName() == null) {
            throw PuckExceptions.INVALID_PARAMETER.create("Null parameter detected.", new Object[0]);
        }
        Report result = new Report("Itineraries " + criteria.getRelationModelName());
        Chronometer chrono = new Chronometer();
        result.setOrigin("Relation reporter");
        List<String> indicators = Arrays.asList("PLACE", "REFERENT_CHAIN", "REFERENT_CHAIN_TYPE", "REFERENT_KIN", "REFERENT_KIN_TYPE", "REFERENT");
        List<String> matrixIndicators = Arrays.asList("REFERENT_CHAIN", "REFERENT_KIN");
        Sequences<Relation> houses = SequenceMaker.createRelationSequences(segmentation, criteria);
        SequenceStatistics houseStatistics = new SequenceStatistics(segmentation, houses, criteria, indicators);
        houseStatistics.putMemberValues(criteria);
        Report reportCensus = new Report("Census");
        Report reportSequences = new Report("Sequences");
        Report reportMatrices = new Report("Matrices");
        Individuals members = houses.getIndividuals(segmentation);
        String headLine1 = "Id\tNAME\tGENDER\t";
        String dateLine1 = "\t\t\t";
        for (String indicator : indicators) {
            headLine1 = String.valueOf(headLine1) + indicator;
            Integer[] integerArray = criteria.getDates();
            int n = integerArray.length;
            int n2 = 0;
            while (n2 < n) {
                Integer year = integerArray[n2];
                headLine1 = String.valueOf(headLine1) + "\t";
                dateLine1 = String.valueOf(dateLine1) + year + "\t";
                ++n2;
            }
        }
        reportSequences.outputs().appendln(headLine1);
        reportSequences.outputs().appendln(dateLine1);
        for (Individual member : members.toSortedList()) {
            Object memberLine = String.valueOf(member.getId()) + "\t" + member.getName() + "\t" + (Object)((Object)member.getGender()) + "\t";
            for (String indicator : indicators) {
                Integer[] integerArray = criteria.getDates();
                int n = integerArray.length;
                int n3 = 0;
                while (n3 < n) {
                    Integer year = integerArray[n3];
                    Ordinal time = new Ordinal(year);
                    Value value = houseStatistics.getValue(member, time, indicator);
                    memberLine = String.valueOf(memberLine) + value + "\t";
                    ++n3;
                }
            }
            reportSequences.outputs().appendln(memberLine);
        }
        StringList pajekBuffer = new StringList();
        for (String matrixIndicator : matrixIndicators) {
            reportMatrices.outputs().appendln("Transition Matrix " + matrixIndicator);
            reportMatrices.outputs().appendln();
            reportCensus.outputs().appendln(String.valueOf(matrixIndicator) + " Position Census");
            reportCensus.outputs().appendln();
            String headLine0 = "Position\t";
            Integer[] integerArray = criteria.getDates();
            int n = integerArray.length;
            int year = 0;
            while (year < n) {
                Integer year2 = integerArray[year];
                headLine0 = String.valueOf(headLine0) + year2 + "\t";
                ++year;
            }
            reportCensus.outputs().appendln(headLine0);
            Map individualValueCensuses = houseStatistics.getDatedIndividualCensus(segmentation, matrixIndicator);
            Map<Value, Double> meanValueFrequencies = houseStatistics.getMeanValueFrequencies(individualValueCensuses, members);
            Partition<Individual> individualSequenceCensus = houseStatistics.getSequenceCensus(individualValueCensuses, members);
            for (Value value : meanValueFrequencies.keySet()) {
                Object valueLine = "" + value;
                Integer[] integerArray2 = criteria.getDates();
                int n2 = integerArray2.length;
                int n3 = 0;
                while (n3 < n2) {
                    Integer year3 = integerArray2[n3];
                    int count = 0;
                    Cluster cluster = individualValueCensuses.get(new Ordinal(year3)).getCluster(new Value(value));
                    if (cluster != null) {
                        count += cluster.size();
                    }
                    valueLine = String.valueOf(valueLine) + "\t" + count;
                    ++n3;
                }
                reportCensus.outputs().appendln(valueLine);
            }
            reportCensus.outputs().appendln();
            reportCensus.outputs().appendln(String.valueOf(matrixIndicator) + " Sequence Census");
            reportCensus.outputs().appendln();
            reportCensus.outputs().appendln("Sequence");
            int sequenceCount = individualSequenceCensus.itemsCount();
            for (Cluster cluster : individualSequenceCensus.getClusters().toListSortedByDescendingSize()) {
                reportCensus.outputs().appendln(cluster.getValue() + "\t" + cluster.size() + "\t" + MathUtils.percent(cluster.size(), sequenceCount));
            }
            reportCensus.outputs().appendln();
            Map map = houseStatistics.getDatedIndividualCensus(segmentation, matrixIndicator);
            Matrix matrix = houseStatistics.getTransitionMatrix(map, members);
            String headLine = "\t";
            int col = 0;
            while (col < matrix.getRowDim()) {
                headLine = String.valueOf(headLine) + matrix.getColLabel(col) + "\t";
                ++col;
            }
            reportMatrices.outputs().appendln(headLine);
            int row = 0;
            while (row < matrix.getRowDim()) {
                String rowLine = String.valueOf(matrix.getRowLabel(row)) + "\t";
                int col2 = 0;
                while (col2 < matrix.getRowDim()) {
                    rowLine = String.valueOf(rowLine) + matrix.getAsRowPercentage(row, col2) + "\t";
                    ++col2;
                }
                reportMatrices.outputs().appendln(rowLine);
                ++row;
            }
            reportMatrices.outputs().appendln();
            Graph<Node<String>> transitionGraph = GraphMaker.createGraph("Transition Graph " + criteria.getRelationModelName() + " " + matrixIndicator, matrix, meanValueFrequencies, "MEAN");
            ArrayList<String> partitionLabels = new ArrayList<String>();
            partitionLabels.add("MEAN");
            pajekBuffer.addAll((Collection)PuckUtils.writePajekNetwork(transitionGraph, partitionLabels));
            pajekBuffer.appendln();
        }
        if (pajekBuffer.length() != 0) {
            File targetFile = ToolBox.setExtension(ToolBox.addToName(new File("Transition graphs_"), criteria.getRelationModelName()), ".paj");
            ReportRawData rawData = new ReportRawData("Export Transition Graphs to Pajek", "Pajek", "paj", targetFile);
            rawData.setData(PAJFile.convertToMicrosoftEndOfLine(pajekBuffer.toString()));
            result.outputs().appendln();
            result.outputs().append(rawData);
        }
        result.outputs().append(reportCensus);
        result.outputs().append(reportSequences);
        result.outputs().append(reportMatrices);
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public static Report reportTreeStructure(Segmentation segmentation, SpaceTimeCriteria criteria, boolean reducedTrees) throws PuckException {
        ReportRawData rawData;
        File targetFile;
        Object year;
        Object year2;
        void var44_47;
        if (segmentation == null || criteria.getRelationModelName() == null) {
            throw PuckExceptions.INVALID_PARAMETER.create("Null parameter detected.", new Object[0]);
        }
        Report result = new Report("Cluster Structure " + criteria.getRelationModelName());
        Chronometer chrono = new Chronometer();
        result.setOrigin("Relation reporter");
        List<String> indicators1 = Arrays.asList("GRAPH", "SIZE", "MAXDEPTH", "MEANDEPTH", "MEANINDEGREE", "DIAMETER", "NRCOMPONENTS", "MAXCOMPONENT", "CONCENTRATION");
        List<String> indicators2 = Arrays.asList("TREES_BY_ID", "TREES_BY_GENDER", "TREES_BY_KIN");
        List<String> matrixIndicators = Arrays.asList("CHAIN", "KIN");
        CensusCriteria censusCriteria = new CensusCriteria();
        censusCriteria.setPattern(criteria.getPattern());
        censusCriteria.setChainClassification(criteria.getChainClassification());
        censusCriteria.setRelationAttributeLabel(criteria.getLocalUnitLabel());
        censusCriteria.setRestrictionType(RestrictionType.ALL);
        censusCriteria.setSymmetryType(SymmetryType.INVERTIBLE);
        censusCriteria.setClosingRelation("TOTAL");
        Sequences<Relation> sequences = SequenceMaker.createRelationSequences(segmentation, criteria);
        SequenceStatistics houseStatistics1 = new SequenceStatistics(segmentation, sequences, criteria, indicators1);
        SequenceStatistics houseStatistics2 = new SequenceStatistics(segmentation, sequences, criteria, indicators2);
        SequenceStatistics houseStatistics3 = new SequenceStatistics(segmentation, sequences, criteria, new ArrayList<String>());
        SequenceStatistics houseStatistics4 = new SequenceStatistics(segmentation, sequences, criteria, new ArrayList<String>());
        SequenceStatistics houseStatistics5 = new SequenceStatistics(segmentation, sequences, criteria, new ArrayList<String>());
        SequenceStatistics houseStatistics6 = new SequenceStatistics(segmentation, sequences, criteria, null);
        houseStatistics1.putSequenceValues();
        houseStatistics2.putSequenceValues();
        Map referentKinCensus = houseStatistics3.getDatedSequenceCensus("REFERENT_KIN", criteria);
        Map<Ordinal, Partition<Relation>> allKinCensus = houseStatistics4.getDatedSequenceCensus("ALL_KIN", criteria);
        Map<Ordinal, Partition<Relation>> referentChainCensus = houseStatistics5.getDatedSequenceCensus("REFERENT_CHAIN", criteria);
        List<String> indicators3 = houseStatistics3.indicators();
        List<String> indicators4 = houseStatistics4.indicators();
        List<String> indicators5 = houseStatistics5.indicators();
        StringList pajekBuffer2 = new StringList();
        Partition<String> inFlows = houseStatistics6.getFlows("IN", criteria.getDateLabel());
        Partition<String> outFlows = houseStatistics6.getFlows("OUT", criteria.getDateLabel());
        Partition<String> allFlows = new Partition<String>();
        allFlows.add(inFlows);
        allFlows.add(outFlows);
        Report reportOverview = new Report("Overview");
        Report reportMetrics = new Report("Metrics");
        Report reportMorphology = new Report("Morphology");
        Report reportReferentKin = new Report("Referent kin census");
        Report reportKin = new Report("All kin census");
        Report reportReferentChain = new Report("Referent chain census");
        Report reportFlow = new Report("Flow census");
        for (Cluster cluster : allFlows.getClusters().toListSortedByValue()) {
            reportFlow.outputs().appendln(cluster.getValue());
            for (String item : cluster.getItems()) {
                reportFlow.outputs().appendln("\t" + item);
            }
        }
        HashSet<Value> values = new HashSet<Value>();
        String timeLine = "Chain Types\t";
        String typeLine = "type\t";
        for (Ordinal time : referentChainCensus.keySet()) {
            timeLine = String.valueOf(timeLine) + time + "\t\t";
            typeLine = String.valueOf(typeLine) + "#Houses\tHouses\t";
            Partition<Relation> partition = referentChainCensus.get(time);
            values.addAll(partition.getValues());
        }
        reportOverview.outputs().appendln(timeLine);
        reportOverview.outputs().appendln(typeLine);
        ArrayList valueList = new ArrayList(values);
        Collections.sort(valueList);
        for (Value value : valueList) {
            String valueLine = "" + value;
            for (Ordinal time : referentChainCensus.keySet()) {
                Cluster<Relation> cluster = referentChainCensus.get(time).getCluster(value);
                valueLine = cluster != null ? String.valueOf(valueLine) + "\t" + cluster.size() + "\t" + cluster.getItemsAsString() : String.valueOf(valueLine) + "\t0\t";
            }
            reportOverview.outputs().appendln(valueLine);
        }
        reportOverview.outputs().appendln();
        HashSet<Value> values2 = new HashSet<Value>();
        String timeLine2 = "Kin Types\t";
        String typeLine2 = "type\t";
        for (Ordinal time : referentKinCensus.keySet()) {
            timeLine2 = String.valueOf(timeLine2) + time + "\t\t";
            typeLine2 = String.valueOf(typeLine2) + "#Houses\tHouses\t";
            Partition<Relation> partition = referentKinCensus.get(time);
            values2.addAll(partition.getValues());
        }
        reportOverview.outputs().appendln(timeLine2);
        reportOverview.outputs().appendln(typeLine2);
        ArrayList valueList2 = new ArrayList(values2);
        Collections.sort(valueList2);
        for (Value value : valueList2) {
            String valueLine = "" + value;
            for (Ordinal ordinal : referentKinCensus.keySet()) {
                Cluster<Relation> cluster = referentKinCensus.get(ordinal).getCluster(value);
                valueLine = cluster != null ? String.valueOf(valueLine) + "\t" + cluster.size() + "\t" + cluster.getItemsAsString() : String.valueOf(valueLine) + "\t0\t";
            }
            reportOverview.outputs().appendln(valueLine);
        }
        reportOverview.outputs().appendln();
        String headLine1 = "HOUSE\t";
        String dateLine1 = "\t";
        for (String indicator : indicators1) {
            if (indicator.equals("GRAPH")) continue;
            headLine1 = String.valueOf(headLine1) + indicator;
            Integer[] integerArray = criteria.getDates();
            int n = integerArray.length;
            int cluster = 0;
            while (cluster < n) {
                Integer year3 = integerArray[cluster];
                headLine1 = String.valueOf(headLine1) + "\t";
                dateLine1 = String.valueOf(dateLine1) + year3 + "\t";
                ++cluster;
            }
            headLine1 = String.valueOf(headLine1) + "\t";
            dateLine1 = String.valueOf(dateLine1) + "TREND\t";
        }
        reportMetrics.outputs().appendln(headLine1);
        reportMetrics.outputs().appendln(dateLine1);
        String headLine2 = "HOUSE\t";
        String string = "\t";
        for (String indicator : indicators2) {
            headLine2 = String.valueOf(headLine2) + indicator;
            Integer[] integerArray = criteria.getDates();
            int n = integerArray.length;
            int n2 = 0;
            while (n2 < n) {
                Integer year4 = integerArray[n2];
                headLine2 = String.valueOf(headLine2) + "\t";
                String string2 = String.valueOf(var44_47) + year4 + "\t";
                ++n2;
            }
        }
        reportMorphology.outputs().appendln(headLine2);
        reportMorphology.outputs().appendln(var44_47);
        String headLine3 = "HOUSE\t";
        String dateLine3 = "\t";
        for (String indicator : indicators3) {
            headLine3 = String.valueOf(headLine3) + indicator;
            Integer[] integerArray = criteria.getDates();
            int n = integerArray.length;
            int n3 = 0;
            while (n3 < n) {
                Integer year5 = integerArray[n3];
                headLine3 = String.valueOf(headLine3) + "\t";
                dateLine3 = String.valueOf(dateLine3) + year5 + "\t";
                ++n3;
            }
            headLine3 = String.valueOf(headLine3) + "\t";
            dateLine3 = String.valueOf(dateLine3) + "TREND\t";
        }
        reportReferentKin.outputs().appendln(headLine3);
        reportReferentKin.outputs().appendln(dateLine3);
        String headLine4 = "HOUSE\t";
        String dateLine4 = "\t";
        for (String indicator : indicators4) {
            headLine4 = String.valueOf(headLine4) + indicator;
            Integer[] integerArray = criteria.getDates();
            int n = integerArray.length;
            int n4 = 0;
            while (n4 < n) {
                Integer year6 = integerArray[n4];
                headLine4 = String.valueOf(headLine4) + "\t";
                dateLine4 = String.valueOf(dateLine4) + year6 + "\t";
                ++n4;
            }
            headLine4 = String.valueOf(headLine4) + "\t";
            dateLine4 = String.valueOf(dateLine4) + "TREND\t";
        }
        reportKin.outputs().appendln(headLine4);
        reportKin.outputs().appendln(dateLine4);
        String headLine5 = "HOUSE\t";
        String dateLine5 = "\t";
        for (String indicator : indicators5) {
            headLine5 = String.valueOf(headLine5) + indicator;
            Integer[] integerArray = criteria.getDates();
            int n = integerArray.length;
            int n5 = 0;
            while (n5 < n) {
                Integer year7 = integerArray[n5];
                headLine5 = String.valueOf(headLine5) + "\t";
                dateLine5 = String.valueOf(dateLine5) + year7 + "\t";
                ++n5;
            }
            headLine5 = String.valueOf(headLine5) + "\t";
            dateLine5 = String.valueOf(dateLine5) + "TREND\t";
        }
        reportReferentChain.outputs().appendln(headLine5);
        reportReferentChain.outputs().appendln(dateLine5);
        for (Sequence house : sequences.toSortedList()) {
            Value value;
            Ordinal time;
            Integer year3;
            int n;
            int n6;
            Integer[] integerArray;
            String houseLine1 = house + "\t";
            String houseLine2 = house + "\t";
            String houseLine3 = house + "\t";
            Object houseLine4 = house + "\t";
            String houseLine5 = house + "\t";
            for (String indicator : indicators1) {
                integerArray = criteria.getDates();
                n6 = integerArray.length;
                n = 0;
                while (n < n6) {
                    year3 = integerArray[n];
                    time = new Ordinal(year3);
                    value = houseStatistics1.getValue(house, time, indicator);
                    if (indicator.equals("GRAPH")) {
                        if (value != null) {
                            ArrayList<String> partitionLabels = new ArrayList<String>();
                            pajekBuffer2.addAll((Collection)PuckUtils.writePajekNetwork(value.graphValue(), partitionLabels));
                            pajekBuffer2.appendln();
                        }
                    } else {
                        houseLine1 = value != null ? String.valueOf(houseLine1) + value + "\t" : String.valueOf(houseLine1) + "\t";
                    }
                    ++n;
                }
                if (indicator.equals("GRAPH")) continue;
                houseLine1 = String.valueOf(houseLine1) + houseStatistics1.getTrend((Relation)((Object)house), indicator) + "\t";
            }
            for (String indicator : indicators2) {
                integerArray = criteria.getDates();
                n6 = integerArray.length;
                n = 0;
                while (n < n6) {
                    year3 = integerArray[n];
                    time = new Ordinal(year3);
                    value = houseStatistics2.getValue(house, time, indicator);
                    houseLine2 = value != null ? String.valueOf(houseLine2) + value + "\t" : String.valueOf(houseLine2) + "\t";
                    ++n;
                }
            }
            for (String indicator : indicators3) {
                integerArray = criteria.getDates();
                n6 = integerArray.length;
                n = 0;
                while (n < n6) {
                    year3 = integerArray[n];
                    time = new Ordinal(year3);
                    value = houseStatistics3.getValue(house, time, indicator);
                    houseLine3 = value != null ? String.valueOf(houseLine3) + value + "\t" : String.valueOf(houseLine3) + "\t";
                    ++n;
                }
                houseLine3 = String.valueOf(houseLine3) + houseStatistics3.getTrend((Relation)((Object)house), indicator) + "\t";
            }
            for (String indicator : indicators4) {
                integerArray = criteria.getDates();
                n6 = integerArray.length;
                n = 0;
                while (n < n6) {
                    year3 = integerArray[n];
                    time = new Ordinal(year3);
                    value = houseStatistics4.getValue(house, time, indicator);
                    houseLine4 = String.valueOf(houseLine4) + value + "\t";
                    ++n;
                }
                houseLine4 = String.valueOf(houseLine4) + houseStatistics4.getTrend((Relation)((Object)house), indicator) + "\t";
            }
            for (String indicator2 : indicators5) {
                integerArray = criteria.getDates();
                n6 = integerArray.length;
                n = 0;
                while (n < n6) {
                    year2 = integerArray[n];
                    time = new Ordinal((Integer)year2);
                    value = houseStatistics5.getValue(house, time, indicator2);
                    houseLine5 = String.valueOf(houseLine5) + value + "\t";
                    ++n;
                }
                houseLine5 = String.valueOf(houseLine5) + houseStatistics5.getTrend((Relation)((Object)house), indicator2) + "\t";
            }
            reportMetrics.outputs().appendln(houseLine1);
            reportMorphology.outputs().appendln(houseLine2);
            reportReferentKin.outputs().appendln(houseLine3);
            reportKin.outputs().appendln(houseLine4);
            reportReferentChain.outputs().appendln(houseLine5);
        }
        String endLine1 = "TOTAL\t";
        String endLine3 = "TOTAL\t";
        String endLine4 = "TOTAL\t";
        String endLine5 = "TOTAL\t";
        for (String indicator : indicators1) {
            if (indicator.equals("GRAPH")) continue;
            year2 = criteria.getDates();
            int n = ((Integer[])year2).length;
            int indicator2 = 0;
            while (indicator2 < n) {
                year = year2[indicator2];
                Ordinal time = new Ordinal((Integer)year);
                Double value = houseStatistics1.meanOverSequences(time, indicator);
                endLine1 = value == null ? String.valueOf(endLine1) + "\t" : String.valueOf(endLine1) + value + "\t";
                ++indicator2;
            }
            endLine1 = String.valueOf(endLine1) + houseStatistics1.getMeanTrend(indicator) + "\t";
        }
        reportMetrics.outputs().appendln(endLine1);
        for (String indicator : indicators3) {
            year2 = criteria.getDates();
            int n = ((Integer[])year2).length;
            int indicator2 = 0;
            while (indicator2 < n) {
                year = year2[indicator2];
                Ordinal time = new Ordinal((Integer)year);
                Double value = houseStatistics3.meanOverSequences(time, indicator);
                endLine3 = value == null ? String.valueOf(endLine3) + "\t" : String.valueOf(endLine3) + value + "\t";
                ++indicator2;
            }
            endLine3 = String.valueOf(endLine3) + houseStatistics3.getMeanTrend(indicator) + "\t";
        }
        reportReferentKin.outputs().appendln(endLine3);
        for (String indicator : indicators4) {
            year2 = criteria.getDates();
            int n = ((Integer[])year2).length;
            int indicator2 = 0;
            while (indicator2 < n) {
                year = year2[indicator2];
                Ordinal time = new Ordinal((Integer)year);
                Double value = houseStatistics4.meanOverSequences(time, indicator);
                endLine4 = value == null ? String.valueOf(endLine4) + "\t" : String.valueOf(endLine4) + value + "\t";
                ++indicator2;
            }
            endLine4 = String.valueOf(endLine4) + houseStatistics4.getMeanTrend(indicator) + "\t";
        }
        reportKin.outputs().appendln(endLine4);
        for (String indicator : indicators5) {
            year2 = criteria.getDates();
            int n = ((Integer[])year2).length;
            int indicator2 = 0;
            while (indicator2 < n) {
                year = year2[indicator2];
                Ordinal time = new Ordinal((Integer)year);
                Double value = houseStatistics5.meanOverSequences(time, indicator);
                endLine5 = value == null ? String.valueOf(endLine5) + "\t" : String.valueOf(endLine5) + value + "\t";
                ++indicator2;
            }
            endLine5 = String.valueOf(endLine5) + houseStatistics5.getMeanTrend(indicator) + "\t";
        }
        reportReferentChain.outputs().appendln(endLine5);
        StringList pajekBuffer1 = new StringList();
        for (String matrixIndicator : matrixIndicators) {
            Report reportMatrices = new Report("Matrix_" + matrixIndicator);
            reportMatrices.outputs().appendln("Transition Matrix " + matrixIndicator);
            reportMatrices.outputs().appendln();
            SequenceStatistics houseStatistics = null;
            Map sequenceCensus = null;
            if (matrixIndicator.equals("KIN")) {
                houseStatistics = houseStatistics3;
                sequenceCensus = referentKinCensus;
            } else if (matrixIndicator.equals("CHAIN")) {
                houseStatistics = houseStatistics5;
                sequenceCensus = referentChainCensus;
            }
            Matrix matrix = houseStatistics.getTransitionMatrix(sequenceCensus, sequences);
            Map<Value, Double> meanValueFrequencies = houseStatistics.getMeanValueFrequencies(sequenceCensus, sequences);
            String headLine = "\t";
            int col = 0;
            while (col < matrix.getRowDim()) {
                headLine = String.valueOf(headLine) + matrix.getColLabel(col) + "\t";
                ++col;
            }
            reportMatrices.outputs().appendln(headLine);
            int row = 0;
            while (row < matrix.getRowDim()) {
                String rowLine = String.valueOf(matrix.getRowLabel(row)) + "\t";
                int col2 = 0;
                while (col2 < matrix.getRowDim()) {
                    rowLine = String.valueOf(rowLine) + matrix.getAsRowPercentage(row, col2) + "\t";
                    ++col2;
                }
                reportMatrices.outputs().appendln(rowLine);
                ++row;
            }
            reportMatrices.outputs().appendln();
            Graph<Node<String>> transitionGraph = new Graph<Node<String>>("Transition Graph " + criteria.getRelationModelName() + " " + matrixIndicator);
            int row2 = 0;
            while (row2 < matrix.getRowDim()) {
                Node<String> node = new Node<String>(row2, matrix.getRowLabel(row2));
                if (meanValueFrequencies.get(new Value(matrix.getRowLabel(row2))) == null) {
                    node.setAttribute("MEAN", "0.");
                } else {
                    node.setAttribute("MEAN", "" + meanValueFrequencies.get(new Value(matrix.getRowLabel(row2))));
                }
                transitionGraph.addNode(row2, node);
                ++row2;
            }
            int row3 = 0;
            while (row3 < matrix.getRowDim()) {
                int col3 = 0;
                while (col3 < matrix.getRowDim()) {
                    if (matrix.get(row3, col3) > 0) {
                        Link arc = transitionGraph.addArc(row3, col3, (double)matrix.get(row3, col3));
                        RelationWorker.TransformationType transformationType = RelationWorker.getTransformationType(matrix.getRowLabel(row3).split("\\s"), matrix.getColLabel(col3).split("\\s"));
                        arc.setTag(String.valueOf(transformationType.ordinal()) + " " + (Object)((Object)transformationType));
                    }
                    ++col3;
                }
                ++row3;
            }
            ArrayList<String> partitionLabels = new ArrayList<String>();
            partitionLabels.add("MEAN");
            pajekBuffer1.addAll((Collection)PuckUtils.writePajekNetwork(transitionGraph, partitionLabels));
            pajekBuffer1.appendln();
            result.outputs().append(reportMatrices);
            result.outputs().append(GraphReporter.reportStrengthsByTags(transitionGraph));
        }
        if (pajekBuffer2.length() != 0) {
            targetFile = ToolBox.setExtension(ToolBox.addToName(new File("Sponsor network "), criteria.getLocalUnitLabel()), ".paj");
            rawData = new ReportRawData("Export Sponsor Networks to Pajek", "Pajek", "paj", targetFile);
            rawData.setData(PAJFile.convertToMicrosoftEndOfLine(pajekBuffer2.toString()));
            result.outputs().appendln();
            result.outputs().append(rawData);
        }
        if (pajekBuffer1.length() != 0) {
            targetFile = ToolBox.setExtension(ToolBox.addToName(new File("Transition graphs_"), criteria.getLocalUnitLabel()), ".paj");
            rawData = new ReportRawData("Export Transition Graphs to Pajek", "Pajek", "paj", targetFile);
            rawData.setData(PAJFile.convertToMicrosoftEndOfLine(pajekBuffer1.toString()));
            result.outputs().appendln();
            result.outputs().append(rawData);
        }
        result.outputs().append(reportOverview);
        result.outputs().append(reportMetrics);
        result.outputs().append(reportMorphology);
        result.outputs().append(reportReferentKin);
        result.outputs().append(reportKin);
        result.outputs().append(reportReferentChain);
        result.outputs().append(reportFlow);
        result.setTimeSpent(chrono.stop().interval());
        return result;
    }
}

