/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.spacetime;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.tip.puck.net.Attributable;
import org.tip.puck.net.Individual;
import org.tip.puck.net.Individuals;
import org.tip.puck.net.Populatable;
import org.tip.puck.net.relations.Relation;
import org.tip.puck.spacetime.EgoRelationSequence;
import org.tip.puck.spacetime.EgoRelationSequences;
import org.tip.puck.spacetime.Ordinal;
import org.tip.puck.spacetime.Sequenceable;
import org.tip.puck.spacetime.Sequences;
import org.tip.puck.util.Numberable;
import org.tip.puck.util.NumberablesHashMap;

public class Sequence<E>
implements Comparable<Sequence<E>>,
Numberable,
Sequenceable<E> {
    int id;
    Map<Ordinal, E> stations = new TreeMap<Ordinal, E>();
    String idLabel;
    private Map<E, String> stationTypes;

    public Sequence() {
    }

    public Sequence(String idLabel, int id) {
        this.idLabel = idLabel;
        this.id = id;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public void setId(int id) {
        this.id = id;
    }

    @Override
    public String idLabel() {
        return this.idLabel;
    }

    @Override
    public E getStation(Ordinal time) {
        E result = time != null ? (E)this.stations.get(time) : null;
        return result;
    }

    @Override
    public String hashKey() {
        return String.valueOf(this.id);
    }

    @Override
    public int compareTo(Sequence<E> sequence) {
        return Integer.valueOf(this.id).compareTo(sequence.id);
    }

    public Ordinal getFirstTime() {
        Ordinal result = (Ordinal)((TreeMap)this.stations).firstKey();
        return result;
    }

    public Ordinal getNextTime(Ordinal key) {
        Ordinal result = key != null ? ((TreeMap)this.stations).higherKey(key) : null;
        return result;
    }

    public Ordinal getNextFreeTime(Ordinal key, Set<Ordinal> filter) {
        Ordinal result;
        if (key != null) {
            result = ((TreeMap)this.stations).higherKey(key);
            if (result != null && filter.contains(result)) {
                result = this.getNextFreeTime(result, filter);
            }
        } else {
            result = null;
        }
        return result;
    }

    public List<String> getStationTypesAsSortedList() {
        ArrayList<String> result = new ArrayList<String>();
        for (String type : this.getStationTypes().values()) {
            if (result.contains(type)) continue;
            result.add(type);
        }
        Collections.sort(result);
        return result;
    }

    public String getStationTypesAsString() {
        String result = "";
        boolean first = true;
        List<String> list = this.getStationTypesAsSortedList();
        if (this.getStationTypes() != null) {
            for (String type : list) {
                if (first) {
                    result = String.valueOf(result) + type;
                    first = false;
                    continue;
                }
                result = String.valueOf(result) + ";" + type;
            }
        }
        return result;
    }

    public int getNrStations() {
        return this.stations.size();
    }

    public int getNrStationTypes() {
        int result = this.getStationTypes() != null ? this.getStationTypesAsSortedList().size() : 0;
        return result;
    }

    public String getStationType(E station) {
        String result = this.getStationTypes().get(station);
        return result;
    }

    public Map<Ordinal, E> getStations() {
        return this.stations;
    }

    public void put(Ordinal ordinal, E station) {
        this.stations.put(ordinal, station);
    }

    public List<E> toList() {
        ArrayList<E> result = new ArrayList<E>(this.stations.values());
        return result;
    }

    public String toValueString() {
        String result = "";
        for (E value : this.toList()) {
            result = value != null ? String.valueOf(result) + value + " " : String.valueOf(result) + "_ ";
        }
        return result;
    }

    public List<Ordinal> getTimes() {
        ArrayList<Ordinal> result = new ArrayList<Ordinal>(this.stations.keySet());
        Collections.sort(result);
        return result;
    }

    public List<Integer> getYears() {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (Ordinal time : this.getTimes()) {
            if (result.contains(time.getYear())) {
                result.add(time.getYear());
                continue;
            }
            System.err.println("Warning: multiple occurence of year " + time.getYear());
        }
        return result;
    }

    public String toString() {
        return String.valueOf(this.id);
    }

    public Map<E, String> getStationTypes() {
        return this.stationTypes;
    }

    public void setStationTypes(Map<E, String> stationTypes) {
        this.stationTypes = stationTypes;
    }

    public Individuals getIndividuals() {
        Individuals result = new Individuals();
        for (E station : this.stations.values()) {
            if (!(station instanceof Populatable)) continue;
            result.add(((Populatable)station).getIndividuals());
        }
        return result;
    }

    public <V extends Numberable> List<String> idValues() {
        ArrayList<String> result = new ArrayList<String>();
        for (E station : this.stations.values()) {
            if (!(station instanceof NumberablesHashMap)) continue;
            for (Numberable stationItem : (NumberablesHashMap)station) {
                String idValue;
                if (!(stationItem instanceof Attributable) || result.contains(idValue = ((Attributable)((Object)stationItem)).getAttributeValue(this.idLabel))) continue;
                result.add(idValue);
            }
        }
        Collections.sort(result);
        return result;
    }

    public <V extends Numberable> Map<String, Individuals> membersByRelationId() {
        TreeMap<String, Individuals> result = new TreeMap<String, Individuals>();
        for (E station : this.stations.values()) {
            if (!(station instanceof NumberablesHashMap)) continue;
            for (Numberable stationItem : (NumberablesHashMap)station) {
                String idValue;
                if (!(stationItem instanceof Populatable & stationItem instanceof Attributable) || (idValue = ((Attributable)((Object)stationItem)).getAttributeValue(this.idLabel)) == null) continue;
                Individuals members = (Individuals)result.get(idValue);
                if (members == null) {
                    members = new Individuals();
                    result.put(idValue, members);
                }
                members.add(((Populatable)((Object)stationItem)).getIndividuals());
            }
        }
        return result;
    }

    public <V extends Numberable> Sequences<V> toSequencesByIdValue() {
        Sequences result = new Sequences();
        for (Ordinal time : this.getTimes()) {
            E station = this.stations.get(time);
            if (!(station instanceof NumberablesHashMap)) continue;
            for (Numberable stationItem : (NumberablesHashMap)station) {
                String idValue = ((Attributable)((Object)stationItem)).getAttributeValue(this.idLabel);
                if (idValue == null) continue;
                Integer id = Integer.parseInt(idValue);
                Sequence<Numberable> sequence = (Sequence<Numberable>)result.getById(id);
                if (sequence == null) {
                    sequence = new Sequence<Numberable>(this.idLabel, id);
                    result.put(sequence);
                }
                sequence.put(time, stationItem);
            }
        }
        return result;
    }

    public <V extends Numberable> EgoRelationSequences toSequencesByEgo() {
        EgoRelationSequences result = new EgoRelationSequences();
        for (Ordinal time : this.getTimes()) {
            E station = this.stations.get(time);
            if (!(station instanceof NumberablesHashMap)) continue;
            for (Numberable stationItem : (NumberablesHashMap)station) {
                for (Individual ego : ((Populatable)((Object)stationItem)).getIndividuals()) {
                    EgoRelationSequence indiSequence = (EgoRelationSequence)result.getById(ego.getId());
                    if (indiSequence == null) {
                        indiSequence = new EgoRelationSequence(ego);
                        result.put(indiSequence);
                    }
                    indiSequence.put(time, (Relation)stationItem);
                }
            }
        }
        return result;
    }
}

