/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.net.workers;

import fr.devinsy.util.StringList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.apache.commons.lang3.StringUtils;
import org.tip.puck.net.workers.AttributeFilter;

public class AttributeFilters
implements Iterable<AttributeFilter> {
    private ArrayList<AttributeFilter> attributeFilters;

    public AttributeFilters() {
        this.attributeFilters = new ArrayList();
    }

    public AttributeFilters(int initialCapacity) {
        this.attributeFilters = new ArrayList(initialCapacity);
    }

    public void add(AttributeFilter source) {
        if (source == null) {
            throw new IllegalArgumentException("source is null.");
        }
        this.attributeFilters.add(source);
    }

    public AttributeFilters addAll(AttributeFilters source) {
        if (source != null) {
            for (AttributeFilter filter : source) {
                this.add(filter);
            }
        }
        AttributeFilters result = this;
        return result;
    }

    public void clear() {
        this.attributeFilters.clear();
    }

    public AttributeFilters copy() {
        AttributeFilters result = new AttributeFilters(this.attributeFilters.size());
        for (AttributeFilter comment : this.attributeFilters) {
            result.add(comment);
        }
        return result;
    }

    public AttributeFilters findBy(AttributeFilter.Mode mode) {
        AttributeFilters result = new AttributeFilters();
        for (AttributeFilter filter : this) {
            if (filter.getMode() != mode) continue;
            result.add(filter);
        }
        return result;
    }

    public AttributeFilters findBy(AttributeFilter.Scope scope) {
        AttributeFilters result = new AttributeFilters();
        for (AttributeFilter filter : this) {
            if (filter.getScope() != scope) continue;
            result.add(filter);
        }
        return result;
    }

    public AttributeFilters findBy(AttributeFilter.Scope scope, AttributeFilter.Mode mode) {
        AttributeFilters result = new AttributeFilters();
        for (AttributeFilter filter : this) {
            if (!(filter.getScope() == scope & filter.getMode() == mode)) continue;
            result.add(filter);
        }
        return result;
    }

    public AttributeFilters findBy(AttributeFilter.Scope scope, String label) {
        AttributeFilters result = new AttributeFilters();
        for (AttributeFilter filter : this) {
            if (filter.getScope() != scope || !StringUtils.equals((CharSequence)filter.getLabel(), (CharSequence)label)) continue;
            result.add(filter);
        }
        return result;
    }

    public AttributeFilters findBy(String relationName, String label) {
        AttributeFilters result = new AttributeFilters();
        for (AttributeFilter filter : this) {
            if (filter.getScope() != AttributeFilter.Scope.RELATION || !StringUtils.equals((CharSequence)filter.getOptionalRelationName(), (CharSequence)relationName) || !StringUtils.equals((CharSequence)filter.getLabel(), (CharSequence)label)) continue;
            result.add(filter);
        }
        return result;
    }

    public AttributeFilters first(int targetCount) {
        AttributeFilters result = new AttributeFilters(targetCount);
        boolean ended = false;
        Iterator<AttributeFilter> iterator = this.iterator();
        int count = 0;
        while (!ended) {
            if (count > targetCount || !iterator.hasNext()) {
                ended = true;
                continue;
            }
            result.add(iterator.next());
            ++count;
        }
        return result;
    }

    public AttributeFilter getByIndex(int index) {
        AttributeFilter result = this.attributeFilters.get(index);
        return result;
    }

    public boolean isEmpty() {
        boolean result = this.attributeFilters.isEmpty();
        return result;
    }

    public boolean isNotEmpty() {
        boolean result = !this.isEmpty();
        return result;
    }

    @Override
    public Iterator<AttributeFilter> iterator() {
        Iterator<AttributeFilter> result = this.attributeFilters.iterator();
        return result;
    }

    public AttributeFilter last() {
        AttributeFilter result = this.attributeFilters.isEmpty() ? null : this.attributeFilters.get(this.attributeFilters.size() - 1);
        return result;
    }

    public synchronized void remove(AttributeFilter message) {
        this.attributeFilters.remove(message);
    }

    public AttributeFilters reverse() {
        Collections.reverse(this.attributeFilters);
        AttributeFilters result = this;
        return result;
    }

    public int size() {
        int result = this.attributeFilters.size();
        return result;
    }

    public String toString() {
        StringList buffer = new StringList();
        for (AttributeFilter attributeFilter : this) {
            String infos = attributeFilter.toString();
            if (infos == null) continue;
            buffer.append(infos);
        }
        String result = buffer.toStringWithCommas();
        return result;
    }
}

