/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.net.relations.workers;

import java.util.ArrayList;
import java.util.List;
import org.tip.puck.PuckException;
import org.tip.puck.PuckExceptions;
import org.tip.puck.census.workers.CensusCriteria;
import org.tip.puck.census.workers.CensusReporter;
import org.tip.puck.census.workers.CircuitType;
import org.tip.puck.census.workers.RestrictionType;
import org.tip.puck.net.relations.Relation;
import org.tip.puck.report.Report;
import org.tip.puck.segmentation.Segmentation;
import org.tip.puck.spacetime.workers.SpaceTimeCriteria;

public class RelationReporter {
    public static List<Report> reportRelationCensus(Segmentation segmentation, SpaceTimeCriteria criteria) throws PuckException {
        if (segmentation == null || criteria.getRelationModelName() == null || criteria.getEgoRoleName() == null) {
            throw PuckExceptions.INVALID_PARAMETER.create("Null parameter detected. " + segmentation + " " + criteria.getRelationModelName() + " " + criteria.getEgoRoleName(), new Object[0]);
        }
        ArrayList<Report> result = new ArrayList<Report>();
        CensusCriteria censusCriteria = new CensusCriteria();
        censusCriteria.setCircuitType(CircuitType.RING);
        censusCriteria.setClosingRelation(criteria.getRelationModelName());
        censusCriteria.setClosingRelationEgoRole(criteria.getEgoRoleName());
        censusCriteria.setPattern(criteria.getPattern());
        censusCriteria.setRelationAttributeLabel(criteria.getLocalUnitLabel());
        censusCriteria.setDateLabel(criteria.getDateLabel());
        censusCriteria.setChainClassification(criteria.getChainClassification());
        censusCriteria.setRestrictionType(RestrictionType.ALL);
        Integer[] times = criteria.getDates();
        for (Relation relation : segmentation.getAllRelations().getByModelName(criteria.getRelationModelName())) {
            relation.updateReferents(criteria.getDefaultReferentRoleName());
        }
        for (String alterRoleName : criteria.getRoleNames()) {
            censusCriteria.setClosingRelationAlterRole(alterRoleName);
            if (times == null) {
                Report report = CensusReporter.reportFindCircuit(segmentation, censusCriteria, null);
                report.setTitle("Relations " + criteria.getEgoRoleName() + " " + alterRoleName);
                result.add(report);
                continue;
            }
            int i = 0;
            while (i < times.length) {
                censusCriteria.setRelationTime(times[i]);
                Report report = CensusReporter.reportFindCircuit(segmentation, censusCriteria, null);
                report.setTitle("Relations " + criteria.getEgoRoleName() + " " + alterRoleName + " " + times[i]);
                result.add(report);
                ++i;
            }
        }
        return result;
    }
}

