/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.io.selz;

import fr.devinsy.util.StringList;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.lang3.text.WordUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.PuckException;
import org.tip.puck.PuckExceptions;
import org.tip.puck.io.selz.SELZTXTFamilyLine;
import org.tip.puck.io.selz.SELZTXTIndividualLine;
import org.tip.puck.io.selz.SELZTXTLabelsLine;
import org.tip.puck.io.selz.SELZTXTRelationLine;
import org.tip.puck.net.Attribute;
import org.tip.puck.net.Attributes;
import org.tip.puck.net.Families;
import org.tip.puck.net.Family;
import org.tip.puck.net.Gender;
import org.tip.puck.net.Individual;
import org.tip.puck.net.Individuals;
import org.tip.puck.net.Net;
import org.tip.puck.net.UnionStatus;
import org.tip.puck.net.relations.Actor;
import org.tip.puck.net.relations.Actors;
import org.tip.puck.net.relations.Relation;
import org.tip.puck.net.relations.RelationModel;
import org.tip.puck.net.relations.RelationModels;
import org.tip.puck.net.relations.Relations;
import org.tip.puck.net.relations.Role;
import org.tip.puck.net.workers.NetUtils;
import org.tip.puck.report.Report;
import org.tip.puck.util.LogHelper;

public class SELZTXTFile {
    private static final Logger logger = LoggerFactory.getLogger(SELZTXTFile.class);
    public static final String DEFAULT_CHARSET_NAME = "UTF-8";
    public static final int MAX_LINE_SIZE = 2048;
    public static Map<String, Integer> idMap;
    public static Map<String, Integer> ordMap;

    public static Net load(File file) throws PuckException {
        Net result = SELZTXTFile.load(file, DEFAULT_CHARSET_NAME);
        return result;
    }

    public static Net load(File file, String charsetName) throws PuckException {
        Net result;
        BufferedReader in = null;
        try {
            try {
                in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), charsetName));
                result = SELZTXTFile.read(in);
                result.setLabel(file.getName());
            }
            catch (UnsupportedEncodingException exception) {
                throw PuckExceptions.UNSUPPORTED_ENCODING.create("Opening file [" + file + "]", new Object[0]);
            }
            catch (FileNotFoundException exception) {
                throw PuckExceptions.FILE_NOT_FOUND.create("Opening file [" + file + "]", new Object[0]);
            }
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException exception) {
                logger.warn("Not managed error.");
                exception.printStackTrace();
            }
        }
        return result;
    }

    public static Net read(BufferedReader in) throws PuckException {
        Net result = new Net();
        SELZTXTFile.readCorpusAttributes(result.attributes(), in);
        SELZTXTFile.readIndividuals(result, in);
        SELZTXTFile.readFamilies(result, in);
        boolean ended = false;
        while (!ended) {
            if (SELZTXTFile.readRelations(result, in)) continue;
            ended = true;
        }
        SELZTXTFile.readPGraphNames(result);
        return result;
    }

    private static void readMacherelNames(Net net) {
        for (Family family : net.families()) {
            Individual father;
            String fatherName = "";
            String motherName = "";
            String firstNamesAttribute = family.getAttributeValue("FIRSTNAMES");
            if (firstNamesAttribute == null) continue;
            String[] firstNames = firstNamesAttribute.split("-");
            fatherName = String.valueOf(firstNames[0]) + " / " + family.getAttributeValue("LIGNEE_H");
            if (firstNames.length > 1) {
                motherName = String.valueOf(firstNames[1]) + " / " + family.getAttributeValue("LIGNEE_W");
            }
            if ((father = family.getFather()) != null) {
                if (StringUtils.isEmpty((CharSequence)father.getName())) {
                    father.setName(fatherName);
                } else if (father.getName().equals("fatherName")) {
                    System.err.println("Name divergence " + father.getId() + " " + father.getName() + " vs " + fatherName);
                }
            } else if (!StringUtils.isEmpty((CharSequence)fatherName)) {
                family.setFather(net.createIndividual(fatherName, Gender.MALE));
                System.out.println("created " + family.getFather() + " " + family);
            }
            Individual mother = family.getMother();
            if (mother != null) {
                if (StringUtils.isEmpty((CharSequence)mother.getName())) {
                    mother.setName(motherName);
                    continue;
                }
                if (!mother.getName().equals("motherName")) continue;
                System.err.println("Name divergence " + mother.getId() + " " + mother.getName() + " vs " + motherName);
                continue;
            }
            if (StringUtils.isEmpty((CharSequence)motherName)) continue;
            family.setMother(net.createIndividual(motherName, Gender.FEMALE));
            System.out.println("created " + family.getMother() + " " + family);
        }
    }

    private static void readPGraphNames(Net net) throws PuckException {
        for (Family family : net.families()) {
            Individual father;
            String fatherName = family.getAttributeValue("NameH");
            String motherName = family.getAttributeValue("NameW");
            if (fatherName != null && (father = family.getFather()) != null) {
                if (StringUtils.isEmpty((CharSequence)father.getName())) {
                    String fatherDeathDate;
                    father.setName(fatherName);
                    String fatherBirthDate = family.getAttributeValue("H_BIRT_DATE");
                    if (fatherBirthDate != null) {
                        father.setAttribute("BIRT_DATE", fatherBirthDate);
                    }
                    if ((fatherDeathDate = family.getAttributeValue("H_DEAT_DATE")) != null) {
                        father.setAttribute("DEAT_DATE", fatherDeathDate);
                    }
                } else if (father.getName().equals("fatherName")) {
                    System.err.println("Name divergence " + father.getId() + " " + father.getName() + " vs " + fatherName);
                }
            }
            if (motherName == null) continue;
            Individual mother = family.getMother();
            if (mother != null) {
                if (StringUtils.isEmpty((CharSequence)mother.getName())) {
                    String motherDeathDate;
                    mother.setName(motherName);
                    String motherBirthDate = family.getAttributeValue("W_BIRT_DATE");
                    if (motherBirthDate != null) {
                        mother.setAttribute("BIRT_DATE", motherBirthDate);
                    }
                    if ((motherDeathDate = family.getAttributeValue("W_DEAT_DATE")) == null) continue;
                    mother.setAttribute("DEAT_DATE", motherDeathDate);
                    continue;
                }
                if (!mother.getName().equals("motherName")) continue;
                System.err.println("Name divergence " + mother.getId() + " " + mother.getName() + " vs " + motherName);
                continue;
            }
            if (StringUtils.isEmpty((CharSequence)motherName)) continue;
            family.setMother(net.createIndividual(motherName, Gender.FEMALE));
            System.out.println("created " + family.getMother() + " " + family);
        }
        for (Family family : net.families()) {
            block2: for (Individual child : family.getChildren()) {
                for (Individual otherChild : family.getChildren()) {
                    if (otherChild.getId() >= child.getId()) continue block2;
                    if (child.getName() == null || !child.getName().equals(otherChild.getName())) continue;
                    child.setName(String.valueOf(otherChild.getId()));
                }
            }
        }
        NetUtils.eliminateDoubleIndividuals(net, net.individuals(), new Report());
    }

    public static SELZTXTLabelsLine readCorpusAttributeLabelsLine(BufferedReader in) throws PuckException {
        SELZTXTLabelsLine result;
        try {
            in.mark(2048);
            String line = SELZTXTFile.readNotEmptyLine(in);
            if (line == null) {
                result = null;
            } else if (line.matches("^[Ii][Dd]\\t.*$") || line.matches("^\\d.*$")) {
                in.reset();
                result = null;
            } else {
                String[] tokens = line.split("\\t");
                result = new SELZTXTLabelsLine();
                String[] stringArray = tokens;
                int n = tokens.length;
                int n2 = 0;
                while (n2 < n) {
                    String token = stringArray[n2];
                    result.add(token);
                    ++n2;
                }
            }
        }
        catch (IOException exception) {
            throw PuckExceptions.IO_ERROR.create(exception, "Reading labels line.", new Object[0]);
        }
        return result;
    }

    public static void readCorpusAttributes(Attributes target, BufferedReader in) throws PuckException {
        SELZTXTLabelsLine valuesLine;
        logger.debug("Read corpus attributes.");
        SELZTXTLabelsLine labelsLine = SELZTXTFile.readCorpusAttributeLabelsLine(in);
        if (labelsLine != null && (valuesLine = SELZTXTFile.readLabelsLine(in)) != null) {
            int valueCount = 0;
            while (valueCount < valuesLine.size()) {
                String label = (String)labelsLine.get(valueCount);
                String value = (String)valuesLine.get(valueCount);
                if (StringUtils.isNotBlank((CharSequence)value)) {
                    target.put(label, value);
                }
                ++valueCount;
            }
        }
    }

    public static void readFamilies(Net target, BufferedReader in) throws PuckException {
        logger.debug("Read families.");
        SELZTXTLabelsLine labelsLine = SELZTXTFile.readLabelsLine(in);
        boolean ended = false;
        while (!ended) {
            UnionStatus status;
            Individual mother;
            Individual father;
            SELZTXTFamilyLine source = SELZTXTFile.readFamilyLine(in);
            if (source == null) {
                ended = true;
                continue;
            }
            if (source.getId() == 0) continue;
            if (source.getFatherId() == 0) {
                father = null;
            } else {
                father = (Individual)target.individuals().getById(source.getFatherId());
                if (father == null) {
                    father = target.createIndividual(source.getFatherId());
                    father.setGender(Gender.MALE);
                    father.setAttribute("ID-Selz", String.valueOf(source.getFatherFamilyId()) + "-" + source.getFatherOrd());
                }
            }
            if (source.getMotherId() == 0) {
                mother = null;
            } else {
                mother = (Individual)target.individuals().getById(source.getMotherId());
                if (mother == null) {
                    mother = target.createIndividual(source.getMotherId());
                    mother.setGender(Gender.FEMALE);
                    mother.setAttribute("ID-Selz", String.valueOf(source.getMotherFamilyId()) + "-" + source.getMotherOrd());
                }
            }
            switch (source.getStatus()) {
                case 'U': {
                    status = UnionStatus.UNMARRIED;
                    break;
                }
                case 'M': {
                    status = UnionStatus.MARRIED;
                    break;
                }
                case 'D': {
                    status = UnionStatus.DIVORCED;
                    break;
                }
                default: {
                    throw PuckExceptions.BAD_FILE_FORMAT.create("Unknown union status [" + source.getStatus() + "]", new Object[0]);
                }
            }
            Family family = target.createFamily(source.getId(), father, mother, status);
            family.setHusbandOrder(source.getFatherOrd());
            family.setWifeOrder(source.getMotherOrd());
            if (StringUtils.isNotBlank((CharSequence)source.getChildIds())) {
                String[] ids;
                String[] stringArray = ids = source.getChildIds().split("[ .,;]+");
                int n = ids.length;
                int n2 = 0;
                while (n2 < n) {
                    String childId = stringArray[n2];
                    if (NumberUtils.isNumber((String)childId)) {
                        Individual child = (Individual)target.individuals().getById(Integer.parseInt(childId));
                        if (child == null) {
                            child = target.createIndividual(Integer.parseInt(childId));
                        }
                        if (child.getOriginFamily() == null) {
                            child.setOriginFamily(family);
                            family.getChildren().add(child);
                        } else {
                            throw PuckExceptions.BAD_FILE_FORMAT.create("Child [" + child.getId() + "] defined in two different families [" + child.getOriginFamily().getId() + "][" + family.getId() + "]", new Object[0]);
                        }
                    }
                    ++n2;
                }
            }
            int valueCount = 0;
            while (valueCount < source.attributeValues().size()) {
                logger.debug("valueCount=" + valueCount + " " + source.attributeValues().size() + " " + source.attributeValues().get(valueCount));
                String label = (String)labelsLine.get(valueCount + 5);
                String value = source.attributeValues().get(valueCount);
                if (StringUtils.isNotBlank((CharSequence)value)) {
                    family.attributes().put(label, value);
                }
                ++valueCount;
            }
        }
        if (idMap != null) {
            for (String token : idMap.keySet()) {
                Individual child = (Individual)target.individuals().getById(idMap.get(token));
                String[] tokens = token.split("\\;");
                int familyId = Double.valueOf(tokens[0]).intValue();
                Family family = (Family)target.families().getById(familyId);
                if (family != null) {
                    if (child.getOriginFamily() == null) {
                        child.setOriginFamily(family);
                        family.getChildren().add(child);
                        child.setAttribute("ORD", tokens[1]);
                        child.setBirthOrder(Double.valueOf(tokens[1]).intValue());
                        continue;
                    }
                    throw PuckExceptions.BAD_FILE_FORMAT.create("Child [" + child.getId() + " " + child.getName() + "] defined in two different families [" + child.getOriginFamily().getId() + "][" + family.getId() + "]", new Object[0]);
                }
                System.err.println("Warning: Family with id " + familyId + " does not exist");
            }
        }
    }

    public static SELZTXTFamilyLine readFamilyLine(BufferedReader in) throws PuckException {
        SELZTXTFamilyLine result;
        block27: {
            try {
                in.mark(2048);
                String line = SELZTXTFile.readNotEmptyLine(in);
                if (line == null) {
                    result = null;
                    break block27;
                }
                if (line.matches("^\\d.*$")) {
                    Integer ord;
                    String[] tokens = line.split("\\t");
                    result = new SELZTXTFamilyLine();
                    result.setId(Double.valueOf(tokens[0]).intValue());
                    if (tokens.length > 1) {
                        String statusToken = tokens[1].trim().toUpperCase();
                        if (statusToken.length() == 0) {
                            result.setStatus('U');
                        } else if (statusToken.length() == 1) {
                            result.setStatus(statusToken.charAt(0));
                        } else {
                            throw PuckExceptions.BAD_FILE_FORMAT.create("Bad union status [" + tokens[1] + "].", new Object[0]);
                        }
                    }
                    if (tokens.length > 2 && !tokens[2].equals("0;0")) {
                        try {
                            if (StringUtils.isNotBlank((CharSequence)tokens[2])) {
                                if (ordMap == null) {
                                    ordMap = new TreeMap<String, Integer>();
                                }
                                if (idMap == null) {
                                    idMap = new TreeMap<String, Integer>();
                                }
                                ord = (ord = ordMap.get(tokens[2])) == null ? Integer.valueOf(1) : Integer.valueOf(ord + 1);
                                ordMap.put(tokens[2], ord);
                                result.setFatherId(idMap.size() + 1);
                                idMap.put(String.valueOf(tokens[2]) + ";" + ord, idMap.size() + 1);
                                result.setFatherFamilyId(Double.valueOf(tokens[2]).intValue());
                                result.setFatherOrd(ord);
                            } else {
                                result.setFatherId(0);
                            }
                        }
                        catch (NumberFormatException nfe) {
                            Integer fatherId = idMap.get(tokens[2]);
                            if (fatherId != null) {
                                result.setFatherId(fatherId);
                            }
                            result.setFatherId(idMap.size() + 1);
                            idMap.put(tokens[2], idMap.size() + 1);
                            String[] fathertokens = tokens[2].split("\\;");
                            result.setFatherFamilyId(Double.valueOf(fathertokens[0]).intValue());
                            result.setFatherOrd(Double.valueOf(fathertokens[1]).intValue());
                        }
                    }
                    if (tokens.length > 3 && !tokens[3].equals("0;0")) {
                        try {
                            if (StringUtils.isNotEmpty((CharSequence)tokens[3])) {
                                if (ordMap == null) {
                                    ordMap = new TreeMap<String, Integer>();
                                }
                                if (idMap == null) {
                                    idMap = new TreeMap<String, Integer>();
                                }
                                ord = (ord = ordMap.get(tokens[3])) == null ? Integer.valueOf(1) : Integer.valueOf(ord + 1);
                                ordMap.put(tokens[3], ord);
                                result.setMotherId(idMap.size() + 1);
                                idMap.put(String.valueOf(tokens[3]) + ";" + ord, idMap.size() + 1);
                                result.setMotherFamilyId(Double.valueOf(tokens[3]).intValue());
                                result.setMotherOrd(ord);
                            } else {
                                result.setMotherId(0);
                            }
                        }
                        catch (NumberFormatException nfe) {
                            Integer motherId = idMap.get(tokens[3]);
                            if (motherId != null) {
                                result.setMotherId(motherId);
                            }
                            result.setMotherId(idMap.size() + 1);
                            idMap.put(tokens[3], idMap.size() + 1);
                            String[] mothertokens = tokens[3].split("\\;");
                            result.setMotherFamilyId(Double.valueOf(mothertokens[0]).intValue());
                            result.setMotherOrd(Double.valueOf(mothertokens[1]).intValue());
                        }
                    }
                    if (tokens.length > 4 && StringUtils.isNotBlank((CharSequence)tokens[4])) {
                        result.setChildIds(tokens[4]);
                    }
                    int tokenCount = 5;
                    while (tokenCount < tokens.length) {
                        result.attributeValues().add(tokens[tokenCount]);
                        ++tokenCount;
                    }
                    break block27;
                }
                in.reset();
                result = null;
            }
            catch (IOException exception) {
                throw PuckExceptions.IO_ERROR.create(exception, "Reading family line.", new Object[0]);
            }
        }
        return result;
    }

    public static SELZTXTIndividualLine readIndividualLine(BufferedReader in) throws PuckException {
        SELZTXTIndividualLine result;
        block12: {
            try {
                in.mark(2048);
                String line = SELZTXTFile.readNotEmptyLine(in);
                if (line == null) {
                    result = null;
                    break block12;
                }
                if (line.matches("^\\d.*$")) {
                    String[] tokens = line.split("\\t");
                    result = new SELZTXTIndividualLine();
                    try {
                        result.setId(Double.valueOf(tokens[0]).intValue());
                    }
                    catch (NumberFormatException nfe) {
                        if (idMap == null) {
                            idMap = new TreeMap<String, Integer>();
                        }
                        String[] firsttokens = tokens[0].split("\\;");
                        result.setFamilyId(Double.valueOf(firsttokens[0]).intValue());
                        result.setFamilyOrd(Double.valueOf(firsttokens[1]).intValue());
                        Integer id = idMap.get(tokens[0]);
                        if (id != null) {
                            result.setId(id);
                        }
                        result.setId(idMap.size() + 1);
                        idMap.put(tokens[0], idMap.size() + 1);
                    }
                    if (tokens.length > 1) {
                        result.setName(tokens[1]);
                    }
                    if (tokens.length > 2 && tokens[2].length() > 0) {
                        result.setGender(tokens[2].charAt(0));
                    } else {
                        result.setGender('X');
                    }
                    int tokenCount = 3;
                    while (tokenCount < tokens.length) {
                        result.attributeValues().add(tokens[tokenCount]);
                        ++tokenCount;
                    }
                    break block12;
                }
                in.reset();
                result = null;
            }
            catch (IOException exception) {
                throw PuckExceptions.IO_ERROR.create(exception, "Reading individual line.", new Object[0]);
            }
        }
        return result;
    }

    public static void readIndividuals(Net target, BufferedReader in) throws PuckException {
        logger.debug("Read individuals.");
        SELZTXTLabelsLine labelsLine = SELZTXTFile.readLabelsLine(in);
        boolean ended = false;
        while (!ended) {
            Individual individual;
            SELZTXTIndividualLine source = SELZTXTFile.readIndividualLine(in);
            if (source == null) {
                ended = true;
                continue;
            }
            if (source.getId() == 0) continue;
            try {
                individual = target.createIndividual(source.getId());
                individual.setAttribute("ID-Selz", String.valueOf(source.getFamilyId()) + "-" + source.getFamilyOrd());
            }
            catch (PuckException exception) {
                throw PuckExceptions.BAD_FILE_FORMAT.create("Individual [" + source.getId() + "] define twice.", new Object[0]);
            }
            if (!StringUtils.isBlank((CharSequence)source.getName())) {
                individual.setName(source.getName());
            }
            if (Gender.valueOf(source.getGender()) != Gender.UNKNOWN) {
                individual.setGender(Gender.valueOf(source.getGender()));
            }
            int valueCount = 0;
            while (valueCount < source.attributeValues().size()) {
                String label = (String)labelsLine.get(valueCount + 3);
                String value = source.attributeValues().get(valueCount);
                if (StringUtils.isNotBlank((CharSequence)value)) {
                    individual.attributes().put(label, value);
                }
                ++valueCount;
            }
        }
    }

    public static SELZTXTLabelsLine readLabelsLine(BufferedReader in) throws PuckException {
        SELZTXTLabelsLine result;
        try {
            in.mark(2048);
            String line = SELZTXTFile.readNotEmptyLine(in);
            if (line == null) {
                result = null;
            } else if (line.matches("^\\d.*$")) {
                in.reset();
                result = null;
            } else {
                String[] tokens = line.split("\\t");
                result = new SELZTXTLabelsLine();
                String[] stringArray = tokens;
                int n = tokens.length;
                int n2 = 0;
                while (n2 < n) {
                    String token = stringArray[n2];
                    result.add(token);
                    ++n2;
                }
            }
        }
        catch (IOException exception) {
            throw PuckExceptions.IO_ERROR.create(exception, "Reading labels line.", new Object[0]);
        }
        return result;
    }

    public static String readNotEmptyLine(BufferedReader in) throws PuckException {
        String result;
        try {
            boolean ended = false;
            result = null;
            while (!ended) {
                String line = in.readLine();
                if (line == null) {
                    ended = true;
                    result = null;
                    continue;
                }
                if (!StringUtils.isNotBlank((CharSequence)line)) continue;
                ended = true;
                result = line;
            }
        }
        catch (IOException exception) {
            throw PuckExceptions.IO_ERROR.create(exception, "Reading line.", new Object[0]);
        }
        return result;
    }

    public static SELZTXTRelationLine readRelationLine(BufferedReader in) throws PuckException {
        SELZTXTRelationLine result;
        try {
            in.mark(2048);
            String line = SELZTXTFile.readNotEmptyLine(in);
            if (line == null) {
                result = null;
            } else if (line.matches("^\\d.*$")) {
                String[] tokens = line.split("\\t");
                result = new SELZTXTRelationLine();
                result.setId(Double.valueOf(tokens[0]).intValue());
                result.setName(tokens[1]);
                int tokenCount = 2;
                while (tokenCount < tokens.length) {
                    result.values().add(tokens[tokenCount]);
                    ++tokenCount;
                }
            } else {
                in.reset();
                result = null;
            }
        }
        catch (IOException exception) {
            throw PuckExceptions.IO_ERROR.create(exception, "Reading individual line.", new Object[0]);
        }
        return result;
    }

    public static boolean readRelations(Net target, BufferedReader in) throws PuckException {
        boolean result;
        SELZTXTLabelsLine labelsLine = SELZTXTFile.readLabelsLine(in);
        if (labelsLine == null || labelsLine.size() != 1) {
            result = false;
        } else {
            String name = ((String)labelsLine.get(0)).length() > 5 ? WordUtils.capitalizeFully((String)((String)labelsLine.get(0))) : (String)labelsLine.get(0);
            RelationModel model = target.relationModels().getByName(name);
            if (model != null) {
                throw PuckExceptions.BAD_FILE_FORMAT.create("Relation model [" + name + "] is defined twice.", new Object[0]);
            }
            model = new RelationModel(name);
            target.relationModels().add(model);
            logger.debug("Relation model=" + model.getName());
            labelsLine = SELZTXTFile.readLabelsLine(in);
            if (labelsLine != null && labelsLine.size() > 1) {
                int labelIndex = 2;
                while (labelIndex < labelsLine.size()) {
                    String label = (String)labelsLine.get(labelIndex);
                    if (!label.startsWith("#")) {
                        model.roles().add(new Role(label, 0));
                    }
                    ++labelIndex;
                }
                if (labelsLine != null && labelsLine.size() > 2) {
                    HashMap<Integer, Relation> relationTypedIdIndex = new HashMap<Integer, Relation>();
                    boolean ended = false;
                    while (!ended) {
                        SELZTXTRelationLine source = SELZTXTFile.readRelationLine(in);
                        if (source == null) {
                            ended = true;
                            continue;
                        }
                        if (source.getId() == 0 || !StringUtils.isNotBlank((CharSequence)source.getName())) continue;
                        Relation relation = (Relation)relationTypedIdIndex.get(source.getId());
                        if (relation == null) {
                            relation = target.createRelation(source.getId(), source.getName(), model);
                            relationTypedIdIndex.put(source.getId(), relation);
                        }
                        int valueCount = 0;
                        while (valueCount < source.values().size()) {
                            String label = (String)labelsLine.get(valueCount + 2);
                            String value = source.values().get(valueCount);
                            if (StringUtils.isNotBlank((CharSequence)value)) {
                                if (label.startsWith("#")) {
                                    relation.attributes().add(new Attribute(label.substring(1), value));
                                } else {
                                    String[] ids;
                                    String[] stringArray = ids = value.split("[ .,;]+");
                                    int n = ids.length;
                                    int n2 = 0;
                                    while (n2 < n) {
                                        String id = stringArray[n2];
                                        target.createRelationActor(relation, Integer.parseInt(id), label);
                                        ++n2;
                                    }
                                }
                            }
                            ++valueCount;
                        }
                    }
                }
            }
            result = true;
        }
        logger.debug("Done.");
        return result;
    }

    public static void save(File file, Net source) throws PuckException {
        PrintWriter out = null;
        try {
            try {
                out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), DEFAULT_CHARSET_NAME));
                SELZTXTFile.write(out, source);
            }
            catch (UnsupportedEncodingException exception) {
                throw PuckExceptions.UNSUPPORTED_ENCODING.create("Opening file [" + file + "]", new Object[0]);
            }
            catch (FileNotFoundException exception) {
                throw PuckExceptions.FILE_NOT_FOUND.create("Opening file [" + file + "]", new Object[0]);
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    public static String toString(SELZTXTFamilyLine source) {
        String result = source == null ? "[null]" : String.format("[id=%d][status=%d][fatherId=%d][motherId=%d][childIds=%s][attributeValues=%s]", source.getId(), Character.valueOf(source.getStatus()), source.getFatherId(), source.getMotherId(), source.getChildIds(), LogHelper.toString(source.attributeValues()));
        return result;
    }

    public static String toString(SELZTXTIndividualLine source) {
        String result = source == null ? "[null]" : String.format("[id=%d][name=%s][gender=%c][attributeValues=%s]", source.getId(), source.getName(), Character.valueOf(source.getGender()), LogHelper.toString(source.attributeValues()));
        return result;
    }

    public static String toString(SELZTXTLabelsLine source) {
        String result;
        if (source == null) {
            result = "[null]";
        } else {
            StringList buffer = new StringList();
            buffer.append("[");
            for (String label : source) {
                buffer.append(label);
                buffer.append(",");
            }
            buffer.removeLast();
            buffer.append("]");
            result = buffer.toString();
        }
        return result;
    }

    public static void write(PrintWriter out, Net source) throws PuckException {
        if (!source.attributes().isEmpty()) {
            SELZTXTFile.writeCorpusAttributes(out, source.attributes());
        }
        SELZTXTFile.writeIndividuals(out, source.individuals());
        SELZTXTFile.writeFamilies(out, source.families());
        SELZTXTFile.writeRelations(out, source.relationModels(), source.relations());
    }

    public static void write(PrintWriter out, SELZTXTFamilyLine source) {
        StringBuffer buffer = new StringBuffer(512);
        buffer.append(String.format("%d\t%c\t%d\t%d", source.getId(), Character.valueOf(source.getStatus()), source.getFatherId(), source.getMotherId()));
        buffer.append("\t");
        if (source.getChildIds() != null) {
            buffer.append(source.getChildIds());
        }
        for (String value : source.attributeValues()) {
            buffer.append("\t");
            buffer.append(value);
        }
        out.println(buffer.toString());
    }

    public static void write(PrintWriter out, SELZTXTIndividualLine source) {
        StringBuffer buffer = new StringBuffer(512);
        buffer.append(String.format("%d\t%s\t%c", source.getId(), source.getName(), Character.valueOf(source.getGender())));
        for (String value : source.attributeValues()) {
            buffer.append("\t");
            buffer.append(value);
        }
        out.println(buffer.toString());
    }

    public static void write(PrintWriter out, SELZTXTLabelsLine source) {
        StringBuffer buffer = new StringBuffer(192);
        for (String value : source) {
            buffer.append(value);
            buffer.append("\t");
        }
        if (buffer.length() > 0) {
            buffer.deleteCharAt(buffer.length() - 1);
        }
        out.println(buffer.toString());
    }

    public static void write(PrintWriter out, SELZTXTRelationLine source) {
        StringBuffer buffer = new StringBuffer(512);
        buffer.append(String.format("%d\t%s", source.getId(), source.getName()));
        for (String value : source.values()) {
            buffer.append("\t");
            buffer.append(value);
        }
        out.println(buffer.toString());
    }

    public static void writeCorpusAttributes(PrintWriter out, Attributes source) {
        if (!source.isEmpty()) {
            logger.debug("Write corpus attributes block.");
            SELZTXTLabelsLine labelsLine = new SELZTXTLabelsLine();
            labelsLine.addAll(source.labels().sort());
            SELZTXTFile.write(out, labelsLine);
            SELZTXTLabelsLine valuesLine = new SELZTXTLabelsLine();
            logger.debug("Write corpus attributes data.");
            for (String label : labelsLine) {
                String value = source.getValue(label);
                if (value == null) {
                    valuesLine.add("");
                    continue;
                }
                valuesLine.add(value.replace('\t', ' '));
            }
            SELZTXTFile.write(out, valuesLine);
        }
        out.println();
    }

    public static void writeFamilies(PrintWriter out, Families source) throws PuckException {
        logger.debug("Write families block.");
        SELZTXTLabelsLine labelsLine = new SELZTXTLabelsLine();
        labelsLine.add("Id");
        labelsLine.add("Status");
        labelsLine.add("FatherId");
        labelsLine.add("MotherId");
        labelsLine.add("Children");
        labelsLine.addAll(source.getAttributeLabels().sort());
        SELZTXTFile.write(out, labelsLine);
        logger.debug("Write families data.");
        for (Family family : source.toSortedList()) {
            char status;
            SELZTXTFamilyLine target = new SELZTXTFamilyLine();
            target.setId(family.getId());
            switch (family.getUnionStatus()) {
                case UNMARRIED: {
                    status = 'U';
                    break;
                }
                case MARRIED: {
                    status = 'M';
                    break;
                }
                case DIVORCED: {
                    status = 'D';
                    break;
                }
                default: {
                    throw PuckExceptions.INVALID_PARAMETER.create("Unknown union status code  [" + family.getUnionStatus().toString() + "]", new Object[0]);
                }
            }
            target.setStatus(status);
            if (family.getFather() == null) {
                target.setFatherId(0);
            } else {
                target.setFatherId(family.getFather().getId());
            }
            if (family.getMother() == null) {
                target.setMotherId(0);
            } else {
                target.setMotherId(family.getMother().getId());
            }
            StringList buffer = new StringList();
            for (Individual individual : family.getChildren()) {
                buffer.append(individual.getId());
                buffer.append(';');
            }
            buffer.removeLast();
            target.setChildIds(buffer.toString());
            if (!family.attributes().isEmpty()) {
                int labelCount = 5;
                while (labelCount < labelsLine.size()) {
                    String label = (String)labelsLine.get(labelCount);
                    String value = family.getAttributeValue(label);
                    if (value == null) {
                        target.attributeValues().add("");
                    } else {
                        target.attributeValues().add(value.replace('\t', ' '));
                    }
                    ++labelCount;
                }
            }
            SELZTXTFile.write(out, target);
        }
        out.println();
    }

    public static void writeIndividuals(PrintWriter out, Individuals source) {
        logger.debug("Write individuals block.");
        SELZTXTLabelsLine labelsLine = new SELZTXTLabelsLine();
        labelsLine.add("Id");
        labelsLine.add("Name");
        labelsLine.add("Gender");
        labelsLine.addAll(source.getAttributeLabels().sort());
        SELZTXTFile.write(out, labelsLine);
        logger.debug("Write individuals data.");
        for (Individual individual : source.toSortedList()) {
            SELZTXTIndividualLine target = new SELZTXTIndividualLine();
            target.setId(individual.getId());
            target.setName(individual.getName());
            target.setGender(individual.getGender().toChar());
            if (!individual.attributes().isEmpty()) {
                int labelCount = 3;
                while (labelCount < labelsLine.size()) {
                    String label = (String)labelsLine.get(labelCount);
                    String value = individual.getAttributeValue(label);
                    if (value == null) {
                        target.attributeValues().add("");
                    } else {
                        target.attributeValues().add(value.replace('\t', ' '));
                    }
                    ++labelCount;
                }
            }
            SELZTXTFile.write(out, target);
        }
        out.println();
    }

    public static void writeRelations(PrintWriter out, RelationModels models, Relations source) {
        for (RelationModel relationModel : models) {
            Relations relations = source.getByModel(relationModel);
            out.println(relationModel.getName());
            logger.debug("Find labels.");
            SELZTXTLabelsLine labelsLine = new SELZTXTLabelsLine();
            labelsLine.add("Id");
            labelsLine.add("Name");
            labelsLine.addAll(relationModel.roles().nameList());
            for (String attributeLabel : relations.getAttributeLabels().sort()) {
                labelsLine.add("#" + attributeLabel);
            }
            SELZTXTFile.write(out, labelsLine);
            if (!relations.isEmpty()) {
                for (Relation relation : relations.toSortedList()) {
                    SELZTXTRelationLine target = new SELZTXTRelationLine();
                    target.setId(relation.getTypedId());
                    target.setName(relation.getName());
                    for (Role role : relationModel.roles()) {
                        Actors actors = relation.actors().getByRole(role);
                        StringList buffer = new StringList();
                        for (Actor actor : actors) {
                            buffer.append(actor.getId());
                            buffer.append(';');
                        }
                        buffer.removeLast();
                        target.values().add(buffer.toString());
                    }
                    if (!relation.attributes().isEmpty()) {
                        int labelCount = 2 + relationModel.roles().size();
                        while (labelCount < labelsLine.size()) {
                            String label = (String)labelsLine.get(labelCount);
                            String value = relation.getAttributeValue(label.substring(1));
                            if (value == null) {
                                target.values().add("");
                            } else {
                                target.values().add(value.replace('\t', ' '));
                            }
                            ++labelCount;
                        }
                    }
                    SELZTXTFile.write(out, target);
                }
            }
            out.println();
        }
    }
}

