/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puckgui.models;

import java.awt.Color;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.tip.puck.net.Individual;

public class IndividualsCellRenderer
extends JLabel
implements ListCellRenderer {
    private static final long serialVersionUID = 8266004148718271775L;
    private static ImageIcon femaleIcon = new ImageIcon(IndividualsCellRenderer.class.getResource("/org/tip/puckgui/images/female-16x16.png"));
    private static ImageIcon maleIcon = new ImageIcon(IndividualsCellRenderer.class.getResource("/org/tip/puckgui/images/male-16x16.png"));
    private static ImageIcon unknowIcon = new ImageIcon(IndividualsCellRenderer.class.getResource("/org/tip/puckgui/images/unknown-16x16.png"));

    public IndividualsCellRenderer() {
        this.setOpaque(true);
    }

    public Component getListCellRendererComponent(JList list, Object lineObject, int index, boolean isSelected, boolean cellHasFocus) {
        if (lineObject == null) {
            throw new NullPointerException("Invalid null parameter.");
        }
        if (lineObject instanceof String) {
            this.setText((String)lineObject);
        } else {
            Individual individual = (Individual)lineObject;
            switch (individual.getGender()) {
                case FEMALE: {
                    this.setIcon(femaleIcon);
                    break;
                }
                case MALE: {
                    this.setIcon(maleIcon);
                    break;
                }
                case UNKNOWN: {
                    this.setIcon(unknowIcon);
                }
            }
            String name = individual.getName() == null ? "Unknown" : individual.getName();
            this.setText(String.format("(%d) %s", individual.getId(), name));
        }
        Color background = null;
        Color foreground = null;
        if (isSelected) {
            background = list.getSelectionBackground();
            foreground = list.getSelectionForeground();
        } else {
            background = list.getBackground();
            foreground = list.getForeground();
        }
        this.setBackground(background);
        this.setForeground(foreground);
        return this;
    }
}

