/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.spacetime.workers;

import fr.devinsy.util.StringList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.tip.puck.PuckException;
import org.tip.puck.geo.GeoLevel;
import org.tip.puck.graphs.Graph;
import org.tip.puck.graphs.GraphComparatorByArcCount;
import org.tip.puck.graphs.Link;
import org.tip.puck.graphs.Node;
import org.tip.puck.graphs.workers.GraphUtils;
import org.tip.puck.graphs.workers.NodeValuator;
import org.tip.puck.net.Gender;
import org.tip.puck.net.Individual;
import org.tip.puck.net.relations.Relation;
import org.tip.puck.partitions.Cluster;
import org.tip.puck.partitions.Partition;
import org.tip.puck.partitions.PartitionCriteria;
import org.tip.puck.partitions.PartitionMaker;
import org.tip.puck.spacetime.CorrelationMatrix;
import org.tip.puck.spacetime.EgoRelationSequence;
import org.tip.puck.spacetime.EgoRelationSequences;
import org.tip.puck.spacetime.workers.SequenceCensus;
import org.tip.puck.spacetime.workers.SpaceTimeCriteria;
import org.tip.puck.util.NumberedValues;
import org.tip.puck.util.PuckUtils;
import org.tip.puck.util.Trafo;
import org.tip.puck.util.Value;
import org.tip.puck.util.Values;

public class SequencesCensus {
    private EgoRelationSequences sequences;
    private Map<String, NumberedValues> valuesMap;
    private List<String> labels;
    private Map<String, StringList> pajekBuffers;
    private Map<String, CorrelationMatrix> eventSequenceMatrices;
    private Map<String, CorrelationMatrix> subSequenceMatrices;
    private Map<String, Map<Integer, Partition<Node<Individual>>>> componentsMap;
    private CorrelationMatrix relationConnectionMatrix;
    private Map<SpaceTimeCriteria.RelationClassificationType, Partition<Link<Individual>>> linkPartitions;
    private Map<SpaceTimeCriteria.RelationClassificationType, Map<Value, Double[]>> similaritiesMaps;
    Map<SpaceTimeCriteria.RelationClassificationType, Map<String, Integer>> nrValues;
    private Map<String, Map<String, Map<String, Value>>> parcoursNetworkStatistics;

    public SequencesCensus(EgoRelationSequences sequences, SpaceTimeCriteria criteria) throws PuckException {
        List<String> singlesList;
        Value singlesValue;
        Individual ego;
        TreeMap<Individual, List<String[]>> pairs;
        TreeMap<Individual, List<String>> singles;
        String eventTypeName;
        this.sequences = sequences;
        this.labels = new ArrayList<String>();
        this.labels.addAll(criteria.getCensusOperationLabels());
        this.labels.add("PROFILE_AGE");
        this.labels.add("PROFILE_" + criteria.getDateLabel());
        this.valuesMap = new HashMap<String, NumberedValues>();
        for (String label : this.labels) {
            if (label.contains("SIMILARITY")) {
                if (this.similaritiesMaps == null) {
                    this.similaritiesMaps = new HashMap<SpaceTimeCriteria.RelationClassificationType, Map<Value, Double[]>>();
                    this.linkPartitions = new HashMap<SpaceTimeCriteria.RelationClassificationType, Partition<Link<Individual>>>();
                }
                SpaceTimeCriteria.RelationClassificationType relationClassificationType = SpaceTimeCriteria.RelationClassificationType.valueOf(label.substring(label.lastIndexOf("_") + 1));
                this.similaritiesMaps.put(relationClassificationType, new HashMap());
                this.linkPartitions.put(relationClassificationType, new Partition());
            }
            this.valuesMap.put(label, new NumberedValues());
        }
        this.pajekBuffers = new HashMap<String, StringList>();
        for (String title : criteria.getNetworkTitles()) {
            this.pajekBuffers.put(title, new StringList());
        }
        for (String networkTitle : criteria.getNetworkTitles()) {
            if (!networkTitle.contains("Ego Network") && !networkTitle.contains("Parcours Similarity Network")) continue;
            if (this.componentsMap == null) {
                this.componentsMap = new HashMap<String, Map<Integer, Partition<Node<Individual>>>>();
            }
            this.componentsMap.put(networkTitle, new HashMap());
        }
        this.eventSequenceMatrices = new HashMap<String, CorrelationMatrix>();
        this.subSequenceMatrices = new HashMap<String, CorrelationMatrix>();
        this.nrValues = new HashMap<SpaceTimeCriteria.RelationClassificationType, Map<String, Integer>>();
        for (SpaceTimeCriteria.RelationClassificationType relationClassificationType : criteria.getTrajectoriesRelationClassificationTypes()) {
            this.nrValues.put(relationClassificationType, new HashMap());
        }
        HashMap parcoursNetworksMap = new HashMap();
        for (String networkTitle : criteria.getNetworkTitles()) {
            if (!networkTitle.contains("Parcours Network") || networkTitle.contains("Fused")) continue;
            parcoursNetworksMap.put(networkTitle.substring(networkTitle.lastIndexOf("_") + 1), new HashMap());
        }
        for (EgoRelationSequence sequence : sequences) {
            SequenceCensus census = new SequenceCensus(sequence, criteria);
            for (String label : this.labels) {
                if (label.contains("SIMILARITY")) {
                    SpaceTimeCriteria.RelationClassificationType relationClassificationType = SpaceTimeCriteria.RelationClassificationType.valueOf(label.substring(label.lastIndexOf("_") + 1));
                    this.linkPartitions.get((Object)relationClassificationType).add(census.getParcoursLinkPartition(relationClassificationType));
                }
                this.valuesMap.get(label).put(sequence.getEgo().getId(), census.getValue(label));
            }
            if (this.componentsMap != null) {
                for (String networkTitle : criteria.getNetworkTitles()) {
                    Map<Integer, Partition<Node<Individual>>> map = this.componentsMap.get(networkTitle);
                    if (map == null) continue;
                    if (networkTitle.contains("Ego Network")) {
                        map.put(sequence.getEgo().getId(), census.getComponents("Nonmediated Ego Network"));
                        continue;
                    }
                    if (!networkTitle.contains("Parcours Similarity Network")) continue;
                    SpaceTimeCriteria.RelationClassificationType relationClassificationType = SpaceTimeCriteria.RelationClassificationType.valueOf(networkTitle.substring(networkTitle.lastIndexOf("_") + 1));
                    map.put(sequence.getEgo().getId(), census.getComponents("Parcours Similarity Network_" + (Object)((Object)relationClassificationType)));
                }
            }
            for (String networkTitle : criteria.getNetworkTitles()) {
                if (!networkTitle.contains("Parcours Network") || networkTitle.contains("Fused")) continue;
                ((Map)parcoursNetworksMap.get(networkTitle.substring(networkTitle.lastIndexOf("_") + 1))).put(sequence.getEgo().getId(), census.getEventTypeNetwork(networkTitle));
            }
            for (String title : criteria.getNetworkTitles()) {
                if (title.equals("Event Type Network") || title.equals("Sequence Type Network")) continue;
                census.writePajekNetwork(this.pajekBuffers.get(title), title);
            }
        }
        for (String networkTitle : criteria.getNetworkTitles()) {
            Graph union;
            if (!networkTitle.contains("Parcours Network") || networkTitle.contains("Fused")) continue;
            Map parcoursNetworks = (Map)parcoursNetworksMap.get(networkTitle.substring(networkTitle.lastIndexOf("_") + 1));
            ArrayList<Graph<Graph<String>>> flatParcoursNetworksNoLoops = new ArrayList<Graph<Graph<String>>>();
            for (Graph parcoursNetwork : parcoursNetworks.values()) {
                Graph<String> flatParcoursNetworkNoLoops = SequenceCensus.getFlatParcoursNetworkNoLoops(parcoursNetwork);
                flatParcoursNetworksNoLoops.add(flatParcoursNetworkNoLoops);
            }
            Collections.sort(flatParcoursNetworksNoLoops, new GraphComparatorByArcCount());
            Graph tree = GraphUtils.createPhylogeneticTree(flatParcoursNetworksNoLoops);
            tree.setLabel(String.valueOf(networkTitle) + "_Tree");
            for (Node node : tree.getNodes()) {
                node.setLabel(node.getLabel().replaceAll(String.valueOf(networkTitle) + " ", ""));
                if (((Set)node.getReferent()).size() == 1) {
                    node.setAttribute("TYPE", "1");
                    String[] splitLabel = Trafo.noParentheses(((Set)node.getReferent()).toString()).split(" ");
                    Integer egoId = Integer.parseInt(splitLabel[splitLabel.length - 1]);
                    node.setAttribute("GENDER", sequences.getByEgoId(egoId).getEgo().getGender().toString());
                    continue;
                }
                node.setAttribute("TYPE", "0");
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("TYPE");
            arrayList.add("GENDER");
            this.pajekBuffers.get(networkTitle.replaceAll("Network", "Similarity Tree")).addAll((Collection)PuckUtils.writePajekNetwork(tree, arrayList));
            ArrayList unions = new ArrayList();
            PartitionCriteria partitionCriteria = new PartitionCriteria(criteria.getPartitionLabel());
            Partition<Individual> individualPartition = PartitionMaker.create("", sequences.egos(), partitionCriteria);
            Partition<Graph> graphPartition = new Partition<Graph>();
            for (Individual individual : individualPartition.getItems()) {
                graphPartition.put((Graph)parcoursNetworks.get(individual.getId()), individualPartition.getValue(individual));
            }
            this.parcoursNetworkStatistics = new TreeMap<String, Map<String, Map<String, Value>>>();
            for (Cluster cluster : graphPartition.getClusters()) {
                union = GraphUtils.fuseGraphs(cluster.getItems());
                union.setLabel(String.valueOf(networkTitle) + "_" + cluster.getValue());
                unions.add(union);
                this.parcoursNetworkStatistics.put("" + cluster.getValue(), GraphUtils.getNodeStatisticsByLabel(union, criteria.getNodeStatisticsLabels()));
            }
            Graph graph = GraphUtils.fuseGraphs(new ArrayList(parcoursNetworks.values()));
            graph.setLabel(String.valueOf(networkTitle) + "_Total");
            this.parcoursNetworkStatistics.put("Total", GraphUtils.getNodeStatisticsByLabel(graph, criteria.getNodeStatisticsLabels()));
            unions.add(graph);
            ArrayList<String> unionPartitionLabels = new ArrayList<String>();
            unionPartitionLabels.add("NUMBER");
            unionPartitionLabels.add("SIZE");
            unionPartitionLabels.add("BETWEENNESS");
            unionPartitionLabels.add("DEGREE");
            Iterator iterator = unions.iterator();
            while (iterator.hasNext()) {
                union = (Graph)iterator.next();
                this.pajekBuffers.get(networkTitle.replaceAll("Network", "Network Fused")).addAll((Collection)PuckUtils.writePajekNetwork(union, unionPartitionLabels));
            }
        }
        if (criteria.getNetworkTitles().contains("Event Type Network")) {
            for (SpaceTimeCriteria.RelationClassificationType relationClassificationType : criteria.getTrajectoriesRelationClassificationTypes()) {
                eventTypeName = relationClassificationType.toString();
                singles = new TreeMap();
                pairs = new TreeMap<Individual, List<String[]>>();
                for (EgoRelationSequence egoRelationSequence : sequences) {
                    ego = egoRelationSequence.getEgo();
                    singlesValue = (Value)this.valuesMap.get("PROFILE_" + eventTypeName).get(ego.getId());
                    if (singlesValue == null) continue;
                    singlesList = singlesValue.listValue();
                    ArrayList<String[]> arrayList = new ArrayList<String[]>();
                    int i = 1;
                    while (i < singlesList.size()) {
                        arrayList.add(new String[]{singlesList.get(i - 1), singlesList.get(i)});
                        ++i;
                    }
                    singles.put(ego, singlesList);
                    pairs.put(ego, arrayList);
                }
                this.eventSequenceMatrices.put(eventTypeName, new CorrelationMatrix("Event Type Network", eventTypeName, singles, pairs));
            }
        }
        if (criteria.getNetworkTitles().contains("Sequence Type Network")) {
            for (SpaceTimeCriteria.RelationClassificationType relationClassificationType : criteria.getTrajectoriesRelationClassificationTypes()) {
                eventTypeName = relationClassificationType.toString();
                singles = new TreeMap<Individual, List<String>>();
                pairs = new TreeMap();
                for (EgoRelationSequence egoRelationSequence : sequences) {
                    ego = egoRelationSequence.getEgo();
                    singlesValue = (Value)this.valuesMap.get("PROFILE_" + eventTypeName).get(ego.getId());
                    if (singlesValue == null) continue;
                    singlesList = PuckUtils.cumulateList(singlesValue.listValue());
                    ArrayList<String[]> arrayList = new ArrayList<String[]>();
                    int i = 1;
                    while (i < singlesList.size()) {
                        arrayList.add(new String[]{singlesList.get(i - 1), singlesList.get(i)});
                        ++i;
                    }
                    singles.put(ego, singlesList);
                    pairs.put(ego, arrayList);
                }
                this.subSequenceMatrices.put(eventTypeName, new CorrelationMatrix("Sequence Type Network", eventTypeName, singles, pairs));
            }
        }
        if (this.labels.contains("CONNECTED_NETWORK_RELATIONS")) {
            TreeMap<Individual, List<String>> singles2 = new TreeMap<Individual, List<String>>();
            TreeMap<Individual, List<String[]>> pairs2 = new TreeMap<Individual, List<String[]>>();
            for (EgoRelationSequence sequence : sequences) {
                Value pairsValue;
                Individual ego3 = sequence.getEgo();
                Value value = (Value)this.valuesMap.get("NETWORK_RELATIONS").get(ego3.getId());
                if (value != null) {
                    singles2.put(ego3, value.listValue());
                }
                if ((pairsValue = (Value)this.valuesMap.get("CONNECTED_NETWORK_RELATIONS").get(ego3.getId())) == null) continue;
                pairs2.put(ego3, pairsValue.listValue());
            }
            this.relationConnectionMatrix = new CorrelationMatrix("Component connections", null, singles2, pairs2);
        }
        for (SpaceTimeCriteria.RelationClassificationType relationClassificationType : criteria.getTrajectoriesRelationClassificationTypes()) {
            Gender gender;
            Gender[] genderArray;
            ArrayList<String> partitionLabels;
            CorrelationMatrix matrix;
            if (criteria.getNetworkTitles().contains("Event Type Network")) {
                matrix = this.eventSequenceMatrices.get(relationClassificationType.toString());
                Graph<Cluster<String>>[] eventTypeNetworks = matrix.getSequenceNetworks();
                partitionLabels = new ArrayList<String>();
                partitionLabels.add(relationClassificationType.toString());
                Map<String, Map<Value, Integer>> map = SequencesCensus.getPartitionNumbersMaps(partitionLabels, eventTypeNetworks[2]);
                for (String label : partitionLabels) {
                    if (map.get(label) == null) continue;
                    this.nrValues.get((Object)relationClassificationType).put(label, map.get(label).size());
                }
                partitionLabels.add("SIZE");
                genderArray = Gender.values();
                int n = genderArray.length;
                int n2 = 0;
                while (n2 < n) {
                    gender = genderArray[n2];
                    this.pajekBuffers.get("Event Type Network").addAll((Collection)PuckUtils.writePajekNetwork(eventTypeNetworks[gender.toInt()], partitionLabels, map));
                    ++n2;
                }
            }
            if (!criteria.getNetworkTitles().contains("Sequence Type Network")) continue;
            matrix = this.subSequenceMatrices.get(relationClassificationType.toString());
            Graph<Cluster<String>>[] sequenceTypeNetworks = matrix.getSequenceNetworks();
            matrix.getDepthPartitions();
            partitionLabels = new ArrayList();
            partitionLabels.add(relationClassificationType.toString());
            Map<String, Map<Value, Integer>> map = SequencesCensus.getPartitionNumbersMaps(partitionLabels, sequenceTypeNetworks[2]);
            for (String label : partitionLabels) {
                this.nrValues.get((Object)relationClassificationType).put(label, map.get(label).size());
            }
            partitionLabels.add("SIZE");
            partitionLabels.add("STEP");
            genderArray = Gender.values();
            int n = genderArray.length;
            int n3 = 0;
            while (n3 < n) {
                gender = genderArray[n3];
                this.pajekBuffers.get("Sequence Type Network").addAll((Collection)PuckUtils.writePajekNetwork(sequenceTypeNetworks[gender.toInt()], partitionLabels, map));
                ++n3;
            }
        }
    }

    public static <E> Map<String, Map<Value, Integer>> getPartitionNumbersMaps(List<String> labels, Graph<E> model) {
        HashMap<String, Map<Value, Integer>> result = new HashMap<String, Map<Value, Integer>>();
        for (String label : labels) {
            Values values = NodeValuator.get(model, label);
            if (values.isNumeric()) continue;
            Partition<Value> partition = PartitionMaker.create(label, values);
            result.put(label, PartitionMaker.getPartitionNumbersMap(partition));
        }
        return result;
    }

    public Map<String, StringList> getPajekBuffers() {
        return this.pajekBuffers;
    }

    public Map<Integer, Partition<Node<Individual>>> getComponents(String networkTitle) {
        return this.componentsMap.get(networkTitle);
    }

    public Map<Value, Double[]> getMeanNrMoves() {
        TreeMap<Value, Double[]> result = new TreeMap<Value, Double[]>();
        HashMap<GeoLevel, Integer[]> sequenceMap = new HashMap<GeoLevel, Integer[]>();
        HashMap<GeoLevel, Integer[]> eventMap = new HashMap<GeoLevel, Integer[]>();
        GeoLevel[] geoLevelArray = new GeoLevel[]{GeoLevel.TRANSNATIONAL, GeoLevel.TRANSREGIONAL, GeoLevel.REGIONAL, GeoLevel.LOCAL};
        int n = geoLevelArray.length;
        int n2 = 0;
        while (n2 < n) {
            GeoLevel level = geoLevelArray[n2];
            sequenceMap.put(level, new Integer[]{0, 0, 0});
            eventMap.put(level, new Integer[]{0, 0, 0});
            result.put(new Value(level), new Double[]{0.0, 0.0, 0.0});
            ++n2;
        }
        for (EgoRelationSequence sequence : this.sequences) {
            int gender = sequence.getEgo().getGender().toInt();
            Value value = (Value)this.valuesMap.get("MEAN_NR_MOVES").get(sequence.getEgo().getId());
            if (value == null) continue;
            Map distanceProfile = value.mapValue();
            for (GeoLevel level : distanceProfile.keySet()) {
                if (sequenceMap.get((Object)level) == null) continue;
                Integer[] integerArray = (Integer[])sequenceMap.get((Object)level);
                int n3 = gender;
                integerArray[n3] = integerArray[n3] + 1;
                Integer[] integerArray2 = (Integer[])sequenceMap.get((Object)level);
                integerArray2[2] = integerArray2[2] + 1;
                Integer[] integerArray3 = (Integer[])eventMap.get((Object)level);
                int n4 = gender;
                integerArray3[n4] = integerArray3[n4] + (Integer)distanceProfile.get((Object)level);
                Integer[] integerArray4 = (Integer[])sequenceMap.get((Object)level);
                integerArray4[2] = integerArray4[2] + (Integer)distanceProfile.get((Object)level);
            }
        }
        for (Value value : result.keySet()) {
            int i = 0;
            while (i < 3) {
                ((Double[])result.get((Object)value))[i] = new Double(((Integer[])eventMap.get(value.enumValue()))[i].intValue()) / new Double(((Integer[])sequenceMap.get(value.enumValue()))[i].intValue());
                ++i;
            }
        }
        return result;
    }

    public NumberedValues getValues(String label) {
        return this.valuesMap.get(label);
    }

    public Graph<Cluster<String>> getSequenceNetwork(String title, SpaceTimeCriteria.RelationClassificationType relationClassificationType, Partition<String> partition) {
        if (this.sequences == null) {
            throw new IllegalArgumentException("Null parameter detected.");
        }
        Graph<Cluster<String>> result = new Graph<Cluster<String>>(String.valueOf(title) + "_" + (Object)((Object)relationClassificationType));
        for (Cluster<String> cluster : partition.getClusters().toListSortedByDescendingSize()) {
            if (cluster.isNull()) continue;
            result.addNode(cluster);
        }
        for (EgoRelationSequence egoRelationSequence : this.sequences) {
            Cluster<String> previous = null;
            for (Relation event : egoRelationSequence.getStations().values()) {
                Cluster<String> next = partition.getCluster(String.valueOf(egoRelationSequence.getEgo().getId()) + " " + event.getTypedId());
                if (previous != null) {
                    result.incArcWeight(previous, next);
                }
                previous = next;
            }
        }
        for (Node node : result.getNodes()) {
            Value clusterValue;
            Cluster referent = (Cluster)node.getReferent();
            if (referent == null || (clusterValue = referent.getValue()) == null) continue;
            String value = clusterValue.toString();
            if (value.lastIndexOf("-") > -1) {
                value = value.substring(value.lastIndexOf("-") + 1);
            }
            node.setAttribute(relationClassificationType.toString(), value);
        }
        return result;
    }

    public Integer getNrValues(SpaceTimeCriteria.RelationClassificationType relationClassificationType, String label) {
        Integer result = relationClassificationType == null || label == null || this.nrValues.get((Object)relationClassificationType) == null ? null : this.nrValues.get((Object)relationClassificationType).get(label);
        return result;
    }

    public Set<Relation> events() {
        HashSet<Relation> result = new HashSet<Relation>();
        for (EgoRelationSequence sequence : this.sequences) {
            for (Relation event : sequence.getStations().values()) {
                result.add(event);
            }
        }
        return result;
    }

    public int nrEvents() {
        return this.events().size();
    }

    public int nrSequences() {
        return this.sequences.size();
    }

    public Map<Value, Double[]> getSimilaritiesMap(SpaceTimeCriteria.RelationClassificationType relationClassificationType) {
        return this.similaritiesMaps.get((Object)relationClassificationType);
    }

    public CorrelationMatrix getRelationConnectionMatrix() {
        return this.relationConnectionMatrix;
    }

    public CorrelationMatrix getEventSequenceMatrix(String eventTypeName) {
        CorrelationMatrix result = this.eventSequenceMatrices == null || eventTypeName == null ? null : this.eventSequenceMatrices.get(eventTypeName);
        return result;
    }

    public CorrelationMatrix getSubSequenceMatrix(String eventTypeName) {
        CorrelationMatrix result = this.subSequenceMatrices == null || eventTypeName == null ? null : this.subSequenceMatrices.get(eventTypeName);
        return result;
    }

    public Map<String, Map<String, Map<String, Value>>> getParcoursNetworkStatistics() {
        return this.parcoursNetworkStatistics;
    }
}

