/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.net.workers;

import fr.devinsy.util.StringSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.net.Attribute;
import org.tip.puck.net.Attributes;
import org.tip.puck.net.Families;
import org.tip.puck.net.Family;
import org.tip.puck.net.Individual;
import org.tip.puck.net.Individuals;
import org.tip.puck.net.Net;
import org.tip.puck.net.relations.Actor;
import org.tip.puck.net.relations.Actors;
import org.tip.puck.net.relations.Relation;
import org.tip.puck.net.relations.RelationModel;
import org.tip.puck.net.relations.Relations;
import org.tip.puck.net.workers.AttributeDescriptor;
import org.tip.puck.net.workers.AttributeDescriptors;
import org.tip.puck.net.workers.AttributeFilter;
import org.tip.puck.net.workers.AttributeFilters;
import org.tip.puck.net.workers.AttributeRenameCriteria;
import org.tip.puck.net.workers.AttributeReplaceValueCriteria;
import org.tip.puck.net.workers.AttributeSetValueCriteria;
import org.tip.puck.net.workers.AttributeValueDescriptors;
import org.tip.puck.net.workers.IndividualValuator;
import org.tip.puck.net.workers.NetNodeType;
import org.tip.puck.net.workers.NetNodeTypes;
import org.tip.puck.segmentation.Segmentation;
import org.tip.puck.util.NumberedValues;
import org.tip.puck.util.Value;

public class AttributeWorker {
    public static final Pattern YEAR_PATTERN = Pattern.compile("(\\d\\d\\d\\d)");
    private static final Logger logger = LoggerFactory.getLogger(AttributeWorker.class);

    public static long anonymizeByFirstName(Individuals source) {
        long result;
        if (source == null) {
            result = 0L;
        } else {
            for (Individual individual : source) {
                individual.setName(StringUtils.defaultString((String)individual.getFirstName(), (String)""));
            }
            result = source.size();
        }
        return result;
    }

    public static long anonymizeByFirstName(Net source) {
        long result = source == null ? 0L : AttributeWorker.anonymizeByFirstName(source.individuals());
        return result;
    }

    public static long anonymizeByGenderAndId(Individuals source) {
        long result;
        if (source == null) {
            result = 0L;
        } else {
            for (Individual individual : source) {
                individual.setName(String.valueOf(individual.getGender().toChar()) + " " + individual.getId());
            }
            result = source.size();
        }
        return result;
    }

    public static long anonymizeByGenderAndId(Net source) {
        long result = source == null ? 0L : AttributeWorker.anonymizeByGenderAndId(source.individuals());
        return result;
    }

    public static long anonymizeByLastName(Individuals source) {
        long result;
        if (source == null) {
            result = 0L;
        } else {
            for (Individual individual : source) {
                individual.setName(StringUtils.defaultString((String)individual.getLastName(), (String)""));
            }
            result = source.size();
        }
        return result;
    }

    public static long anonymizeByLastName(Net source) {
        long result = source == null ? 0L : AttributeWorker.anonymizeByLastName(source.individuals());
        return result;
    }

    public static int anonymizeByNumbering(Families source, String label) {
        int result = 0;
        if (source != null && label != null) {
            Hashtable<String, String> pivot = new Hashtable<String, String>();
            for (Family family : source) {
                String oldValue = family.attributes().getValue(label);
                if (oldValue == null) continue;
                String newValue = (String)pivot.get(oldValue = oldValue.toLowerCase());
                if (newValue == null) {
                    newValue = String.valueOf(pivot.size() + 1);
                    pivot.put(oldValue, newValue);
                }
                family.attributes().put(label, newValue);
                ++result;
            }
        }
        return result;
    }

    public static int anonymizeByNumbering(Individuals source, String label) {
        int result = 0;
        if (source != null && label != null) {
            Hashtable<String, String> pivot = new Hashtable<String, String>();
            for (Individual individual : source) {
                String oldValue = individual.attributes().getValue(label);
                if (oldValue == null) continue;
                String newValue = (String)pivot.get(oldValue = oldValue.toLowerCase());
                if (newValue == null) {
                    newValue = String.valueOf(pivot.size() + 1);
                    pivot.put(oldValue, newValue);
                }
                individual.attributes().put(label, newValue);
                ++result;
            }
        }
        return result;
    }

    public static long anonymizeByNumbering(Net net, AttributeFilter filter) {
        long result = 0L;
        if (net != null && filter != null) {
            if (filter.getScope() == AttributeFilter.Scope.ALL || filter.getScope() == AttributeFilter.Scope.CORPUS) {
                result += AttributeWorker.filter(net.attributes(), filter.getLabel(), filter.getMode());
            }
            if (filter.getScope() == AttributeFilter.Scope.ALL || filter.getScope() == AttributeFilter.Scope.INDIVIDUALS) {
                result += (long)AttributeWorker.anonymizeByNumbering(net.individuals(), filter.getLabel());
            }
            if (filter.getScope() == AttributeFilter.Scope.ALL || filter.getScope() == AttributeFilter.Scope.FAMILIES) {
                result += (long)AttributeWorker.anonymizeByNumbering(net.families(), filter.getLabel());
            }
            if (filter.getScope() == AttributeFilter.Scope.ALL || filter.getScope() == AttributeFilter.Scope.RELATIONS) {
                for (RelationModel model : net.relationModels()) {
                    Relations relations = net.relations().getByModel(model);
                    result += (long)AttributeWorker.anonymizeByNumbering(relations, filter.getLabel());
                }
            } else if (filter.getScope() == AttributeFilter.Scope.RELATION) {
                Relations relations = net.relations().getByModelName(filter.getOptionalRelationName());
                result = AttributeWorker.anonymizeByNumbering(relations, filter.getLabel());
            }
        }
        return result;
    }

    public static long anonymizeByNumbering(Net net, Segmentation segmentation, AttributeFilter filter) {
        long result = 0L;
        if (net != null && filter != null) {
            if (filter.getScope() == AttributeFilter.Scope.ALL || filter.getScope() == AttributeFilter.Scope.CORPUS) {
                result += AttributeWorker.filter(net.attributes(), filter.getLabel(), filter.getMode());
            }
            if (filter.getScope() == AttributeFilter.Scope.ALL || filter.getScope() == AttributeFilter.Scope.INDIVIDUALS) {
                result += (long)AttributeWorker.anonymizeByNumbering(segmentation.getCurrentIndividuals(), filter.getLabel());
            }
            if (filter.getScope() == AttributeFilter.Scope.ALL || filter.getScope() == AttributeFilter.Scope.FAMILIES) {
                result += (long)AttributeWorker.anonymizeByNumbering(segmentation.getCurrentFamilies(), filter.getLabel());
            }
            if (filter.getScope() == AttributeFilter.Scope.ALL || filter.getScope() == AttributeFilter.Scope.RELATIONS) {
                for (RelationModel model : net.relationModels()) {
                    Relations relations = segmentation.getCurrentRelations().getByModel(model);
                    result += (long)AttributeWorker.anonymizeByNumbering(relations, filter.getLabel());
                }
            } else if (filter.getScope() == AttributeFilter.Scope.RELATION) {
                Relations relations = segmentation.getCurrentRelations().getByModelName(filter.getOptionalRelationName());
                result = AttributeWorker.anonymizeByNumbering(relations, filter.getLabel());
            }
        }
        return result;
    }

    public static int anonymizeByNumbering(Relations source, String label) {
        int result = 0;
        if (source != null && label != null) {
            Hashtable<String, String> pivot = new Hashtable<String, String>();
            for (Relation relation : source) {
                String oldValue = relation.attributes().getValue(label);
                if (oldValue == null) continue;
                String newValue = (String)pivot.get(oldValue = oldValue.toLowerCase());
                if (newValue == null) {
                    newValue = String.valueOf(pivot.size() + 1);
                    pivot.put(oldValue, newValue);
                }
                relation.attributes().put(label, newValue);
                ++result;
            }
        }
        return result;
    }

    public static long capitalizeValue(Attribute target) {
        long result;
        if (target == null) {
            result = 0L;
        } else if (StringUtils.isEmpty((CharSequence)target.getValue())) {
            result = 0L;
        } else if (Character.isLowerCase(target.getValue().charAt(0))) {
            target.setValue(StringUtils.capitalize((String)target.getValue()));
            result = 1L;
        } else {
            result = 0L;
        }
        return result;
    }

    public static int cleanAttribute(Individuals source, String attributeLabel) {
        int result = 0;
        for (Individual individual : source) {
            Attribute attribute = (Attribute)individual.attributes().get(attributeLabel);
            if (attribute == null || !StringUtils.isBlank((CharSequence)attribute.getValue()) && !attribute.getValue().trim().equals("0")) continue;
            individual.attributes().remove(attributeLabel);
            logger.debug("remove ===>" + individual.getId() + " " + individual.attributes().get(attributeLabel));
            ++result;
        }
        return result;
    }

    public static long filter(Attributes source, String label, AttributeFilter.Mode filter) {
        long result;
        if (source == null) {
            result = 0L;
        } else {
            if (label == null) {
                throw new IllegalArgumentException("label parameter is null");
            }
            if (filter == null) {
                throw new IllegalArgumentException("filter parameter is null");
            }
            Attribute target = (Attribute)source.get(label);
            switch (filter) {
                case ANONYMIZE_BY_NUMBERING: {
                    String value = source.getValue(label);
                    if (value == null) {
                        result = 0L;
                        break;
                    }
                    source.put(label, "1");
                    result = 1L;
                    break;
                }
                case CAPITALIZE_VALUE: {
                    result = AttributeWorker.capitalizeValue(target);
                    break;
                }
                case CLEAN: {
                    if (target != null && (StringUtils.isBlank((CharSequence)target.getValue()) || target.getValue().trim().equals("0"))) {
                        source.remove(label);
                        result = 1L;
                        break;
                    }
                    result = 0L;
                    break;
                }
                case CLEAN_BLANK: {
                    if (target != null && StringUtils.isBlank((CharSequence)target.getValue())) {
                        source.remove(label);
                        result = 1L;
                        break;
                    }
                    result = 0L;
                    break;
                }
                case FORCE_TO_BLANK: {
                    source.put(label, "");
                    result = 1L;
                    break;
                }
                case LOWERCASE_VALUE: {
                    result = AttributeWorker.lowerCaseValue(target);
                    break;
                }
                case REDUCE_DATE: {
                    result = AttributeWorker.reduceDateValue(target);
                    break;
                }
                case REMOVE: {
                    if (target == null) {
                        result = 0L;
                        break;
                    }
                    source.remove(label);
                    result = 1L;
                    break;
                }
                case REPLACE_BY_BLANK: {
                    if (target == null) {
                        result = 0L;
                        break;
                    }
                    target.setValue("");
                    result = 1L;
                    break;
                }
                case TRIM_VALUE: {
                    result = AttributeWorker.trimValue(target);
                    break;
                }
                case UPPERCASE_VALUE: {
                    result = AttributeWorker.upperCaseValue(target);
                    break;
                }
                default: {
                    result = 0L;
                }
            }
        }
        return result;
    }

    public static long filter(Net net, AttributeFilter filter) {
        long result;
        if (net == null || filter == null || filter.getMode() == AttributeFilter.Mode.NONE) {
            result = 0L;
        } else if (filter.getMode() == AttributeFilter.Mode.ANONYMIZE_BY_NUMBERING) {
            result = AttributeWorker.anonymizeByNumbering(net, filter);
        } else if (filter.getScope() == AttributeFilter.Scope.INDIVIDUALS && filter.getMode() == AttributeFilter.Mode.ANONYMIZE_BY_FIRST_NAME) {
            result = AttributeWorker.anonymizeByFirstName(net);
        } else if (filter.getScope() == AttributeFilter.Scope.INDIVIDUALS && filter.getMode() == AttributeFilter.Mode.ANONYMIZE_BY_LAST_NAME) {
            result = AttributeWorker.anonymizeByLastName(net);
        } else if (filter.getScope() == AttributeFilter.Scope.INDIVIDUALS && filter.getMode() == AttributeFilter.Mode.ANONYMIZE_BY_GENDER_AND_ID) {
            result = AttributeWorker.anonymizeByGenderAndId(net);
        } else {
            result = 0L;
            if (net != null && filter != null) {
                if (filter.getScope() == AttributeFilter.Scope.ALL || filter.getScope() == AttributeFilter.Scope.CORPUS) {
                    result += AttributeWorker.filter(net.attributes(), filter.getLabel(), filter.getMode());
                }
                if (filter.getScope() == AttributeFilter.Scope.ALL || filter.getScope() == AttributeFilter.Scope.INDIVIDUALS) {
                    for (Individual individual : net.individuals()) {
                        result += AttributeWorker.filter(individual.attributes(), filter.getLabel(), filter.getMode());
                    }
                }
                if (filter.getScope() == AttributeFilter.Scope.ALL || filter.getScope() == AttributeFilter.Scope.FAMILIES) {
                    for (Family family : net.families()) {
                        result += AttributeWorker.filter(family.attributes(), filter.getLabel(), filter.getMode());
                    }
                }
                if (filter.getScope() == AttributeFilter.Scope.ALL || filter.getScope() == AttributeFilter.Scope.RELATIONS) {
                    for (Relation relation : net.relations()) {
                        result += AttributeWorker.filter(relation.attributes(), filter.getLabel(), filter.getMode());
                    }
                }
                if (filter.getScope() == AttributeFilter.Scope.RELATION) {
                    Relations relations = net.relations().getByModelName(filter.getOptionalRelationName());
                    for (Relation relation : relations) {
                        result += AttributeWorker.filter(relation.attributes(), filter.getLabel(), filter.getMode());
                    }
                }
            }
        }
        return result;
    }

    public static long filter(Net target, AttributeFilters source) {
        long result = 0L;
        if (target != null && source != null) {
            for (AttributeFilter filter : source) {
                result += AttributeWorker.filter(target, filter);
            }
        }
        return result;
    }

    public static long filter(Net net, Segmentation segmentation, AttributeFilter filter) {
        long result;
        if (segmentation == null) {
            result = AttributeWorker.filter(net, filter);
        } else if (net == null || filter == null || filter.getMode() == AttributeFilter.Mode.NONE) {
            result = 0L;
        } else if (filter.getMode() == AttributeFilter.Mode.ANONYMIZE_BY_NUMBERING) {
            result = AttributeWorker.anonymizeByNumbering(net, segmentation, filter);
        } else if (filter.getScope() == AttributeFilter.Scope.INDIVIDUALS && filter.getMode() == AttributeFilter.Mode.ANONYMIZE_BY_FIRST_NAME) {
            result = AttributeWorker.anonymizeByFirstName(segmentation.getCurrentIndividuals());
        } else if (filter.getScope() == AttributeFilter.Scope.INDIVIDUALS && filter.getMode() == AttributeFilter.Mode.ANONYMIZE_BY_LAST_NAME) {
            result = AttributeWorker.anonymizeByLastName(segmentation.getCurrentIndividuals());
        } else if (filter.getScope() == AttributeFilter.Scope.INDIVIDUALS && filter.getMode() == AttributeFilter.Mode.ANONYMIZE_BY_GENDER_AND_ID) {
            result = AttributeWorker.anonymizeByGenderAndId(segmentation.getCurrentIndividuals());
        } else {
            result = 0L;
            if (net != null && filter != null) {
                if (filter.getScope() == AttributeFilter.Scope.ALL || filter.getScope() == AttributeFilter.Scope.CORPUS) {
                    result += AttributeWorker.filter(net.attributes(), filter.getLabel(), filter.getMode());
                }
                if (filter.getScope() == AttributeFilter.Scope.ALL || filter.getScope() == AttributeFilter.Scope.INDIVIDUALS) {
                    for (Individual individual : segmentation.getCurrentIndividuals()) {
                        result += AttributeWorker.filter(individual.attributes(), filter.getLabel(), filter.getMode());
                    }
                }
                if (filter.getScope() == AttributeFilter.Scope.ALL || filter.getScope() == AttributeFilter.Scope.FAMILIES) {
                    for (Family family : segmentation.getCurrentFamilies()) {
                        result += AttributeWorker.filter(family.attributes(), filter.getLabel(), filter.getMode());
                    }
                }
                if (filter.getScope() == AttributeFilter.Scope.ALL || filter.getScope() == AttributeFilter.Scope.RELATIONS) {
                    for (Relation relation : segmentation.getCurrentRelations()) {
                        result += AttributeWorker.filter(relation.attributes(), filter.getLabel(), filter.getMode());
                    }
                }
                if (filter.getScope() == AttributeFilter.Scope.RELATION) {
                    Relations relations = segmentation.getCurrentRelations().getByModelName(filter.getOptionalRelationName());
                    for (Relation relation : relations) {
                        result += AttributeWorker.filter(relation.attributes(), filter.getLabel(), filter.getMode());
                    }
                }
            }
        }
        return result;
    }

    public static long filter(Net target, Segmentation segmentation, AttributeFilters source) {
        long result = 0L;
        if (target != null && source != null) {
            for (AttributeFilter filter : source) {
                result += AttributeWorker.filter(target, segmentation, filter);
            }
        }
        return result;
    }

    public static AttributeDescriptors getExogenousAttributeDescriptors(Actors source) {
        AttributeDescriptors result = new AttributeDescriptors(20);
        if (source != null) {
            ArrayList<Attribute> attributes = new ArrayList<Attribute>(source.size() * 7);
            for (Actor actor : source) {
                attributes.addAll(actor.attributes().toList());
            }
            AttributeDescriptors descriptors = AttributeWorker.getExogenousAttributeDescriptors(attributes, source.size(), AttributeDescriptor.Scope.RELATION, null);
            result.addAll(descriptors);
        }
        return result;
    }

    public static AttributeDescriptors getExogenousAttributeDescriptors(Families source, Integer limit) {
        AttributeDescriptors result = new AttributeDescriptors(20);
        if (source != null) {
            ArrayList<Attribute> attributes = new ArrayList<Attribute>(source.size() * 7);
            int index = 0;
            Iterator iterator = source.iterator();
            while (iterator.hasNext() && (limit == null || index < limit)) {
                Family family = (Family)iterator.next();
                attributes.addAll(family.attributes().toList());
                ++index;
            }
            AttributeDescriptors descriptors = AttributeWorker.getExogenousAttributeDescriptors(attributes, source.size(), AttributeDescriptor.Scope.FAMILIES, null);
            result.addAll(descriptors);
        }
        return result;
    }

    public static AttributeDescriptors getExogenousAttributeDescriptors(Individuals source, Integer limit) {
        AttributeDescriptors result = new AttributeDescriptors(20);
        if (source != null) {
            ArrayList<Attribute> attributes = new ArrayList<Attribute>(source.size() * 7);
            int index = 0;
            Iterator iterator = source.iterator();
            while (iterator.hasNext() && (limit == null || index < limit)) {
                Individual individual = (Individual)iterator.next();
                attributes.addAll(individual.attributes().toList());
                ++index;
            }
            AttributeDescriptors descriptors = AttributeWorker.getExogenousAttributeDescriptors(attributes, source.size(), AttributeDescriptor.Scope.INDIVIDUALS, null);
            result.addAll(descriptors);
        }
        return result;
    }

    public static AttributeDescriptors getExogenousAttributeDescriptors(List<Attribute> source, long maxCount, AttributeDescriptor.Scope scope, String optionalRelationName) {
        AttributeDescriptors result = new AttributeDescriptors(20);
        if (source != null) {
            Hashtable<String, AttributeDescriptor> descriptors = new Hashtable<String, AttributeDescriptor>();
            for (Attribute attribute : source) {
                AttributeDescriptor descriptor = (AttributeDescriptor)descriptors.get(attribute.getLabel());
                if (descriptor == null) {
                    descriptor = scope == AttributeDescriptor.Scope.RELATION ? new AttributeDescriptor(optionalRelationName, attribute.getLabel()) : new AttributeDescriptor(scope, attribute.getLabel());
                    descriptor.setMax(maxCount);
                }
                descriptor.incCountOfSet();
                if (StringUtils.isBlank((CharSequence)attribute.getValue())) {
                    descriptor.incCountOfBlank();
                }
                descriptors.put(attribute.getLabel(), descriptor);
            }
            for (AttributeDescriptor descriptor : descriptors.values()) {
                result.add(descriptor);
            }
        }
        return result;
    }

    public static AttributeDescriptors getExogenousAttributeDescriptors(Net source, Integer limit) {
        AttributeDescriptors result = new AttributeDescriptors(20);
        if (source != null) {
            HashSet<String> labels = new HashSet<String>();
            for (Attribute attribute : source.attributes()) {
                labels.add(attribute.getLabel());
            }
            for (String label : labels) {
                AttributeDescriptor descriptor = new AttributeDescriptor(AttributeDescriptor.Scope.CORPUS, label);
                descriptor.incCountOfSet();
                descriptor.setMax(1L);
                result.add(descriptor);
            }
            result.addAll(AttributeWorker.getExogenousAttributeDescriptors(source.individuals(), limit));
            result.addAll(AttributeWorker.getExogenousAttributeDescriptors(source.families(), limit));
            result.addAll(AttributeWorker.getExogenousAttributeDescriptors(source.relations(), limit));
        }
        return result;
    }

    public static AttributeDescriptors getExogenousAttributeDescriptors(Net net, Segmentation source, Integer limit) {
        AttributeDescriptors result = new AttributeDescriptors(20);
        if (source != null) {
            result.addAll(AttributeWorker.getExogenousAttributeDescriptors(net.attributes().toList(), source.size(), AttributeDescriptor.Scope.CORPUS, null));
            result.addAll(AttributeWorker.getExogenousAttributeDescriptors(source, limit));
        }
        return result;
    }

    public static AttributeDescriptors getExogenousAttributeDescriptors(Relations source, Integer limit) {
        AttributeDescriptors result = new AttributeDescriptors(20);
        if (source != null) {
            for (RelationModel model : source.getRelationModels()) {
                Relations relations = source.getByModel(model);
                result.addAll(AttributeWorker.getExogenousAttributeDescriptors(relations, model.getName(), limit));
            }
        }
        return result;
    }

    public static AttributeDescriptors getExogenousAttributeDescriptors(Relations source, String relationName, Integer limit) {
        AttributeDescriptors result = new AttributeDescriptors(20);
        if (source != null) {
            ArrayList<Attribute> attributes = new ArrayList<Attribute>(source.size() * 7);
            int index = 0;
            Iterator iterator = source.iterator();
            while (iterator.hasNext() && (limit == null || index < limit)) {
                Relation relation = (Relation)iterator.next();
                attributes.addAll(relation.attributes().toList());
                ++index;
            }
            AttributeDescriptors descriptors = AttributeWorker.getExogenousAttributeDescriptors(attributes, source.size(), AttributeDescriptor.Scope.RELATION, relationName);
            result.addAll(descriptors);
        }
        return result;
    }

    public static AttributeDescriptors getExogenousAttributeDescriptors(Segmentation source, Integer limit) {
        AttributeDescriptors result = new AttributeDescriptors(20);
        if (source != null) {
            result.addAll(AttributeWorker.getExogenousAttributeDescriptors(source.getCurrentIndividuals(), limit));
            result.addAll(AttributeWorker.getExogenousAttributeDescriptors(source.getCurrentFamilies(), limit));
            result.addAll(AttributeWorker.getExogenousAttributeDescriptors(source.getCurrentRelations(), limit));
        }
        return result;
    }

    public static AttributeDescriptors getExogenousAttributeDescriptorsAndValues(Individuals source) {
        AttributeDescriptors result;
        if (source == null) {
            result = new AttributeDescriptors();
        } else {
            Hashtable<String, AttributeDescriptor> descriptors = new Hashtable<String, AttributeDescriptor>();
            for (Individual individual : source) {
                for (Attribute attribute : individual.attributes()) {
                    AttributeDescriptor descriptor = (AttributeDescriptor)descriptors.get(attribute.getLabel());
                    if (descriptor == null) {
                        descriptor = new AttributeDescriptor(AttributeDescriptor.Scope.INDIVIDUALS, attribute.getLabel());
                        descriptor.setMax(source.size());
                    }
                    descriptor.incCountOfSet();
                    if (StringUtils.isBlank((CharSequence)attribute.getValue())) {
                        descriptor.incCountOfBlank();
                    }
                    descriptors.put(attribute.getLabel(), descriptor);
                }
            }
            result = new AttributeDescriptors(descriptors.size());
            result.addAll(descriptors.values());
        }
        return result;
    }

    public static List<String> getExogenousAttributeLabels(Net source, Integer limit) {
        ArrayList<String> result = new ArrayList<String>(20);
        if (source != null) {
            HashSet<String> buffer = new HashSet<String>();
            for (Attribute attribute : source.attributes()) {
                buffer.add(attribute.getLabel());
            }
            int index = 0;
            Iterator iterator = source.individuals().iterator();
            while (iterator.hasNext() && (limit == null || index < limit)) {
                Individual individual = (Individual)iterator.next();
                for (Attribute attribute : individual.attributes()) {
                    buffer.add(attribute.getLabel());
                }
                ++index;
            }
            index = 0;
            iterator = source.families().iterator();
            while (iterator.hasNext() && (limit == null || index < limit)) {
                Family family = (Family)iterator.next();
                for (Attribute attribute : family.attributes()) {
                    buffer.add(attribute.getLabel());
                }
                ++index;
            }
            index = 0;
            iterator = source.relations().iterator();
            while (iterator.hasNext() && (limit == null || index < limit)) {
                Relation relation = (Relation)iterator.next();
                for (Attribute attribute : relation.attributes()) {
                    buffer.add(attribute.getLabel());
                }
                ++index;
            }
            for (String string : buffer) {
                result.add(string);
            }
            Collections.sort(result);
        }
        return result;
    }

    public static AttributeValueDescriptors getExogenousAttributeValueDescriptors(Attributes source, String pattern) {
        AttributeValueDescriptors result = new AttributeValueDescriptors();
        if (source != null) {
            for (Attribute attribute : source) {
                if (pattern != null && !attribute.getLabel().matches(pattern)) continue;
                result.put(attribute.getValue());
            }
        }
        return result;
    }

    public static AttributeValueDescriptors getExogenousAttributeValueDescriptors(Families source, String pattern) {
        AttributeValueDescriptors result = new AttributeValueDescriptors();
        if (source != null) {
            for (Family family : source) {
                result.putAll(AttributeWorker.getExogenousAttributeValueDescriptors(family.attributes(), pattern));
            }
        }
        return result;
    }

    public static AttributeValueDescriptors getExogenousAttributeValueDescriptors(Individuals source, String pattern) {
        AttributeValueDescriptors result = new AttributeValueDescriptors();
        if (source != null) {
            for (Individual individual : source) {
                result.putAll(AttributeWorker.getExogenousAttributeValueDescriptors(individual.attributes(), pattern));
            }
        }
        return result;
    }

    public static AttributeValueDescriptors getExogenousAttributeValueDescriptors(Net source) {
        AttributeValueDescriptors result = AttributeWorker.getExogenousAttributeValueDescriptors(source, null);
        return result;
    }

    public static AttributeValueDescriptors getExogenousAttributeValueDescriptors(Net source, String pattern) {
        AttributeValueDescriptors result = new AttributeValueDescriptors();
        if (source != null) {
            result.putAll(AttributeWorker.getExogenousAttributeValueDescriptors(source.attributes(), pattern));
            result.putAll(AttributeWorker.getExogenousAttributeValueDescriptors(source.individuals(), pattern));
            result.putAll(AttributeWorker.getExogenousAttributeValueDescriptors(source.families(), pattern));
            result.putAll(AttributeWorker.getExogenousAttributeValueDescriptors(source.relations(), pattern));
        }
        return result;
    }

    public static AttributeValueDescriptors getExogenousAttributeValueDescriptors(Relations source, String pattern) {
        AttributeValueDescriptors result = new AttributeValueDescriptors();
        if (source != null) {
            for (Relation relation : source) {
                result.putAll(AttributeWorker.getExogenousAttributeValueDescriptors(relation.attributes(), pattern));
                for (Actor actor : source.getActors()) {
                    result.putAll(AttributeWorker.getExogenousAttributeValueDescriptors(actor.attributes(), pattern));
                }
            }
        }
        return result;
    }

    public static AttributeValueDescriptors getExogenousAttributeValueDescriptors(Segmentation source) {
        AttributeValueDescriptors result = AttributeWorker.getExogenousAttributeValueDescriptors(source, null);
        return result;
    }

    public static AttributeValueDescriptors getExogenousAttributeValueDescriptors(Segmentation source, String pattern) {
        AttributeValueDescriptors result = new AttributeValueDescriptors();
        if (source != null) {
            result.putAll(AttributeWorker.getExogenousAttributeValueDescriptors(source.getCurrentIndividuals(), pattern));
            result.putAll(AttributeWorker.getExogenousAttributeValueDescriptors(source.getCurrentFamilies(), pattern));
            result.putAll(AttributeWorker.getExogenousAttributeValueDescriptors(source.getCurrentRelations(), pattern));
        }
        return result;
    }

    public static StringSet getExogenousAttributeValues(Net source, NetNodeTypes types, String pattern) {
        StringSet result = new StringSet();
        if (source != null) {
            for (NetNodeType type : types) {
                if (NetNodeType.isIndividuals(type)) {
                    for (Individual individual : source.individuals()) {
                        result.put(individual.attributes().searchByLabel(pattern).getValues());
                    }
                    continue;
                }
                if (NetNodeType.isFamilies(type)) {
                    for (Family family : source.families()) {
                        result.put(family.attributes().searchByLabel(pattern).getValues());
                    }
                    continue;
                }
                for (Relation relation : source.relations().getByModelName(type.getRelationModelName())) {
                    result.put(relation.attributes().searchByLabel(pattern).getValues());
                }
            }
        }
        return result;
    }

    public static long lowerCaseValue(Attribute target) {
        long result;
        if (target == null) {
            result = 0L;
        } else if (StringUtils.isEmpty((CharSequence)target.getValue())) {
            result = 0L;
        } else {
            target.setValue(StringUtils.lowerCase((String)target.getValue()));
            result = 1L;
        }
        return result;
    }

    public static long reduceDateValue(Attribute target) {
        long result;
        if (target == null) {
            result = 0L;
        } else if (StringUtils.isBlank((CharSequence)target.getValue())) {
            result = 0L;
        } else {
            Matcher matcher = YEAR_PATTERN.matcher(target.getValue());
            if (matcher.find() && matcher.groupCount() > 0) {
                target.setValue(matcher.group(1));
                result = 1L;
            } else {
                result = 0L;
            }
        }
        return result;
    }

    public static long removeAllAttributes(Net net) {
        long result = AttributeWorker.removeAllAttributes(net, Scope.ALL, null);
        return result;
    }

    public static long removeAllAttributes(Net net, Scope scope, String optionalRelationModelName) {
        if (net == null) {
            throw new IllegalArgumentException("net parameter is null");
        }
        if (scope == null) {
            throw new IllegalArgumentException("target parameter is null");
        }
        int result = 0;
        if (scope == Scope.ALL || scope == Scope.CORPUS) {
            result += net.attributes().size();
            net.attributes().clear();
        }
        if (scope == Scope.ALL || scope == Scope.INDIVIDUALS) {
            for (Individual individual : net.individuals()) {
                result += individual.attributes().size();
                individual.attributes().clear();
            }
        }
        if (scope == Scope.ALL || scope == Scope.FAMILIES) {
            for (Family family : net.families()) {
                result += family.attributes().size();
                family.attributes().clear();
            }
        }
        if (scope == Scope.ALL || scope == Scope.RELATIONS) {
            for (Relation relation : net.relations()) {
                result += relation.attributes().size();
                relation.attributes().clear();
            }
        }
        if (scope == Scope.RELATION) {
            Relations relations = net.relations().getByModelName(optionalRelationModelName);
            for (Relation relation : relations) {
                result += relation.attributes().size();
                relation.attributes().clear();
            }
        }
        return result;
    }

    public static long removeAllAttributesExceptCorpus(Net net) {
        long result = AttributeWorker.removeAllAttributes(net, Scope.INDIVIDUALS, null);
        result += AttributeWorker.removeAllAttributes(net, Scope.FAMILIES, null);
        return result += AttributeWorker.removeAllAttributes(net, Scope.RELATIONS, null);
    }

    public static int removeAttribute(Attributes source, String label, EmptyType type) {
        int result;
        if (label == null) {
            throw new IllegalArgumentException("label parameter is null");
        }
        if (type == null) {
            throw new IllegalArgumentException("type parameter is null");
        }
        if (source == null) {
            result = 0;
        } else {
            Attribute target = (Attribute)source.get(label);
            switch (type) {
                case VOID: {
                    if (target == null) {
                        result = 0;
                        break;
                    }
                    source.remove(label);
                    result = 1;
                    break;
                }
                case BLANK: {
                    if (target == null) {
                        result = 0;
                        break;
                    }
                    target.setValue("");
                    result = 1;
                    break;
                }
                case FORCED_BLANK: {
                    source.put(label, "");
                    result = 1;
                    break;
                }
                default: {
                    result = 0;
                }
            }
        }
        return result;
    }

    public static int removeAttribute(Net net, Scope scope, String optionalRelationModelName, String label, EmptyType type) {
        logger.debug("removeAttribute [net={}][scope={}][optionalName={}][label={}][type={}]", new Object[]{net, scope, optionalRelationModelName, label, type});
        if (net == null) {
            throw new IllegalArgumentException("net parameter is null");
        }
        if (scope == null) {
            throw new IllegalArgumentException("target parameter is null");
        }
        if (label == null) {
            throw new IllegalArgumentException("label parameter is null");
        }
        if (type == null) {
            throw new IllegalArgumentException("type parameter is null");
        }
        int result = 0;
        if (scope == Scope.ALL || scope == Scope.CORPUS) {
            result += AttributeWorker.removeAttribute(net.attributes(), label, type);
        }
        if (scope == Scope.ALL || scope == Scope.INDIVIDUALS) {
            for (Individual individual : net.individuals()) {
                result += AttributeWorker.removeAttribute(individual.attributes(), label, type);
            }
        }
        if (scope == Scope.ALL || scope == Scope.FAMILIES) {
            for (Family family : net.families()) {
                result += AttributeWorker.removeAttribute(family.attributes(), label, type);
            }
        }
        if (scope == Scope.ALL || scope == Scope.RELATIONS) {
            for (Relation relation : net.relations()) {
                result += AttributeWorker.removeAttribute(relation.attributes(), label, type);
            }
        }
        if (scope == Scope.RELATION) {
            Relations relations = net.relations().getByModelName(optionalRelationModelName);
            for (Relation relation : relations) {
                result += AttributeWorker.removeAttribute(relation.attributes(), label, type);
            }
        }
        return result;
    }

    public static long renameAttribute(Attributes source, String label, String newLabel, CaseOption caseOption) {
        long result;
        if (source == null) {
            result = 0L;
        } else {
            if (label == null) {
                throw new IllegalArgumentException("label parameter is null");
            }
            if (StringUtils.isBlank((CharSequence)newLabel)) {
                throw new IllegalArgumentException("newLabel parameter is blank.");
            }
            Attribute target = caseOption == null || caseOption == CaseOption.CASE_SENSITIVE ? (Attribute)source.get(StringUtils.trim((String)label)) : source.getIgnoreCase(StringUtils.trim((String)label));
            if (target == null) {
                result = 0L;
            } else {
                source.remove(target.getLabel());
                target.setLabel(newLabel);
                source.put(target);
                result = 1L;
            }
        }
        return result;
    }

    public static long renameAttribute(Net net, AttributeRenameCriteria criteria) {
        long result = net == null || AttributeRenameCriteria.isNotValid(criteria) ? 0L : AttributeWorker.renameAttribute(net, criteria.getScope(), criteria.getOptionalRelationName(), criteria.getLabel(), criteria.getNewLabel(), criteria.getCaseOption());
        return result;
    }

    public static long renameAttribute(Net net, Scope scope, String optionalRelationModelName, String label, String newLabel, CaseOption caseOption) {
        long result;
        block12: {
            block11: {
                logger.debug("renameAttribute [net={}][scope={}][optionalName={}][label={}][newLabel={}][caseOption={}]", new Object[]{net, scope, optionalRelationModelName, label, newLabel, caseOption});
                if (net == null) {
                    throw new IllegalArgumentException("net parameter is null");
                }
                if (scope == null) {
                    throw new IllegalArgumentException("scope parameter is null");
                }
                if (label == null) {
                    throw new IllegalArgumentException("label parameter is null");
                }
                if (newLabel == null) {
                    throw new IllegalArgumentException("newLabel parameter is null");
                }
                result = 0L;
                if (scope == Scope.ALL || scope == Scope.CORPUS) {
                    result += AttributeWorker.renameAttribute(net.attributes(), label, newLabel, caseOption);
                }
                if (scope == Scope.ALL || scope == Scope.INDIVIDUALS) {
                    for (Individual individual : net.individuals()) {
                        result += AttributeWorker.renameAttribute(individual.attributes(), label, newLabel, caseOption);
                    }
                }
                if (scope == Scope.ALL || scope == Scope.FAMILIES) {
                    for (Family family : net.families()) {
                        result += AttributeWorker.renameAttribute(family.attributes(), label, newLabel, caseOption);
                    }
                }
                if (scope != Scope.ALL && scope != Scope.RELATIONS) break block11;
                for (Relation relation : net.relations()) {
                    result += AttributeWorker.renameAttribute(relation.attributes(), label, newLabel, caseOption);
                }
                break block12;
            }
            if (scope != Scope.RELATION) break block12;
            Relations relations = net.relations().getByModelName(optionalRelationModelName);
            for (Relation relation : relations) {
                result += AttributeWorker.renameAttribute(relation.attributes(), label, newLabel, caseOption);
            }
        }
        return result;
    }

    public static long renameAttribute(Net net, Segmentation segmentation, AttributeRenameCriteria criteria) {
        long result = net == null || AttributeRenameCriteria.isNotValid(criteria) ? 0L : AttributeWorker.renameAttribute(net, segmentation, criteria.getScope(), criteria.getOptionalRelationName(), criteria.getLabel(), criteria.getNewLabel(), criteria.getCaseOption());
        return result;
    }

    public static long renameAttribute(Net net, Segmentation segmentation, Scope scope, String optionalRelationModelName, String label, String newLabel, CaseOption caseOption) {
        long result;
        block12: {
            block13: {
                block11: {
                    logger.debug("renameAttribute [net={}][scope={}][optionalName={}][label={}][newLabel={}][caseOption={}]", new Object[]{net, scope, optionalRelationModelName, label, newLabel, caseOption});
                    if (net == null) {
                        throw new IllegalArgumentException("net parameter is null");
                    }
                    if (scope == null) {
                        throw new IllegalArgumentException("scope parameter is null");
                    }
                    if (label == null) {
                        throw new IllegalArgumentException("label parameter is null");
                    }
                    if (newLabel == null) {
                        throw new IllegalArgumentException("newLabel parameter is null");
                    }
                    if (segmentation != null) break block11;
                    result = AttributeWorker.renameAttribute(net, scope, optionalRelationModelName, label, newLabel, caseOption);
                    break block12;
                }
                result = 0L;
                if (scope == Scope.ALL || scope == Scope.CORPUS) {
                    result += AttributeWorker.renameAttribute(net.attributes(), label, newLabel, caseOption);
                }
                if (scope == Scope.ALL || scope == Scope.INDIVIDUALS) {
                    for (Individual individual : segmentation.getCurrentIndividuals()) {
                        result += AttributeWorker.renameAttribute(individual.attributes(), label, newLabel, caseOption);
                    }
                }
                if (scope == Scope.ALL || scope == Scope.FAMILIES) {
                    for (Family family : segmentation.getCurrentFamilies()) {
                        result += AttributeWorker.renameAttribute(family.attributes(), label, newLabel, caseOption);
                    }
                }
                if (scope != Scope.ALL && scope != Scope.RELATIONS) break block13;
                for (Relation relation : segmentation.getCurrentRelations()) {
                    result += AttributeWorker.renameAttribute(relation.attributes(), label, newLabel, caseOption);
                }
                break block12;
            }
            if (scope != Scope.RELATION) break block12;
            Relations relations = segmentation.getCurrentRelations().getByModelName(optionalRelationModelName);
            for (Relation relation : relations) {
                result += AttributeWorker.renameAttribute(relation.attributes(), label, newLabel, caseOption);
            }
        }
        return result;
    }

    public static long replaceAttributeValue(Attributes source, String label, String targetValue, String newValue, CaseOption caseOption) {
        long result;
        if (source == null) {
            result = 0L;
        } else {
            if (label == null) {
                throw new IllegalArgumentException("label parameter is null");
            }
            Attribute target = (Attribute)source.get(StringUtils.trim((String)label));
            if (target == null) {
                result = 0L;
            } else if (caseOption == null || caseOption == CaseOption.CASE_SENSITIVE) {
                if (StringUtils.equals((CharSequence)target.getValue(), (CharSequence)targetValue)) {
                    target.setValue(newValue);
                    result = 1L;
                } else {
                    result = 0L;
                }
            } else if (StringUtils.equalsIgnoreCase((CharSequence)target.getValue(), (CharSequence)targetValue)) {
                target.setValue(newValue);
                result = 1L;
            } else {
                result = 0L;
            }
        }
        return result;
    }

    public static long replaceAttributeValue(Net net, AttributeReplaceValueCriteria criteria) {
        long result = AttributeWorker.replaceAttributeValue(net, new Segmentation(net), criteria);
        return result;
    }

    public static long replaceAttributeValue(Net net, Scope scope, String optionalRelationModelName, String label, String targetValue, String newValue, CaseOption caseOption) {
        long result = AttributeWorker.replaceAttributeValue(net, new Segmentation(net), scope, optionalRelationModelName, label, targetValue, newValue, caseOption);
        return result;
    }

    public static long replaceAttributeValue(Net net, Segmentation segmentation, AttributeReplaceValueCriteria criteria) {
        long result = net == null || AttributeReplaceValueCriteria.isNotValid(criteria) ? 0L : AttributeWorker.replaceAttributeValue(net, segmentation, criteria.getScope(), criteria.getOptionalRelationName(), criteria.getLabel(), criteria.getTargetValue(), criteria.getNewValue(), criteria.getCaseOption());
        return result;
    }

    public static long replaceAttributeValue(Net net, Segmentation segmentation, Scope scope, String optionalRelationModelName, String label, String targetValue, String newValue, CaseOption caseOption) {
        long result;
        block11: {
            block12: {
                block10: {
                    logger.debug("renameAttribute [net={}][scope={}][optionalName={}][label={}][value={}][newValue={}][caseOption={}]", new Object[]{net, scope, optionalRelationModelName, label, targetValue, newValue, caseOption});
                    if (net == null) {
                        throw new IllegalArgumentException("net parameter is null");
                    }
                    if (scope == null) {
                        throw new IllegalArgumentException("scope parameter is null");
                    }
                    if (label == null) {
                        throw new IllegalArgumentException("label parameter is null");
                    }
                    if (segmentation != null) break block10;
                    result = AttributeWorker.replaceAttributeValue(net, scope, optionalRelationModelName, label, targetValue, newValue, caseOption);
                    break block11;
                }
                result = 0L;
                if (scope == Scope.ALL || scope == Scope.CORPUS) {
                    result += AttributeWorker.replaceAttributeValue(net.attributes(), label, targetValue, newValue, caseOption);
                }
                if (scope == Scope.ALL || scope == Scope.INDIVIDUALS) {
                    for (Individual individual : segmentation.getCurrentIndividuals()) {
                        result += AttributeWorker.replaceAttributeValue(individual.attributes(), label, targetValue, newValue, caseOption);
                    }
                }
                if (scope == Scope.ALL || scope == Scope.FAMILIES) {
                    for (Family family : segmentation.getCurrentFamilies()) {
                        result += AttributeWorker.replaceAttributeValue(family.attributes(), label, targetValue, newValue, caseOption);
                    }
                }
                if (scope != Scope.ALL && scope != Scope.RELATIONS) break block12;
                for (Relation relation : segmentation.getCurrentRelations()) {
                    result += AttributeWorker.replaceAttributeValue(relation.attributes(), label, targetValue, newValue, caseOption);
                }
                break block11;
            }
            if (scope != Scope.RELATION) break block11;
            Relations relations = segmentation.getCurrentRelations().getByModelName(optionalRelationModelName);
            for (Relation relation : relations) {
                result += AttributeWorker.replaceAttributeValue(relation.attributes(), label, targetValue, newValue, caseOption);
            }
        }
        return result;
    }

    public static long setAttributeValue(Attributes source, String label, String value) {
        long result;
        if (source == null) {
            result = 0L;
        } else {
            if (label == null) {
                throw new IllegalArgumentException("label parameter is null");
            }
            Attribute target = (Attribute)source.get(StringUtils.trim((String)label));
            if (target == null) {
                source.add(new Attribute(label, value));
                result = 1L;
            } else {
                target.setValue(value);
                result = 1L;
            }
        }
        return result;
    }

    public static long setAttributeValue(Net net, AttributeSetValueCriteria criteria) {
        long result = AttributeWorker.setAttributeValue(net, new Segmentation(net), criteria);
        return result;
    }

    public static long setAttributeValue(Net net, Scope scope, String optionalRelationModelName, String label, String targetValue) {
        long result = AttributeWorker.setAttributeValue(net, new Segmentation(net), scope, optionalRelationModelName, label, targetValue);
        return result;
    }

    public static long setAttributeValue(Net net, Segmentation segmentation, AttributeSetValueCriteria criteria) {
        long result = net == null || AttributeSetValueCriteria.isNotValid(criteria) ? 0L : AttributeWorker.setAttributeValue(net, segmentation, criteria.getScope(), criteria.getOptionalRelationName(), criteria.getLabel(), criteria.getTargetValue());
        return result;
    }

    public static long setAttributeValue(Net net, Segmentation segmentation, Scope scope, String optionalRelationModelName, String label, String targetValue) {
        long result;
        block11: {
            block12: {
                block10: {
                    logger.debug("setAttribute [net={}][scope={}][optionalName={}][label={}][value={}]", new Object[]{net, scope, optionalRelationModelName, label, targetValue});
                    if (net == null) {
                        throw new IllegalArgumentException("net parameter is null");
                    }
                    if (scope == null) {
                        throw new IllegalArgumentException("scope parameter is null");
                    }
                    if (label == null) {
                        throw new IllegalArgumentException("label parameter is null");
                    }
                    if (segmentation != null) break block10;
                    result = AttributeWorker.setAttributeValue(net, scope, optionalRelationModelName, label, targetValue);
                    break block11;
                }
                result = 0L;
                if (scope == Scope.ALL || scope == Scope.CORPUS) {
                    result += AttributeWorker.setAttributeValue(net.attributes(), label, targetValue);
                }
                if (scope == Scope.ALL || scope == Scope.INDIVIDUALS) {
                    for (Individual individual : segmentation.getCurrentIndividuals()) {
                        result += AttributeWorker.setAttributeValue(individual.attributes(), label, targetValue);
                    }
                }
                if (scope == Scope.ALL || scope == Scope.FAMILIES) {
                    for (Family family : segmentation.getCurrentFamilies()) {
                        result += AttributeWorker.setAttributeValue(family.attributes(), label, targetValue);
                    }
                }
                if (scope != Scope.ALL && scope != Scope.RELATIONS) break block12;
                for (Relation relation : segmentation.getCurrentRelations()) {
                    result += AttributeWorker.setAttributeValue(relation.attributes(), label, targetValue);
                }
                break block11;
            }
            if (scope != Scope.RELATION) break block11;
            Relations relations = segmentation.getCurrentRelations().getByModelName(optionalRelationModelName);
            for (Relation relation : relations) {
                result += AttributeWorker.setAttributeValue(relation.attributes(), label, targetValue);
            }
        }
        return result;
    }

    public static long trimValue(Attribute target) {
        long result;
        if (target == null) {
            result = 0L;
        } else if (StringUtils.isEmpty((CharSequence)target.getValue())) {
            result = 0L;
        } else {
            target.setValue(StringUtils.trim((String)target.getValue()));
            result = 1L;
        }
        return result;
    }

    public static long upperCaseValue(Attribute target) {
        long result;
        if (target == null) {
            result = 0L;
        } else if (StringUtils.isEmpty((CharSequence)target.getValue())) {
            result = 0L;
        } else {
            target.setValue(StringUtils.upperCase((String)target.getValue()));
            result = 1L;
        }
        return result;
    }

    public static int valuateExogenousAttribute(Individuals source, String sourceLabel, String targetLabel, String valuePrefix) {
        logger.debug("valuateExogenousAttribute [source={}][sourceLabel={}][targetLabel={}][valuePrefix={}]", new Object[]{source, sourceLabel, targetLabel, valuePrefix});
        if (source == null) {
            throw new IllegalArgumentException("source parameter is null");
        }
        if (sourceLabel == null) {
            throw new IllegalArgumentException("source label parameter is null");
        }
        if (StringUtils.isBlank((CharSequence)targetLabel)) {
            throw new IllegalArgumentException("target label parameter is null");
        }
        int result = 0;
        NumberedValues values = IndividualValuator.get(source, sourceLabel);
        for (Individual individual : source) {
            Value value = (Value)values.get(individual.getId());
            String attributeValue = value == null ? "" : value.toString();
            String prefix = valuePrefix == null ? "" : valuePrefix;
            individual.attributes().put(targetLabel, String.valueOf(prefix) + attributeValue);
            ++result;
        }
        return result;
    }

    public static enum CaseOption {
        CASE_SENSITIVE,
        IGNORE_CASE;

    }

    public static enum EmptyType {
        VOID,
        BLANK,
        FORCED_BLANK;

    }

    public static enum Scope {
        ALL,
        CORPUS,
        INDIVIDUALS,
        FAMILIES,
        RELATION,
        RELATIONS,
        NONE;

    }
}

