/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.matrix;

import org.tip.puck.matrix.Matrix;
import org.tip.puck.util.NumberedIntegers;

public class SparseMatrix {
    private Matrix matrix;
    private NumberedIntegers idToCol;
    private NumberedIntegers idToRow;
    private NumberedIntegers colToId;
    private NumberedIntegers rowToId;

    public SparseMatrix(int nodeCount) {
        this.matrix = new Matrix(nodeCount);
        this.idToCol = new NumberedIntegers(nodeCount);
        this.idToRow = new NumberedIntegers(nodeCount);
        this.colToId = new NumberedIntegers(nodeCount);
        this.rowToId = new NumberedIntegers(nodeCount);
    }

    public SparseMatrix(int sourceCount, int targetCount) {
        this.matrix = new Matrix(sourceCount, targetCount);
        this.idToCol = new NumberedIntegers(targetCount);
        this.idToRow = new NumberedIntegers(sourceCount);
        this.colToId = new NumberedIntegers(targetCount);
        this.rowToId = new NumberedIntegers(sourceCount);
    }

    public void add(int sourceId, int targetId, double value) {
        Integer columnIndex;
        Integer rowIndex = this.getRowIndex(sourceId);
        if (rowIndex == null) {
            rowIndex = this.idToRow.size();
            this.idToRow.put(sourceId, rowIndex);
            this.rowToId.put(rowIndex, sourceId);
        }
        if ((columnIndex = this.getColumnIndex(targetId)) == null) {
            columnIndex = this.idToCol.size();
            this.idToCol.put(targetId, columnIndex);
            this.colToId.put(columnIndex, targetId);
        }
        this.matrix.augment(rowIndex, columnIndex, (int)value);
    }

    public void addSource(int sourceId) {
        Integer rowIndex = this.getRowIndex(sourceId);
        if (rowIndex == null) {
            rowIndex = this.idToRow.size();
            this.idToRow.put(sourceId, rowIndex);
            this.rowToId.put(rowIndex, sourceId);
        }
    }

    public void addTarget(int targetId) {
        Integer columnIndex = this.getColumnIndex(targetId);
        if (columnIndex == null) {
            columnIndex = this.idToCol.size();
            this.idToCol.put(targetId, columnIndex);
            this.colToId.put(columnIndex, targetId);
        }
    }

    public double get(int sourceId, int targetId) {
        Integer rowIndex = this.getRowIndex(sourceId);
        Integer columnIndex = this.getColumnIndex(targetId);
        double result = rowIndex == null || columnIndex == null ? 0.0 : (double)this.matrix.get(this.getRowIndex(sourceId), this.getColumnIndex(targetId));
        return result;
    }

    public Integer getColumnIndex(int targetId) {
        Integer result = (Integer)this.idToCol.get(targetId);
        return result;
    }

    public Matrix getMatrix() {
        Matrix result = this.matrix;
        return result;
    }

    public Integer getRowIndex(int sourceId) {
        Integer result = (Integer)this.idToRow.get(sourceId);
        return result;
    }

    public int getSourceCount() {
        int result = this.matrix.getRowDim();
        return result;
    }

    public int getSourceId(int rowIndex) {
        int result = (Integer)this.rowToId.get(rowIndex);
        return result;
    }

    public int getSum() {
        int result = this.matrix.getSum();
        return result;
    }

    public int getTargetCount() {
        int result = this.matrix.getColDim();
        return result;
    }

    public int getTargetId(int columnIndex) {
        int result = (Integer)this.colToId.get(columnIndex);
        return result;
    }

    public void inc(int sourceId, int targetId) {
        this.add(sourceId, targetId, 1.0);
    }

    public void set(int sourceId, int targetId, double weight) {
        Integer columnIndex;
        Integer rowIndex = this.getRowIndex(sourceId);
        if (rowIndex == null) {
            rowIndex = this.idToRow.size();
            this.idToRow.put(sourceId, rowIndex);
            this.rowToId.put(rowIndex, sourceId);
        }
        if ((columnIndex = this.getColumnIndex(targetId)) == null) {
            columnIndex = this.idToCol.size();
            this.idToCol.put(targetId, columnIndex);
            this.colToId.put(columnIndex, targetId);
        }
        this.matrix.set(rowIndex, columnIndex, (int)weight);
    }
}

