/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.kinoath.io;

import java.awt.Color;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.Writer;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.XMLAbstractTranscoder;
import org.apache.batik.transcoder.image.ImageTranscoder;
import org.apache.commons.io.IOUtils;
import org.apache.fop.svg.PDFTranscoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.PuckException;
import org.tip.puck.PuckExceptions;
import org.tip.puck.kinoath.KinOathDiagram;

public class KinOathFile {
    private static final Logger logger = LoggerFactory.getLogger(KinOathFile.class);

    public static void save(File file, KinOathDiagram source, String generator) throws PuckException {
        if (file.getName().endsWith(".svg")) {
            KinOathFile.saveSVG(file, source);
        } else if (file.getName().endsWith(".pdf")) {
            KinOathFile.savePDF(file, source);
        }
    }

    public static void savePDF(File file, KinOathDiagram source) {
        block7: {
            BufferedOutputStream outputStream = null;
            try {
                PDFTranscoder transcoder = new PDFTranscoder();
                transcoder.addTranscodingHint(PDFTranscoder.KEY_STROKE_TEXT, (Object)Boolean.FALSE);
                transcoder.addTranscodingHint(ImageTranscoder.KEY_BACKGROUND_COLOR, (Object)Color.WHITE);
                transcoder.addTranscodingHint(XMLAbstractTranscoder.KEY_XML_PARSER_VALIDATING, (Object)Boolean.FALSE);
                transcoder.addTranscodingHint(ImageTranscoder.KEY_PIXEL_UNIT_TO_MILLIMETER, (Object)new Float(4.0f));
                TranscoderInput transcoderInput = new TranscoderInput(source.getDocument());
                outputStream = new BufferedOutputStream(new FileOutputStream(file));
                TranscoderOutput transcoderOutput = new TranscoderOutput((OutputStream)outputStream);
                transcoder.transcode(transcoderInput, transcoderOutput);
            }
            catch (FileNotFoundException exception) {
                exception.printStackTrace();
                IOUtils.closeQuietly(outputStream);
                break block7;
            }
            catch (TranscoderException exception) {
                try {
                    exception.printStackTrace();
                    break block7;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    IOUtils.closeQuietly(outputStream);
                }
            }
            IOUtils.closeQuietly((OutputStream)outputStream);
        }
    }

    /*
     * Loose catch block
     */
    public static void saveSVG(File file, KinOathDiagram source) throws PuckException {
        Writer out = null;
        FileOutputStream fileOutputStream = null;
        try {
            try {
                fileOutputStream = new FileOutputStream(file);
                StreamResult xmlOutput = new StreamResult(fileOutputStream);
                DOMSource dOMSource = new DOMSource(source.getDocument());
                Transformer transformer = TransformerFactory.newInstance().newTransformer();
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
                transformer.transform(dOMSource, xmlOutput);
            }
            catch (FileNotFoundException exception) {
                throw PuckExceptions.FILE_NOT_FOUND.create("Opening file [" + file + "]", new Object[0]);
            }
            catch (TransformerConfigurationException exception) {
                exception.printStackTrace();
                IOUtils.closeQuietly(out);
            }
            catch (TransformerFactoryConfigurationError exception) {
                exception.printStackTrace();
                IOUtils.closeQuietly(out);
            }
            catch (TransformerException exception) {
                exception.printStackTrace();
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly(out);
            }
        }
        finally {
            IOUtils.closeQuietly(out);
        }
    }
}

