/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.io;

import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.io.bar.BARFile;
import org.tip.puck.io.iur.IURFile;

public class BARIURDetector {
    private static final Logger logger = LoggerFactory.getLogger(BARIURDetector.class);
    public static final String DEFAULT_CHARSET_NAME = "UTF-8";
    public static final int MAX_LINE_SIZE = 2048;

    public static Format detectFormat(File source) {
        boolean isBAR = BARFile.isBAR(source);
        boolean isIUR = IURFile.isIUR(source);
        Format result = isBAR && isIUR ? Format.CONFLICTING : (isBAR ? Format.BAR : (isIUR ? Format.IUR : Format.UNKNOWN));
        logger.debug("BARIUR detector: [isBAR={}][isIUR={}][result={}]", new Object[]{isBAR, isIUR, result});
        return result;
    }

    public static enum Format {
        BAR,
        IUR,
        UNKNOWN,
        CONFLICTING;

    }
}

