/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck;

import fr.devinsy.util.FileTools;
import java.io.File;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.PuckException;
import org.tip.puck.PuckExceptions;
import org.tip.puck.io.ged.GEDFile;
import org.tip.puck.io.iur.IURODSFile;
import org.tip.puck.io.iur.IURTXTFile;
import org.tip.puck.io.iur.IURXLSFile;
import org.tip.puck.io.ods.ODSFile;
import org.tip.puck.io.paj.PAJFile;
import org.tip.puck.io.permutation.PermutationFile;
import org.tip.puck.io.permutation.PermutationTable;
import org.tip.puck.io.pl.PLFile;
import org.tip.puck.io.puc.PUCFile;
import org.tip.puck.io.tip.TIPFile;
import org.tip.puck.io.txt.TXTFile;
import org.tip.puck.io.xls.XLSFile;
import org.tip.puck.net.Net;
import org.tip.puck.net.relations.RelationModel;
import org.tip.puck.net.relations.workers.RelationModelTXTFile;
import org.tip.puck.net.workers.UpdateWorker;
import org.tip.puck.report.Report;
import org.tip.puck.report.ReportTXTFile;
import org.tip.puck.report.ReportXLSFile;

public class PuckManager {
    private static final Logger logger = LoggerFactory.getLogger(PuckManager.class);
    public static String DEFAULT_CHARSET_NAME = "UTF-8";

    public static Net fuseNet(Net target, File sourceFile, File concordanceFile, Report errorReport) throws PuckException {
        if (target == null || sourceFile == null) {
            throw PuckExceptions.INVALID_PARAMETER.create("Null parameter.", new Object[0]);
        }
        Net source = PuckManager.loadNet(sourceFile);
        PermutationTable permutations = PermutationFile.load(concordanceFile);
        Net result = UpdateWorker.fuse(target, source, permutations, errorReport);
        return result;
    }

    public static Net loadNet(File file) throws PuckException {
        Net result = PuckManager.loadNet(file, DEFAULT_CHARSET_NAME);
        return result;
    }

    public static Net loadNet(File file, String charsetName) throws PuckException {
        Net result;
        if (file == null) {
            throw PuckExceptions.INVALID_PARAMETER.create("File=[" + file + "].", new Object[0]);
        }
        if (!file.exists()) {
            throw PuckExceptions.FILE_NOT_FOUND.create("File=[" + file + "].", new Object[0]);
        }
        if (!file.isFile()) {
            throw PuckExceptions.NOT_A_FILE.create("File=[" + file + "].", new Object[0]);
        }
        String extension = StringUtils.lowerCase((String)FileTools.getExtension((String)file.getName()));
        if (extension == null) {
            throw PuckExceptions.UNSUPPORTED_FILE_FORMAT.create("File=[" + file + "].", new Object[0]);
        }
        if (extension.endsWith("ged")) {
            result = GEDFile.load(file, charsetName);
        } else if (extension.endsWith("ods")) {
            result = ODSFile.load(file);
        } else if (extension.endsWith("paj")) {
            result = PAJFile.load(file, charsetName);
        } else if (extension.endsWith("pl")) {
            result = PLFile.load(file, charsetName);
        } else if (extension.endsWith("puc")) {
            result = PUCFile.load(file);
        } else if (extension.endsWith("tip")) {
            result = TIPFile.load(file, charsetName);
        } else if (extension.endsWith("txt")) {
            result = TXTFile.load(file);
        } else if (extension.endsWith("txt3")) {
            result = IURTXTFile.load(file);
        } else if (extension.endsWith("xls")) {
            result = XLSFile.load(file);
        } else {
            throw PuckExceptions.UNSUPPORTED_FILE_FORMAT.create("File=[" + file + "].", new Object[0]);
        }
        return result;
    }

    public static Net newEmptyNet() {
        Net result = null;
        return result;
    }

    public static Net newRandomNet() {
        Net result = null;
        return result;
    }

    public static void saveNet(File file, Net net) throws PuckException {
        try {
            boolean succeed;
            if (file == null) {
                throw PuckExceptions.INVALID_PARAMETER.create("File=[" + file + "].", new Object[0]);
            }
            if (file.isDirectory()) {
                throw PuckExceptions.NOT_A_FILE.create("File=[" + file + "].", new Object[0]);
            }
            File temporaryFile = new File(String.valueOf(file.getAbsolutePath()) + "-tmp");
            temporaryFile.delete();
            String extension = StringUtils.lowerCase((String)FileTools.getExtension((String)file.getName()));
            if (extension.endsWith("ged")) {
                GEDFile.save(temporaryFile, net);
            } else if (extension.endsWith("ods")) {
                IURODSFile.save(temporaryFile, net);
                temporaryFile = new File(String.valueOf(temporaryFile.getAbsolutePath()) + ".ods");
            } else if (extension.endsWith("pl")) {
                PLFile.save(temporaryFile, net);
            } else if (extension.endsWith("puc")) {
                PUCFile.save(temporaryFile, net, "PUCK");
            } else if (extension.endsWith("tip")) {
                TIPFile.save(temporaryFile, net);
            } else if (extension.endsWith("txt")) {
                IURTXTFile.save(temporaryFile, net);
            } else if (extension.endsWith("xls")) {
                IURXLSFile.save(temporaryFile, net);
            } else {
                throw PuckExceptions.UNSUPPORTED_FILE_FORMAT.create("File=[" + file + "].", new Object[0]);
            }
            if (file.exists()) {
                File backupFile = new File(String.valueOf(file.getAbsolutePath()) + ".bak");
                backupFile.delete();
                boolean succeed2 = file.renameTo(backupFile);
                if (!succeed2) {
                    logger.warn("Backup failed for [" + file + "][" + backupFile + "]");
                }
            }
            if (!(succeed = temporaryFile.renameTo(file))) {
                logger.error("Error renaming temporary file for [" + temporaryFile + "]: ");
                throw PuckExceptions.IO_ERROR.create("Can't rename temporary file=[" + temporaryFile + "].", new Object[0]);
            }
        }
        catch (SecurityException exception) {
            exception.printStackTrace();
            logger.error("Permissions denied: " + exception.getMessage());
            throw PuckExceptions.IO_ERROR.create("Permission denied: " + exception.getMessage(), exception);
        }
    }

    public static void saveReport(File file, Report net) throws PuckException {
        if (file == null) {
            throw PuckExceptions.INVALID_PARAMETER.create("File=[" + file + "].", new Object[0]);
        }
        if (file.isDirectory()) {
            throw PuckExceptions.NOT_A_FILE.create("File=[" + file + "].", new Object[0]);
        }
        if (file.getName().toLowerCase().endsWith(".txt")) {
            ReportTXTFile.save(file, net);
        } else if (file.getName().toLowerCase().endsWith(".xls")) {
            ReportXLSFile.save(file, net);
        } else {
            throw PuckExceptions.UNSUPPORTED_FILE_FORMAT.create("File=[" + file + "].", new Object[0]);
        }
    }

    public static void saveRelationModel(File file, RelationModel model) throws PuckException {
        if (file == null) {
            throw PuckExceptions.INVALID_PARAMETER.create("File=[" + file + "].", new Object[0]);
        }
        if (file.isDirectory()) {
            throw PuckExceptions.NOT_A_FILE.create("File=[" + file + "].", new Object[0]);
        }
        if (file.getName().toLowerCase().endsWith(".txt")) {
            RelationModelTXTFile.save(file, model);
        } else if (!file.getName().toLowerCase().endsWith(".xls")) {
            throw PuckExceptions.UNSUPPORTED_FILE_FORMAT.create("File=[" + file + "].", new Object[0]);
        }
    }

    public static Net updateNetAppending(Net target, File file, Report errorReport) throws PuckException {
        if (target == null || file == null) {
            throw PuckExceptions.INVALID_PARAMETER.create("Null parameter.", new Object[0]);
        }
        Net source = PuckManager.loadNet(file);
        Net result = UpdateWorker.update(target, source, errorReport, UpdateWorker.UpdateMode.APPEND);
        return result;
    }

    public static Net updateNetOverwriting(Net target, File file, Report errorReport) throws PuckException {
        if (target == null || file == null) {
            throw PuckExceptions.INVALID_PARAMETER.create("Null parameter.", new Object[0]);
        }
        Net source = PuckManager.loadNet(file);
        Net result = UpdateWorker.update(target, source, errorReport, UpdateWorker.UpdateMode.OVERWRITE);
        return result;
    }
}

