package org.tip.puckgui.views.geo;

import java.awt.BorderLayout;
import java.awt.FlowLayout;

import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JCheckBox;
import javax.swing.JProgressBar;
import javax.swing.JTextField;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puckgui.views.geo.Geocode;
import org.tip.puck.graphs.Graph;
import org.tip.puck.io.csv.CSVFile;
import org.tip.puckgui.GroupNetGUI;
import org.tip.puckgui.NetGUI;

import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import java.awt.event.ItemListener;
import java.awt.event.ItemEvent;
import java.io.File;

public class ConfigGeocodingDialog extends JDialog {

	/**
	 * 
	 */
	private static final long serialVersionUID = -7468130858005234778L;
	
	private static final Logger logger = LoggerFactory.getLogger(CSVFile.class);
	
	private GroupNetGUI parentGui = null;
	private NetGUI netGUI = null;
	private Graph<?> graph = null;
	private File csvFile = null;
	
	private final JPanel contentPanel = new JPanel();
	private JTextField textGeonamesFile;
	private JTextField txtCsv;
	JButton btnOpenGeonamesFile;
	JButton btnOpenPersonnalSources;

	/**
	 * @wbp.parser.constructor
	 */
	public ConfigGeocodingDialog(NetGUI gui, Graph<?> graph) {
		
		this.graph = graph;
		this.netGUI = gui;
		
		initialize();
	}
	
	/**
	 * Create the dialog.
	 */
	public ConfigGeocodingDialog(GroupNetGUI gui) {
		
		parentGui = gui;
		
		initialize();
	}
	
	private void initialize() {
		
		setTitle("Configure Geocoding");
		setBounds(100, 100, 450, 258);
		getContentPane().setLayout(new BorderLayout());
		contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
		getContentPane().add(contentPanel, BorderLayout.CENTER);
		contentPanel.setLayout(null);
		
		JLabel lblGeocodingSources = new JLabel("Geocoding sources :");
		lblGeocodingSources.setBounds(12, 12, 151, 15);
		contentPanel.add(lblGeocodingSources);
		
		JCheckBox chckbxGeonames = new JCheckBox("Geonames");
		chckbxGeonames.setSelected(true);
		chckbxGeonames.setToolTipText("Web connection is needed");
		chckbxGeonames.setBounds(33, 35, 129, 23);
		contentPanel.add(chckbxGeonames);
		
		JCheckBox chckbxPersonnalSources = new JCheckBox("Personnal sources");
		chckbxPersonnalSources.setEnabled(false);
		chckbxPersonnalSources.setBounds(33, 86, 170, 23);
		contentPanel.add(chckbxPersonnalSources);
		
		JCheckBox chckbxGeonamesFile = new JCheckBox("Geonames file");
		chckbxGeonamesFile.addItemListener(new ItemListener() {
			public void itemStateChanged(ItemEvent e) {
				if( e.getStateChange() == ItemEvent.SELECTED ) {
					textGeonamesFile.setEnabled(true);
					btnOpenGeonamesFile.setEnabled(true);
				}else{
					textGeonamesFile.setEnabled(false);
					btnOpenGeonamesFile.setEnabled(false);
				}
			}
		});

		chckbxGeonamesFile.setBounds(33, 59, 140, 23);
		contentPanel.add(chckbxGeonamesFile);
		
		final JProgressBar progressBar = new JProgressBar();
		progressBar.setBounds(12, 156, 424, 14);
		progressBar.setVisible(false);
		contentPanel.add(progressBar);
		
		textGeonamesFile = new JTextField();
		textGeonamesFile.setBounds(206, 61, 114, 19);
		contentPanel.add(textGeonamesFile);
		textGeonamesFile.setColumns(10);
		
		btnOpenGeonamesFile = new JButton("Open");
		btnOpenGeonamesFile.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				
				JFileChooser fc = new JFileChooser();
				
				int returnVal = fc.showOpenDialog(ConfigGeocodingDialog.this);

		        if (returnVal == JFileChooser.APPROVE_OPTION) {
		        	csvFile = fc.getSelectedFile();
		            //This is where a real application would open the file.
		            logger.debug("Opening CSV file: " + csvFile.getName() + ".");
		        } else {
		        	logger.debug("Open CSV command cancelled by user.");
		        }
		        
		        textGeonamesFile.setText(ConfigGeocodingDialog.this.csvFile.getAbsolutePath());
				
			}
		});
		btnOpenGeonamesFile.setBounds(332, 63, 72, 15);
		contentPanel.add(btnOpenGeonamesFile);
		
		txtCsv = new JTextField();
		txtCsv.setText("csv ?");
		txtCsv.setEnabled(false);
		txtCsv.setBounds(206, 88, 114, 19);
		contentPanel.add(txtCsv);
		txtCsv.setColumns(10);
		
		btnOpenPersonnalSources = new JButton("Open");
		btnOpenPersonnalSources.setEnabled(false);
		btnOpenPersonnalSources.setBounds(332, 90, 72, 15);
		contentPanel.add(btnOpenPersonnalSources);
		{
			JPanel buttonPane = new JPanel();
			buttonPane.setBounds(12, 182, 424, 35);
			contentPanel.add(buttonPane);
			buttonPane.setLayout(new FlowLayout(FlowLayout.RIGHT));
			{
				JButton geocodeButton = new JButton("Geocode");
				geocodeButton.addActionListener(new ActionListener() {
					public void actionPerformed(ActionEvent arg0) {
						//Launch geocoding
						progressBar.setVisible(true);
						progressBar.setEnabled(true);
						
						Geocode geocodingTask = null;
						if( parentGui != null )
							geocodingTask = new Geocode(ConfigGeocodingDialog.this, progressBar, "geonames", parentGui);
//						ArrayList<DefaultFeatureCollection> collectionfeaturesReadyToBeDisplayed = geocodingTask.buildPointAndLinesGeometry(progressBar, "geonames", parentGui.getGroupNet());
						if( graph != null )
							geocodingTask = new Geocode(ConfigGeocodingDialog.this, progressBar, "geonames", netGUI, graph);
						
						if( csvFile != null )
							geocodingTask = new  Geocode(ConfigGeocodingDialog.this, progressBar, "geonamesFile", csvFile, graph);
						
						//use SwingWorker
						geocodingTask.execute();
	
					}
				});
				geocodeButton.setActionCommand("OK");
				buttonPane.add(geocodeButton);
				getRootPane().setDefaultButton(geocodeButton);
			}
			{
				JButton cancelButton = new JButton("Cancel");
				cancelButton.addActionListener(new ActionListener() {
					public void actionPerformed(ActionEvent arg0) {
						ConfigGeocodingDialog.this.dispose();
					}
				});
				cancelButton.setActionCommand("Cancel");
				buttonPane.add(cancelButton);
			}
		}
	}
}
