package org.tip.puckgui.views;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.ScrollPaneConstants;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.net.relations.RelationModel;
import org.tip.puck.net.relations.RelationModels;
import org.tip.puck.net.relations.Role;
import org.tip.puck.net.workers.AttributeDescriptors;
import org.tip.puck.segmentation.Segmentation;
import org.tip.puck.spacetime.SpaceTimeCriteria;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;

import fr.devinsy.util.StringList;

/**
 * 
 * @author TIP
 */
public class SpaceTimeAnalysisInputDialog extends JDialog {

	private static final long serialVersionUID = -7326870100552727961L;

	private static final Logger logger = LoggerFactory.getLogger(SpaceTimeAnalysisInputDialog.class);

	private RelationModels relationModels;
	private AttributeDescriptors attributeDescriptors;

	private final JPanel contentPanel = new JPanel();
	private SpaceTimeCriteria dialogCriteria;
	private static SpaceTimeCriteria lastCriteria = new SpaceTimeCriteria();
	private JComboBox cmbbxRelationModel;
	private JComboBox cmbbxEgoRole;
	private JComboBox cmbbxDateLabel;
	private JSpinner spnnrMaxAge;
	private JButton okButton;
	private JPanel alterRolesPanel;
	private JTextField textField;
	private JTextField textField_1;

	/**
	 * Create the dialog.
	 */
	public SpaceTimeAnalysisInputDialog(final Segmentation segmentation, final RelationModels relationModels, final AttributeDescriptors attributeDescriptors) {
		super();

		this.relationModels = relationModels;
		this.attributeDescriptors = attributeDescriptors;

		// ////////////////////////////////////////////////
		setModalityType(ModalityType.APPLICATION_MODAL);
		setModal(true);
		setAlwaysOnTop(true);
		setTitle("Space-Time Analysis Input Dialog");
		setIconImage(Toolkit.getDefaultToolkit().getImage(SpaceTimeAnalysisInputDialog.class.getResource("/org/tip/puckgui/favicon-16x16.jpg")));
		addWindowListener(new WindowAdapter() {
			@Override
			public void windowClosing(final WindowEvent e) {
				// Closing window.
				// Cancel button.
				SpaceTimeAnalysisInputDialog.this.dialogCriteria = null;
				setVisible(false);
			}
		});

		setBounds(100, 100, 1150, 761);
		getContentPane().setLayout(new BorderLayout());
		this.contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
		getContentPane().add(this.contentPanel, BorderLayout.CENTER);
		this.contentPanel.setLayout(new FormLayout(new ColumnSpec[] { ColumnSpec.decode("max(175dlu;default)"), FormFactory.RELATED_GAP_COLSPEC,
				ColumnSpec.decode("max(100dlu;default)"), FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode("default:grow"), }, new RowSpec[] {
				FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC,
				FormFactory.RELATED_GAP_ROWSPEC, }));
		{
		}
		{
			JPanel panel = new JPanel();
			this.contentPanel.add(panel, "1, 2, fill, fill");
			panel.setLayout(new FormLayout(new ColumnSpec[] { FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC,
					ColumnSpec.decode("default:grow"), FormFactory.RELATED_GAP_COLSPEC, }, new RowSpec[] { FormFactory.RELATED_GAP_ROWSPEC,
					FormFactory.DEFAULT_ROWSPEC, }));
			{
				JLabel lblRelationModel = new JLabel("Relation Model:");
				panel.add(lblRelationModel, "2, 2");
			}
			this.cmbbxRelationModel = new JComboBox(relationModels.nameList().toArray());
			panel.add(this.cmbbxRelationModel, "4, 2");
			this.cmbbxRelationModel.addItemListener(new ItemListener() {
				@Override
				public void itemStateChanged(final ItemEvent event) {
					// Update label list.
					//
					if (event.getStateChange() == ItemEvent.SELECTED) {
						//
						setRelationModel(SpaceTimeAnalysisInputDialog.this.cmbbxRelationModel.getSelectedIndex(), null, null);
					}
				}
			});
		}
		{
			JPanel constructionOptionsPanel = new JPanel();
			constructionOptionsPanel.setBorder(new TitledBorder(null, "Constructions Options", TitledBorder.LEADING, TitledBorder.TOP, null, null));
			this.contentPanel.add(constructionOptionsPanel, "1, 4, fill, fill");
			constructionOptionsPanel.setLayout(new FormLayout(new ColumnSpec[] { FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC,
					FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode("default:grow"), FormFactory.RELATED_GAP_COLSPEC, }, new RowSpec[] {
					FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC,
					FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC,
					FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC,
					FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode("max(75dlu;default)"),
					FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC,
					FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC,
					FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC,
					FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC,
					FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, }));
			{
				JLabel lblDateLabel = new JLabel("Date Label:");
				constructionOptionsPanel.add(lblDateLabel, "2, 2, right, default");
			}
			{
				this.cmbbxDateLabel = new JComboBox();
				constructionOptionsPanel.add(this.cmbbxDateLabel, "4, 2");
			}
			{
				JLabel lblStartDateLabel = new JLabel("Start Date Label:");
				constructionOptionsPanel.add(lblStartDateLabel, "2, 4, right, default");
			}
			{
				JComboBox comboBox = new JComboBox();
				constructionOptionsPanel.add(comboBox, "4, 4");
			}
			{
				JLabel lblEndDateLabel = new JLabel("End Date Label:");
				constructionOptionsPanel.add(lblEndDateLabel, "2, 6, right, default");
			}
			{
				JComboBox comboBox = new JComboBox();
				constructionOptionsPanel.add(comboBox, "4, 6");
			}
			{
				JLabel lblPlaceLabel = new JLabel("Place Label:");
				constructionOptionsPanel.add(lblPlaceLabel, "2, 8, right, default");
			}
			{
				JComboBox comboBox = new JComboBox();
				constructionOptionsPanel.add(comboBox, "4, 8");
			}
			{
				JLabel lblLocalUnitLabel = new JLabel("Local Unit Label:");
				constructionOptionsPanel.add(lblLocalUnitLabel, "2, 10, right, default");
			}
			{
				JComboBox comboBox = new JComboBox();
				constructionOptionsPanel.add(comboBox, "4, 10");
			}
			{
				JLabel lblEgoRole = new JLabel("Ego Role:");
				constructionOptionsPanel.add(lblEgoRole, "2, 12, right, default");
			}
			{
				this.cmbbxEgoRole = new JComboBox();
				constructionOptionsPanel.add(this.cmbbxEgoRole, "4, 12");
			}
			{
				JLabel lblDefaultReferentRole = new JLabel("<html><div style=\"text-align: right;\">Default Referent<br/>Role Name</div></html>");
				constructionOptionsPanel.add(lblDefaultReferentRole, "2, 14, right, default");
			}
			{
				JComboBox comboBox = new JComboBox();
				constructionOptionsPanel.add(comboBox, "4, 14");
			}
			{
				JLabel lblAlterRoles = new JLabel("Alter Roles:");
				constructionOptionsPanel.add(lblAlterRoles, "2, 16, right, top");
			}
			{
				JScrollPane alterRolesScrollPane = new JScrollPane();
				alterRolesScrollPane.setVerticalScrollBarPolicy(ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS);
				constructionOptionsPanel.add(alterRolesScrollPane, "4, 16, fill, fill");
				{
					this.alterRolesPanel = new JPanel();
					alterRolesScrollPane.setViewportView(this.alterRolesPanel);
					this.alterRolesPanel.setLayout(new BoxLayout(this.alterRolesPanel, BoxLayout.Y_AXIS));
				}
			}
			{
				JLabel lblDates = new JLabel("Dates:");
				constructionOptionsPanel.add(lblDates, "2, 18, right, default");
			}
			{
				this.textField = new JTextField();
				constructionOptionsPanel.add(this.textField, "4, 18");
				this.textField.setColumns(10);
			}
			{
				JLabel lblGeography = new JLabel("Geography:");
				constructionOptionsPanel.add(lblGeography, "2, 20, right, default");
			}
			{
				JComboBox comboBox = new JComboBox();
				constructionOptionsPanel.add(comboBox, "4, 20");
			}
			{
				JLabel lblLevel = new JLabel("Level:");
				constructionOptionsPanel.add(lblLevel, "2, 22, right, default");
			}
			{
				JComboBox comboBox = new JComboBox();
				constructionOptionsPanel.add(comboBox, "4, 22");
			}
			{
				JLabel lblMinimalPlaceNames = new JLabel("Minimal Place Names:");
				constructionOptionsPanel.add(lblMinimalPlaceNames, "2, 24, right, default");
			}
			{
				this.textField_1 = new JTextField();
				constructionOptionsPanel.add(this.textField_1, "4, 24");
				this.textField_1.setColumns(10);
			}
			{
				JLabel lblMinAge = new JLabel("Min Age:");
				constructionOptionsPanel.add(lblMinAge, "2, 26, right, default");
			}
			{
				JSpinner spinner = new JSpinner();
				constructionOptionsPanel.add(spinner, "4, 26");
				spinner.setModel(new SpinnerNumberModel(new Integer(0), new Integer(0), null, new Integer(1)));
			}
			{
				JLabel lblMaxAge = new JLabel("Max Age:");
				constructionOptionsPanel.add(lblMaxAge, "2, 28, right, default");
			}
			{
				this.spnnrMaxAge = new JSpinner();
				constructionOptionsPanel.add(this.spnnrMaxAge, "4, 28");
				this.spnnrMaxAge.setModel(new SpinnerNumberModel(new Integer(0), new Integer(0), null, new Integer(1)));
			}
			{
				JLabel lblExpansionMode = new JLabel("Expansion Mode:");
				constructionOptionsPanel.add(lblExpansionMode, "2, 30, right, default");
			}
			{
				JComboBox comboBox = new JComboBox();
				constructionOptionsPanel.add(comboBox, "4, 30");
			}
			{
				JLabel lblFiliationType = new JLabel("Filiation Type:");
				constructionOptionsPanel.add(lblFiliationType, "2, 32, right, default");
			}
			{
				JComboBox comboBox = new JComboBox();
				constructionOptionsPanel.add(comboBox, "4, 32");
			}
		}
		{
			JPanel column2Panel = new JPanel();
			this.contentPanel.add(column2Panel, "3, 4, fill, fill");
			column2Panel.setLayout(new FormLayout(new ColumnSpec[] { FormFactory.DEFAULT_COLSPEC, }, new RowSpec[] { FormFactory.DEFAULT_ROWSPEC,
					FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC,
					FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode("default:grow"), }));
			{
				JPanel repotOptionsPanel = new JPanel();
				column2Panel.add(repotOptionsPanel, "1, 1");
				repotOptionsPanel.setBorder(new TitledBorder(new TitledBorder(new LineBorder(new Color(184, 207, 229)), "", TitledBorder.LEADING,
						TitledBorder.TOP, null, new Color(51, 51, 51)), "Report Options", TitledBorder.LEADING, TitledBorder.TOP, null, new Color(51, 51, 51)));
				repotOptionsPanel.setLayout(new FormLayout(new ColumnSpec[] { FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC,
						FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode("default:grow"), }, new RowSpec[] { FormFactory.RELATED_GAP_ROWSPEC,
						RowSpec.decode("default:grow"), FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode("default:grow"), }));
				{
					JLabel lblSequenceReportType = new JLabel("<html><div style=\"text-align: right;\">Sequence<br/>Report Type:</div></html>");
					repotOptionsPanel.add(lblSequenceReportType, "2, 2, right, top");
				}
				{
					JPanel panel_1 = new JPanel();
					repotOptionsPanel.add(panel_1, "4, 2, fill, fill");
					panel_1.setLayout(new BoxLayout(panel_1, BoxLayout.Y_AXIS));
					{
						JCheckBox chckbxItinerariessurvey = new JCheckBox("Itineraries (Survey)");
						panel_1.add(chckbxItinerariessurvey);
					}
					{
						JCheckBox chckbxItinerariesdetails = new JCheckBox("Itineraries (Details)");
						panel_1.add(chckbxItinerariesdetails);
					}
					{
						JCheckBox chckbxBiographies = new JCheckBox("Biographies");
						panel_1.add(chckbxBiographies);
					}
					{
						JCheckBox chckbxExtendedBiographies = new JCheckBox("Extended Biographies");
						panel_1.add(chckbxExtendedBiographies);
					}
					{
						JCheckBox chckbxActoreventTables = new JCheckBox("Actor-Event Tables");
						panel_1.add(chckbxActoreventTables);
					}
					{
						JCheckBox chckbxInteractionTables = new JCheckBox("Interaction Tables");
						panel_1.add(chckbxInteractionTables);
					}
				}
				{
					JLabel lblSliceReportType = new JLabel("<html><div style=\"text-align: right\">Slice<br/>Report Type:</div></html>");
					repotOptionsPanel.add(lblSliceReportType, "2, 4, right, top");
				}
				{
					JPanel panel_1 = new JPanel();
					repotOptionsPanel.add(panel_1, "4, 4, fill, fill");
					panel_1.setLayout(new BoxLayout(panel_1, BoxLayout.Y_AXIS));
					{
						JCheckBox chckbxMembership = new JCheckBox("Membership");
						panel_1.add(chckbxMembership);
					}
				}
			}
			{
				JPanel SequenceCensusTypePanel = new JPanel();
				column2Panel.add(SequenceCensusTypePanel, "1, 3");
				SequenceCensusTypePanel.setBorder(new TitledBorder(new LineBorder(new Color(184, 207, 229)), "Sequence Census Options", TitledBorder.LEADING,
						TitledBorder.TOP, null, new Color(51, 51, 51)));
				SequenceCensusTypePanel.setLayout(new FormLayout(new ColumnSpec[] { FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC,
						FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode("default:grow"), }, new RowSpec[] { FormFactory.RELATED_GAP_ROWSPEC,
						FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, }));
				{
					JLabel lblCensusType = new JLabel("<html><div style=\"text-align: right;\">Sequence<br/>Census Type:</div></html>");
					SequenceCensusTypePanel.add(lblCensusType, "2, 2, right, top");
				}
				{
					JPanel panel_1 = new JPanel();
					SequenceCensusTypePanel.add(panel_1, "4, 2, fill, fill");
					panel_1.setLayout(new BoxLayout(panel_1, BoxLayout.Y_AXIS));
					{
						JCheckBox chckbxGeneral = new JCheckBox("General");
						panel_1.add(chckbxGeneral);
					}
					{
						JCheckBox chckbxEgonetworks = new JCheckBox("EgoNetworks");
						panel_1.add(chckbxEgonetworks);
					}
					{
						JCheckBox chckbxParcours = new JCheckBox("Parcours");
						panel_1.add(chckbxParcours);
					}
					{
						JCheckBox chckbxParcoursNetworks = new JCheckBox("Parcours Networks");
						panel_1.add(chckbxParcoursNetworks);
					}
				}
			}
			{
				JPanel partitionCriteriaPanel = new JPanel();
				column2Panel.add(partitionCriteriaPanel, "1, 5");
				partitionCriteriaPanel.setBorder(new TitledBorder(new TitledBorder(new LineBorder(new Color(184, 207, 229)), "", TitledBorder.LEADING,
						TitledBorder.TOP, null, new Color(51, 51, 51)), "Partition Criteria", TitledBorder.LEADING, TitledBorder.TOP, null, new Color(51, 51,
						51)));
				partitionCriteriaPanel.setLayout(new FormLayout(new ColumnSpec[] { FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC,
						FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode("default:grow"), }, new RowSpec[] { FormFactory.RELATED_GAP_ROWSPEC,
						FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode("default:grow"), }));
				{
					JLabel lblIndividualClassificationType = new JLabel(
							"<html><div style=\"text-align: right;\">Individual<br/>Classification Type:</div></html>");
					partitionCriteriaPanel.add(lblIndividualClassificationType, "2, 2, right, default");
				}
				{
					JComboBox comboBox = new JComboBox();
					partitionCriteriaPanel.add(comboBox, "4, 2, fill, default");
				}
				{
					JLabel lblRelationClassificationType = new JLabel("<html><div style=\"text-align: right;\">Relation<br/>Classification Type:</div<</html>");
					partitionCriteriaPanel.add(lblRelationClassificationType, "2, 4, right, top");
				}
				{
					JPanel panel_1 = new JPanel();
					partitionCriteriaPanel.add(panel_1, "4, 4, fill, fill");
					panel_1.setLayout(new BoxLayout(panel_1, BoxLayout.Y_AXIS));
					{
						JCheckBox chckbxEvents = new JCheckBox("Events");
						panel_1.add(chckbxEvents);
					}
					{
						JCheckBox chckbxAge = new JCheckBox("Age");
						panel_1.add(chckbxAge);
					}
					{
						JCheckBox chckbxRelations = new JCheckBox("Relations");
						panel_1.add(chckbxRelations);
					}
				}
			}
			{
				JPanel generalStatisticsPanel = new JPanel();
				column2Panel.add(generalStatisticsPanel, "1, 7");
				generalStatisticsPanel.setBorder(new TitledBorder(new TitledBorder(new LineBorder(new Color(184, 207, 229)), "", TitledBorder.LEADING,
						TitledBorder.TOP, null, new Color(51, 51, 51)), "General Statistics", TitledBorder.LEADING, TitledBorder.TOP, null, new Color(51, 51,
						51)));
				generalStatisticsPanel.setLayout(new FormLayout(new ColumnSpec[] { FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC,
						FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode("default:grow"), }, new RowSpec[] { FormFactory.RELATED_GAP_ROWSPEC,
						RowSpec.decode("default:grow"), }));
				{
					JLabel lblCensusOperationLabels = new JLabel("Census Operation:");
					generalStatisticsPanel.add(lblCensusOperationLabels, "2, 2, default, top");
				}
				{
					JPanel panel_1 = new JPanel();
					generalStatisticsPanel.add(panel_1, "4, 2, fill, fill");
					panel_1.setLayout(new BoxLayout(panel_1, BoxLayout.Y_AXIS));
					{
						JCheckBox chckbxEvents_1 = new JCheckBox("Events");
						panel_1.add(chckbxEvents_1);
					}
					{
						JCheckBox checkBox = new JCheckBox("Age");
						panel_1.add(checkBox);
					}
					{
						JCheckBox checkBox = new JCheckBox("Relations");
						panel_1.add(checkBox);
					}
				}
			}
		}
		{
			JPanel column3Panel = new JPanel();
			this.contentPanel.add(column3Panel, "5, 4, fill, fill");
			column3Panel.setLayout(new FormLayout(new ColumnSpec[] { ColumnSpec.decode("default:grow"), }, new RowSpec[] { FormFactory.DEFAULT_ROWSPEC,
					FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode("default:grow"), FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode("default:grow"),
					FormFactory.RELATED_GAP_ROWSPEC, }));
			{
				JPanel egoNetworkdStatisticsPanel = new JPanel();
				column3Panel.add(egoNetworkdStatisticsPanel, "1, 1");
				egoNetworkdStatisticsPanel.setBorder(new TitledBorder(new TitledBorder(new LineBorder(new Color(184, 207, 229)), "", TitledBorder.LEADING,
						TitledBorder.TOP, null, new Color(51, 51, 51)), "Ego Networks", TitledBorder.LEADING, TitledBorder.TOP, null, new Color(51, 51, 51)));
				egoNetworkdStatisticsPanel.setLayout(new FormLayout(new ColumnSpec[] { FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC,
						FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode("default:grow"), FormFactory.RELATED_GAP_COLSPEC, }, new RowSpec[] {
						FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode("default:grow"), FormFactory.RELATED_GAP_ROWSPEC, }));
				{
					JLabel lblCensusOperationLabels_1 = new JLabel("Census Operation:");
					egoNetworkdStatisticsPanel.add(lblCensusOperationLabels_1, "2, 2, right, top");
				}
				{
					JPanel panel_1 = new JPanel();
					egoNetworkdStatisticsPanel.add(panel_1, "4, 2, fill, fill");
					panel_1.setLayout(new BoxLayout(panel_1, BoxLayout.Y_AXIS));
					{
						JCheckBox chckbxGeneral_1 = new JCheckBox("General");
						panel_1.add(chckbxGeneral_1);
					}
					{
						JCheckBox chckbxCentrality = new JCheckBox("Centrality");
						panel_1.add(chckbxCentrality);
					}
					{
						JCheckBox chckbxCohesion = new JCheckBox("Cohesion");
						panel_1.add(chckbxCohesion);
					}
					{
						JCheckBox chckbxNewCheckBox = new JCheckBox("Relations");
						panel_1.add(chckbxNewCheckBox);
					}
					{
						JCheckBox chckbxNewCheckBox_1 = new JCheckBox("Export Ego Networks");
						panel_1.add(chckbxNewCheckBox_1);
					}
				}
			}
			{
				JPanel parcoursNetworkStatisticsPanel = new JPanel();
				parcoursNetworkStatisticsPanel.setBorder(new TitledBorder(new LineBorder(new Color(184, 207, 229)), "Parcours Network Statistics",
						TitledBorder.LEADING, TitledBorder.TOP, null, new Color(51, 51, 51)));
				column3Panel.add(parcoursNetworkStatisticsPanel, "1, 3, fill, fill");
				parcoursNetworkStatisticsPanel.setLayout(new FormLayout(new ColumnSpec[] { FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode("default:grow"),
						FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode("default:grow"), }, new RowSpec[] { FormFactory.RELATED_GAP_ROWSPEC,
						RowSpec.decode("default:grow"), FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode("default:grow"), }));
				{
					JLabel lblMainRelationClassification = new JLabel(
							"<html><div style=\"text-align: right\">Main Relation<br/>Classification Types:</div></html>");
					parcoursNetworkStatisticsPanel.add(lblMainRelationClassification, "2, 2, right, top");
				}
				{
					JPanel panel = new JPanel();
					parcoursNetworkStatisticsPanel.add(panel, "4, 2, fill, fill");
					panel.setLayout(new BoxLayout(panel, BoxLayout.Y_AXIS));
					{
						JCheckBox checkBox = new JCheckBox("xxxx");
						panel.add(checkBox);
					}
				}
				{
					JPanel panel = new JPanel();
					parcoursNetworkStatisticsPanel.add(panel, "2, 4, fill, fill");
					panel.setLayout(new BoxLayout(panel, BoxLayout.Y_AXIS));
					{
						JLabel label = new JLabel("Census Operation:");
						panel.add(label);
					}
					{
						JCheckBox checkBox = new JCheckBox("General");
						panel.add(checkBox);
					}
					{
						JCheckBox checkBox = new JCheckBox("Centrality");
						panel.add(checkBox);
					}
					{
						JCheckBox checkBox = new JCheckBox("Cohesion");
						panel.add(checkBox);
					}
					{
						JCheckBox checkBox = new JCheckBox("Relations");
						panel.add(checkBox);
					}
				}
				{
					JPanel panel = new JPanel();
					parcoursNetworkStatisticsPanel.add(panel, "4, 4, fill, fill");
					panel.setLayout(new BoxLayout(panel, BoxLayout.Y_AXIS));
					{
						JCheckBox chckbxExportParcours = new JCheckBox("Export Parcours");
						panel.add(chckbxExportParcours);
					}
					{
						JCheckBox chckbxExportExtendedParcours = new JCheckBox("Export Extended Parcours");
						panel.add(chckbxExportExtendedParcours);
					}
					{
						JCheckBox chckbxExportMultipleParcours = new JCheckBox("Export Multiple Parcours");
						panel.add(chckbxExportMultipleParcours);
					}
					{
						JCheckBox chckbxExportParcoursNetworks = new JCheckBox("Export Parcours Networks");
						panel.add(chckbxExportParcoursNetworks);
					}
					{
						JCheckBox chckbxExportSimilaryTrees = new JCheckBox("Export Similary Trees");
						panel.add(chckbxExportSimilaryTrees);
					}
				}
			}
			{
				JPanel typeNetworkStatisticsPanel = new JPanel();
				typeNetworkStatisticsPanel.setBorder(new TitledBorder(new TitledBorder(new LineBorder(new Color(184, 207, 229)), "", TitledBorder.LEADING,
						TitledBorder.TOP, null, new Color(51, 51, 51)), "Type Network Statistics", TitledBorder.LEADING, TitledBorder.TOP, null, new Color(51,
						51, 51)));
				column3Panel.add(typeNetworkStatisticsPanel, "1, 5, fill, fill");
				typeNetworkStatisticsPanel.setLayout(new FormLayout(new ColumnSpec[] { FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC,
						FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode("default:grow"), }, new RowSpec[] { FormFactory.RELATED_GAP_ROWSPEC,
						RowSpec.decode("default:grow"), FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode("default:grow"), }));
				{
					JLabel lblMainRelationClassification_1 = new JLabel(
							"<html><div style=\"text-align: right;\">Main Relation<br/>Classification Types:</div></html>");
					typeNetworkStatisticsPanel.add(lblMainRelationClassification_1, "2, 2, right, top");
				}
				{
					JPanel panel_1 = new JPanel();
					typeNetworkStatisticsPanel.add(panel_1, "4, 2, fill, fill");
					panel_1.setLayout(new BoxLayout(panel_1, BoxLayout.Y_AXIS));
					{
						JCheckBox chckbxXxxx_1 = new JCheckBox("xxxx");
						panel_1.add(chckbxXxxx_1);
					}
				}
				{
					JLabel lblCensusOperations = new JLabel("Census Operations:");
					typeNetworkStatisticsPanel.add(lblCensusOperations, "2, 4, right, top");
				}
				{
					JPanel panel = new JPanel();
					typeNetworkStatisticsPanel.add(panel, "4, 4, fill, fill");
					panel.setLayout(new BoxLayout(panel, BoxLayout.Y_AXIS));
					{
						JCheckBox checkBox = new JCheckBox("General");
						panel.add(checkBox);
					}
					{
						JCheckBox chckbxListTrees = new JCheckBox("List Trees");
						panel.add(chckbxListTrees);
					}
					{
						JCheckBox chckbxExportEvenType = new JCheckBox("<html>Export Event<br/>Type Networks</html>");
						panel.add(chckbxExportEvenType);
					}
					{
						JCheckBox chckbxExportSequenceType = new JCheckBox("<html>Export Sequence<br/>Type Networks</html>");
						panel.add(chckbxExportSequenceType);
					}
				}
			}
		}
		{
			JPanel buttonPane = new JPanel();
			buttonPane.setLayout(new FlowLayout(FlowLayout.CENTER));
			getContentPane().add(buttonPane, BorderLayout.SOUTH);
			{
				JButton cancelButton = new JButton("Cancel");
				cancelButton.addActionListener(new ActionListener() {
					@Override
					public void actionPerformed(final ActionEvent e) {
						// Cancel button.
						SpaceTimeAnalysisInputDialog.this.dialogCriteria = null;
						setVisible(false);
					}
				});
				cancelButton.setActionCommand("Cancel");
				buttonPane.add(cancelButton);
			}
			{
				this.okButton = new JButton("Launch");
				this.okButton.addActionListener(new ActionListener() {
					@Override
					public void actionPerformed(final ActionEvent e) {
						//
						SpaceTimeCriteria criteria = getCriteria();

						if (criteria.getRelationModelName() == null) {
							//
							String title = "Invalid input";
							String message = "A relation model is required to launch.";

							//
							JOptionPane.showMessageDialog(null, message, title, JOptionPane.ERROR_MESSAGE);

						} else if (criteria.getEgoRoleName() == null) {
							//
							String title = "Invalid input";
							String message = "An ego role is required to launch.";

							//
							JOptionPane.showMessageDialog(null, message, title, JOptionPane.ERROR_MESSAGE);

						} else if (criteria.getDateLabel() == null) {
							//
							String title = "Invalid input";
							String message = "A valid date label is required to launch.";

							//
							JOptionPane.showMessageDialog(null, message, title, JOptionPane.ERROR_MESSAGE);
						} else {
							//
							lastCriteria = criteria;
							SpaceTimeAnalysisInputDialog.this.dialogCriteria = criteria;

							//
							setVisible(false);
						}
					}
				});
				this.okButton.setActionCommand("OK");
				buttonPane.add(this.okButton);
				getRootPane().setDefaultButton(this.okButton);
			}
		}

		// ////////////////////////
		setCriteria(lastCriteria);
	}

	/**
	 * 
	 * @return
	 */
	public SpaceTimeCriteria getCriteria() {
		SpaceTimeCriteria result;

		result = new SpaceTimeCriteria();

		//
		int currentRelationModelIndex = this.cmbbxRelationModel.getSelectedIndex();
		if (currentRelationModelIndex != -1) {
			//
			result.setRelationModelName(this.relationModels.get(currentRelationModelIndex).getName());
		}

		//
		int currentEgoRoleIndex = this.cmbbxEgoRole.getSelectedIndex();
		if (currentEgoRoleIndex != -1) {
			//
			result.setEgoRoleName(this.relationModels.get(currentRelationModelIndex).roles().get(currentEgoRoleIndex).getName());
		}
		logger.debug("EgoRoleName=" + result.getEgoRoleName());

		//
		// result.getAlterRoleNames().clear();
		// for (Component component : this.alterRolesPanel.getComponents()) {
		// //
		// if (((JCheckBox) component).isSelected()) {
		// //
		// result.getAlterRoleNames().add(((JCheckBox) component).getText());
		// }
		// }

		//
		result.setMaxAge((Integer) this.spnnrMaxAge.getValue());

		//
		int currentDateLabelIndex = this.cmbbxDateLabel.getSelectedIndex();
		if (currentDateLabelIndex != -1) {
			//
			result.setDateLabel(this.attributeDescriptors.findByRelationModelName(this.relationModels.get(currentRelationModelIndex).getName()).sort()
					.getByIndex(currentDateLabelIndex).getLabel());
		}

		logger.debug(result.toString());

		//
		return result;
	}

	/**
	 * 
	 * @return
	 */
	public SpaceTimeCriteria getDialogCriteria() {
		SpaceTimeCriteria result;

		result = this.dialogCriteria;

		//
		return result;
	}

	/**
	 * 
	 * @param source
	 */
	private void setCriteria(final SpaceTimeCriteria source) {
		//
		if (source != null) {
			//
			if (this.relationModels.isEmpty()) {
				//
				this.cmbbxRelationModel.setEnabled(false);
				this.cmbbxEgoRole.setEnabled(false);
				this.cmbbxDateLabel.setEnabled(false);

			} else {
				//
				this.cmbbxRelationModel.setEnabled(true);
				this.cmbbxEgoRole.setEnabled(true);
				this.cmbbxDateLabel.setEnabled(true);

				//
				RelationModel currentRelationModel = this.relationModels.getByName(source.getRelationModelName());
				if (currentRelationModel == null) {
					//
					currentRelationModel = this.relationModels.get(0);
				}

				//
				setRelationModel(this.relationModels.indexOf(currentRelationModel), source.getEgoRoleName(), source.getDateLabel());
			}
		}
	}

	/**
	 * 
	 * @param currentRelationModelIndex
	 */
	private void setRelationModel(final int currentRelationModelIndex, final String egoRoleName, final String dateLabel) {
		//
		RelationModel currentRelationModel = this.relationModels.get(currentRelationModelIndex);

		//
		if (currentRelationModel.roles().isEmpty()) {
			//
			this.cmbbxEgoRole.setEnabled(false);
			this.cmbbxDateLabel.setEnabled(false);

		} else {
			//
			this.cmbbxEgoRole.setModel(new DefaultComboBoxModel(currentRelationModel.roles().nameList().toArray()));

			//
			Role currentEgoRole = currentRelationModel.roles().getByName(egoRoleName);
			if (currentEgoRole == null) {
				//
				currentEgoRole = currentRelationModel.roles().get(0);
			}

			this.cmbbxEgoRole.setSelectedIndex(currentRelationModel.roles().indexOf(currentEgoRole));

			//
			this.alterRolesPanel.removeAll();
			for (Role role : currentRelationModel.roles()) {
				//
				this.alterRolesPanel.add(new JCheckBox(role.getName()));
			}

			//
			StringList currentLabels = this.attributeDescriptors.findByRelationModelName(currentRelationModel.getName()).labels().sort();

			if (currentLabels.isEmpty()) {
				//
				this.cmbbxDateLabel.setEnabled(false);

			} else {
				//
				this.cmbbxDateLabel.setModel(new DefaultComboBoxModel(currentLabels.toArray()));

				//
				int currentDateLabelIndex = currentLabels.indexOf(dateLabel);
				if (currentDateLabelIndex == -1) {
					//
					currentDateLabelIndex = 0;
				}

				this.cmbbxDateLabel.setSelectedIndex(currentDateLabelIndex);
			}
		}

	}

	/**
	 * Launch the application.
	 */
	public static void main(final String[] args) {
		/* SpaceTimeCriteria criteria = */showDialog(null, null, null);
	}

	/**
	 * Launch the application.
	 */
	public static SpaceTimeCriteria showDialog(final Segmentation segmentation, final RelationModels relationModels,
			final AttributeDescriptors attributeDescriptors) {
		SpaceTimeCriteria result;

		//
		SpaceTimeAnalysisInputDialog dialog = new SpaceTimeAnalysisInputDialog(segmentation, relationModels, attributeDescriptors);
		dialog.setLocationRelativeTo(null);
		dialog.pack();
		dialog.setVisible(true);

		//
		result = dialog.getDialogCriteria();

		//
		return result;
	}
}
