package org.tip.puck.spacetime;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.tip.puck.PuckException;
import org.tip.puck.geo.GeoLevel;
import org.tip.puck.geo.Geography;
import org.tip.puck.geo.Place;
import org.tip.puck.graphs.Graph;
import org.tip.puck.graphs.GraphProfile;
import org.tip.puck.graphs.Node;
import org.tip.puck.io.paj.PAJFile;
import org.tip.puck.matrix.MatrixStatistics.Indicator;
import org.tip.puck.matrix.MatrixStatistics.Mode;
import org.tip.puck.net.Attribute;
import org.tip.puck.net.Gender;
import org.tip.puck.net.Individual;
import org.tip.puck.net.Individuals;
import org.tip.puck.net.Net;
import org.tip.puck.net.relations.Relation;
import org.tip.puck.net.relations.Relations;
import org.tip.puck.net.workers.NetUtils;
import org.tip.puck.partitions.Cluster;
import org.tip.puck.partitions.Partition;
import org.tip.puck.partitions.PartitionCriteria;
import org.tip.puck.partitions.PartitionCriteria.PartitionType;
import org.tip.puck.partitions.PartitionCriteria.SizeFilter;
import org.tip.puck.partitions.PartitionCriteria.ValueFilter;
import org.tip.puck.partitions.PartitionMaker;
import org.tip.puck.report.Report;
import org.tip.puck.report.ReportChart;
import org.tip.puck.report.ReportChart.GraphType;
import org.tip.puck.report.ReportRawData;
import org.tip.puck.report.ReportTable;
import org.tip.puck.segmentation.Segmentation;
import org.tip.puck.spacetime.SpaceTimeCriteria.CensusType;
import org.tip.puck.spacetime.SpaceTimeCriteria.RelationClassificationType;
import org.tip.puck.statistics.StatisticsReporter;
import org.tip.puck.util.Chronometer;
import org.tip.puck.util.MathUtils;
import org.tip.puck.util.NumberedValues;
import org.tip.puck.util.PuckUtils;
import org.tip.puck.util.ToolBox;
import org.tip.puck.util.Value;

import fr.devinsy.util.StringList;

/**
 * 
 * @author Klaus Hamberger
 * 
 */
public class SequenceReporter {

	private static StringList getStories(final Relation event) {
		StringList result;

		result = new StringList();

		for (Attribute attribute : event.attributes()) {
			String story = "";
			if (attribute.getLabel().contains("NOTE")) {
				String[] label = attribute.getLabel().split("_");
				if (label.length > 1 && StringUtils.isNumeric(label[1])) {
					int id = Integer.parseInt(label[1]);
					Individual indi = event.getIndividuals().getById(id);
					story += indi.signature() + ": ";
				}
				story += attribute.getValue();
				result.appendln(story);
			}
		}

		//
		return result;
	}

	/**
	 * 
	 * @param segmentation
	 * @param criteria
	 * @param bundle
	 * @return
	 */
	public static Report reportDiscontinuousItineraries(final Segmentation segmentation, final SpaceTimeCriteria criteria, final ResourceBundle bundle) {
		Report result;

		//
		Chronometer chrono = new Chronometer();

		int errorCount = 0;
		StringList errors = new StringList();

		//
		result = new Report();
		result.setTitle("Discontinuous Itineraries");
		result.setOrigin("Control reporter");
		result.setTarget(segmentation.getLabel());

		for (Sequence itinerary : SequenceMaker.createPersonalSequences(segmentation, criteria).toSortedList()) {
			Sequences partials = SequenceWorker.split(itinerary);
			if (partials.size() > 1) {
				errorCount++;
				errors.appendln(itinerary.getEgo().signature());
				int j = 0;
				for (Sequence partial : partials) {
					if (partial.getEvents().size() != 0 && j > 0) {
						errors.appendln(partial.getFirst() + "\t" + partial.getEvents().get(partial.getFirst()));
					}
					j++;
				}
				errors.appendln();
			}
		}

		//
		errors.add(0, errorCount + " " + Report.translate(bundle, "Discontinuous Itineraries") + "\n");
		result.outputs().append(errors.toString());

		//
		result.setStatus(errorCount);

		//
		result.setTimeSpent(chrono.stop().interval());

		//
		return result;
	}

	/*	public static Report reportEventSpace (Segmentation segmentation) throws PuckException{
			Report result;
			
			//
			Chronometer chrono = new Chronometer();
			
			result = new Report("Parcours");
			result.setOrigin("Sequence reporter");
			
			Report overallReport = new Report("Survey");
			Report diagramReport = new Report("Diagrams");
			Report detailReport = new Report("Details");
			
			

			
			// === Build Pajek data.
			StringList pajekBufferParcours = new StringList();
			StringList pajekBufferExtendedParcours = new StringList();
			StringList pajekBufferMultipleParcours = new StringList();
			
			List<String> labels = new ArrayList<String>();
			labels.add("DATE");
			
			List<String> labels2 = new ArrayList<String>();
	//		labels2.add("DATE");
	//		labels2.add("TYPE");
	//		labels2.add("RELATIONS");
			labels2.add("MOVEMENT");
			labels2.add("ORDER");
			
			SpaceTimeCriteria censusCriteria = new SpaceTimeCriteria();
			
			censusCriteria.getRoleNames().add("HOST");
			censusCriteria.getRoleNames().add("MIG");
			
			censusCriteria.getTypes().add(EventType.HOSTMIG);
			censusCriteria.getTypes().add(EventType.MIGRATIONTYPE);
			censusCriteria.getTypes().add(EventType.PLACE);
			censusCriteria.getTypes().add(EventType.DISTANCE);
			censusCriteria.getTypes().add(EventType.MOVEMENT);
			
			censusCriteria.getRelationModelNames().add("Apprenticeship");
			censusCriteria.getRelationModelNames().add("Housing");
			censusCriteria.getRelationModelNames().add("Employment");
			censusCriteria.getRelationModelNames().add("Friend");
			

			
			Map<String, NumberedValues> valuesMap = new HashMap<String, NumberedValues>();
			
			List<String> censusLabels = new ArrayList<String>();
			censusLabels.add("NREVENTS");
			censusLabels.add("AGEFIRST");
			censusLabels.add("AGEFIRST_MIGRATIONTYPE_NOPARENTS");
			censusLabels.add("AGEFIRST_DISTANCE_CONTINENT");
			censusLabels.add("MAX_DISTANCE");
			censusLabels.add("NRALTERS");
			for (String roleName : censusCriteria.getRoleNames()){
				censusLabels.add("MEANNR_"+roleName);
			}
			censusLabels.add("MEAN_COVERAGE");
			censusLabels.add("MAX_COVERAGE");
			for (String roleName : censusCriteria.getRoleNames()){
				censusLabels.add("RELATIONS_"+roleName);
			}
			censusLabels.add("MAX_ALTERS_COVERAGE");
			censusLabels.add("MAX_ALTERS_BETWEENNESS");
			censusLabels.add("MAX_RELATIONS_COVERAGE");
			censusLabels.add("MAX_RELATIONS_BETWEENNESS");
			for (EventType type : censusCriteria.getTypes()){
				censusLabels.add("PROFILE_"+type);
			}
			
			censusLabels.add("BETWEENNESS");
			censusLabels.add("EGO-BETWEENNESS");
			censusLabels.add("SIZE");
			censusLabels.add("TIES");
			censusLabels.add("DENSITY");
			censusLabels.add("DENSITY_NOLOOPS");
			censusLabels.add("MEANDEGREE");
			censusLabels.add("MEANDEGREE_NOLOOPS");
			censusLabels.add("NRCOMPONENTS");
			censusLabels.add("MAXCOMPONENT");
			censusLabels.add("NRCOMPONENTS_NORM");
			censusLabels.add("MAXCOMPONENT_NORM");
			censusLabels.add("BROKERAGE");
			censusLabels.add("EFFICIENT_SIZE");
			censusLabels.add("EFFICIENCY");
			censusLabels.add("JACQUARD");

			
			for (String label : censusLabels){
				valuesMap.put(label, new NumberedValues());
			}
			
			
			for (Individual ego : segmentation.getCurrentIndividuals().toSortedList()){
				
				Sequence fullBiography = SequenceWorker.getItinerary(ego, censusCriteria.getEgoRoleName());
				Sequence sortedBiography = SequenceWorker.sortAndSplit(fullBiography).getById(1);
				Sequence biography = SequenceWorker.truncate(sortedBiography, censusCriteria.getMinAge(), censusCriteria.getMaxAge());
			
				SequenceCensus census = new SequenceCensus(biography, censusCriteria);
				
	//			biography.setAlterRelations(censusCriteria.getMaxDepth(), censusCriteria.getMaxOrder(), censusCriteria.getRelationModelNames());
	//			SequenceWorker.setEventTypes(biography, censusCriteria);
				
				List<Graph<Relation>> graphs = new ArrayList<Graph<Relation>>();
				
				if (biography.getNrEvents()>1){
					
					Graph<Relation> egoGraph = biography.getParcoursGraph();
					pajekBufferParcours.addAll(PuckUtils.writePajekNetwork(egoGraph,labels));
					pajekBufferParcours.appendln();
					graphs.add(egoGraph);
					
					Graph<Relation> extendedGraph = census.getExtendedParcoursGraph();
					pajekBufferExtendedParcours.addAll(PuckUtils.writePajekNetwork(extendedGraph,labels2,null));
					pajekBufferExtendedParcours.appendln();
					
					for (String label : censusLabels){
						valuesMap.get(label).addValue(ego.getId(), census.getValue(label));
					}
					
					for (Individual alter : biography.alters()){
						Sequence alterBiography = SequenceWorker.getItinerary(alter, censusCriteria.getEgoRoleName());
						if (alterBiography.getNrEvents()>0){
							Graph<Relation> alterGraph = alterBiography.getParcoursGraph();
							graphs.add(alterGraph);
						}
					}
					
					Graph<Relation> fusedGraph = GraphUtils.fuse(graphs);
					fusedGraph.setLabel("Event space "+ego);
					pajekBufferMultipleParcours.addAll(PuckUtils.writePajekNetwork(fusedGraph,labels,null));
					pajekBufferMultipleParcours.appendln();
				}
			}
			
			if (pajekBufferParcours.length() != 0) {
				File targetFile = ToolBox.setExtension(ToolBox.addToName(new File(segmentation.getLabel()), "-Parcours"), ".paj");
				ReportRawData rawData = new ReportRawData("Export Parcours Networks to Pajek", "Pajek", "paj", targetFile);
				rawData.setData(PAJFile.convertToMicrosoftEndOfLine(pajekBufferParcours.toString()));

				result.outputs().appendln();
				result.outputs().append(rawData);
			}
			
			if (pajekBufferMultipleParcours.length() != 0) {
				File targetFile = ToolBox.setExtension(ToolBox.addToName(new File(segmentation.getLabel()), "-Multiparcours"), ".paj");
				ReportRawData rawData = new ReportRawData("Export Multiple Parcours Networks to Pajek", "Pajek", "paj", targetFile);
				rawData.setData(PAJFile.convertToMicrosoftEndOfLine(pajekBufferMultipleParcours.toString()));

				result.outputs().appendln();
				result.outputs().append(rawData);
			}
			
			if (pajekBufferExtendedParcours.length() != 0) {
				File targetFile = ToolBox.setExtension(ToolBox.addToName(new File(segmentation.getLabel()), "-Event Spaces"), ".paj");
				ReportRawData rawData = new ReportRawData("Export Ego Space Networks to Pajek", "Pajek", "paj", targetFile);
				rawData.setData(PAJFile.convertToMicrosoftEndOfLine(pajekBufferExtendedParcours.toString()));

				result.outputs().appendln();
				result.outputs().append(rawData);
			}
			
			// Create Partition charts and tables
			List<ReportChart> charts = new ArrayList<ReportChart>();
			List<ReportTable> tables = new ArrayList<ReportTable>();
			
			overallReport.outputs().appendln("Measure\tAverage\tMaximum");

			for (String label : censusLabels){
				
				PartitionCriteria partitionCriteria = new PartitionCriteria(label);
				
				if (label.contains("PROFILE")){
					partitionCriteria.setType(PartitionType.PARTIALIZATION);
				} else if (label.contains("AGEFIRST")){
					partitionCriteria.setType(PartitionType.SIZED_GROUPING);
					partitionCriteria.setStart(0.);
					partitionCriteria.setSize(5.);
				} else {
					partitionCriteria.setType(PartitionType.RAW);
				}
				
				NumberedValues values = valuesMap.get(label);
				
				Partition<Individual> partition = PartitionMaker.create(label, segmentation.getCurrentIndividuals(), values, partitionCriteria);
			
				PartitionCriteria splitCriteria = new PartitionCriteria("GENDER");
				ReportChart chart = StatisticsReporter.createPartitionChart(partition, partitionCriteria, splitCriteria);
			
				if (chart != null) {
					charts.add(chart);
					tables.add(ReportTable.transpose(chart.createReportTableWithSum()));
				}
				
				overallReport.outputs().appendln(label+"\t"+MathUtils.round(values.average(),2)+"\t"+values.max());
			}
					
			// Manage the number of chart by line.
			for (int chartIndex = 0; chartIndex < charts.size(); chartIndex++) {
				diagramReport.outputs().append(charts.get(chartIndex));
				if (chartIndex % 4 == 3) {
					diagramReport.outputs().appendln();
				}
			}
			
			// Add chart tables.
			for (ReportTable table : tables) {
				diagramReport.outputs().appendln(table.getTitle());
				diagramReport.outputs().appendln(table);
			}
			
			// Report individual values
			detailReport.outputs().append("Ego");
			for (String partitionLabel : censusLabels){
				detailReport.outputs().append("\t"+partitionLabel);
			}
			detailReport.outputs().appendln();
			for (Individual ego : segmentation.getCurrentIndividuals().toSortedList()){
				if (valuesMap.get("NREVENTS").get(ego.getId())!=null){
					detailReport.outputs().append(ego);
					for (String label : censusLabels){
						detailReport.outputs().append("\t"+valuesMap.get(label).get(ego.getId()));
					}
					detailReport.outputs().appendln();
				}
			}
			
			result.outputs().append(overallReport);
			result.outputs().append(diagramReport);
			result.outputs().append(detailReport);

			//
			result.setTimeSpent(chrono.stop().interval());

			//
			return result;

			
		}*/

	/**
	 * 
	 * @param segmentation
	 * @param criteria
	 * @param bundle
	 * @return
	 */
	public static Report reportMissingTestimonies(final Segmentation segmentation, final MissingTestimoniesCriteria criteria, final ResourceBundle bundle) {
		Report result;

		//
		Chronometer chrono = new Chronometer();

		int errorCount = 0;
		StringList errors = new StringList();

		//
		result = new Report();
		result.setTitle("Missing Testimonies");
		result.setOrigin("Control reporter");
		result.setTarget(segmentation.getLabel());

		for (Relation event : segmentation.getCurrentRelations().getByModelName(criteria.getRelationModelName())) {
			for (Individual witness : event.getIndividuals(criteria.getEgoRoleName())) {
				if (segmentation.getCurrentIndividuals().contains(witness)) {
					boolean missing = true;
					for (Attribute attribute : event.attributes()) {
						if (attribute.getLabel().contains("NOTE") && attribute.getLabel().indexOf("_") > -1) {
							String id = attribute.getLabel().substring(attribute.getLabel().indexOf("_") + 1);
							if (NumberUtils.isNumber(id) && Integer.parseInt(id) == witness.getId()) {
								missing = false;
								break;
							}
						}
					}
					if (missing) {
						errorCount++;
						errors.appendln(witness.signature() + "\t" + event.getTypedId() + "\t" + event.getName());
					}
				}
			}
		}

		//
		errors.add(0, errorCount + " " + Report.translate(bundle, "Missing Testimonies") + "\n");
		result.outputs().append(errors.toString());

		//
		result.setStatus(errorCount);

		//
		result.setTimeSpent(chrono.stop().interval());

		//
		return result;
	}

	/*	public static Report reportEventNetworks (Segmentation segmentation, String eventType) throws PuckException{
			Report result;
			
			//
			Chronometer chrono = new Chronometer();
			
			//
			result = new Report("Events "+eventType);
			result.setOrigin("Sequence reporter");

			Report overallReport = new Report("Survey");
			Report diagramReport = new Report("Diagrams");
			Report treeReport = new Report("Trees");
			Report detailReport = new Report ("Details");
			StringList morph = new StringList();
			
	//		Partition<Individual> patterns = new Partition<Individual>();
			
			SpaceTimeCriteria censusCriteria = new SpaceTimeCriteria();
			censusCriteria.setType(EventType.valueOf(eventType));

			PartitionCriteria criteria = new PartitionCriteria(censusCriteria.getPartitionLabel());
			
			censusCriteria.getRelationModelNames().add("Apprenticeship");
			censusCriteria.getRelationModelNames().add("Housing");
			censusCriteria.getRelationModelNames().add("Employment");

			// === Build Pajek data.
			StringList pajekBufferEventTypeNetwork = new StringList();
			
			// Create Event Graph
			
			Partition<Individual> individualPartition = PartitionMaker.create("Sequences", segmentation.getCurrentIndividuals(), criteria);

			Map<Value,Sequences> sortedBiographiesByValue = new HashMap<Value,Sequences>();
			Map<Value,Partition<String>> eventPartitionByValue = new HashMap<Value,Partition<String>>();
			Map<Value,Partition<String>> subsequencePartitionByValue = new HashMap<Value,Partition<String>>();
			Map<Value,Partition<String>> sequencePartitionByValue = new HashMap<Value,Partition<String>>();
			Map<Value,Graph<Cluster<String>>> eventTypeNetworksByValue = new HashMap<Value,Graph<Cluster<String>>>();
			Map<Value,Graph<Cluster<String>>> sequenceTypeNetworksByValue = new HashMap<Value,Graph<Cluster<String>>>();
			
			Sequences sortedBiographies = new Sequences();
			for (Value value : individualPartition.getValues()){
				sortedBiographiesByValue.put(value, new Sequences());
			}
			
			// Get event networks
			for (Individual ego : segmentation.getCurrentIndividuals().toSortedList()){
		
				Sequence biography = SequenceWorker.getItinerary(ego, censusCriteria.getEgoRoleName());
				SequenceWorker.setEventTypes(biography, censusCriteria);
				
	//			biography.setAlters(egoRoleName);
	//			biography.setAlterRelations(maxDepth, maxOrder, relationModelNames);

				Sequences subBiographies = SequenceWorker.sortAndSplit(biography);
				Sequences sortedBiographiesByCluster = sortedBiographiesByValue.get(individualPartition.getValue(ego));
				
				for (Sequence subBiography : subBiographies){

					sortedBiographies.addRenumbered(subBiography);
					sortedBiographiesByCluster.addRenumbered(subBiography);
					
					morph.appendln(ego.signature()+"\t"+subBiography.getNrEvents()+" events"+"\t"+subBiography.getNrEventTypes()+" eventTypes");
					morph.appendln("\tItinerary: "+subBiography.getEventTypePattern());
					morph.appendln("\tStations: "+subBiography.getEventTypesAsString());
					morph.appendln();
					
					SequenceCensus census = new SequenceCensus(subBiography,level);
					patterns.put(ego, new Value(census.pattern()));
					
					morph.appendln(ego.signature()+"\t"+census.getLength()+"\t"+census.getPlaces().size());
					morph.appendln("Pattern: "+census.pattern());
					morph.appendln("Itinerary: "+census.getStations().toString());
					morph.appendln("Places: "+census.getPlaces().toString());
					morph.appendln();

				}
			}
			
			PartitionCriteria morphCriteria = new PartitionCriteria("_");
			morphCriteria.setType(PartitionType.RAW);
			ReportChart morphChart = StatisticsReporter.createPartitionChart(patterns, morphCriteria, new PartitionCriteria("GENDER"));
			morphologyReport.outputs().appendln(morphChart);
			morphologyReport.outputs().appendln(ReportTable.transpose(morphChart.createReportTableWithSum()));
			detailReport.outputs().appendln(morph);
			detailReport.outputs().appendln();

			Partition<String> eventPartition = SequenceWorker.getEventPartition(sortedBiographies);
			Partition<String> subsequencePartition = SequenceWorker.getSubsequencePartition(sortedBiographies);
			Graph<Cluster<String>> eventTypeNetwork = SequenceWorker.getSequenceNetwork(sortedBiographies, eventPartition);
			Graph<Cluster<String>> sequenceTypeNetwork = SequenceWorker.getSequenceNetwork(sortedBiographies, subsequencePartition);
			Partition<String> sequencePartition = SequenceWorker.getSequencePartition(sortedBiographies);

			pajekBufferEventTypeNetwork.addAll(PuckUtils.writePajekNetwork(sequenceTypeNetwork, ClusterNetworkReporter.ALLIANCE_NETWORK_PARTITION_LABELS));
			pajekBufferEventTypeNetwork.addAll(PuckUtils.writePajekNetwork(eventTypeNetwork, ClusterNetworkReporter.ALLIANCE_NETWORK_PARTITION_LABELS));

			for (Value value : individualPartition.getValues()){
				eventPartitionByValue.put(value, SequenceWorker.getEventPartition(sortedBiographiesByValue.get(value)));
				subsequencePartitionByValue.put(value, SequenceWorker.getSubsequencePartition(sortedBiographiesByValue.get(value)));
				sequencePartitionByValue.put(value, SequenceWorker.getSequencePartition(sortedBiographiesByValue.get(value)));
			
				eventTypeNetworksByValue.put(value, SequenceWorker.getSequenceNetwork(sortedBiographiesByValue.get(value),eventPartitionByValue.get(value)));
				sequenceTypeNetworksByValue.put(value, SequenceWorker.getSequenceNetwork(sortedBiographiesByValue.get(value),subsequencePartitionByValue.get(value)));
				
				pajekBufferEventTypeNetwork.addAll(PuckUtils.writePajekNetwork(eventTypeNetworksByValue.get(value), ClusterNetworkReporter.ALLIANCE_NETWORK_PARTITION_LABELS,null));
				pajekBufferEventTypeNetwork.addAll(PuckUtils.writePajekNetwork(sequenceTypeNetworksByValue.get(value), ClusterNetworkReporter.ALLIANCE_NETWORK_PARTITION_LABELS,null));

			}

			// Create diagrams
			
			List<ReportChart> charts = new ArrayList<ReportChart>();
	//		List<ReportTable> tables = new ArrayList<ReportTable>();

			// Sequence analysis
			
			reportSequencePartition(overallReport,"",eventPartition,sequencePartition,sortedBiographies.size(),sortedBiographies.getNrEvents());
			reportSequenceTree(treeReport,"",sequenceTypeNetwork);
			
			charts.add(StatisticsReporter.createPartitionChartBySize(eventPartition,censusCriteria.getThreshold()));
			charts.add(StatisticsReporter.createPartitionChartBySize(sequencePartition,censusCriteria.getThreshold()));
			
			for (Value value : individualPartition.getValues()){
				
				reportSequencePartition(overallReport,value.toString(),eventPartitionByValue.get(value),sequencePartitionByValue.get(value),sortedBiographiesByValue.get(value).size(),sortedBiographiesByValue.get(value).getNrEvents());
				reportSequenceTree(treeReport,value.toString(),sequenceTypeNetworksByValue.get(value));
				
				charts.add(StatisticsReporter.createPartitionChartBySize(eventPartitionByValue.get(value),censusCriteria.getThreshold()));
				charts.add(StatisticsReporter.createPartitionChartBySize(sequencePartitionByValue.get(value),censusCriteria.getThreshold()));
			}
			
			
			Partition<Relation> types = new Partition<Relation>("TYPES");
			PartitionCriteria typeCriteria = new PartitionCriteria("TYPE");
			typeCriteria.setValueFilter(ValueFilter.NULL);
			PartitionCriteria splitCriteria1 = new PartitionCriteria("DISTANCE");
			splitCriteria1.setValueFilter(ValueFilter.NULL);

			ReportChart typeChart = StatisticsReporter.createPartitionChart(types, typeCriteria, splitCriteria1);
			charts.add(typeChart);
			tables.add(ReportTable.transpose(typeChart.createReportTableWithSum()));
			
			// Manage the number of chart by line.
			for (int chartIndex = 0; chartIndex < charts.size(); chartIndex++) {
				diagramReport.outputs().append(charts.get(chartIndex));
				if (chartIndex % 4 == 3) {
					diagramReport.outputs().appendln();
				}
			}


			// Create Pajek Event Network
			if (pajekBufferEventTypeNetwork.length() != 0) {
				File targetFile = ToolBox.setExtension(ToolBox.addToName(new File(segmentation.getLabel()), "-Ego Networks"), ".paj");
				ReportRawData rawData = new ReportRawData("Export Event Networks to Pajek", "Pajek", "paj", targetFile);
				rawData.setData(PAJFile.convertToMicrosoftEndOfLine(pajekBufferEventTypeNetwork.toString()));

				result.outputs().appendln();
				result.outputs().append(rawData);
			}
			
			result.outputs().append(overallReport);
			result.outputs().append(diagramReport);
			result.outputs().append(treeReport);
			result.outputs().append(detailReport);

			//
			result.setTimeSpent(chrono.stop().interval());

			//
			return result;
		}*/

	/*	private static void reportSequencePartition(Report report, String value, Partition<String> eventPartition, Partition<String> eventPairPartition, int nrTotalSequences, int nrTotalEvents){
			
			report.outputs().appendln("Events "+value);
			report.outputs().appendln("Type\tnrEvents\t%\tnrItineraries\t%\tEvents/Itinerary");
			for (Cluster<String> cluster : eventPartition.getClusters().toListSortedByDescendingSize()){
				int nrEvents = cluster.size();
				int nrSequences = sequenceNumber(cluster);
				report.outputs().appendln(cluster.getValue()+"\t"+nrEvents+"\t"+MathUtils.percent(nrEvents, nrTotalEvents)+"\t"+nrSequences+"\t"+MathUtils.percent(nrSequences, nrTotalSequences)+"\t"+MathUtils.percent(nrEvents, 100*nrSequences));
			}
			report.outputs().appendln();

			report.outputs().appendln("Sequences "+value);
			report.outputs().appendln("Type\tnrEvents\t%\tnrItineraries\t%\tEvents/Itinerary\tConfidence\tLift");
			for (Cluster<String> cluster : eventPairPartition.getClusters().toListSortedByDescendingSize()){
				int nrEvents = cluster.size();
				int nrSequences = sequenceNumber(cluster);
				String[] values = cluster.getValue().stringArrayValue();
				Cluster<String> previous = eventPartition.getCluster(Value.valueOf(values[0]));
				Cluster<String> next = eventPartition.getCluster(Value.valueOf(values[1]));
				double confidence = MathUtils.percent(nrEvents, previous.size());
				double lift = MathUtils.round(confidence/MathUtils.percent(next.size(), nrTotalEvents),2);
						
				report.outputs().appendln(values[0]+" - "+values[1]+"\t"+nrEvents+"\t"+MathUtils.percent(nrEvents, nrTotalEvents)+"\t"+nrSequences+"\t"+MathUtils.percent(nrSequences, nrTotalSequences)+"\t"+MathUtils.percent(nrEvents, 100*nrSequences)+"\t"+confidence+"\t"+lift);
			}
			report.outputs().appendln();
		}*/

	/**
	 * 
	 * @param segmentation
	 * @param censusType
	 * @return
	 * @throws PuckException
	 */
	public static Report reportSequenceCensus(final Segmentation segmentation, final CensusType censusType) throws PuckException {
		Report result;

		//
		Chronometer chrono = new Chronometer();

		result = new Report(censusType.toString());
		result.setOrigin("Sequence reporter");

		// Create Reports
		Report overallReport = new Report("Survey");
		Report diagramReport = new Report("Diagrams");
		Report detailReport = new Report("Details");
		Report componentReport = new Report("Components");
		Report treeReport = new Report("Trees");

		// Create Partition charts and tables
		List<ReportChart> charts = new ArrayList<ReportChart>();
		List<ReportTable> tables = new ArrayList<ReportTable>();

		// Set census criteria
		SpaceTimeCriteria censusCriteria = new SpaceTimeCriteria(censusType);

		// Get (coherent) itineraries
		Sequences sequences = new Sequences();
		for (Individual ego : segmentation.getCurrentIndividuals().toSortedList()) {
			sequences.addRenumbered(SequenceWorker.getCoherentItinerarySegment(ego, censusCriteria));
		}

		// Proceed census
		SequencesCensus census = new SequencesCensus(sequences, censusCriteria);

		// Make overall report and diagrams
		overallReport
				.outputs()
				.appendln(
						"Measure\tAverage (Male)\tAverage Pos. (Male)\tMedian (Male)\tMaximum (Male)\tSum (Male)\tAverage (Female)\tAverage Pos. (Female)\tMedian (Female)\tMaximum (Female)\tSum (Female)\tAverage (All)\tAverage Pos. (All)\tMedian (All)\tMaximum (All)\tSum (All)");

		// Set partition criteria
		for (String label : censusCriteria.getCensusOperationLabels()) {

			PartitionCriteria partitionCriteria = new PartitionCriteria(label);
			// partitionCriteria.setValueFilter(ValueFilter.NULL);

			/*			if (label.contains("PROFILE")){
							partitionCriteria.setType(PartitionType.PARTIALIZATION);
						} */

			if (label.equals("NREVENTS")) {
				partitionCriteria.setType(PartitionType.RAW);
				// partitionCriteria.setCumulationType(CumulationType.DESCENDANT);
			} else if (label.contains("AGEFIRST")) {
				partitionCriteria.setType(PartitionType.SIZED_GROUPING);
				partitionCriteria.setStart(0.);
				partitionCriteria.setSize(5.);
			} else if (label.equals("ECCENTRICITY")) {
				partitionCriteria.setType(PartitionType.SIZED_GROUPING);
				partitionCriteria.setStart(-100.);
				partitionCriteria.setSize(20.);
			} else if (label.contains("COVERAGE") || label.contains("SAME") || label.contains("NORM") || label.contains("DENSITY")
					|| label.contains("BETWEENNESS") || label.contains("EFFICIENCY") || label.contains("CONCENTRATION")) {
				partitionCriteria.setType(PartitionType.SIZED_GROUPING);
				partitionCriteria.setStart(0.);
				partitionCriteria.setSize(20.);
			} else if (label.contains("MEAN") || label.contains("COVERAGE") || label.contains("PEREVENT") || label.contains("BETWEENNESS")
					|| label.contains("BROKERAGE") || label.contains("EFFICIENT_SIZE")) {
				partitionCriteria.setType(PartitionType.SIZED_GROUPING);
				partitionCriteria.setStart(0.);
				partitionCriteria.setSize(1.);
			} else {
				partitionCriteria.setType(PartitionType.RAW);
			}

			ReportChart chart = null;

			if (label.contains("SIMILARITY")) {
				RelationClassificationType relationClassificationType = RelationClassificationType.valueOf(label.substring(label.lastIndexOf("_") + 1));
				Map<Value, Double[]> similaritiesMap = census.getSimilaritiesMap(relationClassificationType);
				chart = StatisticsReporter.createMapChart(similaritiesMap, label, new String[] { "HH", "FH", "HF", "FF", "All" }, GraphType.LINES);

				for (Value key : similaritiesMap.keySet()) {
					overallReport.outputs().appendln(label + "_" + key + "\t" + MathUtils.percent(similaritiesMap.get(key)[4], 100));
				}

			} else if (!label.contains("ALTERS") && !label.contains("PROFILE")) {
				NumberedValues values = census.getValues(label);

				Partition<Individual> partition = PartitionMaker.create(label, segmentation.getCurrentIndividuals(), values, partitionCriteria);

				PartitionCriteria splitCriteria = new PartitionCriteria(censusCriteria.getPartitionLabel());
				chart = StatisticsReporter.createPartitionChart(partition, partitionCriteria, splitCriteria);

				if (label.substring(0, 3).equals("AGE")) {

					partitionCriteria.setType(PartitionType.RAW);
					partitionCriteria.setSizeFilter(SizeFilter.HOLES);
					partitionCriteria.setValueFilter(ValueFilter.NULL);

					partition = PartitionMaker.create(label, segmentation.getCurrentIndividuals(), values, partitionCriteria);

					if (partition.maxValue() != null) {
						ReportChart survivalChart = StatisticsReporter.createSurvivalChart(partition, splitCriteria);
						charts.add(survivalChart);
					} else {
						System.err.println(label + " no max value");
					}
				}

				NumberedValues[] genderedValues = PuckUtils.getGenderedNumberedValues(values, segmentation.getCurrentIndividuals());

				overallReport.outputs().append(label + "\t");
				for (int gender = 0; gender < 3; gender++) {
					String sum = "";
					if (label.startsWith("NR")) {
						sum = new Double(genderedValues[gender].sum()).intValue() + "";
					}
					overallReport.outputs().append(
							MathUtils.round(genderedValues[gender].average(), 2) + "\t" + MathUtils.round(genderedValues[gender].averagePositives(), 2) + "\t"
									+ values.median() + "\t" + genderedValues[gender].max() + "\t" + sum + "\t");
				}
				overallReport.outputs().appendln();

			}

			if (chart != null) {
				charts.add(chart);
				if (label.equals("SIMILARITY")) {
					tables.add(ReportTable.transpose(chart.createReportTable()));
				} else {
					ReportTable table = ReportTable.transpose(chart.createReportTableWithSum());
					tables.add(table);
					if (!label.contains("EVENTS_") && !label.contains("RELATIONS")) {
						tables.add(ReportTable.normalize(table));
					}
				}

			}

		}
		overallReport.outputs().appendln();

		// Create detailed report
		detailReport.outputs().append("Nr\tEgo\tGender");
		for (String partitionLabel : censusCriteria.getCensusOperationLabels()) {
			if (partitionLabel.contains("SIMILARITY")) {
				RelationClassificationType relationClassificationType = RelationClassificationType.valueOf(partitionLabel.substring(partitionLabel
						.lastIndexOf("_") + 1));
				detailReport.outputs().append(
						"\tSIMILARITY_PARENT_" + relationClassificationType + "\tSIMILARITY_CHILD_" + relationClassificationType + "\tSIMILARITY_SIBLING_"
								+ relationClassificationType + "\tSIMILARITY_SPOUSE_" + relationClassificationType);
			} else {
				detailReport.outputs().append("\t" + partitionLabel);
			}
		}

		Map<String, Map<String, Double>> componentChartMap = new TreeMap<String, Map<String, Double>>();
		/*		String[] types = new String[]{"FATHER","MOTHER","PARENT","SPOUSE","RELATIVE","OTHER","UNKNOWN"};
				for (String type : types){
					Map<String,Double> map = new TreeMap<String,Double>();
					componentChartMap.put(type,map);
					for (Gender gender : Gender.values()){
						map.put(gender.toString(), 0.);
					}
				}*/

		detailReport.outputs().appendln();
		for (Individual ego : segmentation.getCurrentIndividuals().toSortedList()) {

			if ((((censusType == CensusType.GENERAL) || (censusType == CensusType.PARCOURS) || (censusType == CensusType.PARCOURSNETWORKS)) && (census
					.getValues("NREVENTS").get(ego.getId()) != null))
					|| ((censusType == CensusType.EGONETWORKS) && (census.getValues("SIZE").get(ego.getId()) != null))) {
				detailReport.outputs().append(ego.getId() + "\t" + ego + "\t" + ego.getGender());
				for (String label : censusCriteria.getCensusOperationLabels()) {
					if (label.contains("SIMILARITY")) {
						Value value = census.getValues(label).get(ego.getId());
						Map<Value, Double[]> indiSimilaritiesMap = value.mapValue();
						String[] keys = new String[] { "PARENT", "CHILD", "SIBLING", "SPOUSE" };
						for (String key : keys) {
							Double[] sim = indiSimilaritiesMap.get(new Value(key));
							if (sim != null) {
								detailReport.outputs().append("\t" + MathUtils.round(sim[4], 2));
							}
						}
					} else {
						detailReport.outputs().append("\t" + census.getValues(label).get(ego.getId()));
					}
				}
				detailReport.outputs().appendln();
			}

			if ((censusType == CensusType.EGONETWORKS || censusType == CensusType.PARCOURSNETWORKS)) {

				for (String networkTitle : censusCriteria.getNetworkTitles()) {
					Map<Integer, Partition<Node<Individual>>> componentsMap = census.getComponents(networkTitle);
					if (componentsMap != null) {
						Partition<Node<Individual>> components = componentsMap.get(ego.getId());

						componentReport.outputs().appendln("Components " + networkTitle);
						componentReport.outputs().appendln(ego + "\t" + components.size());
						int i = 1;
						for (Cluster<Node<Individual>> cluster : components.getClusters().toListSortedByValue()) {
							componentReport.outputs().appendln(
									"\t" + i + "\t" + cluster.getValue() + "\t(" + cluster.size() + ")\t" + cluster.getItemsAsString());
							i++;
						}
						componentReport.outputs().appendln();

						for (Value value : components.getValues()) {
							String label = value.toString();
							Map<String, Double> map = componentChartMap.get(label);
							if (map == null) {
								map = new TreeMap<String, Double>();
								for (Gender gender : Gender.values()) {
									map.put(gender.toString(), 0.);
								}
								componentChartMap.put(label, map);
							}
							map.put(ego.getGender().toString(), map.get(ego.getGender().toString()) + 1);
						}
					}
				}
			}
		}

		if ((censusType == CensusType.EGONETWORKS || censusType == CensusType.PARCOURSNETWORKS)) {
			ReportChart componentChart = StatisticsReporter.createChart("COMPONENTS", componentChartMap);
			charts.add(componentChart);
			tables.add(ReportTable.transpose(componentChart.createReportTableWithSum()));

			if (census.getRelationConnectionMatrix() != null) {
				for (ReportChart chart : census.getRelationConnectionMatrix().getCharts()) {
					charts.add(chart);
				}
				tables.add(census.getRelationConnectionMatrix().getTable("Component Connections"));
			}

		}

		// SequenceAnalysis

		if (censusType == CensusType.PARCOURS) {

			for (RelationClassificationType relationClassificationType : censusCriteria.getMainRelationClassificationTypes()) {

				if (censusCriteria.getNetworkTitles().contains("Event Type Network")) {

					CorrelationMatrix eventSequenceMatrix = census.getEventSequenceMatrix(relationClassificationType.toString());

					if (eventSequenceMatrix != null) {
						for (ReportChart chart : eventSequenceMatrix.getCharts()) {
							charts.add(chart);
						}
						tables.add(eventSequenceMatrix.getTable("Event Type Sequences"));
					}

					overallReport.outputs().appendln();
					overallReport.outputs().appendln("Sequence Network Statistics " + relationClassificationType);
					overallReport.outputs().appendln("\tDensity\tInertia\t(Divergence)\tConcentration\t(Divergence)\tSymmetry\t(Divergence)\tCentral nodes");

					for (Gender gender : Gender.values()) {
						GraphProfile<Cluster<String>> profile = eventSequenceMatrix.getProfile(gender);

						String centralReferents = "";
						for (Cluster<String> centralReferent : profile.getCentralReferents()) {
							centralReferents += centralReferent.getValue() + " ";
						}
						double maxBetweenness = profile.getMaxBetweenness();
						double density = profile.density();
						double endo = MathUtils.round(profile.getStatistics(Indicator.LOOPS, Mode.NORMALIZED), 2);
						double endoExp = MathUtils.round(profile.getStatistics(Indicator.LOOPS, Mode.DIVERGENCE_NORMALIZED), 2);
						double conc = MathUtils.round(profile.getStatistics(Indicator.CONCENTRATION, Mode.SIMPLE), 2);
						double concExp = MathUtils.round(profile.getStatistics(Indicator.CONCENTRATION, Mode.DIVERGENCE), 2);
						double sym = MathUtils.round(profile.getStatistics(Indicator.SYMMETRY, Mode.SIMPLE), 2);
						double symExp = MathUtils.round(profile.getStatistics(Indicator.SYMMETRY, Mode.DIVERGENCE), 2);

						overallReport.outputs().appendln(
								gender + "\t" + density + "\t" + endo + "\t" + endoExp + "\t" + conc + "\t" + concExp + "\t" + sym + "\t" + symExp + "\t"
										+ centralReferents + "(" + maxBetweenness + ") betweenness centrality");
					}
					overallReport.outputs().appendln();

				}

				if (censusCriteria.getNetworkTitles().contains("Sequence Type Network")) {

					CorrelationMatrix subSequenceMatrix = census.getSubSequenceMatrix(relationClassificationType.toString());

					if (subSequenceMatrix != null) {
						charts.add(subSequenceMatrix.getRamificationChart());
					}
				}

				// reportSequencePartition(overallReport,"",census.getEventPartition(eventTypeName),census.getEventPairPartition(eventTypeName),census.nrSequences(),census.nrEvents());
				// reportSequenceTree(treeReport,"",census.getSequenceTypeNetwork(eventTypeName));

				/*				int maxPositions = census.getNrValues(eventType,eventType.toString());
										
								ReportChart diversityChart = StatisticsReporter.createDiversityChart(census.getDepthPartition(eventType.toString()), maxPositions);
								charts.add(diversityChart);*/
			}
		}

		// Manage the number of chart by line.
		for (int chartIndex = 0; chartIndex < charts.size(); chartIndex++) {
			diagramReport.outputs().append(charts.get(chartIndex));
			if (chartIndex % 4 == 3) {
				diagramReport.outputs().appendln();
			}
		}

		// Add chart tables.
		for (ReportTable table : tables) {
			diagramReport.outputs().appendln(table.getTitle());
			diagramReport.outputs().appendln(table);
		}

		// Finalize reports
		result.outputs().append(overallReport);
		result.outputs().append(diagramReport);
		result.outputs().append(detailReport);

		if (censusType == CensusType.EGONETWORKS || censusType == CensusType.PARCOURSNETWORKS) {
			result.outputs().append(componentReport);
		}
		if (censusType == CensusType.PARCOURS) {
			result.outputs().append(treeReport);
		}

		// addPajekData

		Map<String, StringList> pajekBuffers = census.getPajekBuffers();

		for (String title : pajekBuffers.keySet()) {

			StringList pajekBuffer = pajekBuffers.get(title);
			if (pajekBuffer.length() != 0) {
				File targetFile = ToolBox.setExtension(ToolBox.addToName(new File(segmentation.getLabel()), "-" + title), ".paj");
				ReportRawData rawData = new ReportRawData("Export " + title + "s to Pajek", "Pajek", "paj", targetFile);
				rawData.setData(PAJFile.convertToMicrosoftEndOfLine(pajekBuffer.toString()));

				result.outputs().appendln();
				result.outputs().append(rawData);
			}
		}

		//
		result.setTimeSpent(chrono.stop().interval());

		//
		return result;

	}

	/**
	 * 
	 * @param net
	 * @param segmentation
	 * @param censusCriteria
	 * @return
	 * @throws PuckException
	 */
	public static Report reportSequences(final Net net, final Segmentation segmentation, final SpaceTimeCriteria censusCriteria) throws PuckException {
		Report result;

		String spouseFilterLabel = "INTERV";

		//
		Chronometer chrono = new Chronometer();

		result = new Report("Itineraries");
		result.setOrigin("Sequence reporter");

		//
		Report surveyReport = new Report("Survey");
		Report detailedReport = new Report("Details");
		Report actorEventTableReport = new Report("Actor-Event tables");
		Report interactionTableReport = new Report("Interaction tables");

		Sequences sequences = new Sequences();

		Geography geography = censusCriteria.getGeography();

		// === Build Pajek data.
		StringList pajekBuffer = new StringList();

		Graph<Individual> graph = NetUtils.createRelationGraph(segmentation, censusCriteria.getRelationModelName());
		List<String> partitionLabels = new ArrayList<String>();
		pajekBuffer.addAll(PuckUtils.writePajekNetwork(graph, partitionLabels));
		pajekBuffer.appendln();

		// Create sequences

		for (Individual ego : segmentation.getCurrentIndividuals().toSortedList()) {

			surveyReport.outputs().appendln(ego.signature());
			surveyReport.outputs().appendln();

			detailedReport.outputs().appendln(ego.signature());
			detailedReport.outputs().appendln();

			Sequence sequence = SequenceMaker.createPersonalSequence(ego, censusCriteria);
			sequences.add(sequence);

			// Move to appropriate census!
			for (Individual spouse : ego.spouses()) {
				if (spouse.getAttributeValue(spouseFilterLabel) != null) {
					// surveyReport.outputs().appendln("Common events with spouse ("+spouse+"): "+SequenceWorker.getCommonEvents(ego,spouse,censusCriteria.getRelationModelName()).size());
				}
			}

			// Add role tables

			actorEventTableReport.outputs().append(sequence.roleTable());
			interactionTableReport.outputs().append(sequence.interactionTable());

			// Create coherent subsequences

			Sequences subSequences = SequenceWorker.split(sequence);

			for (Sequence subSequence : subSequences) {

				if (subSequences.size() > 1) {
					surveyReport.outputs().appendln(subSequence.getId());
					detailedReport.outputs().appendln(subSequence.getId());
				}

				for (Ordinal key : subSequence.getEvents().keySet()) {

					Relation event = subSequence.getEvent(key);

					Place start = geography.getByHomonym(event.getAttributeValue("START_PLACE"));
					Place end = geography.getByHomonym(event.getAttributeValue("END_PLACE"));
					Place ancestor = geography.getCommonAncestor(start, end);
					GeoLevel commonLevel = null;
					String commonPlaceName = null;
					if (ancestor != null) {
						commonLevel = ancestor.getLevel();
						commonPlaceName = ancestor.getName();
					}

					String order = SequenceWorker.order(event, ego);

					surveyReport.outputs().appendln(
							key + "\t" + order + "\t(" + subSequence.getAge(key.getYear()) + ")\t" + event.getTypedId() + "\t"
									+ event.getAttributeValue("START_PLACE") + "\t" + event.getAttributeValue("END_PLACE") + "\t" + commonLevel + "\t("
									+ commonPlaceName + ")\t");

					detailedReport.outputs().appendln(
							key + "\t" + order + "\t(" + subSequence.getAge(key.getYear()) + ")\t" + event.getTypedId() + "\t"
									+ event.getAttributeValue("START_PLACE") + "\t" + event.getAttributeValue("END_PLACE") + "\t" + commonLevel + "\t("
									+ commonPlaceName + ")\t");
					detailedReport.outputs().appendln();
					detailedReport.outputs().appendln(getStories(event));

				}

				surveyReport.outputs().appendln();
				detailedReport.outputs().appendln();
				actorEventTableReport.outputs().appendln();
				interactionTableReport.outputs().appendln();

			}

		}

		// Create sequences including life events

		Report biographyReport = new Report("Biographies");

		for (Sequence biography : SequenceMaker.createBiographies(net, segmentation, censusCriteria).toSortedList()) {

			Individual ego = segmentation.getCurrentIndividuals().getById(biography.getId());

			biographyReport.outputs().appendln(ego.signature());
			for (Ordinal key : biography.getEvents().keySet()) {
				Relation event = biography.getEvent(key);
				biographyReport.outputs().appendln(
						key + "\t" + event.getRoles(ego).toString() + " (" + biography.getAge(key.getYear()) + ")\t" + event.getName() + " "
								+ SequenceCensus.getEgoRolePartners(event, censusCriteria));
			}
			biographyReport.outputs().appendln();
		}

		// Create extended biographies

		Report extendedBiographyReport = new Report("Extended biographies");
		for (Sequence extendedBiography : SequenceMaker.createExtendedBiographies(net, segmentation, censusCriteria).toSortedList()) {

			Individual ego = segmentation.getCurrentIndividuals().getById(extendedBiography.getId());

			extendedBiographyReport.outputs().appendln(ego.signature());
			for (Ordinal key : extendedBiography.getEvents().keySet()) {
				Relation event = extendedBiography.getEvent(key);
				extendedBiographyReport.outputs().appendln(
						key + "\t" + event.getRoles(ego).toString() + " (" + extendedBiography.getAge(key.getYear()) + ")\t" + event.getName() + " "
								+ SequenceCensus.getEgoRolePartners(event, censusCriteria));
			}
			extendedBiographyReport.outputs().appendln();
		}

		// Create Pajek File

		if (pajekBuffer.length() != 0) {
			File targetFile = ToolBox.setExtension(ToolBox.addToName(new File(segmentation.getLabel()), "-Relation Network"), ".paj");
			ReportRawData rawData = new ReportRawData("Export Relation Network to Pajek", "Pajek", "paj", targetFile);
			rawData.setData(PAJFile.convertToMicrosoftEndOfLine(pajekBuffer.toString()));

			result.outputs().appendln();
			result.outputs().append(rawData);
		}

		result.outputs().append(surveyReport);
		result.outputs().append(detailedReport);
		result.outputs().append(biographyReport);
		result.outputs().append(extendedBiographyReport);
		result.outputs().append(actorEventTableReport);
		result.outputs().append(interactionTableReport);

		//
		result.setTimeSpent(chrono.stop().interval());

		//
		return result;
	}

	/**
	 * 
	 * @param report
	 * @param value
	 * @param sequenceTypeNetwork
	 */
	private static void reportSequenceTree(final Report report, final String value, final Graph<Cluster<String>> sequenceTypeNetwork) {

		report.outputs().appendln("Sequence Tree " + value);
		Node<Cluster<String>> start = sequenceTypeNetwork.getNode(1);
		Stack<Node<Cluster<String>>> stack = new Stack<Node<Cluster<String>>>();
		report.outputs().appendln(start.getReferent() + "\t" + start.getReferent().size());
		stack.push(start);

		while (!stack.isEmpty()) {
			Node<Cluster<String>> node = stack.pop();
			for (Node<Cluster<String>> next : node.getOutNodes().toListSortedByLabel()) {
				report.outputs().appendln(next.getReferent() + "\t" + next.getReferent().size());
				stack.push(next);
			}
		}
		report.outputs().appendln();

	}

	/*	public static Report reportEgoNetworks (Segmentation segmentation, String alterRoleName) throws PuckException{
			Report result;
			
			//
			Chronometer chrono = new Chronometer();
			
			//
			result = new Report("Ego Networks "+alterRoleName);
			result.setOrigin("Sequence reporter");

			Report overallReport = new Report("Survey");
			Report diagramReport = new Report("Diagrams");
			Report detailReport = new Report("Details");
			Report componentReport = new Report("Components");
			
	//		Sequences biographies = new Sequences();
			
			// === Build Pajek data.
			StringList pajekBuffer = new StringList();
			
			// Create total relation graph
			Graph<Individual> graph = NetUtils.createRelationGraph(segmentation,"Migevent");
			Map<Integer,Integer> nodeIds = GraphUtils.getIds(graph);

			double[] graphBetweenness = GraphUtils.betweenness(graph);
			
			Map<String, NumberedValues> valuesMap = new HashMap<String,NumberedValues>(); 
			Map<Integer, Partition<EventTriangle>> trianglesMap = new HashMap<Integer,Partition<EventTriangle>>(); 
			Partition<EventTriangle> allTriangles = new Partition<EventTriangle>();
			Partition<Individual> triangleTypes = new Partition<Individual>();
			
			List<String> pajekPartitionLabels = new ArrayList<String>();
			pajekPartitionLabels.add("BETWEENNESS");

			List<String> partitionLabels = new ArrayList<String>();
			partitionLabels.add("BETWEENNESS");
			partitionLabels.add("EGO-BETWEENNESS");
			partitionLabels.add("SIZE");
			partitionLabels.add("TIES");
			partitionLabels.add("DENSITY");
			partitionLabels.add("DENSITY_NOLOOPS");
			partitionLabels.add("MEANDEGREE");
			partitionLabels.add("MEANDEGREE_NOLOOPS");
			partitionLabels.add("NRCOMPONENTS");
			partitionLabels.add("MAXCOMPONENT");
			partitionLabels.add("NRCOMPONENTS_NORM");
			partitionLabels.add("MAXCOMPONENT_NORM");
			partitionLabels.add("BROKERAGE");
			partitionLabels.add("EFFICIENT_SIZE");
			partitionLabels.add("EFFICIENCY");
			partitionLabels.add("JACQUARD");
			
			List<String> roleNames = new ArrayList<String>();
			for (Role role : segmentation.getCurrentRelations().getRelationModels().getByName("Migevent").roles()){
				roleNames.add(role.getName());
				partitionLabels.add("NR"+role.getName());
				partitionLabels.add("NR"+role.getName()+"_NORM");
			}
			
			for (String partitionLabel : partitionLabels){
				valuesMap.put(partitionLabel, new NumberedValues());
			}
			
			SpaceTimeCriteria criteria = new SpaceTimeCriteria();
			criteria.setAlterRoleName(alterRoleName);
			
			// Get ego networks
			for (Individual ego : segmentation.getCurrentIndividuals().toSortedList()){
		
				Sequence biography = SequenceWorker.getItinerary(ego, criteria.getEgoRoleName());
	//			biographies.add(biography);
		
				Graph<Individual> egoNetwork = NetUtils.createRelationGraph(ego, "Migevent", criteria.getEgoRoleName(), criteria.getAlterRoleName());
				egoNetwork.setLabel("ego Network "+ego);
				pajekBuffer.addAll(PuckUtils.writePajekNetwork(egoNetwork,pajekPartitionLabels));
				pajekBuffer.appendln();
				
				Graph<Individual> egoNetworkWithoutEgo = GraphUtils.cloneWithoutEgo(egoNetwork, egoNetwork.getNode(ego));
				Partition<Node<Individual>> components = GraphUtils.components(egoNetworkWithoutEgo);
				
				componentReport.outputs().appendln(ego+"\t"+components.size());
				int i=1;
				for (Cluster<Node<Individual>> cluster : components.getClusters().toListSortedByDescendingSize()){
					componentReport.outputs().appendln("\t"+i+"("+cluster.size()+"): "+cluster.getItemsAsString());
					i++;
				}
				componentReport.outputs().appendln();
				
				
				valuesMap.get("BETWEENNESS").put(ego.getId(),new Value(100.*graphBetweenness[nodeIds.get(ego.getId())-1]));
				valuesMap.get("EGO-BETWEENNESS").put(ego.getId(),new Value(100.*GraphUtils.betweenness(egoNetwork)[0]));
				valuesMap.get("SIZE").put(ego.getId(),new Value(egoNetworkWithoutEgo.nodeCount()));
				valuesMap.get("TIES").put(ego.getId(),new Value(egoNetworkWithoutEgo.lineCount()));
				valuesMap.get("DENSITY").put(ego.getId(),new Value(GraphUtils.density(egoNetworkWithoutEgo)));
				valuesMap.get("DENSITY_NOLOOPS").put(ego.getId(),new Value(GraphUtils.densityWithoutLoops(egoNetworkWithoutEgo)));
				valuesMap.get("MEANDEGREE").put(ego.getId(),new Value(GraphUtils.meanDegree(egoNetworkWithoutEgo)));
				valuesMap.get("MEANDEGREE_NOLOOPS").put(ego.getId(),new Value(GraphUtils.meanDegreeWithoutLoops(egoNetworkWithoutEgo)));
				valuesMap.get("NRCOMPONENTS").put(ego.getId(),new Value(components.size()));
				valuesMap.get("MAXCOMPONENT").put(ego.getId(),new Value(components.maxClusterSize()));
				valuesMap.get("NRCOMPONENTS_NORM").put(ego.getId(),new Value(100.*components.meanShare()));
				valuesMap.get("MAXCOMPONENT_NORM").put(ego.getId(),new Value(100.*components.maxShare()));
				valuesMap.get("BROKERAGE").put(ego.getId(),new Value(GraphUtils.unconnectedPairsNormalized(egoNetworkWithoutEgo)));
				valuesMap.get("EFFICIENT_SIZE").put(ego.getId(),new Value(GraphUtils.efficientSize(egoNetworkWithoutEgo)));
				valuesMap.get("EFFICIENCY").put(ego.getId(),new Value(GraphUtils.efficiency(egoNetworkWithoutEgo)));
				
				
				double jacquard = 0.;
				double nrAlters = 0.;
				for (Individual alter : egoNetwork.getReferents()){
					if (alter!=ego){
						nrAlters++;
						jacquard+= SequenceWorker.jacquardDistance(ego,alter,"Migevent",criteria.getEgoRoleName(),criteria.getAlterRoleName());
					}
				}
				valuesMap.get("JACQUARD").put(ego.getId(),new Value(MathUtils.percent(jacquard,100*nrAlters)));

				for (String roleName : roleNames){
					nrAlters = 0;
					for (Individual alter : biography.alters(roleName)){
						if (egoNetwork.getReferents().contains(alter)){
							nrAlters++;
							
						}
					}
					valuesMap.get("NR"+roleName).put(ego.getId(), new Value(nrAlters));
					valuesMap.get("NR"+roleName+"_NORM").put(ego.getId(), new Value(MathUtils.percent(nrAlters,egoNetwork.nodeCount()-1)));
				}
				
				
				
				// Get triangles
				
				Individuals individuals = ego.getRelated("Migevent");
				individuals.add(ego);
				Partition<EventTriangle> triangles = SequenceWorker.getTriangles(individuals, "Migevent");
				allTriangles.add(triangles);
				trianglesMap.put(ego.getId(), triangles);
				for (Cluster<EventTriangle> cluster : triangles.getClusters()){
					triangleTypes.put(ego, cluster.getValue());
				}
			}
			
			
			// Create Pajek Egonetworks
			if (pajekBuffer.length() != 0) {
				File targetFile = ToolBox.setExtension(ToolBox.addToName(new File(segmentation.getLabel()), "-Ego Networks"), ".paj");
				ReportRawData rawData = new ReportRawData("Export Ego Networks to Pajek", "Pajek", "paj", targetFile);
				rawData.setData(PAJFile.convertToMicrosoftEndOfLine(pajekBuffer.toString()));

				result.outputs().appendln();
				result.outputs().append(rawData);
			}
			
			// Create Partition charts and tables
			List<ReportChart> charts = new ArrayList<ReportChart>();
			List<ReportTable> tables = new ArrayList<ReportTable>();
			
			overallReport.outputs().appendln("Measure\tAverage\tMaximum");

			for (String partitionLabel : partitionLabels){
				
				PartitionCriteria partitionCriteria = new PartitionCriteria(partitionLabel);
				
				if (partitionLabel.equals("SIZE") || partitionLabel.equals("TIES") || partitionLabel.equals("NRCOMPONENTS") || partitionLabel.equals("MAXCOMPONENT")){
					partitionCriteria.setType(PartitionType.RAW);
				} else {
					partitionCriteria.setType(PartitionType.SIZED_GROUPING);
					partitionCriteria.setStart(0.);
					partitionCriteria.setEnd(100.);
					partitionCriteria.setSize(10.);
				}
				
				NumberedValues values = valuesMap.get(partitionLabel);
				
				Partition<Individual> partition = PartitionMaker.create(partitionLabel, segmentation.getCurrentIndividuals(), values, partitionCriteria);
			
				PartitionCriteria splitCriteria = new PartitionCriteria("GENDER");
				ReportChart chart = StatisticsReporter.createPartitionChart(partition, partitionCriteria, splitCriteria);
			
				if (chart != null) {
					charts.add(chart);
					tables.add(ReportTable.transpose(chart.createReportTableWithSum()));
				}
				
				overallReport.outputs().appendln(partitionLabel+"\t"+MathUtils.round(values.average(),2)+"\t"+values.median()+"\t"+values.max());
			}
					
			// Manage the number of chart by line.
			for (int chartIndex = 0; chartIndex < charts.size(); chartIndex++) {
				diagramReport.outputs().append(charts.get(chartIndex));
				if (chartIndex % 4 == 3) {
					diagramReport.outputs().appendln();
				}
			}
			
			// Add chart tables.
			for (ReportTable table : tables) {
				diagramReport.outputs().appendln(table.getTitle());
				diagramReport.outputs().appendln(table);
			}
			
			// Report individual values
			detailReport.outputs().append("Ego");
			for (String partitionLabel : partitionLabels){
				detailReport.outputs().append("\t"+partitionLabel);
			}
			detailReport.outputs().appendln();
			for (Individual ego : segmentation.getCurrentIndividuals().toSortedList()){
				detailReport.outputs().append(ego);
				for (String partitionLabel : partitionLabels){
					detailReport.outputs().append("\t"+valuesMap.get(partitionLabel).get(ego.getId()));
				}
				detailReport.outputs().appendln();
			}
			
			
			// Report triangles
			Report trianglesReport = new Report("Triangles");
			trianglesReport.outputs().appendln("Type\tnrTriangles\tnrEgoNetworks");
			for (Cluster<EventTriangle> cluster: allTriangles.getClusters().toListSortedByValue()){
				trianglesReport.outputs().appendln(cluster.getValue()+"\t"+cluster.size()+"\t"+triangleTypes.getCluster(cluster.getValue()).size());
			}
			trianglesReport.outputs().appendln();
			
			PartitionCriteria partitionCriteria = new PartitionCriteria("Triangles");
			ReportChart chart5 = StatisticsReporter.createPartitionChart(allTriangles, partitionCriteria, null);
			trianglesReport.outputs().appendln(chart5);
			
			for (Individual ego : segmentation.getCurrentIndividuals().toSortedList()){
				Partition<EventTriangle> triangles = trianglesMap.get(ego.getId());
				trianglesReport.outputs().appendln(ego+"\t"+triangles.size()+" types");
				for (Cluster<EventTriangle> cluster : triangles.getClusters().toListSortedByValue()){
					trianglesReport.outputs().appendln(cluster.getValue()+"\t"+cluster.size());
					for (EventTriangle triangle : cluster.getItems()){
						trianglesReport.outputs().appendln(triangle.getEventPattern());
					}
					trianglesReport.outputs().appendln();
				}
				trianglesReport.outputs().appendln();
			}
			
			result.outputs().append(overallReport);
			result.outputs().append(diagramReport);
			result.outputs().append(detailReport);
			result.outputs().append(componentReport);
			result.outputs().append(trianglesReport);

			//
			result.setTimeSpent(chrono.stop().interval());

			//
			return result;
		}*/

	/**
	 * 
	 * @param report
	 * @param segmentation
	 * @throws PuckException
	 */
	private static void reportTriangles(final Report report, final Segmentation segmentation) throws PuckException {

		Map<Integer, Partition<EventTriangle>> trianglesMap = new HashMap<Integer, Partition<EventTriangle>>();
		Partition<EventTriangle> allTriangles = new Partition<EventTriangle>();
		Partition<Individual> triangleTypes = new Partition<Individual>();

		// Get triangles

		for (Individual ego : segmentation.getCurrentIndividuals()) {
			Individuals individuals = ego.getRelated("Migevent");
			individuals.add(ego);
			Partition<EventTriangle> triangles = SequenceWorker.getTriangles(individuals, "Migevent");
			allTriangles.add(triangles);
			trianglesMap.put(ego.getId(), triangles);
			for (Cluster<EventTriangle> cluster : triangles.getClusters()) {
				triangleTypes.put(ego, cluster.getValue());
			}
		}

		// Report triangles
		Report trianglesReport = new Report("Triangles");
		trianglesReport.outputs().appendln("Type\tnrTriangles\tnrEgoNetworks");

		for (Cluster<EventTriangle> cluster : allTriangles.getClusters().toListSortedByValue()) {
			trianglesReport.outputs().appendln(cluster.getValue() + "\t" + cluster.size() + "\t" + triangleTypes.getCluster(cluster.getValue()).size());
		}
		trianglesReport.outputs().appendln();

		PartitionCriteria partitionCriteria = new PartitionCriteria("Triangles");
		ReportChart chart5 = StatisticsReporter.createPartitionChart(allTriangles, partitionCriteria, null);
		trianglesReport.outputs().appendln(chart5);

		for (Individual ego : segmentation.getCurrentIndividuals().toSortedList()) {
			Partition<EventTriangle> triangles = trianglesMap.get(ego.getId());
			trianglesReport.outputs().appendln(ego + "\t" + triangles.size() + " types");
			for (Cluster<EventTriangle> cluster : triangles.getClusters().toListSortedByValue()) {
				trianglesReport.outputs().appendln(cluster.getValue() + "\t" + cluster.size());
				for (EventTriangle triangle : cluster.getItems()) {
					trianglesReport.outputs().appendln(triangle.getEventPattern());
				}
				trianglesReport.outputs().appendln();
			}
			trianglesReport.outputs().appendln();
		}
	}

	// Should be placed into control reporter (not specific for sequences)
	/**
	 * @param segmentation
	 * @param bundle
	 * @return
	 */
	public static Report reportUnknownPlaces(final Segmentation segmentation, final ResourceBundle bundle) {
		Report result;

		UnknownPlacesCriteria criteria = new UnknownPlacesCriteria();
		criteria.setIncludedIndividual(true);
		criteria.setIncludedAllRelations(true);

		result = reportUnknownPlaces(segmentation, criteria, bundle);

		//
		return result;
	}

	/**
	 * @param segmentation
	 * @param bundle
	 * @return
	 */
	public static Report reportUnknownPlaces(final Segmentation segmentation, final UnknownPlacesCriteria criteria, final ResourceBundle bundle) {
		Report result;

		//
		Chronometer chrono = new Chronometer();

		Geography geography = Geography.getInstance();

		Partition<String> unknownPlaces = new Partition<String>();

		int errorCount = 0;
		StringList errors = new StringList();

		//
		if (criteria.isIncludedIndividual()) {
			//
			for (Individual individual : segmentation.getCurrentIndividuals()) {
				for (Attribute attribute : individual.attributes()) {
					if (attribute.getLabel().contains("PLAC")) {
						if (geography.getByHomonym(attribute.getValue()) == null) {
							unknownPlaces.put(attribute.getValue(), new Value(attribute.getLabel()));
							errorCount++;
						}
					}
				}
			}
		}

		//
		Relations relations;
		if (criteria.isIncludedAllRelations()) {
			//
			relations = segmentation.getCurrentRelations();

		} else if (criteria.getRelationNames().isEmpty()) {
			//
			relations = new Relations();

		} else {
			//
			relations = segmentation.getCurrentRelations().getByModelNames(criteria.getRelationNames());
		}

		for (Relation relation : relations) {
			for (Attribute attribute : relation.attributes()) {
				if (attribute.getLabel().contains("PLAC")) {
					if (geography.getByHomonym(attribute.getValue()) == null) {
						unknownPlaces.put(attribute.getValue(), new Value(attribute.getLabel()));
						errorCount++;
					}
				}
			}
		}

		for (Cluster<String> cluster : unknownPlaces.getClusters()) {
			errors.appendln(cluster.getValue().toString());
			for (String placeName : cluster.getItems()) {
				errors.appendln("\t" + placeName);
			}
			errors.appendln();
		}

		//
		result = new Report();
		result.setTitle("Unknown Places");
		result.setOrigin("Control reporter");
		result.setTarget(segmentation.getLabel());

		//
		errors.add(0, errorCount + " " + Report.translate(bundle, "Unknown Places") + "\n");
		result.outputs().append(errors.toString());

		//
		result.setStatus(errorCount);

		//
		result.setTimeSpent(chrono.stop().interval());

		//
		return result;
	}

	/**
	 * 
	 * @param cluster
	 * @return
	 */
	private static int sequenceNumber(final Cluster<String> cluster) {
		int result;

		Set<String> set = new HashSet<String>();

		for (String string : cluster.getItems()) {
			set.add(string.split("\\s")[0]);
		}

		result = set.size();

		//
		return result;
	}

}
