package org.tip.puck.spacetime;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import org.tip.puck.PuckException;
import org.tip.puck.net.FiliationType;
import org.tip.puck.net.Individual;
import org.tip.puck.net.Net;
import org.tip.puck.net.relations.Relation;
import org.tip.puck.net.workers.ExpansionMode;
import org.tip.puck.net.workers.NetUtils;
import org.tip.puck.segmentation.Segmentation;

public class SequenceMaker {


	/**
	 * creates sequence with variable ego roles
	 * @param ego
	 * @return
	 */
	public static Sequence createSequence (Individual ego, SpaceTimeCriteria criteria){
		Sequence result;
		
		result = new Sequence(ego.getId());
		result.setEgo(ego);
		result.setDateLabel(criteria.getDateLabel());
		
		for (Relation relation : ego.relations()){
			result.putInOrder(relation);
		}
		
		//
		return result;
	}
	
	/**
	 * creates sequence with constant ego role
	 * @param ego
	 * @param criteria
	 * @return
	 */
	public static Sequence createPersonalSequence (Individual ego, SpaceTimeCriteria criteria){
		Sequence result;
		
		String egoRoleName = criteria.getEgoRoleName();
		
		result = new Sequence(ego.getId());
		result.setEgo(ego);
		result.setEgoRoleName(egoRoleName);
		result.setDateLabel(criteria.getDateLabel());
		
		List<Relation> list = new ArrayList<Relation>();
		
		for (Relation relation : ego.relations()){
			if (relation.getRoleNames(ego).contains(egoRoleName)){
				list.add(relation);
			}
		}
		
		Collections.sort(list,new EventComparator(criteria));

		for (Relation event : list){
			
			result.putInOrder(event);
		}
		
//		result.setAlters();
		
		//
		return result;
	}
	
	public static Sequences createPersonalSequences (Segmentation segmentation, SpaceTimeCriteria criteria){
		Sequences result;
		
		result = new Sequences();
		
		for (Individual individual : segmentation.getCurrentIndividuals().toSortedList()){
			result.add(createPersonalSequence(individual, criteria));
		}
		//
		return result;
	}


	/**
	 * creates sequences including life events
	 * @param net
	 * @param segmentation
	 * @return
	 * @throws PuckException
	 */
	public static Sequences createBiographies (Net net, Segmentation segmentation, SpaceTimeCriteria criteria) throws PuckException{
		Sequences result;
		
		result = new Sequences();
		
		net.getFamilyEvents(segmentation);
		
		for (Individual individual : segmentation.getCurrentIndividuals()){
			result.add(createSequence(individual, criteria));
		}
	
		net.removeFamilyEvents();
		
		//
		return result;
		
	}

	/**
	 * create sequence for multiple egos
	 * @param individual
	 * @param criteria
	 * @return
	 */
	public static Sequence createExtendedSequence (Individual individual, SpaceTimeCriteria criteria){
		Sequence result;
		
		result = new Sequence(individual.getId());
		result.setEgo(individual);
		result.setDateLabel(criteria.getDateLabel());
		
		for (Relation relation : individual.relations()){
			result.putInOrder(relation);
		}
		
		ExpansionMode expansionMode = criteria.getExpansionMode();
		FiliationType filiationType = criteria.getFiliationType();

		for (Individual relative : NetUtils.neighbors(individual, expansionMode, filiationType)){
			
			for (Relation relation : relative.relations()){
				result.putInOrder(relation);
			}
		}
		
		//
		return result;
	}
	
	public static Sequences createExtendedBiographies (Net net, Segmentation segmentation, SpaceTimeCriteria criteria) throws PuckException{
		Sequences result;
		
		result = new Sequences();
		
		net.getFamilyEvents(segmentation);
		
		for (Individual individual : segmentation.getCurrentIndividuals()){
			result.add(SequenceMaker.createExtendedSequence(individual,criteria));
		}
	
		net.removeFamilyEvents();

		//
		return result;
		
	}


}
