package org.tip.puck.net.relations.workers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.TreeMap;

import org.apache.commons.lang3.StringUtils;
import org.tip.puck.net.Gender;
import org.tip.puck.net.relations.RelationModel;
import org.tip.puck.net.relations.Role;
import org.tip.puck.net.relations.RoleDefinition;
import org.tip.puck.net.relations.RoleDefinitions;
import org.tip.puck.net.relations.Roles;
import org.tip.puck.net.relations.RoleDefinition.Primary;

public class RelationModelStatistics {
	
	Roles roles;
	RoleDefinitions roleDefinitions;

	
	public RelationModelStatistics (RelationModel model){
		
		roles = model.roles();
		roleDefinitions = model.roleDefinitions().neutralize();
		
/*		for (RoleDefinition roleDefinition : roleDefinitions){

			Role role = roleDefinition.role();
			
			if (!roles.contains(role)){
				roles.add(role);
			}
		}*/
	}
	

	
	public List<Role> sortedRoles() {
		List<Role> result;
		
		result = roles;
		
		Collections.sort(result);
		
		return result;
	}



	public int termCount(){
		int result;
		
		result = roles.size();
		
		return result;
	}
	
	public List<Integer> generations(Role role){
		return generations(role, new Roles());
	}
	
	public List<Gender> genders(Role role){
		return genders(role, null);
	}
	
	public List<Gender> genders (Role role, Role preDefined){
		List<Gender> result;
		
		result = new ArrayList<Gender>();

		RoleDefinitions definitions = roleDefinitions.getDefinitions(role);
		
		for (RoleDefinition definition : definitions){
			if (definition.alterGender()!=null){
				if (!result.contains(definition.alterGender())){
					result.add(definition.alterGender());
				}
			} else if (definition.composition()!=null && !definition.composition().get(1).equals(preDefined)){
				for (Gender gender : genders(definition.composition().get(1),role)){
					if (!result.contains(gender)){
						result.add(gender);
					}
				}
			}
			
/*			if (definition.inversion()!=null){
				for (RoleDefinition inverseDefinition : roleDefinitions.getDefinitions(definition.inversion())){
					if (!result.contains(inverseDefinition.egoGender())){
						result.add(inverseDefinition.egoGender());
					}
				}
			}*/
		}
		//
		return result;
		
	}
	
	public List<Integer> generations(Role role, Roles preDefined){
		List<Integer> result;
		
		result = new ArrayList<Integer>();
		
		RoleDefinitions definitions = roleDefinitions.getDefinitions(role);
		
		for (RoleDefinition definition : definitions){
			if (definition.primary() == Primary.PARENT){
				if (!result.contains(1)){
					result.add(1);
				}
			} else if (definition.primary() == Primary.SIBLING || definition.primary() == Primary.SPOUSE){
				if (!result.contains(0)){
					result.add(0);
				}
			} 
			if (definition.inversion() != null){
				for (int inverseGeneration : generations(definition.inversion())){
					if (!result.contains(-inverseGeneration)){
						result.add(-inverseGeneration);
					}
				}
			} 
			
			if (definition.composition()!= null && !definition.composition().contains(role)){
				boolean recursive = false;
				for (Role preRole : preDefined){
					if (definition.composition().contains(preRole)){
						recursive = true;
						break;
					}
				}
				if (!recursive){
					preDefined.add(role);
					for (int firstGeneration : generations(definition.composition().get(0),preDefined)){
						for (int secondGeneration : generations(definition.composition().get(1),preDefined)){
							if (!result.contains(firstGeneration+secondGeneration)){
								result.add(firstGeneration+secondGeneration);
							}
						}
					}
					preDefined.remove(role);
				}
			}
		}
		Collections.sort(result);
		//
		return result;
		
	}
	
	public List<String> links (Role role){
		return links (role, 0);
	}
	
	public List<String> links (Role role, int iterations){
		List<String> result;
		
		result = new ArrayList<String>();
		int maxIterations = 2;
		
		if (iterations>maxIterations){
			return result;
		}

		RoleDefinitions definitions = roleDefinitions.getDefinitions(role);
		
		for (RoleDefinition definition : definitions){
			if (definition.primary()!=null){
				String ps = definition.getPrimaryAsString();
				if (StringUtils.isNotBlank(ps) && !result.contains(ps)){
					result.add(ps);
				}
			} 
			if (definition.inversion()!=null){
				String ps = definition.getInversePrimaryAsString(roleDefinitions);
				if (StringUtils.isNotBlank(ps) && !result.contains(ps)){
					result.add(ps);
				}
			}
			if (definition.composition()!= null && !definition.composition().contains(role)){
				
				for (String firstLink : links(definition.composition().get(0),iterations+1)){
					for (String secondLink : links(definition.composition().get(1),iterations+1)){
						String link = firstLink+secondLink;
						if (!result.contains(link)){
							result.add(link);
						}
					}
				}
			}
		}
		Collections.sort(result);
		//
		return result;
	}
	
	private boolean isParent(Role role){
		boolean result;
		
		result = false;
		
		for (RoleDefinition definition : roleDefinitions){
			if (definition.role().equals(role) && definition.primary()==Primary.PARENT){
				result = true;
				break;
			}
		}
		
		//
		return result;
	}
	
	private boolean isChild(Role role){
		boolean result;
		
		result = false;
		
		for (RoleDefinition definition : roleDefinitions){
			if (definition.role().equals(role) && isParent(definition.inversion())){
				result = true;
				break;
			}
		}
		
		//
		return result;
	}
	
	private boolean isSibling(Role role){
		boolean result;
		
		result = false;
		
		for (RoleDefinition definition : roleDefinitions){
			if (definition.role().equals(role) && definition.primary()==Primary.SIBLING){
				result = true;
				break;
			}
		}
		
		//
		return result;
	}
	
	private boolean hasSameGender(Role alpha, Role beta){
		boolean result;
		
		result = false;
		
		for (Gender gender : genders(alpha)){
			if (genders(beta).contains(gender)){
				result = true;
				break;
			}
		}
		//
		return result;
	}
	
	private boolean isAscendingParallel(Role role){
		boolean result;
		
		result = false;
		
		for (RoleDefinition definition : roleDefinitions){
			if (definition.role().equals(role) && definition.composition()!=null){
				
				Role first = definition.composition().get(0);
				Role second = definition.composition().get(1);

				if (isParent(first) && isSibling(second) && hasSameGender(first,second)) 
				
				result = true;
				break;
			}
		}
		
		//
		return result;
	}
	
	private boolean isAscendingCross(Role role){
		boolean result;
		
		result = false;
		
		for (RoleDefinition definition : roleDefinitions){
			if (definition.role().equals(role) && definition.composition()!=null){
				
				Role first = definition.composition().get(0);
				Role second = definition.composition().get(1);

				if (isParent(first) && isSibling(second) && !hasSameGender(first,second)) {
					result = true;
					break;
				}
				
			}
		}
		
		//
		return result;
	}
	
	private boolean isCollateralParallel(Role role){
		boolean result;
		
		result = false;
		
		for (RoleDefinition definition : roleDefinitions){
			if (definition.role().equals(role) && definition.composition()!=null){
				
				Role first = definition.composition().get(0);
				Role second = definition.composition().get(1);

				if (isAscendingParallel(first) && isChild(second)) {
					result = true;
					break;
				}
			}
		}
		
		//
		return result;
	}

	private boolean isCollateralCross(Role role){
		boolean result;
		
		result = false;
		
		for (RoleDefinition definition : roleDefinitions){
			if (definition.role().equals(role) && definition.composition()!=null){
				
				Role first = definition.composition().get(0);
				Role second = definition.composition().get(1);

				if (isAscendingCross(first) && isChild(second)) 
				
				result = true;
				break;
			}
		}
		
		//
		return result;
	}
	

	public String cousinClassification (){
		String result;
		
		result = null;
		
		boolean lineal = false;
		boolean merging = false;
		
		for (Role role : roles){
			if (isCollateralParallel(role) && isSibling(role)){
				merging = true;
			}
			if (isCollateralParallel(role) && isCollateralCross(role)){
				lineal = true;
			}
		}
		
		if (lineal){
			if (merging){
				result = "GENERATIONAL";
			} else {
				result = "LINEAL";
			}
		} else {
			if (merging){
				result = "BIFURCATE-MERGING";
			} else {
				result = "BIFURCATE-COLLATERAL";
			}
		}
		//
		return result;
	}
	
	public Roles undefinedRoles(){
		Roles result;
		
		result = new Roles();
		
		for (Role role : roles){
			if (roleDefinitions.getDefinitions(role).size()==0){
				if (!result.contains(role)){
					result.add(role);
				}
			}
		}
		
		Collections.sort(result);
		
		//
		return result;
	}
	
	public RoleDefinitions recursiveDefinitions(){
		
		return roleDefinitions.recursiveDefinitions();
	}
	

	
	
	
	



}
