package org.tip.puck.net.relations;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.TreeMap;

import org.tip.puck.net.Gender;
import org.tip.puck.net.relations.RoleDefinition.AlterAge;
import org.tip.puck.net.relations.RoleDefinition.Primary;
import org.tip.puck.util.NumberablesHashMap;

public class RoleDefinitions extends NumberablesHashMap<RoleDefinition> {
	
	boolean egoGenderDistinction;
	RoleDefinitions recursiveDefinitions;
	Map<Role,Roles> factors;
	
	public RoleDefinitions (){
		
	}
	
	public RoleDefinitions (RoleDefinitions roleDefinitions){
		for (RoleDefinition roleDefinition: roleDefinitions){
			add(roleDefinition.clone());
		}
	}
	
	public RoleDefinitions get (Primary primary, Role inversion, Roles composition, Gender alterGender, AlterAge alterAge, Gender egoGender){
		RoleDefinitions result;
		
		result = new RoleDefinitions();
		
		for (RoleDefinition def : this){
			
			if ((def.primary() == primary)
				&& (def.inversion() == inversion)
				&& (def.composition() == composition)
				&& (def.alterGender() == alterGender || def.alterGender()==null || alterGender==null)
				&& (def.alterAge() == alterAge || def.alterAge()==null || alterAge==null)
				&& (def.egoGender() == egoGender || def.egoGender()==null || egoGender ==null)) {
				
				result.add(def);
			}
		}
		
		//
		return result;
	}
	
	public boolean isPrimaryParent (RoleDefinition roleDefinition){
		return roleDefinition.primary() == Primary.PARENT;
	}
	
	public boolean isPrimarySibling (RoleDefinition roleDefinition){
		return roleDefinition.primary() == Primary.SIBLING;
	}
	
	public boolean isPrimarySpouse (RoleDefinition roleDefinition){
		return roleDefinition.primary() == Primary.SPOUSE;
	}
	
	public boolean isPrimaryChild (RoleDefinition roleDefinition){
		boolean result;
		
		result = false;
		
		for (RoleDefinition inverseDefinition : getDefinitions(roleDefinition.inversion())){
			if (isPrimaryParent(inverseDefinition)){
				result = true;
			}
		}
		//
		return result;
	}
	
	public Roles getCompositeRoles(Role alpha, Role beta){
		Roles result;

		result = new Roles();

		for (RoleDefinition alphaDef : getDefinitions(alpha)){
			for (RoleDefinition betaDef : getDefinitions(beta)){
				if (isPrimaryChild(betaDef)){
					if (isPrimaryParent(alphaDef)){
						for (RoleDefinition siblingDef : get(Primary.SIBLING,null,null,betaDef.alterGender(),betaDef.alterAge(),alphaDef.egoGender())){
							if (!result.contains(siblingDef.role())){
								result.add(siblingDef.role());
							}
						}
					} else if (alphaDef.composition()!=null){
						Role gamma = alphaDef.composition().get(0);
						Role delta = alphaDef.composition().get(1);
						for (RoleDefinition deltaDef : getDefinitions(delta)){
							if (isPrimaryParent(deltaDef)){
								for (RoleDefinition siblingDef : get(Primary.SIBLING,null,null,betaDef.alterGender(),betaDef.alterAge(),deltaDef.egoGender())){
									Role deltaBeta = siblingDef.role();
									for (Role gammaDeltaBeta : getCompositeRoles(gamma,deltaBeta)){
										if (!result.contains(gammaDeltaBeta)){
											result.add(gammaDeltaBeta);
										}
									}
								}
							}
						}
					}
				} else if (isPrimaryParent(betaDef)){
					if (isPrimaryChild(alphaDef)){
						for (RoleDefinition spouseDef : get(Primary.SPOUSE,null,null,betaDef.alterGender(),betaDef.alterAge(),alphaDef.egoGender())){
							if (!result.contains(spouseDef.role())){
								result.add(spouseDef.role());
							}
						}
					} else if (alphaDef.composition()!=null){
						Role gamma = alphaDef.composition().get(0);
						Role delta = alphaDef.composition().get(1);
						for (RoleDefinition deltaDef : getDefinitions(delta)){
							if (isPrimaryChild(deltaDef)){
								for (RoleDefinition spouseDef : get(Primary.SPOUSE,null,null,betaDef.alterGender(),betaDef.alterAge(),deltaDef.egoGender())){
									Role deltaBeta = spouseDef.role();
									for (Role gammaDeltaBeta : getCompositeRoles(gamma,deltaBeta)){
										if (!result.contains(gammaDeltaBeta)){
											result.add(gammaDeltaBeta);
										}
									}
								}
							}
						}
					}
				}
			}
		}
		
		if (!isComposite(beta)){
			for (RoleDefinition def : this){
				if (def.composition()!=null && def.composition().get(0).equals(alpha) && def.composition().get(1).equals(beta) && !result.contains(def.role())){
					result.add(def.role());
				}
			}
		} else {
			for (RoleDefinition compositeDefinition : getCompositeDefinitions(beta)){
				if (!isRecursive(compositeDefinition)){
					Role gamma = compositeDefinition.composition().get(0);
					Role delta = compositeDefinition.composition().get(1);
					for (Role alphaGamma: getCompositeRoles(alpha,gamma)){
						for (Role alphaGammaDelta : getCompositeRoles(alphaGamma,delta)){
							if (!result.contains(alphaGammaDelta)){
								result.add(alphaGammaDelta);
							}
						}
					}
				}
			}
		}
		Collections.sort(result);

		//
		return result;
	}
	
	private static AlterAge inverse(AlterAge age){
		AlterAge result;
		
		result = null;
		if (age!=null){
			result = age.invert();
		}
		//
		return result;
	}
	
	public boolean isRecursive(RoleDefinition roleDefinition){
		boolean result;
		
		result = recursiveDefinitions().contains(roleDefinition);
		
		//
		return result;
		
	}
	
	public Roles getReciprocalRoles (Role role){
		Roles result;
		
		result = new Roles();
		
		for (RoleDefinition def : getDefinitions(role)){
			if (isPrimarySibling(def)){
				for (RoleDefinition siblingDef : get(Primary.SIBLING,null,null,def.egoGender(),inverse(def.alterAge()),def.alterGender())){
					if (siblingDef!=null && !result.contains(siblingDef.role())){
						result.add(siblingDef.role());
					}
				}
			} else if (isPrimarySpouse(def)){
				for (RoleDefinition spouseDef : get(Primary.SPOUSE,null,null,def.egoGender(),inverse(def.alterAge()),def.alterGender())){
					if (spouseDef!=null && !result.contains(spouseDef.role())){
						result.add(spouseDef.role());
					}
				}
			} else if (def.inversion()!=null){
				result.add(def.inversion());
			} else {
				for (RoleDefinition inverseDefinition : getInverseDefinitions(role)){
					if (inverseDefinition.inversion()!=null && !result.contains(inverseDefinition.role())){
						result.add(inverseDefinition.role());
					}
				}
				for (RoleDefinition compositeDefinition : getCompositeDefinitions(role)){
					if (!isRecursive(compositeDefinition)){
						for (Role alpha: getReciprocalRoles(compositeDefinition.composition().get(0))){
							for (Role beta: getReciprocalRoles(compositeDefinition.composition().get(1))){
								for (Role betaAlpha : getCompositeRoles(beta,alpha)){
									if (!result.contains(betaAlpha)){
										result.add(betaAlpha);
									}
								}
							}
						}
					}
				}
			}
		}
		
		
		
		//
		return result;
	}
	


	public boolean isPrimary (Role role){
		boolean result;
		
		result = getPrimaryDefinitions(role).size()>0;
		
		//
		return result;
	}
	
	public boolean isInverse (Role role){
		boolean result;
		
		result = getInverseDefinitions(role).size()>0;
		
		//
		return result;
	}
	
	public boolean isComposite (Role role){
		boolean result;
		
		result = getCompositeDefinitions(role).size()>0;
		
		//
		return result;
	}
	
	public RoleDefinitions getPrimaryDefinitions(Role role){
		RoleDefinitions result;
		
		result = new RoleDefinitions();
		
		for (RoleDefinition definition : getDefinitions(role)){
			if (definition.primary()!=null){
				result.add(definition);
			}
		}
		
		//
		return result;
	}
	
	public RoleDefinitions getInverseDefinitions(Role role){
		RoleDefinitions result;
		
		result = new RoleDefinitions();
		
		for (RoleDefinition definition : getDefinitions(role)){
			if (definition.inversion()!=null){
				result.add(definition);
			} else {
				for (RoleDefinition otherDefinition : this){
					if (otherDefinition.inversion()!=null && otherDefinition.inversion().equals(role) && !result.contains(otherDefinition)){
						result.add(otherDefinition);
					}
				}
			}
		}
		
		//
		return result;
	}
	
	public RoleDefinitions getCompositeDefinitions(Role role){
		RoleDefinitions result;
		
		result = new RoleDefinitions();
		
		for (RoleDefinition definition : getDefinitions(role)){
			if (definition.composition()!=null){
				result.add(definition);
			}
		}
		
		//
		return result;
	}
		
	public RoleDefinitions getDefinitions(Role role){
		RoleDefinitions result;
		
		result = new RoleDefinitions();
		
		for (RoleDefinition roleDefinition : this){
			if (roleDefinition.role().equals(role)){
				result.add(roleDefinition);
			}
		}
		//
		return result;
	}
	
	public RoleDefinition getEgoGenderComplement (RoleDefinition source){
		RoleDefinition result;
		
		result = null;
		
		for (RoleDefinition def : this){
			if ((def.primary() == source.primary())
				&& (Role.equalOrBothNull(def.inversion(),source.inversion()))
				&& (Roles.equalOrBothNull(def.composition(), source.composition()))
				&& (def.alterGender() == source.alterGender())
				&& (def.alterAge() == source.alterAge())
				&& (source.egoGender()!=null && def.egoGender() == source.egoGender().invert())) {
				
				result = def;
				break;
			}
		}
		
		//
		return result;
	}
	
	public RoleDefinition getAlterGenderComplement (RoleDefinition source){
		RoleDefinition result;
		
		result = null;
		
		for (RoleDefinition def : this){
			
			if ((def.primary() == source.primary())
				&& (Role.equalOrBothNull(def.inversion(),source.inversion()))
				&& (Roles.equalOrBothNull(def.composition(), source.composition()))
				&& (source.alterGender()!=null && def.alterGender() == source.alterGender().invert())
				&& (def.alterAge() == source.alterAge())
				&& (def.egoGender() == source.egoGender())) {
				
				result = def;
				break;
			}
		}
		

		
		//
		return result;
	}
	
	public RoleDefinition getAlterAgeComplement (RoleDefinition source){
		RoleDefinition result;
		
		result = null;
		
		for (RoleDefinition def : this){
			if ((def.primary() == source.primary())
				&& (Role.equalOrBothNull(def.inversion(),source.inversion()))
				&& (Roles.equalOrBothNull(def.composition(), source.composition()))
				&& (def.alterGender() == source.alterGender())
				&& (source.alterAge()!=null && def.alterAge() == source.alterAge().invert())
				&& (def.egoGender() == source.egoGender())) {
				
				result = def;
				break;
			}
		}
		
		//
		return result;
	}
	
	public Roles getRoles (Primary primary, Gender alterGender, AlterAge alterAge, Gender egoGender){
		Roles result;
		
		result = new Roles();
		
		for (RoleDefinition def : this){
			if ((def.primary() == primary)
				&& (def.alterGender()==null || alterGender == null || alterGender == def.alterGender())
				&& (def.egoGender()==null || egoGender == null || egoGender == def.egoGender())
				&& (def.alterAge()==alterAge || def.alterAge()==null || alterAge == null)){
				
				if (!result.contains(def.role())){
					result.add(def.role());
				}
			}
		}
		
		//
		return result;
	}
	
	public Role getRoleByName (String name){
		Role result;
		
		result = null;
		
		for (RoleDefinition def : this){
			if (def.role()!=null && def.role().getName().equals(name)){
				result = def.role();
				break;
			}
		}
		//
		return result;
	}
	
	public Roles getInverseRoles (Role role){
		Roles result;
		
		result = new Roles();
		
		for (RoleDefinition def : this){
			if (def.inversion()!=null && def.inversion().equals(role)){
				result.add(def.role());
			}
		}
		//
		return result;
	}
	
	public Role getInverseRole (Role role, Gender egoGender, Gender alterGender){
		Role result;
		
		result = null;
		
		for (RoleDefinition def : this){
			
			if (def.inversion()!=null && def.inversion().equals(role) && genderMatch(egoGender,def.alterGender()) && genderMatch(def.egoGender(), alterGender)){
				result = def.role();
				break;
			} 
			if (def.inversion()!=null && def.role().equals(role) && genderMatch(def.egoGender(),egoGender) && genderMatch(def.alterGender(),alterGender)){				
				result = def.inversion();
				break;
			}
		}

		//
		return result;
	}
	
	/**
	 * 
	 * @return
	 */
	public List<RoleDefinition> toSortedList() {
		List<RoleDefinition> result;

		result = toList();
		Collections.sort(result, new RoleDefinitionComparator());

		//
		return result;
	}

	private static boolean genderMatch (Gender alphaGender, Gender betaGender){
		return (alphaGender==null || alphaGender == betaGender);
	}

	public boolean isEgoGenderDistinction() {
		return egoGenderDistinction;
	}

	public void setEgoGenderDistinction(boolean egoGenderDistinction) {
		this.egoGenderDistinction = egoGenderDistinction;
	}
	
	public List<Gender> getAlterGenders(Role role){
		List<Gender> result;
		
		result = new ArrayList<Gender>();
		
		for (RoleDefinition def : getDefinitions(role)){
			if (!result.contains(def.alterGender())){
				result.add(def.alterGender());
			}
		}
		//
		return result;
	}
	
	public List<Gender> getMediusGenders(Role role){
		List<Gender> result;

		result = new ArrayList<Gender>();
		
		for (RoleDefinition def : getDefinitions(role)){
			if (def.composition()!=null){
				for (RoleDefinition mediusDef : getDefinitions(def.composition().get(0))){
					if (!result.contains(mediusDef.alterGender())){
						result.add(mediusDef.alterGender());
					}
				}
			}
			
		}
		//
		return result;
		
	}
	
	public RoleDefinitions neutralize (){
		RoleDefinitions result;
		
		result = new RoleDefinitions(this);
		
		for (RoleDefinition def : this){
			
			if (result.getById(def.getId())!=null){
				RoleDefinition egoGenderComplement = result.getEgoGenderComplement(result.getById(def.getId()));
				if (egoGenderComplement==null) {
					result.getById(def.getId()).setEgoGender(null);
				} else if (egoGenderComplement.role().equals(def.role())){
					result.getById(def.getId()).setEgoGender(null);
					result.removeById(egoGenderComplement.getId());
				}
			}
		}
		
		for (RoleDefinition def : this){
			
			if (result.getById(def.getId())!=null){
				RoleDefinition alterGenderComplement = result.getAlterGenderComplement(result.getById(def.getId()));

				if (alterGenderComplement==null) {
//					def.setAlterGender(null);
				} else if (alterGenderComplement.role().equals(def.role())){
					result.getById(def.getId()).setAlterGender(null);
					result.removeById(alterGenderComplement.getId());
				}
			}
		}
		//
		return result;
	}
	
	private Roles roles(){
		Roles result;
		
		result = new Roles();
		
		for (RoleDefinition definition : this){
			if (definition.role()!=null && !result.contains(definition.role())){
				result.add(definition.role());
			}
		}
		//
		return result;
	}
	
	public Map<Role,Roles> factors (){
		
		if (factors==null){
			factors = new TreeMap<Role,Roles>();
			recursiveDefinitions = new RoleDefinitions();
			
			for (Role role : roles()){
				factors.put(role, factors(role));
			}
			
		}
		
		//
		return factors;
	}
	
	public RoleDefinitions recursiveDefinitions(){
		
		if (recursiveDefinitions==null){
			factors();
		}
		
		return recursiveDefinitions;
	}
	
	private Roles factors(Role role){
		Roles result;
		
		result = new Roles();
		
		
		Queue<Role> queue = new LinkedList<Role>();
		Roles visited = new Roles();
		
		queue.add(role);
		visited.add(role);
		
		while (!queue.isEmpty()){
			Role factor = queue.remove();
			for (RoleDefinition definition : getDefinitions(factor)){
				if (definition.primary()!=null && !result.contains(factor)){
					result.add(factor);
				} else if (definition.inversion()!=null){
					Role inv = definition.inversion();
					if (inv.equals(role)){
						recursiveDefinitions.add(definition);
					} else if (!visited.contains(inv)){
						queue.add(inv);
						visited.add(inv);
					}
				} else if (definition.composition()!=null){
					for (Role comp : definition.composition()){
						if (comp.equals(role)){
							recursiveDefinitions.add(definition);
						} else if (!visited.contains(comp)){
							queue.add(comp);
							visited.add(comp);
						}
					}
				}
			}
		}
		
		//
		return result;
	}

	

}
