package org.tip.puck.net.relations;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.apache.commons.lang3.StringUtils;
import org.tip.puck.net.Attribute;
import org.tip.puck.net.Attributes;
import org.tip.puck.net.Individual;
import org.tip.puck.net.Individuals;
import org.tip.puck.net.workers.RelationValuator;
import org.tip.puck.util.Numberable;
import org.tip.puck.util.Value;

/**
 * 
 * @author TIP
 */
public class Relation implements Numberable {

	private int id;
	private int typedId;
	private RelationModel model;
	private String name;
	private Actors actors;
	private Attributes attributes;

	/**
	 * 
	 * @param id
	 * @param model
	 * @param name
	 * @param actors
	 */
	public Relation(final int id, final int typedId, final RelationModel model, final String name, final Actor... actors) {
		this.id = id;
		this.typedId = typedId;
		this.model = model;
		this.name = name;
		this.actors = new Actors();
		for (Actor actor : actors) {
			this.actors.add(actor);
		}
		this.attributes = new Attributes();
	}
	
	public Actor firstActorById(int id){
		Actor result;
		
		result = null;
		if (actors!=null && actors.size()>0){
			result = actors.get(0);
		}
		//
		return result;
	}

	/**
	 * 
	 * @return
	 */
	public Actors actors() {
		return actors;
	}
	
	public boolean addActor(final Individual individual, final Role role){
		return actors().add(new Actor(individual,role));
	}

	/**
	 * 
	 * @return
	 */
	public Attributes attributes() {
		Attributes result;

		result = this.attributes;

		//
		return result;
	}

	/**
	 * 
	 */
	public String getAttributeValue(final String label) {
		String result;

		Attribute attribute = this.attributes().get(label);
		if (attribute == null) {
			result = null;
		} else {
			result = attribute.getValue();
		}

		//
		return result;
	}

	/**
	 * 
	 */
	@Override
	public int getId() {
		return id;
	}
	
	public boolean equals(Object obj){
		boolean result;
		
		result = obj != null && getId() == ((Relation) obj).getId();
		//
		return result;
	}

	public RelationModel getModel() {
		return model;
	}

	public String getName() {
		return name;
	}
	
	public Integer getTime(String dateLabel){
		Integer result;
		
		Value timeValue = RelationValuator.get(this, dateLabel);
		if (timeValue!=null) {
			result = timeValue.intValue();
		} else {
			result = null;
		}
		//
		return result;
	}

	public int getTypedId() {
		return typedId;
	}
	
	/**
	 * 
	 * @param key
	 * @return
	 */
	public boolean hasActor(final Actor actor) {
		boolean result;

		if (actor == null) {
			result = false;
		} else {
			result = this.actors.hasActor(actor.getId(), actor.getRole().getName());
		}

		//
		return result;
	}
	
	/**
	 * 
	 * @param key
	 * @return
	 */
	public boolean hasActors(final String... roleNames) {
		boolean result;
		
		result = false;
		
		for (String roleName : roleNames){
			if (this.actors.getByRole(roleName).size()>0){
				result = true;
				break;
			}
		}

		//
		return result;
	}

	
	public List<String> getRoleNames (final Individual individual) {
		List<String> result;
		
		result = new ArrayList<String>();
		
		for (Actor actor : actors){
			if (actor.getIndividual().equals(individual)){
				result.add(actor.getRole().getName());
			}
		}
		
		//
		return result;
	}
	
	public String getRoleNamesAsString (final Individual individual) {
		String result;
		
		result = "";
		
		for (Actor actor : actors){
			if (actor.getIndividual().equals(individual)){
				result += actor.getRole().getName()+" ";
			}
		}
		
		//
		return result;
	}
	
	public Roles getRoles (final Individual individual) {
		Roles result;
		
		result = new Roles();
		
		for (Actor actor : actors){
			if (actor.getIndividual().equals(individual)){
				result.add(actor.getRole());
			}
		}
		
		//
		return result;
	}
	
	public Individuals getIndividuals (final String roleName) {
		Individuals result;
		
		result = new Individuals();
		
		for (Actor actor : actors){
			if (actor.getRole().getName().equals(roleName)){
				result.add(actor.getIndividual());
			}
		}
		
		//
		return result;
	}
	
	public Individuals getIndividuals (final List<String> roleNames) {
		Individuals result;
		
		result = new Individuals();
		
		for (Actor actor : actors){
			if (roleNames.contains(actor.getRole().getName())){
				result.add(actor.getIndividual());
			}
		}
		
		//
		return result;
	}
	
	public Individuals getIndividuals () {
		Individuals result;
		
		result = new Individuals();
		
		for (Actor actor : actors){
			result.add(actor.getIndividual());
		}
		
		//
		return result;
	}

	public Individual getFirstIndividual () {
		Individual result;
		
		result = null;
		Individuals individuals = getIndividuals();
		
		if (individuals != null){
			for (Individual individual : individuals){
				result = individual;
				break;
			}
		}
		//
		return result;
	}

	/**
	 * 
	 * @param key
	 * @return
	 */
	public boolean hasActor(final Individual individual) {
		boolean result;

		if (individual == null) {
			result = false;
		} else {
			result = this.actors.hasActor(individual.getId());
		}

		//
		return result;
	}

	/**
	 * 
	 * @param key
	 * @return
	 */
	public boolean hasActor(final Individual individual, final String role) {
		boolean result;

		if (individual == null) {
			result = false;
		} else {
			result = this.actors.hasActor(individual.getId(), role);
		}

		//
		return result;
	}

	/**
	 * 
	 * @param id
	 * @return
	 */
	public boolean hasActor(final int id) {
		boolean result;

		result = this.actors.hasActor(id);

		//
		return result;
	}

	/**
	 * 
	 * @param id
	 * @param role
	 * @return
	 */
	public boolean hasActor(final int id, final String role) {
		boolean result;

		result = this.actors.hasActor(id, role);

		//
		return result;
	}
	
	/**
	 * note: each relation is supposed to have "null" as attribute value
	 * @param label
	 * @return
	 */
	public boolean hasAttributeValue(String label){
		boolean result;
		
		if (label==null){
			result = true;
		} else {
			result = (getAttributeValue(label)!=null);
		}
		
		return result;
	}
	
	public boolean hasTime(String dateLabel, Integer time){
		boolean result;
		
		result = (getTime(dateLabel)!=null && getTime(dateLabel).equals(time));
		
		//
		return result;
	}

	/**
	 * 
	 */
	@Override
	public String hashKey() {
		String result;

		result = "" + this.id;

		//
		return result;
	}

	public boolean hasRole(final Individual individual, final String roleName) {
		boolean result = false;

		for (Actor actor : actors) {
			if (actor.getIndividual() == individual && actor.getRole().getName().equals(roleName)) {
				result = true;
				break;
			}
		}
		//
		return result;
	}

	/**
	 * 
	 * @param pattern
	 * @return
	 */
	public boolean matches(final String pattern) {
		boolean result;

		if (StringUtils.isBlank(pattern)) {
			result = false;
		} else {
			String targetPattern = pattern.toLowerCase();

			if (this.name.toLowerCase().contains(targetPattern)) {
				result = true;
			} else {
				boolean ended = false;
				result = false;
				Iterator<Actor> iterator = this.actors.iterator();
				while (!ended) {
					if (iterator.hasNext()) {
						Actor actor = iterator.next();
						if (actor.getIndividual().getName().toLowerCase().contains(targetPattern)) {
							ended = true;
							result = true;
						}
					} else {
						ended = true;
						result = false;
					}
				}
			}
		}

		//
		return result;
	}

	/**
	 * 
	 * @param target
	 */
	public void removeActor(final Actor actor) {
		this.actors.remove(actor);
	}

	/**
	 * 
	 * @param id
	 */
	public void removeActor(final int id) {
		for (Actor actor : this.actors.toList()) {
			if (actor.getId() == id) {
				this.actors.remove(actor);
			}
		}
	}
	
	/**
	 * 
	 * @param label
	 * @param value
	 */
	public void setAttribute(final String label, final String value) {
		this.attributes().put(label, value);
	}
	
	public String toString(){
		return model+" "+id+" "+name+" ("+typedId+")";
	}

	/**
	 * 
	 */
	@Override
	public void setId(final int id) {
		this.id = id;
	}

	public void setModel(final RelationModel model) {
		this.model = model;
	}

	public void setName(final String name) {
		this.name = name;
	}

	public void setTypedId(final int typedId) {
		this.typedId = typedId;
	}
	
	public String defaultRoleName() {
		return model.defaultRoleName();
	}
	
	public Actors getDependants(Actor referent){
		Actors result;
		
		result = new Actors();
		
		if (referent!=null){
			for (Actor actor : actors){
				if (actor.getReferent()!=null && actor.getReferent().equals(referent.getIndividual())){
					result.add(actor);
				}
			}
		}
		
		//
		return result;
	}
	
	public Individuals getReferents (Individual ego){
		Individuals result;
		
		result = new Individuals();
		
		if (ego!=null){
			for (Actor actor : actors){
				if (actor.getIndividual()==ego){
					if (actor.getReferent()!=null && !result.contains(actor.getReferent())){
						result.add(actor.getReferent());
					}
				}
			}
		}
		//
		return result;
	}
	
	public void updateReferents (String roleName){
		Individual referent = null;
		for (Actor actor : actors){
			if (actor.getRole().getName().equals(roleName) && actor.getReferent()==null){
				referent = actor.getIndividual();
				break;
			}
		}
		if (referent!=null){
			for (Actor actor : actors){
				if (actor.getReferent()==null && actor.getIndividual()!=referent && !actor.getRole().getName().equals(roleName)){
					actor.setReferent(referent);
				}
			}
		}
	}
	
	public Actor getActor (Actor actor){
		Actor result;
		
		result = null;
		for (Actor thisActor : actors){
			if (thisActor.equals(actor)){
				result = thisActor;
				break;
			}
		}
		//
		return result;
	}
	
	public Actor getActor (Individual individual, String roleName){
		Actor result;

		result = null;
		Actors actors = actors().getById(individual.getId()).getByRole(roleName);
		if (actors.size()>0){
			result = actors.get(0);
		}
		//
		return result;
	}
	



	
}
