package org.tip.puck.io.csv;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

import org.opengis.feature.simple.SimpleFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.PuckException;
import org.tip.puck.geo.Place;
import org.tip.puck.graphs.Graph;
import org.tip.puck.graphs.Node;

import com.vividsolutions.jts.geom.Coordinate;

/**
 * This class represents a XLS File reader and writer.
 * 
 * @author Éric Mermet
 */
public class CSVFile {

	private static final Logger logger = LoggerFactory.getLogger(CSVFile.class);

	public static final String DEFAULT_CHARSET_NAME = "UTF-8";

	public static final int MAX_LINE_SIZE = 2048;

	/**
	 * Loads a XLS file into a Net.
	 * 
	 * @param file
	 *            file from where load a net.
	 * 
	 * @return the loaded net.
	 * 
	 * @throws PuckException
	 */
	public static HashMap<String, Place> load(final File csvFile, Graph<?> graph) throws PuckException {

		HashMap<String, Place> returnHashedPlaces = new HashMap<String, Place>();

		//Parse with TDf tab delimited format relative to geonames
		try {

			BufferedReader br = new BufferedReader(new FileReader(csvFile.getAbsolutePath()));

			returnHashedPlaces = readLines(br, returnHashedPlaces, graph);

		} catch (IOException e) {
			e.printStackTrace();
		}	

		//
		return returnHashedPlaces;
	}

	/**
	 * 
	 * @param file
	 * @return
	 * @throws IOException 
	 */
	public static HashMap<String, Place> readLines(BufferedReader reader, HashMap<String, Place> hashPlaces, Graph<?> placesGraph) throws IOException {

		String nextLine;
		String[] columnDetail;
		
		Graph<Place> graphPlaces = new Graph<Place>("GraphPlaces");
		ArrayList<String> places = new ArrayList<String>();
		
		//Build list to compare nodes labels
		for (Node<?> node : placesGraph.getNodes())
			places.add(node.getLabel());
		
		int i = 0;
		while ((nextLine = reader.readLine()) != null) {
			// nextLine[] is an array of values from the line
			
			columnDetail = nextLine.split("\t", -1);
			
//			if( i%100000 == 0) {
//				for (int j = 0; j < columnDetail.length; j++) {
//					System.out.println( j + " " + columnDetail[j]);
//				}
//				System.out.println(columnDetail[0] + " " + columnDetail[1] + " " + columnDetail[4] + " " + columnDetail[5] );
//			}
				
			Coordinate c = new Coordinate(Double.parseDouble(columnDetail[4]), Double.parseDouble(columnDetail[5]));
			hashPlaces.put(columnDetail[1], new Place(Integer.parseInt(columnDetail[0]), columnDetail[1], columnDetail[1], columnDetail[2], columnDetail[3], columnDetail[8], c));

			i++;
		}
		System.out.println("End csv file" + hashPlaces.size());

		//		for (CSVRecord csvRecord : parser) {
		////			String tempPlace = csvRecord.get(1);
		////			String y_s = csvRecord.get(4);
		////			String x_s = csvRecord.get(5);
		////
		////			Coordinate c = new Coordinate(Double.parseDouble(x_s), Double.parseDouble(y_s));
		////
		////			hashPlaces.put(tempPlace, new Place(tempPlace, c));
		//			
		//			System.out.println(csvRecord);
		//		}


		//
		return hashPlaces;
	}

}
