package org.tip.puck.geo.io;

import java.util.ArrayList;

import javax.swing.JProgressBar;

import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.JTSFactoryFinder;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.tip.puck.geo.Place;
import org.tip.puck.graphs.Graph;
import org.tip.puck.graphs.Link;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateList;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;

public class BuildingGeoLinks {

	DefaultFeatureCollection featureLinesCollection;
	SimpleFeatureBuilder featureBuilder;

	GeometryFactory geometryFactory = JTSFactoryFinder.getGeometryFactory(null);

	SimpleFeatureType lineFeatureType;
	Object[] attributesSchema = new Object[3];

	public BuildingGeoLinks() {
		SimpleFeatureTypeBuilder b = new SimpleFeatureTypeBuilder();

		//set the name
		b.setName( "SCHEMA_LINES" );

		//Add attributes
		b.add( "name", String.class);
		b.add( "value", Double.class);
		//add a geometry property
		b.setCRS( DefaultGeographicCRS.WGS84 ); // set crs first
		b.add( "the_geom", LineString.class ); // then add geometry

		//build the type
		this.lineFeatureType = b.buildFeatureType();

		featureLinesCollection = new DefaultFeatureCollection("internal",this.lineFeatureType);

		this.featureBuilder = new SimpleFeatureBuilder(this.lineFeatureType);
	}

	public DefaultFeatureCollection getFeatureLinesCollection() {
		return featureLinesCollection;
	}

	public void setFeatureLinesCollection(
			DefaultFeatureCollection featureLinesCollection) {
		this.featureLinesCollection = featureLinesCollection;
	}

	public SimpleFeatureBuilder getFeatureBuilder() {
		return featureBuilder;
	}

	public void setFeatureBuilder(SimpleFeatureBuilder featureBuilder) {
		this.featureBuilder = featureBuilder;
	}

	public GeometryFactory getGeometryFactory() {
		return geometryFactory;
	}

	public void setGeometryFactory(GeometryFactory geometryFactory) {
		this.geometryFactory = geometryFactory;
	}

	public SimpleFeatureType getLineFeatureType() {
		return lineFeatureType;
	}

	public void setLineFeatureType(SimpleFeatureType lineFeatureType) {
		this.lineFeatureType = lineFeatureType;
	}

	public DefaultFeatureCollection buildLinkGeometry(JProgressBar progressBar, Graph<Place>  graphPlaces) {
		
		for (Link<Place> link : graphPlaces.getArcs()) {

			if( link.getSourceNode().getReferent().getCoordinate() != null & link.getTargetNode().getReferent().getCoordinate() != null) {

				if( link.getSourceId() != link.getTargetId() ) {
				
					Coordinate[] tabCoord = new Coordinate[]{
							link.getSourceNode().getReferent().getCoordinate(),
							link.getTargetNode().getReferent().getCoordinate() };

					LineString line = this.geometryFactory.createLineString(tabCoord);
					attributesSchema[2] = line;

				}else{
					
					//Create a LineString ring from circle coordinates
					
					int nbPoints = 10;
					double radius =  0.1;
					double x_start = link.getSourceNode().getReferent().getCoordinate().x;
					double y_start = link.getSourceNode().getReferent().getCoordinate().y+radius;
					
					Coordinate[] coordTabCircle = new Coordinate[2*nbPoints+1];
					
					int i = 0;
					for( double ang_rd = -Math.PI/2; ang_rd <= 3*Math.PI/2; ang_rd+=Math.PI/nbPoints) {
						
						double x = radius * Math.cos(ang_rd)+x_start;
						double y = radius * Math.sin(ang_rd)+y_start;
						coordTabCircle[i++] = new Coordinate(x, y);
						
					}
					
					
					CoordinateList coordList2 = new CoordinateList(coordTabCircle);
					
					LinearRing ring = this.geometryFactory.createLinearRing(coordList2.toCoordinateArray());
					attributesSchema[2] = ring;
				}
				
				attributesSchema[0] = link.getSourceNode().getReferent().getName() + " -- " +  link.getTargetNode().getReferent().getName();
				attributesSchema[1] = (Double)link.getWeight();
				
				
				SimpleFeature f = SimpleFeatureBuilder.build(this.lineFeatureType, attributesSchema, null );

				this.featureLinesCollection.add(f);

			}
			int i = progressBar.getValue();
			progressBar.setValue(i++);
		}
		return this.featureLinesCollection;

	}

}