package org.tip.puck.geo;

import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.tip.puck.PuckException;
import org.tip.puck.geo.io.PlaceFile;

public class Geography {

	private static Geography geography;

	Map<GeoLevel,Map<String,Place>> levels;
	Map<String,String> homonyms;
	Map<String,Map<GeoLevel,Place>> sups;

	public Geography (){
		levels = new HashMap<GeoLevel,Map<String,Place>>();
		sups = new HashMap<String,Map<GeoLevel,Place>>();
		for (GeoLevel level : GeoLevel.values()){
			levels.put(level, new HashMap<String,Place>());
		}
		homonyms = new HashMap<String,String>();
	}

	public void reportGeography(){
		for (GeoLevel level : GeoLevel.values()){
			System.out.println(level);
			for (Place place : levels.get(level).values()){
				System.out.println("\t"+place.getId());
			}
		}
	}

	public Place get (GeoLevel level, String id){
		return levels.get(level).get(id);
	}

	public Place get (String id){
		Place result;

		result = null;

		for (GeoLevel level : GeoLevel.values()){
			result = levels.get(level).get(id);
			if (result!=null){
				break;
			}
		}

		return result;
	}

	public Place get(String homonym, GeoLevel minLevel){
		Place result;

		result = getByHomonym(homonym);
		if (result!=null && minLevel!=null && minLevel.compareTo(result.level)<0){
			result = getPlace(homonym,minLevel);
		} 
		//
		return result;

	}

	public Place getByHomonym (String homonym){
		Place result;

		result = get(homonyms.get(homonym));
		if (homonym != null && result==null){
			System.err.println("missing geography entry:\t"+ homonym);
		}

		//
		return result;
	}

	public void put (String homonym, Place place){
		homonyms.put(homonym, place.getId());
	}

	public void put (Place place){
		levels.get(place.getLevel()).put(place.getId(), place);
	}

	public Place getCommonAncestor (Place first, Place second){
		Place result;

		result = null;

		if (first == second){
			result = first;
		} else if (first!=null && second!=null){
			int comp = first.compareByLevel(second);
			if (comp == 0){
				result = getCommonAncestor(first.getSup(),second.getSup());
			} else if (comp < 0){
				result = getCommonAncestor(first,second.getSup());
			} else if (comp > 0){
				result = getCommonAncestor(first.getSup(),second);
			}
		}
		//
		return result;
	}

	public static Geography getInstance() {
		if (geography == null){
			try {
				geography = PlaceFile.loadGeoData(new File("src/org/tip/puck/geo/data/togo.txt"));
			} catch (PuckException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}
		//
		return geography;
	}

	
	/**
	 * @param homonym
	 * @return
	 */
	public Place getPlaceByCenter(String homonym, String center){
		Place result;

		result = null;
		if (homonym.equals(center)){
			result = getByHomonym(homonym);
		} else {
			for (GeoLevel level : GeoLevel.values()){
				result = getPlace(homonym,level);
				if (level == GeoLevel.HOMONYM || (result!=null && !result.equals(getPlace(center,level)))){
					break;
				}
			}
		}
		
		//
		return result;
	}
	
	public Place getPlace (String homonym, String parameter){
		Place result;
		
		try {
			result = getPlace (homonym, GeoLevel.valueOf(parameter));
		} catch (IllegalArgumentException iae){
			result = getPlaceByCenter (homonym, parameter);
		}
		
		//
		return result;
	}
	
	public Place getPlace(String homonym, GeoLevel level){
		Place result;

		if (getByHomonym(homonym)==null){
			result = null;
			System.err.println("Place not known: "+homonym);
		} else {
			result = getByHomonym(homonym).atLevel(level);
		}

		//
		return result;
	}

	public Place getSup(String homonym, List<String> placenames){
		Place result;

		if (getByHomonym(homonym)==null){
			result = null;
		} else {
			result = getByHomonym(homonym).getSup(placenames);
		}

		//
		return result;
	}


}
