/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puckgui.views.kinoath;

import java.awt.Component;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.swing.JOptionPane;
import nl.mpi.kinnate.kindata.EntityData;
import org.apache.batik.swing.JSVGCanvas;
import org.apache.batik.swing.JSVGScrollPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.PuckException;
import org.tip.puck.kinoath.KinOathDiagram;
import org.tip.puck.kinoath.io.KinOathFile;
import org.tip.puckgui.util.GUIToolBox;
import org.tip.puckgui.views.kinoath.KinOathExportFileSelector;
import org.w3c.dom.Document;

public class KinOathDiagramPanel
extends JSVGScrollPane {
    private static final long serialVersionUID = -8822574190413071405L;
    private static final Logger logger = LoggerFactory.getLogger(KinOathDiagramPanel.class);
    private KinOathDiagram diagram;

    public KinOathDiagramPanel() {
        this(null);
    }

    public KinOathDiagramPanel(EntityData[] source) {
        super(new JSVGCanvas());
        this.getCanvas().setEnableImageZoomInteractor(true);
        this.getCanvas().setEnablePanInteractor(true);
        this.getCanvas().setEnableRotateInteractor(true);
        this.getCanvas().setEnableZoomInteractor(true);
        this.updateSource(source);
    }

    public void copyToClipboard() {
        BufferedImage image = GUIToolBox.takeScreenshot((Component)this.getCanvas());
        image = GUIToolBox.crop(image);
        GUIToolBox.copyToClipboard(image);
    }

    public void export() throws IOException, PuckException {
        File targetFile = KinOathExportFileSelector.showSelectorDialog(null, null);
        if (targetFile != null) {
            if (targetFile.getName().endsWith("png")) {
                GUIToolBox.saveScreenshot((Component)this.getCanvas(), targetFile);
            } else {
                KinOathFile.save(targetFile, this.diagram, "Exported from PUCK");
            }
        }
    }

    public void resetZoom() {
        this.canvas.resetRenderingTransform();
    }

    public void setDocument(Document document) {
        if (this.getCanvas() != null) {
            this.getCanvas().setDocument(document);
        }
    }

    public void updateSource(EntityData[] source) {
        if (source == null) {
            this.diagram = new KinOathDiagram(new EntityData[0]);
        } else if (source.length <= 500) {
            this.diagram = new KinOathDiagram(source);
        } else {
            Object[] buttons = new String[]{"Continue", "Abort"};
            int response = JOptionPane.showOptionDialog(null, "Individual count is huge: " + source.length + ".\n It can take a very long time for a low usable result.", "Warning", 1, 2, null, buttons, buttons[0]);
            this.diagram = response == 0 ? new KinOathDiagram(source) : new KinOathDiagram(new EntityData[0]);
        }
        this.setDocument(this.diagram.getDocument());
    }
}

