/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puckgui.views.kinoath;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Hashtable;
import java.util.ResourceBundle;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.PuckException;
import org.tip.puck.kinoath.IndividualAroundWorker;
import org.tip.puck.kinoath.KinOathDiagram;
import org.tip.puck.kinoath.PruningCriteria;
import org.tip.puck.kinoath.Puck2KinOath;
import org.tip.puck.net.Individual;
import org.tip.puck.net.Individuals;
import org.tip.puckgui.NetGUI;
import org.tip.puckgui.models.IndividualsCellRenderer;
import org.tip.puckgui.models.IndividualsModel;
import org.tip.puckgui.views.MainWindow;
import org.tip.puckgui.views.kinoath.KinOathDiagramPanel;

public class IndividualDiagramsPanel
extends JPanel {
    private static final long serialVersionUID = 651718283569255829L;
    private static final Logger logger = LoggerFactory.getLogger(IndividualDiagramsPanel.class);
    int reportCounter = 0;
    private JPanel thisJPanel = this;
    private JTextField txtfldSearchIndividual;
    private NetGUI netGUI;
    JList individualList;
    JScrollPane individualsScrollPane;
    KinOathDiagram diagram;
    private KinOathDiagramPanel diagramScrollPanel;
    private JSlider parentsSlider;
    private JSlider partnersSlider;
    private JSlider childrenSlider;
    private JCheckBox chckbxAddCollaterals;
    private JCheckBox chckbxAddAffines;
    private static int SLIDER_MAX = 6;
    private JPanel pruningPanel;
    private boolean sliderActive = true;

    public IndividualDiagramsPanel(NetGUI guiManager) {
        this.netGUI = guiManager;
        Hashtable<Integer, JLabel> sliderLabels = new Hashtable<Integer, JLabel>();
        sliderLabels.put(new Integer(0), new JLabel("+0"));
        sliderLabels.put(new Integer(1), new JLabel("+1"));
        sliderLabels.put(new Integer(2), new JLabel("+2"));
        sliderLabels.put(new Integer(3), new JLabel("+3"));
        sliderLabels.put(new Integer(4), new JLabel("+4"));
        sliderLabels.put(new Integer(5), new JLabel("+5"));
        sliderLabels.put(new Integer(6), new JLabel("+\u221e"));
        Object defaultPaintValue = UIManager.get("Slider.paintValue");
        UIManager.put("Slider.paintValue", false);
        this.setLayout(new BoxLayout(this, 1));
        JSplitPane individualsSplit = new JSplitPane();
        this.add(individualsSplit);
        individualsSplit.setAlignmentX(0.5f);
        JPanel individualsPanel = new JPanel();
        individualsPanel.setMinimumSize(new Dimension(200, 10));
        individualsSplit.setLeftComponent(individualsPanel);
        individualsPanel.setLayout(new BoxLayout(individualsPanel, 1));
        this.individualsScrollPane = new JScrollPane();
        this.individualsScrollPane.setVerticalScrollBarPolicy(22);
        individualsPanel.add(this.individualsScrollPane);
        this.individualList = new JList();
        this.individualList.setDoubleBuffered(true);
        this.individualList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent event) {
                logger.debug("event = " + event.getValueIsAdjusting() + " " + event.getFirstIndex() + " " + event.getLastIndex() + " " + IndividualDiagramsPanel.this.individualList.getSelectedIndex());
                if (IndividualDiagramsPanel.this.individualList.getSelectedIndex() != -1) {
                    Individual individual = (Individual)((JList)event.getSource()).getModel().getElementAt(IndividualDiagramsPanel.this.individualList.getSelectedIndex());
                    IndividualDiagramsPanel.this.updateIndividualDiagram(individual);
                }
            }
        });
        this.individualList.setSelectionMode(0);
        this.individualList.setCellRenderer(new IndividualsCellRenderer());
        this.individualList.setModel(new IndividualsModel(null));
        this.individualsScrollPane.setViewportView(this.individualList);
        JPanel diagramZonePanel = new JPanel();
        individualsSplit.setRightComponent(diagramZonePanel);
        diagramZonePanel.setAlignmentX(0.0f);
        diagramZonePanel.setAlignmentY(0.0f);
        diagramZonePanel.setLayout(new BorderLayout(0, 0));
        JPanel parametersPanel = new JPanel();
        diagramZonePanel.add((Component)parametersPanel, "North");
        parametersPanel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC}));
        this.pruningPanel = new JPanel();
        parametersPanel.add((Component)this.pruningPanel, "2, 2");
        this.pruningPanel.setBorder(new TitledBorder(null, "Pruning", 4, 2, null, null));
        this.pruningPanel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC}));
        JLabel lblParentDepth = new JLabel(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("IndividualDiagramPanel.lblParentDepth.text"));
        this.pruningPanel.add((Component)lblParentDepth, "2, 2, default, center");
        this.parentsSlider = new JSlider();
        this.parentsSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent event) {
                if (event.getSource() instanceof JSlider && !((JSlider)event.getSource()).getValueIsAdjusting() && IndividualDiagramsPanel.this.sliderActive) {
                    IndividualDiagramsPanel.this.updateIndividualDiagram();
                }
            }
        });
        this.parentsSlider.setSnapToTicks(true);
        this.pruningPanel.add((Component)this.parentsSlider, "4, 2");
        this.parentsSlider.setMajorTickSpacing(1);
        this.parentsSlider.setValue(1);
        this.parentsSlider.setMaximum(6);
        this.chckbxAddCollaterals = new JCheckBox(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("IndividualDiagramPanel.chckbxAddCollaterals.text"));
        this.chckbxAddCollaterals.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                IndividualDiagramsPanel.this.updateIndividualDiagram();
            }
        });
        this.pruningPanel.add((Component)this.chckbxAddCollaterals, "6, 2");
        JLabel lblPartner = new JLabel(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("IndividualDiagramPanel.lblPartner.text"));
        this.pruningPanel.add((Component)lblPartner, "2, 4, default, center");
        this.partnersSlider = new JSlider();
        this.partnersSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent event) {
                if (event.getSource() instanceof JSlider && !((JSlider)event.getSource()).getValueIsAdjusting() && IndividualDiagramsPanel.this.sliderActive) {
                    IndividualDiagramsPanel.this.updateIndividualDiagram();
                }
            }
        });
        this.pruningPanel.add((Component)this.partnersSlider, "4, 4");
        this.partnersSlider.setMajorTickSpacing(1);
        this.partnersSlider.setValue(3);
        this.partnersSlider.setMaximum(6);
        this.partnersSlider.setSnapToTicks(true);
        JLabel lblChildren = new JLabel(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("IndividualDiagramPanel.lblChildren.text"));
        this.pruningPanel.add((Component)lblChildren, "2, 6, default, top");
        this.childrenSlider = new JSlider();
        this.childrenSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent event) {
                if (event.getSource() instanceof JSlider && !((JSlider)event.getSource()).getValueIsAdjusting() && IndividualDiagramsPanel.this.sliderActive) {
                    IndividualDiagramsPanel.this.updateIndividualDiagram();
                }
            }
        });
        this.pruningPanel.add((Component)this.childrenSlider, "4, 6");
        this.childrenSlider.setValue(2);
        this.childrenSlider.setMajorTickSpacing(1);
        this.childrenSlider.setMaximum(6);
        this.childrenSlider.setSnapToTicks(true);
        this.childrenSlider.setPaintLabels(true);
        this.childrenSlider.setPaintTicks(true);
        this.chckbxAddAffines = new JCheckBox(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("IndividualDiagramPanel.chckbxAddAffines.text"));
        this.chckbxAddAffines.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                IndividualDiagramsPanel.this.updateIndividualDiagram();
            }
        });
        this.pruningPanel.add((Component)this.chckbxAddAffines, "6, 6, default, top");
        JPanel panel = new JPanel();
        parametersPanel.add((Component)panel, "4, 2, fill, fill");
        panel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormFactory.RELATED_GAP_COLSPEC}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        JButton btnDirect = new JButton(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("IndividualDiagramPanel.btnDirect.text"));
        btnDirect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                IndividualDiagramsPanel.this.setCriteria(PruningCriteria.DIRECT);
                IndividualDiagramsPanel.this.updateIndividualDiagram();
            }
        });
        panel.add((Component)btnDirect, "2, 2");
        JButton btnGrand = new JButton(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("IndividualDiagramPanel.btnGrand.text"));
        btnGrand.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                IndividualDiagramsPanel.this.setCriteria(PruningCriteria.GRAND);
                IndividualDiagramsPanel.this.updateIndividualDiagram();
            }
        });
        JButton btnExport = new JButton(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("IndividualDiagramPanel.btnExport.text"));
        btnExport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    IndividualDiagramsPanel.this.diagramScrollPanel.export();
                }
                catch (IOException exception) {
                    exception.printStackTrace();
                }
                catch (PuckException exception) {
                    exception.printStackTrace();
                }
            }
        });
        panel.add((Component)btnExport, "4, 2");
        panel.add((Component)btnGrand, "2, 4");
        JButton btnGreat = new JButton(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("IndividualDiagramPanel.btnGreat.text"));
        btnGreat.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                IndividualDiagramsPanel.this.setCriteria(PruningCriteria.GREAT);
                IndividualDiagramsPanel.this.updateIndividualDiagram();
            }
        });
        JButton btnCopy = new JButton(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("IndividualDiagramPanel.btnCopy.text"));
        btnCopy.setToolTipText(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("IndividualDiagramPanel.btnCopy.toolTipText"));
        btnCopy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                IndividualDiagramsPanel.this.diagramScrollPanel.copyToClipboard();
            }
        });
        panel.add((Component)btnCopy, "4, 4");
        panel.add((Component)btnGreat, "2, 6");
        JButton btnFull = new JButton(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("IndividualDiagramPanel.btnFull.text"));
        btnFull.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                IndividualDiagramsPanel.this.setCriteria(PruningCriteria.FULL);
                IndividualDiagramsPanel.this.updateIndividualDiagram();
            }
        });
        panel.add((Component)btnFull, "2, 8");
        JButton btnResetZoom = new JButton(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("GlobalDiagramPanel.btnResetZoom.text"));
        panel.add((Component)btnResetZoom, "4, 8");
        btnResetZoom.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                IndividualDiagramsPanel.this.diagramScrollPanel.resetZoom();
            }
        });
        this.childrenSlider.setLabelTable(sliderLabels);
        JPanel diagramPanel = new JPanel();
        diagramZonePanel.add(diagramPanel);
        JPanel bottomButtonsPanel = new JPanel();
        this.add(bottomButtonsPanel);
        bottomButtonsPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        bottomButtonsPanel.setLayout(new BoxLayout(bottomButtonsPanel, 0));
        JButton btnIndividualsPrevious = new JButton(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.btnPrevious.text"));
        btnIndividualsPrevious.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                int selectedIndex = IndividualDiagramsPanel.this.individualList.getSelectedIndex();
                if (selectedIndex == -1) {
                    int size = IndividualDiagramsPanel.this.individualList.getModel().getSize();
                    if (size != 0) {
                        selectedIndex = size - 1;
                        IndividualDiagramsPanel.this.individualList.setSelectedIndex(selectedIndex);
                        IndividualDiagramsPanel.this.individualList.ensureIndexIsVisible(selectedIndex);
                    }
                } else if (selectedIndex > 0) {
                    IndividualDiagramsPanel.this.individualList.setSelectedIndex(--selectedIndex);
                    IndividualDiagramsPanel.this.individualList.ensureIndexIsVisible(selectedIndex);
                }
            }
        });
        Component horizontalStrut_6 = Box.createHorizontalStrut(20);
        bottomButtonsPanel.add(horizontalStrut_6);
        JButton btnClose = new JButton(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("IndividualDiagramPanel.btnClose.text"));
        btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                IndividualDiagramsPanel.this.netGUI.closeCurrentTab();
            }
        });
        bottomButtonsPanel.add(btnClose);
        Component horizontalGlue_1 = Box.createHorizontalGlue();
        bottomButtonsPanel.add(horizontalGlue_1);
        JButton btnSort = new JButton(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("IndividualsPanel.btnSort.text"));
        btnSort.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Individual selectedIndividual = IndividualDiagramsPanel.this.getSelectedIndividual();
                ((IndividualsModel)IndividualDiagramsPanel.this.individualList.getModel()).touchSorting();
                if (selectedIndividual != null) {
                    IndividualDiagramsPanel.this.select(selectedIndividual);
                }
            }
        });
        bottomButtonsPanel.add(btnSort);
        Component horizontalGlue_4 = Box.createHorizontalGlue();
        bottomButtonsPanel.add(horizontalGlue_4);
        bottomButtonsPanel.add(btnIndividualsPrevious);
        JButton btnIndividualsNext = new JButton(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.btnNext.text"));
        btnIndividualsNext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                int selectedIndex = IndividualDiagramsPanel.this.individualList.getSelectedIndex();
                int size = IndividualDiagramsPanel.this.individualList.getModel().getSize();
                if (selectedIndex == -1) {
                    if (size != 0) {
                        selectedIndex = 0;
                        IndividualDiagramsPanel.this.individualList.setSelectedIndex(selectedIndex);
                        IndividualDiagramsPanel.this.individualList.ensureIndexIsVisible(selectedIndex);
                    }
                } else if (selectedIndex < size - 1) {
                    IndividualDiagramsPanel.this.individualList.setSelectedIndex(++selectedIndex);
                    IndividualDiagramsPanel.this.individualList.ensureIndexIsVisible(selectedIndex);
                }
            }
        });
        bottomButtonsPanel.add(btnIndividualsNext);
        Component horizontalGlue = Box.createHorizontalGlue();
        bottomButtonsPanel.add(horizontalGlue);
        JPanel panel_13 = new JPanel();
        bottomButtonsPanel.add(panel_13);
        panel_13.setLayout(new BoxLayout(panel_13, 0));
        JLabel lblIndividualsSearch = new JLabel(" ");
        lblIndividualsSearch.setToolTipText(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.lblSearch.text"));
        lblIndividualsSearch.setIcon(new ImageIcon(MainWindow.class.getResource("/org/tip/puckgui/images/find.png")));
        bottomButtonsPanel.add(lblIndividualsSearch);
        lblIndividualsSearch.setMinimumSize(new Dimension(300, 15));
        this.txtfldSearchIndividual = new JTextField();
        this.txtfldSearchIndividual.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int index;
                String pattern = IndividualDiagramsPanel.this.txtfldSearchIndividual.getText();
                logger.debug("Search individual=[" + pattern + "]");
                if (StringUtils.isNotBlank((CharSequence)pattern) && (index = ((IndividualsModel)IndividualDiagramsPanel.this.individualList.getModel()).nextSearchedIndividualIndex(pattern)) != -1) {
                    IndividualDiagramsPanel.this.individualList.setSelectedIndex(index);
                    IndividualDiagramsPanel.this.individualList.ensureIndexIsVisible(index);
                }
            }
        });
        bottomButtonsPanel.add(this.txtfldSearchIndividual);
        this.txtfldSearchIndividual.setMaximumSize(new Dimension(500, 50));
        this.txtfldSearchIndividual.setText("");
        this.txtfldSearchIndividual.setColumns(15);
        this.diagramScrollPanel = new KinOathDiagramPanel();
        diagramPanel.setLayout(new BorderLayout(0, 0));
        diagramPanel.add((Component)((Object)this.diagramScrollPanel));
        JLabel lblHelp = new JLabel(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("IndividualDiagramPanel.lblHelp.text"));
        diagramZonePanel.add((Component)lblHelp, "South");
        UIManager.put("Slider.paintValue", defaultPaintValue);
        this.setCriteria(PruningCriteria.GRAND);
    }

    public PruningCriteria getCriteria() {
        PruningCriteria result = new PruningCriteria();
        if (this.parentsSlider.getValue() == SLIDER_MAX) {
            result.setParentsDepth(Integer.MAX_VALUE);
        } else {
            result.setParentsDepth(this.parentsSlider.getValue());
        }
        if (this.partnersSlider.getValue() == SLIDER_MAX) {
            result.setPartnersDepth(Integer.MAX_VALUE);
        } else {
            result.setPartnersDepth(this.partnersSlider.getValue());
        }
        if (this.childrenSlider.getValue() == SLIDER_MAX) {
            result.setChildrenDepth(Integer.MAX_VALUE);
        } else {
            result.setChildrenDepth(this.childrenSlider.getValue());
        }
        result.setCollaterals(this.chckbxAddCollaterals.isSelected());
        result.setAffines(this.chckbxAddAffines.isSelected());
        return result;
    }

    public Individual getSelectedIndividual() {
        Individual result = this.individualList.getSelectedIndex() == -1 ? null : (Individual)((IndividualsModel)this.individualList.getModel()).getElementAt(this.individualList.getSelectedIndex());
        return result;
    }

    public void select(Individual individual) {
        int individualIndex = ((IndividualsModel)this.individualList.getModel()).indexOf(individual);
        if (individualIndex >= 0 && individualIndex < ((IndividualsModel)this.individualList.getModel()).getSize()) {
            this.individualList.setSelectedIndex(individualIndex);
            this.individualList.ensureIndexIsVisible(individualIndex);
        } else if (((IndividualsModel)this.individualList.getModel()).getSize() != 0) {
            this.individualList.setSelectedIndex(0);
            this.individualList.ensureIndexIsVisible(0);
        } else {
            this.updateIndividualDiagram(null);
        }
    }

    public void selectByIndex(int individualIndex) {
        if (individualIndex >= 0 && individualIndex < ((IndividualsModel)this.individualList.getModel()).getSize()) {
            this.individualList.setSelectedIndex(individualIndex);
            this.individualList.ensureIndexIsVisible(individualIndex);
        } else if (((IndividualsModel)this.individualList.getModel()).getSize() != 0) {
            this.individualList.setSelectedIndex(0);
            this.individualList.ensureIndexIsVisible(0);
        } else {
            this.updateIndividualDiagram(null);
        }
    }

    public void setCriteria(PruningCriteria source) {
        this.sliderActive = false;
        this.parentsSlider.setValue(source.getParentsDepth());
        this.partnersSlider.setValue(source.getPartnersDepth());
        this.childrenSlider.setValue(source.getChildrenDepth());
        this.chckbxAddCollaterals.setSelected(source.isCollaterals());
        this.chckbxAddAffines.setSelected(source.isAffines());
        this.sliderActive = true;
    }

    public void setFocusOnFind() {
        this.txtfldSearchIndividual.requestFocus();
    }

    public void update() {
        int selectedIndividual = this.individualList.getSelectedIndex();
        ((IndividualsModel)this.individualList.getModel()).setSource(this.netGUI.getCurrentIndividuals());
        this.selectByIndex(selectedIndividual);
    }

    public void update(Individual individual) {
        ((IndividualsModel)this.individualList.getModel()).setSource(this.netGUI.getCurrentIndividuals());
        this.select(individual);
    }

    public void updateIndividualDiagram() {
        this.updateIndividualDiagram(this.getSelectedIndividual());
    }

    public void updateIndividualDiagram(Individual source) {
        if (source == null) {
            logger.debug("updateIndividualDiagram(null)");
        } else {
            logger.debug("updateIndividualDiagram(" + source.getId() + ")");
            Individuals target = IndividualAroundWorker.searchAround(source, this.getCriteria());
            logger.debug("around count=" + target.size());
            this.diagramScrollPanel.updateSource(Puck2KinOath.convert(target));
        }
    }
}

