/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puckgui.views.geo;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.SwingWorker;
import javax.swing.border.EmptyBorder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.graphs.Graph;
import org.tip.puck.io.csv.CSVFile;
import org.tip.puckgui.GroupNetGUI;
import org.tip.puckgui.NetGUI;
import org.tip.puckgui.views.geo.Geocode;

public class ConfigGeocodingDialog
extends JDialog {
    private static final long serialVersionUID = -7468130858005234778L;
    private static final Logger logger = LoggerFactory.getLogger(CSVFile.class);
    private GroupNetGUI parentGui = null;
    private NetGUI netGUI = null;
    private Graph<?> graph = null;
    private File csvFile = null;
    private final JPanel contentPanel = new JPanel();
    private JTextField textGeonamesFile;
    private JTextField txtCsv;
    JButton btnOpenGeonamesFile;
    JButton btnOpenPersonnalSources;

    public ConfigGeocodingDialog(NetGUI gui, Graph<?> graph) {
        this.graph = graph;
        this.netGUI = gui;
        this.initialize();
    }

    public ConfigGeocodingDialog(GroupNetGUI gui) {
        this.parentGui = gui;
        this.initialize();
    }

    private void initialize() {
        this.setTitle("Configure Geocoding");
        this.setBounds(100, 100, 450, 258);
        this.getContentPane().setLayout(new BorderLayout());
        this.contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)this.contentPanel, "Center");
        this.contentPanel.setLayout(null);
        JLabel lblGeocodingSources = new JLabel("Geocoding sources :");
        lblGeocodingSources.setBounds(12, 12, 151, 15);
        this.contentPanel.add(lblGeocodingSources);
        JCheckBox chckbxGeonames = new JCheckBox("Geonames");
        chckbxGeonames.setSelected(true);
        chckbxGeonames.setToolTipText("Web connection is needed");
        chckbxGeonames.setBounds(33, 35, 129, 23);
        this.contentPanel.add(chckbxGeonames);
        JCheckBox chckbxPersonnalSources = new JCheckBox("Personnal sources");
        chckbxPersonnalSources.setEnabled(false);
        chckbxPersonnalSources.setBounds(33, 86, 170, 23);
        this.contentPanel.add(chckbxPersonnalSources);
        JCheckBox chckbxGeonamesFile = new JCheckBox("Geonames file");
        chckbxGeonamesFile.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    ConfigGeocodingDialog.this.textGeonamesFile.setEnabled(true);
                    ConfigGeocodingDialog.this.btnOpenGeonamesFile.setEnabled(true);
                } else {
                    ConfigGeocodingDialog.this.textGeonamesFile.setEnabled(false);
                    ConfigGeocodingDialog.this.btnOpenGeonamesFile.setEnabled(false);
                }
            }
        });
        chckbxGeonamesFile.setBounds(33, 59, 140, 23);
        this.contentPanel.add(chckbxGeonamesFile);
        final JProgressBar progressBar = new JProgressBar();
        progressBar.setBounds(12, 156, 424, 14);
        progressBar.setVisible(false);
        this.contentPanel.add(progressBar);
        this.textGeonamesFile = new JTextField();
        this.textGeonamesFile.setBounds(206, 61, 114, 19);
        this.contentPanel.add(this.textGeonamesFile);
        this.textGeonamesFile.setColumns(10);
        this.btnOpenGeonamesFile = new JButton("Open");
        this.btnOpenGeonamesFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JFileChooser fc = new JFileChooser();
                int returnVal = fc.showOpenDialog(ConfigGeocodingDialog.this);
                if (returnVal == 0) {
                    ConfigGeocodingDialog.this.csvFile = fc.getSelectedFile();
                    logger.debug("Opening CSV file: " + ConfigGeocodingDialog.this.csvFile.getName() + ".");
                } else {
                    logger.debug("Open CSV command cancelled by user.");
                }
                ConfigGeocodingDialog.this.textGeonamesFile.setText(ConfigGeocodingDialog.this.csvFile.getAbsolutePath());
            }
        });
        this.btnOpenGeonamesFile.setBounds(332, 63, 72, 15);
        this.contentPanel.add(this.btnOpenGeonamesFile);
        this.txtCsv = new JTextField();
        this.txtCsv.setText("csv ?");
        this.txtCsv.setEnabled(false);
        this.txtCsv.setBounds(206, 88, 114, 19);
        this.contentPanel.add(this.txtCsv);
        this.txtCsv.setColumns(10);
        this.btnOpenPersonnalSources = new JButton("Open");
        this.btnOpenPersonnalSources.setEnabled(false);
        this.btnOpenPersonnalSources.setBounds(332, 90, 72, 15);
        this.contentPanel.add(this.btnOpenPersonnalSources);
        JPanel buttonPane = new JPanel();
        buttonPane.setBounds(12, 182, 424, 35);
        this.contentPanel.add(buttonPane);
        buttonPane.setLayout(new FlowLayout(2));
        JButton geocodeButton = new JButton("Geocode");
        geocodeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                progressBar.setVisible(true);
                progressBar.setEnabled(true);
                SwingWorker geocodingTask = null;
                if (ConfigGeocodingDialog.this.parentGui != null) {
                    geocodingTask = new Geocode(ConfigGeocodingDialog.this, progressBar, "geonames", ConfigGeocodingDialog.this.parentGui);
                }
                if (ConfigGeocodingDialog.this.graph != null) {
                    geocodingTask = new Geocode(ConfigGeocodingDialog.this, progressBar, "geonames", ConfigGeocodingDialog.this.netGUI, ConfigGeocodingDialog.this.graph);
                }
                if (ConfigGeocodingDialog.this.csvFile != null) {
                    geocodingTask = new Geocode(ConfigGeocodingDialog.this, progressBar, "geonamesFile", ConfigGeocodingDialog.this.csvFile, ConfigGeocodingDialog.this.graph);
                }
                geocodingTask.execute();
            }
        });
        geocodeButton.setActionCommand("OK");
        buttonPane.add(geocodeButton);
        this.getRootPane().setDefaultButton(geocodeButton);
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ConfigGeocodingDialog.this.dispose();
            }
        });
        cancelButton.setActionCommand("Cancel");
        buttonPane.add(cancelButton);
    }
}

