/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puckgui.views;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import fr.devinsy.util.StringList;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.net.relations.RelationModel;
import org.tip.puck.net.relations.RelationModels;
import org.tip.puck.net.relations.Role;
import org.tip.puck.net.workers.AttributeDescriptors;
import org.tip.puck.segmentation.Segmentation;
import org.tip.puck.spacetime.SpaceTimeCriteria;

public class SpaceTimeAnalysisInputDialog
extends JDialog {
    private static final long serialVersionUID = -7326870100552727961L;
    private static final Logger logger = LoggerFactory.getLogger(SpaceTimeAnalysisInputDialog.class);
    private RelationModels relationModels;
    private AttributeDescriptors attributeDescriptors;
    private final JPanel contentPanel = new JPanel();
    private SpaceTimeCriteria dialogCriteria;
    private static SpaceTimeCriteria lastCriteria = new SpaceTimeCriteria();
    private JComboBox cmbbxRelationModel;
    private JComboBox cmbbxEgoRole;
    private JComboBox cmbbxDateLabel;
    private JSpinner spnnrMaxAge;
    private JButton okButton;
    private JPanel alterRolesPanel;
    private JTextField textField;
    private JTextField textField_1;

    public SpaceTimeAnalysisInputDialog(Segmentation segmentation, RelationModels relationModels, AttributeDescriptors attributeDescriptors) {
        this.relationModels = relationModels;
        this.attributeDescriptors = attributeDescriptors;
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.setModal(true);
        this.setAlwaysOnTop(true);
        this.setTitle("Space-Time Analysis Input Dialog");
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(SpaceTimeAnalysisInputDialog.class.getResource("/org/tip/puckgui/favicon-16x16.jpg")));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                SpaceTimeAnalysisInputDialog.this.dialogCriteria = null;
                SpaceTimeAnalysisInputDialog.this.setVisible(false);
            }
        });
        this.setBounds(100, 100, 1150, 761);
        this.getContentPane().setLayout(new BorderLayout());
        this.contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)this.contentPanel, "Center");
        this.contentPanel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{ColumnSpec.decode((String)"max(175dlu;default)"), FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"max(100dlu;default)"), FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow")}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC}));
        JPanel panel = new JPanel();
        this.contentPanel.add((Component)panel, "1, 2, fill, fill");
        panel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormFactory.RELATED_GAP_COLSPEC}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        JLabel lblRelationModel = new JLabel("Relation Model:");
        panel.add((Component)lblRelationModel, "2, 2");
        this.cmbbxRelationModel = new JComboBox<Object>(relationModels.nameList().toArray());
        panel.add((Component)this.cmbbxRelationModel, "4, 2");
        this.cmbbxRelationModel.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                if (event.getStateChange() == 1) {
                    SpaceTimeAnalysisInputDialog.this.setRelationModel(SpaceTimeAnalysisInputDialog.this.cmbbxRelationModel.getSelectedIndex(), null, null);
                }
            }
        });
        JPanel constructionOptionsPanel = new JPanel();
        constructionOptionsPanel.setBorder(new TitledBorder(null, "Constructions Options", 4, 2, null, null));
        this.contentPanel.add((Component)constructionOptionsPanel, "1, 4, fill, fill");
        constructionOptionsPanel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormFactory.RELATED_GAP_COLSPEC}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"max(75dlu;default)"), FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC}));
        JLabel lblDateLabel = new JLabel("Date Label:");
        constructionOptionsPanel.add((Component)lblDateLabel, "2, 2, right, default");
        this.cmbbxDateLabel = new JComboBox();
        constructionOptionsPanel.add((Component)this.cmbbxDateLabel, "4, 2");
        JLabel lblStartDateLabel = new JLabel("Start Date Label:");
        constructionOptionsPanel.add((Component)lblStartDateLabel, "2, 4, right, default");
        JComboBox comboBox = new JComboBox();
        constructionOptionsPanel.add(comboBox, "4, 4");
        JLabel lblEndDateLabel = new JLabel("End Date Label:");
        constructionOptionsPanel.add((Component)lblEndDateLabel, "2, 6, right, default");
        comboBox = new JComboBox();
        constructionOptionsPanel.add(comboBox, "4, 6");
        JLabel lblPlaceLabel = new JLabel("Place Label:");
        constructionOptionsPanel.add((Component)lblPlaceLabel, "2, 8, right, default");
        comboBox = new JComboBox();
        constructionOptionsPanel.add(comboBox, "4, 8");
        JLabel lblLocalUnitLabel = new JLabel("Local Unit Label:");
        constructionOptionsPanel.add((Component)lblLocalUnitLabel, "2, 10, right, default");
        comboBox = new JComboBox();
        constructionOptionsPanel.add(comboBox, "4, 10");
        JLabel lblEgoRole = new JLabel("Ego Role:");
        constructionOptionsPanel.add((Component)lblEgoRole, "2, 12, right, default");
        this.cmbbxEgoRole = new JComboBox();
        constructionOptionsPanel.add((Component)this.cmbbxEgoRole, "4, 12");
        JLabel lblDefaultReferentRole = new JLabel("<html><div style=\"text-align: right;\">Default Referent<br/>Role Name</div></html>");
        constructionOptionsPanel.add((Component)lblDefaultReferentRole, "2, 14, right, default");
        comboBox = new JComboBox();
        constructionOptionsPanel.add(comboBox, "4, 14");
        JLabel lblAlterRoles = new JLabel("Alter Roles:");
        constructionOptionsPanel.add((Component)lblAlterRoles, "2, 16, right, top");
        JScrollPane alterRolesScrollPane = new JScrollPane();
        alterRolesScrollPane.setVerticalScrollBarPolicy(22);
        constructionOptionsPanel.add((Component)alterRolesScrollPane, "4, 16, fill, fill");
        this.alterRolesPanel = new JPanel();
        alterRolesScrollPane.setViewportView(this.alterRolesPanel);
        this.alterRolesPanel.setLayout(new BoxLayout(this.alterRolesPanel, 1));
        JLabel lblDates = new JLabel("Dates:");
        constructionOptionsPanel.add((Component)lblDates, "2, 18, right, default");
        this.textField = new JTextField();
        constructionOptionsPanel.add((Component)this.textField, "4, 18");
        this.textField.setColumns(10);
        JLabel lblGeography = new JLabel("Geography:");
        constructionOptionsPanel.add((Component)lblGeography, "2, 20, right, default");
        comboBox = new JComboBox();
        constructionOptionsPanel.add(comboBox, "4, 20");
        JLabel lblLevel = new JLabel("Level:");
        constructionOptionsPanel.add((Component)lblLevel, "2, 22, right, default");
        comboBox = new JComboBox();
        constructionOptionsPanel.add(comboBox, "4, 22");
        JLabel lblMinimalPlaceNames = new JLabel("Minimal Place Names:");
        constructionOptionsPanel.add((Component)lblMinimalPlaceNames, "2, 24, right, default");
        this.textField_1 = new JTextField();
        constructionOptionsPanel.add((Component)this.textField_1, "4, 24");
        this.textField_1.setColumns(10);
        JLabel lblMinAge = new JLabel("Min Age:");
        constructionOptionsPanel.add((Component)lblMinAge, "2, 26, right, default");
        JSpinner spinner = new JSpinner();
        constructionOptionsPanel.add((Component)spinner, "4, 26");
        spinner.setModel(new SpinnerNumberModel(new Integer(0), new Integer(0), null, new Integer(1)));
        JLabel lblMaxAge = new JLabel("Max Age:");
        constructionOptionsPanel.add((Component)lblMaxAge, "2, 28, right, default");
        this.spnnrMaxAge = new JSpinner();
        constructionOptionsPanel.add((Component)this.spnnrMaxAge, "4, 28");
        this.spnnrMaxAge.setModel(new SpinnerNumberModel(new Integer(0), new Integer(0), null, new Integer(1)));
        JLabel lblExpansionMode = new JLabel("Expansion Mode:");
        constructionOptionsPanel.add((Component)lblExpansionMode, "2, 30, right, default");
        comboBox = new JComboBox();
        constructionOptionsPanel.add(comboBox, "4, 30");
        JLabel lblFiliationType = new JLabel("Filiation Type:");
        constructionOptionsPanel.add((Component)lblFiliationType, "2, 32, right, default");
        comboBox = new JComboBox();
        constructionOptionsPanel.add(comboBox, "4, 32");
        JPanel column2Panel = new JPanel();
        this.contentPanel.add((Component)column2Panel, "3, 4, fill, fill");
        column2Panel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.DEFAULT_COLSPEC}, new RowSpec[]{FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"default:grow")}));
        JPanel repotOptionsPanel = new JPanel();
        column2Panel.add((Component)repotOptionsPanel, "1, 1");
        repotOptionsPanel.setBorder(new TitledBorder(new TitledBorder(new LineBorder(new Color(184, 207, 229)), "", 4, 2, null, new Color(51, 51, 51)), "Report Options", 4, 2, null, new Color(51, 51, 51)));
        repotOptionsPanel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow")}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"default:grow"), FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"default:grow")}));
        JLabel lblSequenceReportType = new JLabel("<html><div style=\"text-align: right;\">Sequence<br/>Report Type:</div></html>");
        repotOptionsPanel.add((Component)lblSequenceReportType, "2, 2, right, top");
        JPanel panel_1 = new JPanel();
        repotOptionsPanel.add((Component)panel_1, "4, 2, fill, fill");
        panel_1.setLayout(new BoxLayout(panel_1, 1));
        JCheckBox chckbxItinerariessurvey = new JCheckBox("Itineraries (Survey)");
        panel_1.add(chckbxItinerariessurvey);
        JCheckBox chckbxItinerariesdetails = new JCheckBox("Itineraries (Details)");
        panel_1.add(chckbxItinerariesdetails);
        JCheckBox chckbxBiographies = new JCheckBox("Biographies");
        panel_1.add(chckbxBiographies);
        JCheckBox chckbxExtendedBiographies = new JCheckBox("Extended Biographies");
        panel_1.add(chckbxExtendedBiographies);
        JCheckBox chckbxActoreventTables = new JCheckBox("Actor-Event Tables");
        panel_1.add(chckbxActoreventTables);
        JCheckBox chckbxInteractionTables = new JCheckBox("Interaction Tables");
        panel_1.add(chckbxInteractionTables);
        JLabel lblSliceReportType = new JLabel("<html><div style=\"text-align: right\">Slice<br/>Report Type:</div></html>");
        repotOptionsPanel.add((Component)lblSliceReportType, "2, 4, right, top");
        panel_1 = new JPanel();
        repotOptionsPanel.add((Component)panel_1, "4, 4, fill, fill");
        panel_1.setLayout(new BoxLayout(panel_1, 1));
        JCheckBox chckbxMembership = new JCheckBox("Membership");
        panel_1.add(chckbxMembership);
        JPanel SequenceCensusTypePanel = new JPanel();
        column2Panel.add((Component)SequenceCensusTypePanel, "1, 3");
        SequenceCensusTypePanel.setBorder(new TitledBorder(new LineBorder(new Color(184, 207, 229)), "Sequence Census Options", 4, 2, null, new Color(51, 51, 51)));
        SequenceCensusTypePanel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow")}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC}));
        JLabel lblCensusType = new JLabel("<html><div style=\"text-align: right;\">Sequence<br/>Census Type:</div></html>");
        SequenceCensusTypePanel.add((Component)lblCensusType, "2, 2, right, top");
        panel_1 = new JPanel();
        SequenceCensusTypePanel.add((Component)panel_1, "4, 2, fill, fill");
        panel_1.setLayout(new BoxLayout(panel_1, 1));
        JCheckBox chckbxGeneral = new JCheckBox("General");
        panel_1.add(chckbxGeneral);
        JCheckBox chckbxEgonetworks = new JCheckBox("EgoNetworks");
        panel_1.add(chckbxEgonetworks);
        JCheckBox chckbxParcours = new JCheckBox("Parcours");
        panel_1.add(chckbxParcours);
        JCheckBox chckbxParcoursNetworks = new JCheckBox("Parcours Networks");
        panel_1.add(chckbxParcoursNetworks);
        JPanel partitionCriteriaPanel = new JPanel();
        column2Panel.add((Component)partitionCriteriaPanel, "1, 5");
        partitionCriteriaPanel.setBorder(new TitledBorder(new TitledBorder(new LineBorder(new Color(184, 207, 229)), "", 4, 2, null, new Color(51, 51, 51)), "Partition Criteria", 4, 2, null, new Color(51, 51, 51)));
        partitionCriteriaPanel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow")}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"default:grow")}));
        JLabel lblIndividualClassificationType = new JLabel("<html><div style=\"text-align: right;\">Individual<br/>Classification Type:</div></html>");
        partitionCriteriaPanel.add((Component)lblIndividualClassificationType, "2, 2, right, default");
        JComboBox comboBox2 = new JComboBox();
        partitionCriteriaPanel.add(comboBox2, "4, 2, fill, default");
        JLabel lblRelationClassificationType = new JLabel("<html><div style=\"text-align: right;\">Relation<br/>Classification Type:</div<</html>");
        partitionCriteriaPanel.add((Component)lblRelationClassificationType, "2, 4, right, top");
        panel_1 = new JPanel();
        partitionCriteriaPanel.add((Component)panel_1, "4, 4, fill, fill");
        panel_1.setLayout(new BoxLayout(panel_1, 1));
        JCheckBox chckbxEvents = new JCheckBox("Events");
        panel_1.add(chckbxEvents);
        JCheckBox chckbxAge = new JCheckBox("Age");
        panel_1.add(chckbxAge);
        JCheckBox chckbxRelations = new JCheckBox("Relations");
        panel_1.add(chckbxRelations);
        JPanel generalStatisticsPanel = new JPanel();
        column2Panel.add((Component)generalStatisticsPanel, "1, 7");
        generalStatisticsPanel.setBorder(new TitledBorder(new TitledBorder(new LineBorder(new Color(184, 207, 229)), "", 4, 2, null, new Color(51, 51, 51)), "General Statistics", 4, 2, null, new Color(51, 51, 51)));
        generalStatisticsPanel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow")}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"default:grow")}));
        JLabel lblCensusOperationLabels = new JLabel("Census Operation:");
        generalStatisticsPanel.add((Component)lblCensusOperationLabels, "2, 2, default, top");
        panel_1 = new JPanel();
        generalStatisticsPanel.add((Component)panel_1, "4, 2, fill, fill");
        panel_1.setLayout(new BoxLayout(panel_1, 1));
        JCheckBox chckbxEvents_1 = new JCheckBox("Events");
        panel_1.add(chckbxEvents_1);
        JCheckBox checkBox = new JCheckBox("Age");
        panel_1.add(checkBox);
        checkBox = new JCheckBox("Relations");
        panel_1.add(checkBox);
        JPanel column3Panel = new JPanel();
        this.contentPanel.add((Component)column3Panel, "5, 4, fill, fill");
        column3Panel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{ColumnSpec.decode((String)"default:grow")}, new RowSpec[]{FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"default:grow"), FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"default:grow"), FormFactory.RELATED_GAP_ROWSPEC}));
        JPanel egoNetworkdStatisticsPanel = new JPanel();
        column3Panel.add((Component)egoNetworkdStatisticsPanel, "1, 1");
        egoNetworkdStatisticsPanel.setBorder(new TitledBorder(new TitledBorder(new LineBorder(new Color(184, 207, 229)), "", 4, 2, null, new Color(51, 51, 51)), "Ego Networks", 4, 2, null, new Color(51, 51, 51)));
        egoNetworkdStatisticsPanel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormFactory.RELATED_GAP_COLSPEC}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"default:grow"), FormFactory.RELATED_GAP_ROWSPEC}));
        JLabel lblCensusOperationLabels_1 = new JLabel("Census Operation:");
        egoNetworkdStatisticsPanel.add((Component)lblCensusOperationLabels_1, "2, 2, right, top");
        panel_1 = new JPanel();
        egoNetworkdStatisticsPanel.add((Component)panel_1, "4, 2, fill, fill");
        panel_1.setLayout(new BoxLayout(panel_1, 1));
        JCheckBox chckbxGeneral_1 = new JCheckBox("General");
        panel_1.add(chckbxGeneral_1);
        JCheckBox chckbxCentrality = new JCheckBox("Centrality");
        panel_1.add(chckbxCentrality);
        JCheckBox chckbxCohesion = new JCheckBox("Cohesion");
        panel_1.add(chckbxCohesion);
        JCheckBox chckbxNewCheckBox = new JCheckBox("Relations");
        panel_1.add(chckbxNewCheckBox);
        JCheckBox chckbxNewCheckBox_1 = new JCheckBox("Export Ego Networks");
        panel_1.add(chckbxNewCheckBox_1);
        JPanel parcoursNetworkStatisticsPanel = new JPanel();
        parcoursNetworkStatisticsPanel.setBorder(new TitledBorder(new LineBorder(new Color(184, 207, 229)), "Parcours Network Statistics", 4, 2, null, new Color(51, 51, 51)));
        column3Panel.add((Component)parcoursNetworkStatisticsPanel, "1, 3, fill, fill");
        parcoursNetworkStatisticsPanel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow")}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"default:grow"), FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"default:grow")}));
        JLabel lblMainRelationClassification = new JLabel("<html><div style=\"text-align: right\">Main Relation<br/>Classification Types:</div></html>");
        parcoursNetworkStatisticsPanel.add((Component)lblMainRelationClassification, "2, 2, right, top");
        JPanel panel2 = new JPanel();
        parcoursNetworkStatisticsPanel.add((Component)panel2, "4, 2, fill, fill");
        panel2.setLayout(new BoxLayout(panel2, 1));
        checkBox = new JCheckBox("xxxx");
        panel2.add(checkBox);
        panel2 = new JPanel();
        parcoursNetworkStatisticsPanel.add((Component)panel2, "2, 4, fill, fill");
        panel2.setLayout(new BoxLayout(panel2, 1));
        JLabel label = new JLabel("Census Operation:");
        panel2.add(label);
        checkBox = new JCheckBox("General");
        panel2.add(checkBox);
        checkBox = new JCheckBox("Centrality");
        panel2.add(checkBox);
        checkBox = new JCheckBox("Cohesion");
        panel2.add(checkBox);
        checkBox = new JCheckBox("Relations");
        panel2.add(checkBox);
        panel2 = new JPanel();
        parcoursNetworkStatisticsPanel.add((Component)panel2, "4, 4, fill, fill");
        panel2.setLayout(new BoxLayout(panel2, 1));
        JCheckBox chckbxExportParcours = new JCheckBox("Export Parcours");
        panel2.add(chckbxExportParcours);
        JCheckBox chckbxExportExtendedParcours = new JCheckBox("Export Extended Parcours");
        panel2.add(chckbxExportExtendedParcours);
        JCheckBox chckbxExportMultipleParcours = new JCheckBox("Export Multiple Parcours");
        panel2.add(chckbxExportMultipleParcours);
        JCheckBox chckbxExportParcoursNetworks = new JCheckBox("Export Parcours Networks");
        panel2.add(chckbxExportParcoursNetworks);
        JCheckBox chckbxExportSimilaryTrees = new JCheckBox("Export Similary Trees");
        panel2.add(chckbxExportSimilaryTrees);
        JPanel typeNetworkStatisticsPanel = new JPanel();
        typeNetworkStatisticsPanel.setBorder(new TitledBorder(new TitledBorder(new LineBorder(new Color(184, 207, 229)), "", 4, 2, null, new Color(51, 51, 51)), "Type Network Statistics", 4, 2, null, new Color(51, 51, 51)));
        column3Panel.add((Component)typeNetworkStatisticsPanel, "1, 5, fill, fill");
        typeNetworkStatisticsPanel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow")}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"default:grow"), FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"default:grow")}));
        JLabel lblMainRelationClassification_1 = new JLabel("<html><div style=\"text-align: right;\">Main Relation<br/>Classification Types:</div></html>");
        typeNetworkStatisticsPanel.add((Component)lblMainRelationClassification_1, "2, 2, right, top");
        panel_1 = new JPanel();
        typeNetworkStatisticsPanel.add((Component)panel_1, "4, 2, fill, fill");
        panel_1.setLayout(new BoxLayout(panel_1, 1));
        JCheckBox chckbxXxxx_1 = new JCheckBox("xxxx");
        panel_1.add(chckbxXxxx_1);
        JLabel lblCensusOperations = new JLabel("Census Operations:");
        typeNetworkStatisticsPanel.add((Component)lblCensusOperations, "2, 4, right, top");
        panel2 = new JPanel();
        typeNetworkStatisticsPanel.add((Component)panel2, "4, 4, fill, fill");
        panel2.setLayout(new BoxLayout(panel2, 1));
        checkBox = new JCheckBox("General");
        panel2.add(checkBox);
        JCheckBox chckbxListTrees = new JCheckBox("List Trees");
        panel2.add(chckbxListTrees);
        JCheckBox chckbxExportEvenType = new JCheckBox("<html>Export Event<br/>Type Networks</html>");
        panel2.add(chckbxExportEvenType);
        JCheckBox chckbxExportSequenceType = new JCheckBox("<html>Export Sequence<br/>Type Networks</html>");
        panel2.add(chckbxExportSequenceType);
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new FlowLayout(1));
        this.getContentPane().add((Component)buttonPane, "South");
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SpaceTimeAnalysisInputDialog.this.dialogCriteria = null;
                SpaceTimeAnalysisInputDialog.this.setVisible(false);
            }
        });
        cancelButton.setActionCommand("Cancel");
        buttonPane.add(cancelButton);
        this.okButton = new JButton("Launch");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SpaceTimeCriteria criteria = SpaceTimeAnalysisInputDialog.this.getCriteria();
                if (criteria.getRelationModelName() == null) {
                    String title = "Invalid input";
                    String message = "A relation model is required to launch.";
                    JOptionPane.showMessageDialog(null, message, title, 0);
                } else if (criteria.getEgoRoleName() == null) {
                    String title = "Invalid input";
                    String message = "An ego role is required to launch.";
                    JOptionPane.showMessageDialog(null, message, title, 0);
                } else if (criteria.getDateLabel() == null) {
                    String title = "Invalid input";
                    String message = "A valid date label is required to launch.";
                    JOptionPane.showMessageDialog(null, message, title, 0);
                } else {
                    lastCriteria = criteria;
                    SpaceTimeAnalysisInputDialog.this.dialogCriteria = criteria;
                    SpaceTimeAnalysisInputDialog.this.setVisible(false);
                }
            }
        });
        this.okButton.setActionCommand("OK");
        buttonPane.add(this.okButton);
        this.getRootPane().setDefaultButton(this.okButton);
        this.setCriteria(lastCriteria);
    }

    public SpaceTimeCriteria getCriteria() {
        int currentEgoRoleIndex;
        SpaceTimeCriteria result = new SpaceTimeCriteria();
        int currentRelationModelIndex = this.cmbbxRelationModel.getSelectedIndex();
        if (currentRelationModelIndex != -1) {
            result.setRelationModelName(((RelationModel)this.relationModels.get(currentRelationModelIndex)).getName());
        }
        if ((currentEgoRoleIndex = this.cmbbxEgoRole.getSelectedIndex()) != -1) {
            result.setEgoRoleName(((Role)((RelationModel)this.relationModels.get(currentRelationModelIndex)).roles().get(currentEgoRoleIndex)).getName());
        }
        logger.debug("EgoRoleName=" + result.getEgoRoleName());
        result.setMaxAge((Integer)this.spnnrMaxAge.getValue());
        int currentDateLabelIndex = this.cmbbxDateLabel.getSelectedIndex();
        if (currentDateLabelIndex != -1) {
            result.setDateLabel(this.attributeDescriptors.findByRelationModelName(((RelationModel)this.relationModels.get(currentRelationModelIndex)).getName()).sort().getByIndex(currentDateLabelIndex).getLabel());
        }
        logger.debug(result.toString());
        return result;
    }

    public SpaceTimeCriteria getDialogCriteria() {
        SpaceTimeCriteria result = this.dialogCriteria;
        return result;
    }

    private void setCriteria(SpaceTimeCriteria source) {
        if (source != null) {
            if (this.relationModels.isEmpty()) {
                this.cmbbxRelationModel.setEnabled(false);
                this.cmbbxEgoRole.setEnabled(false);
                this.cmbbxDateLabel.setEnabled(false);
            } else {
                this.cmbbxRelationModel.setEnabled(true);
                this.cmbbxEgoRole.setEnabled(true);
                this.cmbbxDateLabel.setEnabled(true);
                RelationModel currentRelationModel = this.relationModels.getByName(source.getRelationModelName());
                if (currentRelationModel == null) {
                    currentRelationModel = (RelationModel)this.relationModels.get(0);
                }
                this.setRelationModel(this.relationModels.indexOf(currentRelationModel), source.getEgoRoleName(), source.getDateLabel());
            }
        }
    }

    private void setRelationModel(int currentRelationModelIndex, String egoRoleName, String dateLabel) {
        RelationModel currentRelationModel = (RelationModel)this.relationModels.get(currentRelationModelIndex);
        if (currentRelationModel.roles().isEmpty()) {
            this.cmbbxEgoRole.setEnabled(false);
            this.cmbbxDateLabel.setEnabled(false);
        } else {
            this.cmbbxEgoRole.setModel(new DefaultComboBoxModel<Object>(currentRelationModel.roles().nameList().toArray()));
            Role currentEgoRole = currentRelationModel.roles().getByName(egoRoleName);
            if (currentEgoRole == null) {
                currentEgoRole = (Role)currentRelationModel.roles().get(0);
            }
            this.cmbbxEgoRole.setSelectedIndex(currentRelationModel.roles().indexOf(currentEgoRole));
            this.alterRolesPanel.removeAll();
            for (Role role : currentRelationModel.roles()) {
                this.alterRolesPanel.add(new JCheckBox(role.getName()));
            }
            StringList currentLabels = this.attributeDescriptors.findByRelationModelName(currentRelationModel.getName()).labels().sort();
            if (currentLabels.isEmpty()) {
                this.cmbbxDateLabel.setEnabled(false);
            } else {
                this.cmbbxDateLabel.setModel(new DefaultComboBoxModel<Object>(currentLabels.toArray()));
                int currentDateLabelIndex = currentLabels.indexOf((Object)dateLabel);
                if (currentDateLabelIndex == -1) {
                    currentDateLabelIndex = 0;
                }
                this.cmbbxDateLabel.setSelectedIndex(currentDateLabelIndex);
            }
        }
    }

    public static void main(String[] args) {
        SpaceTimeAnalysisInputDialog.showDialog(null, null, null);
    }

    public static SpaceTimeCriteria showDialog(Segmentation segmentation, RelationModels relationModels, AttributeDescriptors attributeDescriptors) {
        SpaceTimeAnalysisInputDialog dialog = new SpaceTimeAnalysisInputDialog(segmentation, relationModels, attributeDescriptors);
        dialog.setLocationRelativeTo(null);
        dialog.pack();
        dialog.setVisible(true);
        SpaceTimeCriteria result = dialog.getDialogCriteria();
        return result;
    }
}

