/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puckgui.views;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import fr.devinsy.util.StringList;
import fr.devinsy.util.StringSet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.PuckException;
import org.tip.puck.PuckExceptions;
import org.tip.puck.net.Family;
import org.tip.puck.net.Gender;
import org.tip.puck.net.Individual;
import org.tip.puck.net.workers.AttributeWorker;
import org.tip.puck.net.workers.NetUtils;
import org.tip.puck.util.NumberablesHashMap;
import org.tip.puck.util.ToolBox;
import org.tip.puckgui.InputSettings;
import org.tip.puckgui.NetGUI;
import org.tip.puckgui.models.FamiliesCellRenderer;
import org.tip.puckgui.models.FamiliesModel;
import org.tip.puckgui.models.FamilyChildrenModel;
import org.tip.puckgui.util.AutoComboBox;
import org.tip.puckgui.util.ComboBoxIds;
import org.tip.puckgui.views.AttributesPanel;
import org.tip.puckgui.views.IndividualsPanel;
import org.tip.puckgui.views.MainWindow;

public class FamiliesPanel
extends JPanel {
    private static final long serialVersionUID = 651718283569255829L;
    private static final Logger logger = LoggerFactory.getLogger(FamiliesPanel.class);
    private boolean doLostFocus = true;
    int reportCounter = 0;
    private JPanel thisJPanel = this;
    private NetGUI netGUI;
    private StringSet attributeTemplates;
    private static ImageIcon mediumFemaleIcon = new ImageIcon(MainWindow.class.getResource("/org/tip/puckgui/images/female-32x32.png"));
    private static ImageIcon mediumMaleIcon = new ImageIcon(MainWindow.class.getResource("/org/tip/puckgui/images/male-32x32.png"));
    private static ImageIcon mediumUnknowIcon = new ImageIcon(MainWindow.class.getResource("/org/tip/puckgui/images/unknown-32x32.png"));
    private static ImageIcon largeUnknowIcon = new ImageIcon(MainWindow.class.getResource("/org/tip/puckgui/images/unknown-64x64.png"));
    private static ImageIcon largeUnmarriedIcon = new ImageIcon(MainWindow.class.getResource("/org/tip/puckgui/images/unmarried-x45.png"));
    private static ImageIcon largeMarriedIcon = new ImageIcon(MainWindow.class.getResource("/org/tip/puckgui/images/married-x45.png"));
    private static ImageIcon largeDivorcedIcon = new ImageIcon(MainWindow.class.getResource("/org/tip/puckgui/images/divorced-x45.png"));
    private JTextField txtfldSearchFamily;
    private JList familyList;
    private JTable tableFamilyChildren;
    private JLabel lblFamilyId;
    private JLabel lblFamilyStatus;
    private JLabel lblFamilyFatherId;
    private JLabel lblFamilyFatherName;
    private JLabel lblFamilyMotherId;
    private JLabel lblFamilyMotherName;
    private JLabel lblFamilyChildren;
    private JLabel lblPosition;
    private AttributesPanel attributesPanel;
    private AutoComboBox cmbbxFamilyParent1;
    private AutoComboBox cmbbxFamilyParent2;
    private AutoComboBox cmbbxFamilyChildrenIds;
    private AutoComboBox cmbbxIndividualChildrenOrders;
    private JButton btnAddChild;
    private JTextField txtFldFamilyId;

    public FamiliesPanel(NetGUI guiManager) {
        this.netGUI = guiManager;
        this.attributeTemplates = new StringSet();
        this.updateAttributeTemplates();
        this.setLayout(new BoxLayout(this, 1));
        JSplitPane familiesSplit = new JSplitPane();
        this.add(familiesSplit);
        familiesSplit.setAlignmentY(0.5f);
        familiesSplit.setAlignmentX(0.5f);
        JPanel familiesPanel = new JPanel();
        familiesPanel.setSize(new Dimension(400, 0));
        familiesPanel.setMinimumSize(new Dimension(200, 10));
        familiesSplit.setLeftComponent(familiesPanel);
        familiesPanel.setLayout(new BoxLayout(familiesPanel, 1));
        JScrollPane familiesScrollPane = new JScrollPane();
        familiesScrollPane.setVerticalScrollBarPolicy(22);
        familiesPanel.add(familiesScrollPane);
        this.familyList = new JList();
        this.familyList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent event) {
                logger.debug("value changed = " + event.getValueIsAdjusting() + " " + event.getFirstIndex() + " " + event.getLastIndex() + " " + FamiliesPanel.this.familyList.getSelectedIndex());
                if (FamiliesPanel.this.familyList.getSelectedIndex() != -1) {
                    Family family = (Family)((JList)event.getSource()).getModel().getElementAt(FamiliesPanel.this.familyList.getSelectedIndex());
                    FamiliesPanel.this.updateFamilyIdentity(family);
                }
            }
        });
        this.familyList.setDoubleBuffered(true);
        this.familyList.setSelectionMode(0);
        this.familyList.setCellRenderer(new FamiliesCellRenderer());
        this.familyList.setModel(new FamiliesModel(null));
        familiesScrollPane.setViewportView(this.familyList);
        JPanel familyPanel = new JPanel();
        familyPanel.setAlignmentY(0.0f);
        familyPanel.setAlignmentX(0.0f);
        familiesSplit.setRightComponent(familyPanel);
        familyPanel.setLayout(new BoxLayout(familyPanel, 1));
        JPanel panelFamilyIdentity = new JPanel();
        familyPanel.add(panelFamilyIdentity);
        panelFamilyIdentity.setLayout(new BoxLayout(panelFamilyIdentity, 0));
        Component horizontalStrut_2 = Box.createHorizontalStrut(20);
        panelFamilyIdentity.add(horizontalStrut_2);
        Component horizontalGlue_6 = Box.createHorizontalGlue();
        panelFamilyIdentity.add(horizontalGlue_6);
        JPanel panel_1 = new JPanel();
        panelFamilyIdentity.add(panel_1);
        panel_1.setLayout(new BoxLayout(panel_1, 1));
        Component verticalStrut_1 = Box.createVerticalStrut(10);
        verticalStrut_1.setMaximumSize(new Dimension(20, 10));
        panel_1.add(verticalStrut_1);
        this.lblFamilyId = new JLabel("555");
        this.lblFamilyId.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                if (event.getButton() == 1) {
                    FamiliesPanel.this.setFamilyIdEditorOn();
                }
            }
        });
        panel_1.add(this.lblFamilyId);
        this.lblFamilyId.setAlignmentX(1.0f);
        this.txtFldFamilyId = new JTextField();
        this.txtFldFamilyId.setFocusTraversalKeysEnabled(false);
        this.txtFldFamilyId.setMaximumSize(new Dimension(200, Integer.MAX_VALUE));
        this.txtFldFamilyId.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent event) {
                try {
                    if (event.getKeyCode() == 27) {
                        logger.debug("escape pressed");
                        FamiliesPanel.this.txtFldFamilyId.transferFocus();
                    } else if (event.getKeyCode() == 10) {
                        logger.debug("enter pressed");
                        this.save();
                        FamiliesPanel.this.txtFldFamilyId.transferFocus();
                    } else if (event.getKeyCode() == 9) {
                        if (event.isShiftDown()) {
                            logger.debug("shift-tab pressed");
                            this.save();
                            FamiliesPanel.this.txtFldFamilyId.transferFocus();
                        } else {
                            logger.debug("tab pressed");
                            this.save();
                            FamiliesPanel.this.txtFldFamilyId.transferFocus();
                            FamiliesPanel.this.setParent1EditorOn();
                        }
                    }
                }
                catch (PuckException exception) {
                    FamiliesPanel.this.txtFldFamilyId.requestFocus();
                }
            }

            /*
             * Enabled aggressive block sorting
             */
            public void save() throws PuckException {
                String input = FamiliesPanel.this.txtFldFamilyId.getText();
                logger.debug("[lbl,cmb]=[" + FamiliesPanel.this.lblFamilyId.getText() + "," + input + "]");
                if (!StringUtils.isNotBlank((CharSequence)input)) return;
                if (StringUtils.equals((CharSequence)FamiliesPanel.this.lblFamilyId.getText(), (CharSequence)FamiliesPanel.this.txtFldFamilyId.getText())) return;
                if (!NumberUtils.isDigits((String)(input = input.trim()))) {
                    FamiliesPanel.this.doLostFocus = false;
                    JOptionPane.showMessageDialog(FamiliesPanel.this.thisJPanel, "Numeric value required.", "Invalid id", 0);
                    FamiliesPanel.this.doLostFocus = true;
                    throw PuckExceptions.INVALID_PARAMETER.create();
                }
                int targetId = Integer.parseInt(input);
                Family family = (Family)FamiliesPanel.this.netGUI.getNet().families().getById(targetId);
                if (family == null) {
                    Family currentFamily = FamiliesPanel.this.getSelectedFamily();
                    FamiliesPanel.this.netGUI.getNet().changeId(currentFamily, targetId);
                    FamiliesPanel.this.netGUI.setChanged(true);
                    FamiliesPanel.this.netGUI.updateAll();
                    FamiliesPanel.this.select(currentFamily);
                    return;
                }
                FamiliesPanel.this.doLostFocus = false;
                JOptionPane.showMessageDialog(FamiliesPanel.this.thisJPanel, "ID already in use.", "Invalid id", 0);
                FamiliesPanel.this.doLostFocus = true;
                throw PuckExceptions.INVALID_PARAMETER.create();
            }
        });
        this.txtFldFamilyId.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                logger.debug("FOCUS LOST FAMILY ID");
                if (FamiliesPanel.this.doLostFocus) {
                    FamiliesPanel.this.lblFamilyId.setVisible(true);
                    FamiliesPanel.this.txtFldFamilyId.setVisible(false);
                }
            }
        });
        this.txtFldFamilyId.setFocusTraversalKeysEnabled(false);
        panel_1.add(this.txtFldFamilyId);
        this.txtFldFamilyId.setColumns(10);
        Component verticalStrut = Box.createVerticalStrut(10);
        verticalStrut.setMaximumSize(new Dimension(20, 10));
        panel_1.add(verticalStrut);
        this.lblPosition = new JLabel(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("FamiliesPanel.lblNewLabel.text"));
        this.lblPosition.setAlignmentX(1.0f);
        panel_1.add(this.lblPosition);
        Component horizontalStrut_5 = Box.createHorizontalStrut(5);
        panelFamilyIdentity.add(horizontalStrut_5);
        this.lblFamilyStatus = new JLabel("");
        this.lblFamilyStatus.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                if (event.getButton() == 1) {
                    FamiliesPanel.this.lblFamilyStatus.requestFocus();
                    Family currentFamily = FamiliesPanel.this.getSelectedFamily();
                    if (currentFamily != null) {
                        switch (currentFamily.getUnionStatus()) {
                            case UNMARRIED: {
                                currentFamily.setMarried();
                                break;
                            }
                            case MARRIED: {
                                currentFamily.setDivorced();
                                break;
                            }
                            case DIVORCED: {
                                currentFamily.setUnmarried();
                            }
                        }
                        FamiliesPanel.this.updateFamilyIdentity(currentFamily);
                        FamiliesPanel.this.netGUI.setChanged(true);
                    }
                }
            }
        });
        this.lblFamilyStatus.setAlignmentX(0.5f);
        this.lblFamilyStatus.setIcon(largeUnmarriedIcon);
        this.lblFamilyStatus.setFont(new Font("Dialog", 0, 24));
        panelFamilyIdentity.add(this.lblFamilyStatus);
        Component horizontalStrut_4 = Box.createHorizontalStrut(20);
        panelFamilyIdentity.add(horizontalStrut_4);
        JPanel panel_5 = new JPanel();
        panel_5.setMaximumSize(new Dimension(Short.MAX_VALUE, 200));
        panelFamilyIdentity.add(panel_5);
        panel_5.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.DEFAULT_COLSPEC, ColumnSpec.decode((String)"default:grow")}, new RowSpec[]{FormFactory.MIN_ROWSPEC, FormFactory.MIN_ROWSPEC, FormFactory.MIN_ROWSPEC, FormFactory.MIN_ROWSPEC}));
        this.cmbbxFamilyParent1 = new AutoComboBox(null);
        this.cmbbxFamilyParent1.setStrict(false);
        this.cmbbxFamilyParent1.setVisible(false);
        this.cmbbxFamilyParent1.setEditable(true);
        this.cmbbxFamilyParent1.getEditor().getEditorComponent().setFocusTraversalKeysEnabled(false);
        this.cmbbxFamilyParent1.getEditor().getEditorComponent().addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent arg0) {
                logger.debug("FOCUS GAINED PARENT 1 ID");
            }

            @Override
            public void focusLost(FocusEvent arg0) {
                logger.debug("FOCUS LOST PARENT 1 ID");
                if (FamiliesPanel.this.doLostFocus) {
                    FamiliesPanel.this.cmbbxFamilyParent1.setVisible(false);
                    FamiliesPanel.this.lblFamilyFatherId.setVisible(true);
                    FamiliesPanel.this.lblFamilyFatherName.setVisible(true);
                    FamiliesPanel.this.cmbbxFamilyParent1.setDataList(new ArrayList());
                }
            }
        });
        this.cmbbxFamilyParent1.getEditor().getEditorComponent().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent event) {
                try {
                    if (event.getKeyCode() == 27) {
                        logger.debug("escape pressed");
                        FamiliesPanel.this.cmbbxFamilyParent1.getEditor().getEditorComponent().transferFocus();
                    } else if (event.getKeyCode() == 10) {
                        logger.debug("enter pressed");
                        this.save();
                        FamiliesPanel.this.cmbbxFamilyParent1.getEditor().getEditorComponent().transferFocus();
                    } else if (event.getKeyCode() == 9) {
                        if (event.isShiftDown()) {
                            logger.debug("shift-tab pressed");
                            this.save();
                            FamiliesPanel.this.cmbbxFamilyParent1.getEditor().getEditorComponent().transferFocus();
                            FamiliesPanel.this.setFamilyIdEditorOn();
                        } else {
                            logger.debug("tab pressed");
                            this.save();
                            FamiliesPanel.this.cmbbxFamilyParent1.getEditor().getEditorComponent().transferFocus();
                            FamiliesPanel.this.setParent2EditorOn();
                        }
                    }
                }
                catch (PuckException exception) {
                    logger.debug("SAVE FAILED");
                    FamiliesPanel.this.cmbbxFamilyParent1.getEditor().getEditorComponent().requestFocus();
                }
            }

            public void save() throws PuckException {
                String newFatherIdInput = (String)FamiliesPanel.this.cmbbxFamilyParent1.getEditor().getItem();
                logger.debug("[lbl,cmb]=[" + FamiliesPanel.this.lblFamilyFatherId.getText() + "," + newFatherIdInput + "]");
                Individual newFather = ComboBoxIds.getOrCreateIndividualFromInput(FamiliesPanel.this.netGUI.getIndividualIdStrategy(), FamiliesPanel.this.netGUI.getNet(), newFatherIdInput, Gender.MALE);
                Family currentFamily = FamiliesPanel.this.getIdentityFamily();
                if (newFather != currentFamily.getFather()) {
                    String errorMessage = IndividualsPanel.controlPartners(InputSettings.CheckLevel.ERROR, newFather, currentFamily.getMother(), currentFamily.getChildren().toArray());
                    if (errorMessage != null) {
                        FamiliesPanel.this.doLostFocus = false;
                        JOptionPane.showMessageDialog(FamiliesPanel.this.thisJPanel, errorMessage, "Error", 0);
                        FamiliesPanel.this.doLostFocus = true;
                        throw PuckExceptions.INVALID_PARAMETER.create();
                    }
                    Family previousFamily = FamiliesPanel.this.netGUI.getNet().families().getBySpouses(newFather, currentFamily.getFather());
                    if (newFather != null && currentFamily.getMother() != null && previousFamily != null && previousFamily.getId() != currentFamily.getId()) {
                        FamiliesPanel.this.doLostFocus = false;
                        JOptionPane.showMessageDialog(FamiliesPanel.this.thisJPanel, "This family already exists (" + previousFamily.getId() + ").", "Error", 0);
                        FamiliesPanel.this.doLostFocus = true;
                        throw PuckExceptions.INVALID_PARAMETER.create();
                    }
                    NetUtils.setKinFather(currentFamily, newFather);
                    if (currentFamily.numberOfParents() == 2) {
                        currentFamily.setUnionStatus(FamiliesPanel.this.netGUI.getDefaultUnionStatus());
                    }
                    FamiliesPanel.this.netGUI.setChanged(true);
                    try {
                        FamiliesPanel.this.netGUI.getSegmentation().refresh();
                    }
                    catch (PuckException e) {
                        e.printStackTrace();
                    }
                    FamiliesPanel.this.netGUI.updateAll();
                    String warningMessage = IndividualsPanel.controlPartners(InputSettings.CheckLevel.WARNING, newFather, currentFamily.getMother(), currentFamily.getChildren().toArray());
                    if (warningMessage != null) {
                        JOptionPane.showMessageDialog(FamiliesPanel.this.thisJPanel, warningMessage, "Warning", 2);
                    }
                }
            }
        });
        panel_5.add((Component)this.cmbbxFamilyParent1, "1, 1, 2, 1, fill, default");
        this.lblFamilyFatherId = new JLabel("55");
        this.lblFamilyFatherId.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                logger.debug("parent 1 id clicked");
                if (event.getButton() == 1) {
                    FamiliesPanel.this.setParent1EditorOn();
                }
            }
        });
        this.lblFamilyFatherId.setHorizontalAlignment(4);
        panel_5.add((Component)this.lblFamilyFatherId, "1, 2, right, center");
        this.lblFamilyFatherName = new JLabel("anonymous");
        this.lblFamilyFatherName.setHorizontalAlignment(2);
        this.lblFamilyFatherName.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                try {
                    Family selected;
                    int selectedIndex;
                    if (event.getClickCount() == 2 && (selectedIndex = FamiliesPanel.this.familyList.getSelectedIndex()) != -1 && (selected = (Family)((FamiliesModel)FamiliesPanel.this.familyList.getModel()).getElementAt(selectedIndex)) != null && selected.getFather() != null) {
                        FamiliesPanel.this.netGUI.changeSegmentationToCluster(selected.getFather());
                    }
                }
                catch (PuckException exception) {
                    exception.printStackTrace();
                }
            }
        });
        this.lblFamilyFatherName.setIcon(new ImageIcon(MainWindow.class.getResource("/org/tip/puckgui/images/unknown-32x32.png")));
        panel_5.add((Component)this.lblFamilyFatherName, "2, 2, left, center");
        JPopupMenu popupMenu = new JPopupMenu();
        FamiliesPanel.addPopup(this.lblFamilyFatherName, popupMenu);
        JMenuItem mntmBrowse = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("FamiliesPanel.mntmBrowse.text"));
        mntmBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Family selected;
                    int selectedIndex = FamiliesPanel.this.familyList.getSelectedIndex();
                    if (selectedIndex != -1 && (selected = (Family)((FamiliesModel)FamiliesPanel.this.familyList.getModel()).getElementAt(selectedIndex)) != null && selected.getFather() != null) {
                        FamiliesPanel.this.netGUI.changeSegmentationToCluster(selected.getFather());
                    }
                }
                catch (PuckException exception) {
                    exception.printStackTrace();
                }
            }
        });
        popupMenu.add(mntmBrowse);
        JMenuItem mntmSwapParents = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("FamiliesPanel.mntmSwapParents.text"));
        mntmSwapParents.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Family currentFamily = FamiliesPanel.this.getIdentityFamily();
                if (currentFamily != null && (currentFamily.getFather() != null || currentFamily.getMother() != null)) {
                    NetUtils.swapParents(currentFamily);
                    FamiliesPanel.this.netGUI.setChanged(true);
                    FamiliesPanel.this.netGUI.updateAll();
                    FamiliesPanel.this.netGUI.selectFamiliesTab(currentFamily);
                }
            }
        });
        JMenuItem mntmEdit = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("FamiliesPanel.mntmEdit.text"));
        mntmEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                FamiliesPanel.this.setParent1EditorOn();
            }
        });
        popupMenu.add(mntmEdit);
        popupMenu.add(mntmSwapParents);
        JSeparator separator = new JSeparator();
        popupMenu.add(separator);
        JMenuItem mntmDelete = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("FamiliesPanel.mntmDelete.text"));
        mntmDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Family currentFamily = FamiliesPanel.this.getIdentityFamily();
                if (currentFamily.getFather() != null) {
                    NetUtils.removeFather(currentFamily);
                    try {
                        FamiliesPanel.this.netGUI.getSegmentation().refresh();
                    }
                    catch (PuckException exception) {
                        exception.printStackTrace();
                    }
                    FamiliesPanel.this.netGUI.updateAll();
                    FamiliesPanel.this.netGUI.setChanged(true);
                }
            }
        });
        popupMenu.add(mntmDelete);
        this.lblFamilyMotherId = new JLabel("5555");
        this.lblFamilyMotherId.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                logger.debug("parent 2 id clicked");
                if (event.getButton() == 1) {
                    FamiliesPanel.this.setParent2EditorOn();
                }
            }
        });
        this.lblFamilyMotherId.setHorizontalAlignment(4);
        panel_5.add((Component)this.lblFamilyMotherId, "1, 3, right, center");
        this.lblFamilyMotherName = new JLabel("anonymous");
        this.lblFamilyMotherName.setHorizontalAlignment(2);
        this.lblFamilyMotherName.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                try {
                    Family selected;
                    int selectedIndex;
                    if (event.getClickCount() == 2 && (selectedIndex = FamiliesPanel.this.familyList.getSelectedIndex()) != -1 && (selected = (Family)((FamiliesModel)FamiliesPanel.this.familyList.getModel()).getElementAt(selectedIndex)) != null && selected.getMother() != null) {
                        FamiliesPanel.this.netGUI.changeSegmentationToCluster(selected.getMother());
                    }
                }
                catch (PuckException exception) {
                    exception.printStackTrace();
                }
            }
        });
        this.lblFamilyMotherName.setIcon(new ImageIcon(MainWindow.class.getResource("/org/tip/puckgui/images/unknown-32x32.png")));
        panel_5.add((Component)this.lblFamilyMotherName, "2, 3, left, center");
        JPopupMenu popupMenu_1 = new JPopupMenu();
        FamiliesPanel.addPopup(this.lblFamilyMotherName, popupMenu_1);
        JMenuItem mntmDelete_1 = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("FamiliesPanel.mntmDelete_1.text"));
        mntmDelete_1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Family currentFamily = FamiliesPanel.this.getIdentityFamily();
                if (currentFamily.getMother() != null) {
                    NetUtils.removeMother(currentFamily);
                    try {
                        FamiliesPanel.this.netGUI.getSegmentation().refresh();
                    }
                    catch (PuckException exception) {
                        exception.printStackTrace();
                    }
                    FamiliesPanel.this.netGUI.updateAll();
                    FamiliesPanel.this.netGUI.setChanged(true);
                }
            }
        });
        JMenuItem mntmSwapParents_1 = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("FamiliesPanel.mntmSwapParents_1.text"));
        mntmSwapParents_1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Family currentFamily = FamiliesPanel.this.getIdentityFamily();
                if (currentFamily != null && (currentFamily.getFather() != null || currentFamily.getMother() != null)) {
                    NetUtils.swapParents(currentFamily);
                    FamiliesPanel.this.netGUI.setChanged(true);
                    FamiliesPanel.this.netGUI.updateAll();
                    FamiliesPanel.this.netGUI.selectFamiliesTab(currentFamily);
                }
            }
        });
        JMenuItem mntmBrowse_1 = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("FamiliesPanel.mntmBrowse_1.text"));
        mntmBrowse_1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    Family selected;
                    int selectedIndex = FamiliesPanel.this.familyList.getSelectedIndex();
                    if (selectedIndex != -1 && (selected = (Family)((FamiliesModel)FamiliesPanel.this.familyList.getModel()).getElementAt(selectedIndex)) != null && selected.getMother() != null) {
                        FamiliesPanel.this.netGUI.changeSegmentationToCluster(selected.getMother());
                    }
                }
                catch (PuckException exception) {
                    exception.printStackTrace();
                }
            }
        });
        popupMenu_1.add(mntmBrowse_1);
        JMenuItem mntmEdit_1 = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("FamiliesPanel.mntmEdit_1.text"));
        mntmEdit_1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                FamiliesPanel.this.setParent2EditorOn();
            }
        });
        popupMenu_1.add(mntmEdit_1);
        popupMenu_1.add(mntmSwapParents_1);
        JSeparator separator_1 = new JSeparator();
        popupMenu_1.add(separator_1);
        popupMenu_1.add(mntmDelete_1);
        this.cmbbxFamilyParent2 = new AutoComboBox(null);
        this.cmbbxFamilyParent2.setStrict(false);
        this.cmbbxFamilyParent2.setEditable(true);
        this.cmbbxFamilyParent2.setVisible(false);
        this.cmbbxFamilyParent2.getEditor().getEditorComponent().setFocusTraversalKeysEnabled(false);
        this.cmbbxFamilyParent2.getEditor().getEditorComponent().addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent arg0) {
                logger.debug("FOCUS GAINED PARENT 2 ID");
            }

            @Override
            public void focusLost(FocusEvent arg0) {
                logger.debug("FOCUS LOST PARENT 2 ID");
                if (FamiliesPanel.this.doLostFocus) {
                    FamiliesPanel.this.cmbbxFamilyParent2.setVisible(false);
                    FamiliesPanel.this.lblFamilyMotherId.setVisible(true);
                    FamiliesPanel.this.lblFamilyMotherName.setVisible(true);
                    FamiliesPanel.this.cmbbxFamilyParent2.setDataList(new ArrayList());
                }
            }
        });
        this.cmbbxFamilyParent2.getEditor().getEditorComponent().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent event) {
                try {
                    if (event.getKeyCode() == 27) {
                        logger.debug("escape pressed");
                        FamiliesPanel.this.cmbbxFamilyParent2.getEditor().getEditorComponent().transferFocus();
                    } else if (event.getKeyCode() == 10) {
                        logger.debug("enter pressed");
                        this.save();
                        FamiliesPanel.this.cmbbxFamilyParent2.getEditor().getEditorComponent().transferFocus();
                    } else if (event.getKeyCode() == 9) {
                        if (event.isShiftDown()) {
                            logger.debug("shift-tab pressed");
                            this.save();
                            FamiliesPanel.this.cmbbxFamilyParent2.getEditor().getEditorComponent().transferFocus();
                            FamiliesPanel.this.setParent1EditorOn();
                        } else {
                            logger.debug("tab pressed");
                            this.save();
                            FamiliesPanel.this.cmbbxFamilyParent2.getEditor().getEditorComponent().transferFocus();
                        }
                    }
                }
                catch (PuckException exception) {
                    logger.debug("SAVE FAILED");
                    FamiliesPanel.this.cmbbxFamilyParent2.getEditor().getEditorComponent().requestFocus();
                }
            }

            public void save() throws PuckException {
                String newMotherIdInput = (String)FamiliesPanel.this.cmbbxFamilyParent2.getEditor().getItem();
                logger.debug("[lbl,cmb]=[" + FamiliesPanel.this.lblFamilyMotherId.getText() + "," + newMotherIdInput + "]");
                Family currentFamily = FamiliesPanel.this.getIdentityFamily();
                Individual newMother = ComboBoxIds.getOrCreateIndividualFromInput(FamiliesPanel.this.netGUI.getIndividualIdStrategy(), FamiliesPanel.this.netGUI.getNet(), newMotherIdInput, Gender.MALE);
                if (newMother != currentFamily.getMother()) {
                    String errorMessage = IndividualsPanel.controlPartners(InputSettings.CheckLevel.ERROR, currentFamily.getFather(), newMother, currentFamily.getChildren().toArray());
                    if (errorMessage != null) {
                        FamiliesPanel.this.doLostFocus = false;
                        JOptionPane.showMessageDialog(FamiliesPanel.this.thisJPanel, errorMessage, "Error", 0);
                        FamiliesPanel.this.doLostFocus = true;
                        throw PuckExceptions.INVALID_PARAMETER.create();
                    }
                    Family previousFamily = FamiliesPanel.this.netGUI.getNet().families().getBySpouses(newMother, currentFamily.getFather());
                    if (newMother != null && currentFamily.getFather() != null && previousFamily != null && previousFamily.getId() != currentFamily.getId()) {
                        FamiliesPanel.this.doLostFocus = false;
                        JOptionPane.showMessageDialog(FamiliesPanel.this.thisJPanel, "This family already exists (" + previousFamily.getId() + ").", "Error", 0);
                        FamiliesPanel.this.doLostFocus = true;
                        throw PuckExceptions.INVALID_PARAMETER.create();
                    }
                    NetUtils.setKinMother(currentFamily, newMother);
                    if (currentFamily.numberOfParents() == 2) {
                        currentFamily.setUnionStatus(FamiliesPanel.this.netGUI.getDefaultUnionStatus());
                    }
                    try {
                        FamiliesPanel.this.netGUI.getSegmentation().refresh();
                    }
                    catch (PuckException e) {
                        e.printStackTrace();
                    }
                    FamiliesPanel.this.netGUI.updateAll();
                    FamiliesPanel.this.netGUI.setChanged(true);
                    String warningMessage = IndividualsPanel.controlPartners(InputSettings.CheckLevel.WARNING, currentFamily.getFather(), newMother, currentFamily.getChildren().toArray());
                    if (warningMessage != null) {
                        JOptionPane.showMessageDialog(FamiliesPanel.this.thisJPanel, warningMessage, "Warning", 2);
                    }
                }
            }
        });
        panel_5.add((Component)this.cmbbxFamilyParent2, "1, 4, 2, 1, fill, default");
        Component horizontalStrut_3 = Box.createHorizontalStrut(20);
        panelFamilyIdentity.add(horizontalStrut_3);
        Component verticalStrut_7 = Box.createVerticalStrut(10);
        familyPanel.add(verticalStrut_7);
        JPanel panel = new JPanel();
        familyPanel.add(panel);
        panel.setLayout(new BorderLayout(0, 0));
        JSplitPane splitPane = new JSplitPane();
        panel.add((Component)splitPane, "Center");
        splitPane.setOrientation(0);
        JPanel panelFamilyChildren = new JPanel();
        panelFamilyChildren.setMinimumSize(new Dimension(10, 200));
        splitPane.setLeftComponent(panelFamilyChildren);
        panelFamilyChildren.setLayout(new BoxLayout(panelFamilyChildren, 1));
        JPanel panel_2 = new JPanel();
        panel_2.setAlignmentX(0.0f);
        panelFamilyChildren.add(panel_2);
        panel_2.setLayout(new BoxLayout(panel_2, 0));
        this.lblFamilyChildren = new JLabel(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.lblChildren.text"));
        panel_2.add(this.lblFamilyChildren);
        Component horizontalStrut = Box.createHorizontalStrut(20);
        panel_2.add(horizontalStrut);
        this.btnAddChild = new JButton(" + ");
        this.btnAddChild.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                logger.debug("Add Child");
                FamiliesPanel.this.addChild();
            }
        });
        this.btnAddChild.setBorder(new EmptyBorder(0, 0, 0, 0));
        panel_2.add(this.btnAddChild);
        Component horizontalStrut_1 = Box.createHorizontalStrut(5);
        panel_2.add(horizontalStrut_1);
        JLabel lblctrlk = new JLabel("(Ctrl-K)");
        panel_2.add(lblctrlk);
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setAlignmentX(0.0f);
        panelFamilyChildren.add(scrollPane);
        this.tableFamilyChildren = new JTable();
        this.tableFamilyChildren.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                try {
                    if (event.getClickCount() == 2) {
                        Individual selected;
                        int selectedIndex = FamiliesPanel.this.tableFamilyChildren.getSelectedRow();
                        int selectedColumn = FamiliesPanel.this.tableFamilyChildren.getSelectedColumn();
                        logger.debug("[index= " + selectedIndex + ", col]=[" + selectedColumn + "]");
                        if (selectedIndex != -1 && selectedColumn > 0 && (selected = ((FamilyChildrenModel)FamiliesPanel.this.tableFamilyChildren.getModel()).children().get(selectedIndex)) != null) {
                            FamiliesPanel.this.netGUI.changeSegmentationToCluster(selected);
                        }
                    }
                }
                catch (PuckException exception) {
                    exception.printStackTrace();
                }
            }
        });
        scrollPane.setViewportView(this.tableFamilyChildren);
        this.tableFamilyChildren.setBorder(new LineBorder(new Color(169, 169, 169)));
        this.tableFamilyChildren.setSelectionMode(2);
        this.tableFamilyChildren.getTableHeader().setReorderingAllowed(false);
        this.tableFamilyChildren.setModel(new FamilyChildrenModel(this.netGUI, null));
        JPopupMenu popupMenu_2 = new JPopupMenu();
        JMenuItem mntmDelete_2 = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("FamiliesPanel.mntmDelete_2.text_1"));
        mntmDelete_2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                logger.debug("Delete " + ArrayUtils.toString((Object)FamiliesPanel.this.tableFamilyChildren.getSelectedRows()));
                int[] selectedRowIds = FamiliesPanel.this.tableFamilyChildren.getSelectedRows();
                if (selectedRowIds.length != 0) {
                    ArrayUtils.reverse((int[])selectedRowIds);
                    int[] nArray = selectedRowIds;
                    int n = selectedRowIds.length;
                    int n2 = 0;
                    while (n2 < n) {
                        int rowIndex = nArray[n2];
                        int childId = (Integer)FamiliesPanel.this.tableFamilyChildren.getModel().getValueAt(rowIndex, 0);
                        FamiliesPanel.this.netGUI.getNet().removeChild((Individual)FamiliesPanel.this.netGUI.getNet().individuals().getById(childId));
                        ++n2;
                    }
                    FamiliesPanel.this.netGUI.setChanged(true);
                    FamiliesPanel.this.netGUI.updateAll();
                }
            }
        });
        JMenuItem mntmBrowse_2 = new JMenuItem(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("FamiliesPanel.mntmBrowse_2.text"));
        mntmBrowse_2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Individual selected;
                    int selectedIndex = FamiliesPanel.this.tableFamilyChildren.getSelectedRow();
                    int selectedColumn = FamiliesPanel.this.tableFamilyChildren.getSelectedColumn();
                    logger.debug("[index= " + selectedIndex + ", col]=[" + selectedColumn + "]");
                    if (selectedIndex != -1 && selectedColumn > 0 && (selected = ((FamilyChildrenModel)FamiliesPanel.this.tableFamilyChildren.getModel()).children().get(selectedIndex)) != null) {
                        FamiliesPanel.this.netGUI.changeSegmentationToCluster(selected);
                    }
                }
                catch (PuckException exception) {
                    exception.printStackTrace();
                }
            }
        });
        popupMenu_2.add(mntmBrowse_2);
        JSeparator separator_2 = new JSeparator();
        popupMenu_2.add(separator_2);
        popupMenu_2.add(mntmDelete_2);
        FamiliesPanel.addPopup(this.tableFamilyChildren, popupMenu_2);
        this.attributesPanel = new AttributesPanel(this.netGUI, null, this.attributeTemplates);
        splitPane.setRightComponent(this.attributesPanel);
        this.cmbbxFamilyChildrenIds = new AutoComboBox(null);
        this.cmbbxFamilyChildrenIds.getEditor().getEditorComponent().addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent arg0) {
            }

            @Override
            public void focusLost(FocusEvent arg0) {
                logger.debug("FOCUS LOST FAMILY CHILDREN TABLE " + FamiliesPanel.this.tableFamilyChildren.isEditing());
                if (FamiliesPanel.this.tableFamilyChildren.isEditing()) {
                    FamiliesPanel.this.tableFamilyChildren.getColumnModel().getColumn(0).getCellEditor().cancelCellEditing();
                }
                if (((FamilyChildrenModel)FamiliesPanel.this.tableFamilyChildren.getModel()).isNewEditionOn()) {
                    ((FamilyChildrenModel)FamiliesPanel.this.tableFamilyChildren.getModel()).escapeNewEdition();
                }
            }
        });
        this.cmbbxFamilyChildrenIds.setEditable(true);
        this.cmbbxFamilyChildrenIds.setStrict(false);
        this.cmbbxFamilyChildrenIds.setMaximumRowCount(7);
        DefaultCellEditor editor = new DefaultCellEditor(this.cmbbxFamilyChildrenIds);
        this.tableFamilyChildren.getColumnModel().getColumn(0).setCellEditor(editor);
        this.tableFamilyChildren.getColumnModel().getColumn(0).setMinWidth(10);
        this.tableFamilyChildren.getColumnModel().getColumn(0).setPreferredWidth(90);
        this.tableFamilyChildren.getColumnModel().getColumn(0).setMaxWidth(110);
        this.tableFamilyChildren.getColumnModel().getColumn(1).setMinWidth(10);
        this.tableFamilyChildren.getColumnModel().getColumn(1).setMaxWidth(30);
        this.tableFamilyChildren.getColumnModel().getColumn(1).setResizable(false);
        ArrayList<Integer> orderList = new ArrayList<Integer>(99);
        int order = 1;
        while (order < 100) {
            orderList.add(order);
            ++order;
        }
        this.cmbbxIndividualChildrenOrders = new AutoComboBox(orderList);
        this.cmbbxIndividualChildrenOrders.getEditor().getEditorComponent().addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent arg0) {
            }

            @Override
            public void focusLost(FocusEvent arg0) {
                logger.debug("FOCUS LOST CHILDREN TABLE(2) " + FamiliesPanel.this.tableFamilyChildren.isEditing());
                if (FamiliesPanel.this.tableFamilyChildren.isEditing()) {
                    FamiliesPanel.this.tableFamilyChildren.getColumnModel().getColumn(3).getCellEditor().cancelCellEditing();
                }
                if (((FamilyChildrenModel)FamiliesPanel.this.tableFamilyChildren.getModel()).isNewEditionOn()) {
                    ((FamilyChildrenModel)FamiliesPanel.this.tableFamilyChildren.getModel()).escapeNewEdition();
                }
            }
        });
        this.cmbbxIndividualChildrenOrders.setEditable(true);
        this.cmbbxIndividualChildrenOrders.setStrict(false);
        this.cmbbxIndividualChildrenOrders.setMaximumRowCount(10);
        DefaultCellEditor orderEditor = new DefaultCellEditor(this.cmbbxIndividualChildrenOrders);
        this.tableFamilyChildren.getColumnModel().getColumn(3).setCellEditor(orderEditor);
        this.tableFamilyChildren.getColumnModel().getColumn(3).setPreferredWidth(50);
        this.tableFamilyChildren.getColumnModel().getColumn(3).setMaxWidth(50);
        this.tableFamilyChildren.getColumnModel().getColumn(3).setResizable(false);
        this.tableFamilyChildren.getColumnModel().getColumn(4).setMaxWidth(125);
        this.tableFamilyChildren.getColumnModel().getColumn(4).setResizable(false);
        this.tableFamilyChildren.getColumnModel().getColumn(5).setMaxWidth(125);
        this.tableFamilyChildren.getColumnModel().getColumn(5).setResizable(false);
        JPanel familiesButtonsPanel = new JPanel();
        this.add(familiesButtonsPanel);
        familiesButtonsPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        familiesButtonsPanel.setLayout(new BoxLayout(familiesButtonsPanel, 0));
        JButton btnAddFamily = new JButton("");
        btnAddFamily.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                logger.debug("Add family");
                FamiliesPanel.this.addFamily();
            }
        });
        btnAddFamily.setToolTipText(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.btnAddFamily.toolTipText"));
        btnAddFamily.setIcon(new ImageIcon(MainWindow.class.getResource("/org/tip/puckgui/images/add.png")));
        familiesButtonsPanel.add(btnAddFamily);
        JButton btnRemoveFamily = new JButton("");
        btnRemoveFamily.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Family target = FamiliesPanel.this.getSelectedFamily();
                if (target != null) {
                    int selectedIndex = FamiliesPanel.this.familyList.getSelectedIndex();
                    FamiliesPanel.this.netGUI.getNet().remove(target);
                    FamiliesPanel.this.update();
                    if (FamiliesPanel.this.netGUI.getNet().families().size() != 0) {
                        if (selectedIndex == FamiliesPanel.this.netGUI.getNet().families().size()) {
                            --selectedIndex;
                        }
                        FamiliesPanel.this.familyList.setSelectedIndex(selectedIndex);
                    }
                    FamiliesPanel.this.netGUI.setChanged(true);
                }
            }
        });
        familiesButtonsPanel.add(btnRemoveFamily);
        btnRemoveFamily.setToolTipText(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.btnRemoveFamily.toolTipText"));
        btnRemoveFamily.setIcon(new ImageIcon(MainWindow.class.getResource("/org/tip/puckgui/images/remove.png")));
        Component horizontalGlue = Box.createHorizontalGlue();
        familiesButtonsPanel.add(horizontalGlue);
        JButton btnFamiliesPrevious = new JButton(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.btnPrevious.text"));
        btnFamiliesPrevious.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                int selectedIndex = FamiliesPanel.this.familyList.getSelectedIndex();
                if (selectedIndex == -1) {
                    if (FamiliesPanel.this.netGUI.getNet().families().size() != 0) {
                        selectedIndex = FamiliesPanel.this.netGUI.getNet().families().size() - 1;
                        FamiliesPanel.this.familyList.setSelectedIndex(selectedIndex);
                        FamiliesPanel.this.familyList.ensureIndexIsVisible(selectedIndex);
                    }
                } else if (selectedIndex > 0) {
                    FamiliesPanel.this.familyList.setSelectedIndex(--selectedIndex);
                    FamiliesPanel.this.familyList.ensureIndexIsVisible(selectedIndex);
                }
            }
        });
        familiesButtonsPanel.add(btnFamiliesPrevious);
        JButton btnFamiliesNext = new JButton(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.btnNext.text"));
        btnFamiliesNext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int selectedIndex = FamiliesPanel.this.familyList.getSelectedIndex();
                if (selectedIndex == -1) {
                    if (FamiliesPanel.this.netGUI.getNet().families().size() != 0) {
                        selectedIndex = 0;
                        FamiliesPanel.this.familyList.setSelectedIndex(selectedIndex);
                        FamiliesPanel.this.familyList.ensureIndexIsVisible(selectedIndex);
                    }
                } else if (selectedIndex < FamiliesPanel.this.netGUI.getNet().families().size() - 1) {
                    FamiliesPanel.this.familyList.setSelectedIndex(++selectedIndex);
                    FamiliesPanel.this.familyList.ensureIndexIsVisible(selectedIndex);
                }
            }
        });
        familiesButtonsPanel.add(btnFamiliesNext);
        Component horizontalGlue_4 = Box.createHorizontalGlue();
        familiesButtonsPanel.add(horizontalGlue_4);
        JButton btnRta = new JButton(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("FamiliesPanel.btnRta.text"));
        btnRta.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FamiliesPanel.this.updateAttributeTemplates();
            }
        });
        btnRta.setToolTipText(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("FamiliesPanel.btnRta.toolTipText"));
        familiesButtonsPanel.add(btnRta);
        Component horizontalGlue_1 = Box.createHorizontalGlue();
        familiesButtonsPanel.add(horizontalGlue_1);
        JLabel lblFamiliesSearch = new JLabel(" ");
        lblFamiliesSearch.setIcon(new ImageIcon(MainWindow.class.getResource("/org/tip/puckgui/images/find.png")));
        lblFamiliesSearch.setToolTipText("Search: ");
        lblFamiliesSearch.setMinimumSize(new Dimension(300, 15));
        familiesButtonsPanel.add(lblFamiliesSearch);
        this.txtfldSearchFamily = new JTextField();
        this.txtfldSearchFamily.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int index;
                String pattern = FamiliesPanel.this.txtfldSearchFamily.getText();
                logger.debug("Search family=[" + pattern + "]");
                if (StringUtils.isNotBlank((CharSequence)pattern) && (index = ((FamiliesModel)FamiliesPanel.this.familyList.getModel()).nextSearchedFamilyIndex(pattern)) != -1) {
                    FamiliesPanel.this.familyList.setSelectedIndex(index);
                    FamiliesPanel.this.familyList.ensureIndexIsVisible(index);
                }
            }
        });
        this.txtfldSearchFamily.setText("");
        this.txtfldSearchFamily.setMaximumSize(new Dimension(500, 50));
        this.txtfldSearchFamily.setColumns(15);
        familiesButtonsPanel.add(this.txtfldSearchFamily);
    }

    public void addChild() {
        if (((FamilyChildrenModel)this.tableFamilyChildren.getModel()).getSource() != null && !((FamilyChildrenModel)this.tableFamilyChildren.getModel()).isNewEditionOn()) {
            ((FamilyChildrenModel)this.tableFamilyChildren.getModel()).setNewItem();
            this.tableFamilyChildren.scrollRectToVisible(this.tableFamilyChildren.getCellRect(this.tableFamilyChildren.getModel().getRowCount() - 1, 0, true));
            this.tableFamilyChildren.setRowSelectionInterval(this.tableFamilyChildren.getModel().getRowCount() - 1, this.tableFamilyChildren.getModel().getRowCount() - 1);
            this.tableFamilyChildren.editCellAt(this.tableFamilyChildren.getModel().getRowCount() - 1, 0);
            this.tableFamilyChildren.getEditorComponent().requestFocus();
        }
    }

    public void addFamily() {
        try {
            Family newFamily = this.netGUI.getNet().createFamily(NumberablesHashMap.IdStrategy.APPEND, null, null, new Individual[0]);
            this.netGUI.setChanged(true);
            this.netGUI.updateAll();
            this.netGUI.selectFamiliesTab(newFamily);
            this.setParent1EditorOn();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            String title = "Error computerum est";
            String message = "Error occured during working: " + exception.getMessage();
            JOptionPane.showMessageDialog(null, message, title, 0);
        }
    }

    public Family getIdentityFamily() {
        Family result = NumberUtils.isDigits((String)this.lblFamilyId.getText()) ? (Family)this.netGUI.getNet().families().getById(Integer.parseInt(this.lblFamilyId.getText())) : null;
        return result;
    }

    public Individual getIdentityParent1() {
        Individual result = NumberUtils.isDigits((String)this.lblFamilyFatherId.getText()) ? (Individual)this.netGUI.getNet().individuals().getById(Integer.parseInt(this.lblFamilyFatherId.getText())) : null;
        return result;
    }

    public Individual getIdentityParent2() {
        Individual result = NumberUtils.isDigits((String)this.lblFamilyMotherId.getText()) ? (Individual)this.netGUI.getNet().individuals().getById(Integer.parseInt(this.lblFamilyMotherId.getText())) : null;
        return result;
    }

    public Family getSelectedFamily() {
        Family result = this.familyList.getSelectedIndex() == -1 ? null : (Family)((FamiliesModel)this.familyList.getModel()).getElementAt(this.familyList.getSelectedIndex());
        return result;
    }

    public void select(Family family) {
        int familyIndex = ((FamiliesModel)this.familyList.getModel()).indexOf(family);
        if (familyIndex >= 0 && familyIndex < ((FamiliesModel)this.familyList.getModel()).getSize()) {
            this.familyList.setSelectedIndex(familyIndex);
            this.familyList.ensureIndexIsVisible(familyIndex);
        } else if (((FamiliesModel)this.familyList.getModel()).getSize() != 0) {
            this.familyList.setSelectedIndex(0);
            this.familyList.ensureIndexIsVisible(0);
        } else {
            this.updateFamilyIdentity(null);
        }
    }

    public void selectByIndex(int familyIndex) {
        if (familyIndex >= 0 && familyIndex < ((FamiliesModel)this.familyList.getModel()).getSize()) {
            this.familyList.setSelectedIndex(familyIndex);
            this.familyList.ensureIndexIsVisible(familyIndex);
        } else if (((FamiliesModel)this.familyList.getModel()).getSize() != 0) {
            this.familyList.setSelectedIndex(0);
            this.familyList.ensureIndexIsVisible(0);
        } else {
            this.updateFamilyIdentity(null);
        }
    }

    private void setFamilyIdEditorOn() {
        logger.debug("Family id clicked");
        this.txtFldFamilyId.setText(this.lblFamilyId.getText());
        this.lblFamilyId.setVisible(false);
        this.txtFldFamilyId.setVisible(true);
        this.txtFldFamilyId.requestFocus();
    }

    public void setFocusOnFind() {
        this.txtfldSearchFamily.requestFocus();
    }

    private void setParent1EditorOn() {
        Individual currentParent = this.getIdentityParent1();
        List individuals = this.netGUI.getNet().individuals().toSortedList();
        ArrayList<String> items = new ArrayList<String>(individuals.size());
        for (Individual individual : individuals) {
            items.add(String.valueOf(individual.getId()) + " " + individual.getName());
        }
        this.cmbbxFamilyParent1.setDataList(items);
        if (currentParent == null) {
            this.cmbbxFamilyParent1.setSelectedIndex(-1);
        } else {
            int currentItemIndex = ToolBox.indexOf(String.valueOf(currentParent.getId()) + " " + currentParent.getName(), items);
            this.cmbbxFamilyParent1.setSelectedIndex(currentItemIndex);
        }
        this.lblFamilyFatherId.setVisible(false);
        this.lblFamilyFatherName.setVisible(false);
        this.cmbbxFamilyParent1.setVisible(true);
        this.cmbbxFamilyParent1.requestFocus();
    }

    private void setParent2EditorOn() {
        Individual currentParent2 = this.getIdentityParent2();
        List individuals = this.netGUI.getNet().individuals().toSortedList();
        ArrayList<String> items = new ArrayList<String>(individuals.size());
        for (Individual individual : individuals) {
            items.add(String.valueOf(individual.getId()) + " " + individual.getName());
        }
        this.cmbbxFamilyParent2.setDataList(items);
        if (currentParent2 == null) {
            this.cmbbxFamilyParent2.setSelectedIndex(-1);
        } else {
            int currentItemIndex = ToolBox.indexOf(String.valueOf(currentParent2.getId()) + " " + currentParent2.getName(), items);
            this.cmbbxFamilyParent2.setSelectedIndex(currentItemIndex);
        }
        this.lblFamilyMotherId.setVisible(false);
        this.lblFamilyMotherName.setVisible(false);
        this.cmbbxFamilyParent2.setVisible(true);
        this.cmbbxFamilyParent2.requestFocus();
    }

    public void update() {
        int selectedFamily = this.familyList.getSelectedIndex();
        ((FamiliesModel)this.familyList.getModel()).setSource(this.netGUI.getCurrentFamilies());
        this.selectByIndex(selectedFamily);
    }

    public void updateAttributeTemplates() {
        this.attributeTemplates.clear();
        if (this.netGUI != null && this.netGUI.getNet() != null) {
            StringList templates = AttributeWorker.getExogenousAttributeDescriptors(this.netGUI.getNet().families(), null).labels();
            this.attributeTemplates.addAll((Collection)templates);
        }
    }

    public void updateFamilyIdentity(Family source) {
        if (source == null) {
            logger.debug("updateFamilyIdentity null");
        } else {
            logger.debug("updateFamilyIdentity " + source.getId());
        }
        if (source == null) {
            this.lblFamilyId.setText("---");
            this.txtFldFamilyId.setVisible(false);
            this.lblFamilyStatus.setIcon(largeUnknowIcon);
            this.lblPosition.setText("(--/--)");
            this.lblFamilyFatherId.setText("---");
            this.lblFamilyFatherName.setText(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.individual.unknown"));
            this.lblFamilyFatherName.setIcon(mediumUnknowIcon);
            this.lblFamilyMotherId.setText("---");
            this.lblFamilyMotherName.setText(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.individual.unknown"));
            this.lblFamilyMotherName.setIcon(mediumUnknowIcon);
            this.lblFamilyChildren.setText(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.lblChildren.text"));
            ((FamilyChildrenModel)this.tableFamilyChildren.getModel()).setSource(null);
            this.cmbbxFamilyChildrenIds.setDataList(new ArrayList(0));
            this.attributesPanel.setSource(null);
            this.btnAddChild.setEnabled(false);
        } else {
            int sourceIndex;
            Family selected;
            this.lblFamilyId.setText(String.valueOf(source.getId()));
            this.txtFldFamilyId.setVisible(false);
            switch (source.getUnionStatus()) {
                case UNMARRIED: {
                    this.lblFamilyStatus.setIcon(largeUnmarriedIcon);
                    break;
                }
                case MARRIED: {
                    this.lblFamilyStatus.setIcon(largeMarriedIcon);
                    break;
                }
                case DIVORCED: {
                    this.lblFamilyStatus.setIcon(largeDivorcedIcon);
                    break;
                }
                default: {
                    this.lblFamilyStatus.setIcon(largeUnknowIcon);
                }
            }
            this.lblPosition.setText("(" + (this.familyList.getSelectedIndex() + 1) + "/" + this.familyList.getModel().getSize() + ")");
            if (source.getFather() == null) {
                this.lblFamilyFatherId.setText("---");
                this.lblFamilyFatherName.setText(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.individual.unknown"));
                this.lblFamilyFatherName.setIcon(mediumUnknowIcon);
            } else {
                this.lblFamilyFatherId.setText(String.valueOf(source.getFather().getId()));
                this.lblFamilyFatherName.setText(source.getFather().getName());
                switch (source.getFather().getGender()) {
                    case FEMALE: {
                        this.lblFamilyFatherName.setIcon(mediumFemaleIcon);
                        break;
                    }
                    case MALE: {
                        this.lblFamilyFatherName.setIcon(mediumMaleIcon);
                        break;
                    }
                    case UNKNOWN: {
                        this.lblFamilyFatherName.setIcon(mediumUnknowIcon);
                    }
                }
            }
            if (source.getMother() == null) {
                this.lblFamilyMotherId.setText("---");
                this.lblFamilyMotherName.setText(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.individual.unknown"));
                this.lblFamilyMotherName.setIcon(mediumUnknowIcon);
            } else {
                this.lblFamilyMotherId.setText(String.valueOf(source.getMother().getId()));
                this.lblFamilyMotherName.setText(source.getMother().getName());
                switch (source.getMother().getGender()) {
                    case FEMALE: {
                        this.lblFamilyMotherName.setIcon(mediumFemaleIcon);
                        break;
                    }
                    case MALE: {
                        this.lblFamilyMotherName.setIcon(mediumMaleIcon);
                        break;
                    }
                    case UNKNOWN: {
                        this.lblFamilyMotherName.setIcon(mediumUnknowIcon);
                    }
                }
            }
            ((FamilyChildrenModel)this.tableFamilyChildren.getModel()).setSource(source);
            this.lblFamilyChildren.setText(String.valueOf(ResourceBundle.getBundle("org.tip.puckgui.messages").getString("MainWindow.lblChildren.text")) + " (" + ((FamilyChildrenModel)this.tableFamilyChildren.getModel()).children().size() + ")");
            this.cmbbxFamilyChildrenIds.setDataList(ComboBoxIds.instance().items());
            this.attributesPanel.setSource(source.attributes());
            int selectedIndex = this.familyList.getSelectedIndex();
            if (selectedIndex != -1 && source != (selected = (Family)((FamiliesModel)this.familyList.getModel()).getElementAt(selectedIndex)) && (sourceIndex = ((FamiliesModel)this.familyList.getModel()).indexOf(source)) != -1) {
                this.familyList.setSelectedIndex(sourceIndex);
                this.familyList.ensureIndexIsVisible(sourceIndex);
            }
            this.btnAddChild.setEnabled(true);
        }
    }

    private static void addPopup(Component component, final JPopupMenu popup) {
        component.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.showMenu(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.showMenu(e);
                }
            }

            private void showMenu(MouseEvent e) {
                popup.show(e.getComponent(), e.getX(), e.getY());
            }
        });
    }
}

