/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puckgui.views;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import fr.devinsy.util.StringList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.net.relations.RelationModels;
import org.tip.puck.net.workers.AttributeDescriptors;
import org.tip.puck.spacetime.SpaceTimeCriteria;

public class DiscontinuousItinerariesInputDialog
extends JDialog {
    private static final long serialVersionUID = 9154925259628674969L;
    private static final Logger logger = LoggerFactory.getLogger(DiscontinuousItinerariesInputDialog.class);
    private RelationModels relationModels;
    private AttributeDescriptors attributeDescriptors;
    private final JPanel contentPanel = new JPanel();
    private SpaceTimeCriteria dialogCriteria;
    private static SpaceTimeCriteria lastCriteria = new SpaceTimeCriteria();
    private JComboBox cmbxEgoRole;
    private JComboBox cmbxDateLabel;
    private JButton okButton;
    private JComboBox cmbxStartPlaceLabel;
    private JComboBox cmbxEndPlaceLabel;

    public DiscontinuousItinerariesInputDialog(RelationModels relationModels, AttributeDescriptors attributeDescriptors) {
        this.relationModels = relationModels;
        this.attributeDescriptors = attributeDescriptors;
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.setModal(true);
        this.setAlwaysOnTop(true);
        this.setTitle("Discontinuous Itineraries Input Dialog");
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(DiscontinuousItinerariesInputDialog.class.getResource("/org/tip/puckgui/favicon-16x16.jpg")));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                DiscontinuousItinerariesInputDialog.this.dialogCriteria = null;
                DiscontinuousItinerariesInputDialog.this.setVisible(false);
            }
        });
        this.setBounds(100, 100, 420, 242);
        this.getContentPane().setLayout(new BorderLayout());
        this.contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)this.contentPanel, "Center");
        this.contentPanel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"max(100dlu;default):grow"), FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC}));
        JLabel lblEgoRole = new JLabel("Ego Role:");
        this.contentPanel.add((Component)lblEgoRole, "2, 2, right, default");
        this.cmbxEgoRole = new JComboBox();
        this.contentPanel.add((Component)this.cmbxEgoRole, "4, 2, fill, default");
        JLabel lblDateLabel = new JLabel("Date Label:");
        this.contentPanel.add((Component)lblDateLabel, "2, 4, right, default");
        this.cmbxDateLabel = new JComboBox();
        this.contentPanel.add((Component)this.cmbxDateLabel, "4, 4, fill, default");
        JLabel lblStartPlaceLabel = new JLabel("Start Place Label");
        this.contentPanel.add((Component)lblStartPlaceLabel, "2, 6, right, default");
        this.cmbxStartPlaceLabel = new JComboBox();
        this.contentPanel.add((Component)this.cmbxStartPlaceLabel, "4, 6, fill, default");
        JLabel lblEndPlaceLabel = new JLabel("End Place Label");
        this.contentPanel.add((Component)lblEndPlaceLabel, "2, 8, right, default");
        this.cmbxEndPlaceLabel = new JComboBox();
        this.contentPanel.add((Component)this.cmbxEndPlaceLabel, "4, 8, fill, default");
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new FlowLayout(1));
        this.getContentPane().add((Component)buttonPane, "South");
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DiscontinuousItinerariesInputDialog.this.dialogCriteria = null;
                DiscontinuousItinerariesInputDialog.this.setVisible(false);
            }
        });
        cancelButton.setActionCommand("Cancel");
        buttonPane.add(cancelButton);
        this.okButton = new JButton("Launch");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SpaceTimeCriteria criteria = DiscontinuousItinerariesInputDialog.this.getCriteria();
                if (criteria.getEgoRoleName() == null) {
                    String title = "Invalid input";
                    String message = "An ego role is required to launch.";
                    JOptionPane.showMessageDialog(null, message, title, 0);
                } else if (criteria.getDateLabel() == null) {
                    String title = "Invalid input";
                    String message = "A valid date label is required to launch.";
                    JOptionPane.showMessageDialog(null, message, title, 0);
                } else if (criteria.getStartDateLabel() == null) {
                    String title = "Invalid input";
                    String message = "A valid start date label is required to launch.";
                    JOptionPane.showMessageDialog(null, message, title, 0);
                } else if (criteria.getEndDateLabel() == null) {
                    String title = "Invalid input";
                    String message = "A valid end date label is required to launch.";
                    JOptionPane.showMessageDialog(null, message, title, 0);
                } else {
                    lastCriteria = criteria;
                    DiscontinuousItinerariesInputDialog.this.dialogCriteria = criteria;
                    DiscontinuousItinerariesInputDialog.this.setVisible(false);
                }
            }
        });
        this.okButton.setActionCommand("OK");
        buttonPane.add(this.okButton);
        this.getRootPane().setDefaultButton(this.okButton);
        this.cmbxEgoRole.setModel(new DefaultComboBoxModel<Object>(relationModels.roleNames().sort().toArray()));
        StringList labels = this.attributeDescriptors.labels().sort();
        this.cmbxDateLabel.setModel(new DefaultComboBoxModel<Object>(labels.toArray()));
        this.cmbxStartPlaceLabel.setModel(new DefaultComboBoxModel<Object>(labels.toArray()));
        this.cmbxEndPlaceLabel.setModel(new DefaultComboBoxModel<Object>(labels.toArray()));
        this.setCriteria(lastCriteria);
    }

    public SpaceTimeCriteria getCriteria() {
        SpaceTimeCriteria result = new SpaceTimeCriteria();
        if (this.cmbxEgoRole.getSelectedIndex() == -1) {
            result.setEgoRoleName(null);
        } else {
            result.setEgoRoleName((String)this.cmbxEgoRole.getSelectedItem());
        }
        if (this.cmbxDateLabel.getSelectedIndex() == -1) {
            result.setDateLabel(null);
        } else {
            result.setDateLabel((String)this.cmbxDateLabel.getSelectedItem());
        }
        if (this.cmbxStartPlaceLabel.getSelectedIndex() == -1) {
            result.setStartPlaceLabel(null);
        } else {
            result.setStartPlaceLabel((String)this.cmbxStartPlaceLabel.getSelectedItem());
        }
        if (this.cmbxEndPlaceLabel.getSelectedIndex() == -1) {
            result.setEndPlaceLabel(null);
        } else {
            result.setEndPlaceLabel((String)this.cmbxEndPlaceLabel.getSelectedItem());
        }
        return result;
    }

    public SpaceTimeCriteria getDialogCriteria() {
        SpaceTimeCriteria result = this.dialogCriteria;
        return result;
    }

    private void setCriteria(SpaceTimeCriteria source) {
        if (source != null) {
            if (source.getEgoRoleName() != null) {
                this.cmbxEgoRole.setSelectedItem(source.getEgoRoleName());
            }
            if (source.getDateLabel() != null) {
                this.cmbxDateLabel.setSelectedItem(source.getDateLabel());
            }
            if (source.getStartDateLabel() != null) {
                this.cmbxStartPlaceLabel.setSelectedItem(source.getStartDateLabel());
            }
            if (source.getEndDateLabel() != null) {
                this.cmbxEndPlaceLabel.setSelectedItem(source.getEndDateLabel());
            }
        }
    }

    public static void main(String[] args) {
        DiscontinuousItinerariesInputDialog.showDialog(null, null);
    }

    public static SpaceTimeCriteria showDialog(RelationModels relationModels, AttributeDescriptors attributeDescriptors) {
        DiscontinuousItinerariesInputDialog dialog = new DiscontinuousItinerariesInputDialog(relationModels, attributeDescriptors);
        dialog.setLocationRelativeTo(null);
        dialog.pack();
        dialog.setVisible(true);
        SpaceTimeCriteria result = dialog.getDialogCriteria();
        return result;
    }
}

