/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puckgui.views;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import fr.devinsy.util.StringList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import org.apache.commons.lang3.StringUtils;
import org.tip.puck.net.workers.AttributeDescriptor;
import org.tip.puck.net.workers.AttributeDescriptors;
import org.tip.puck.net.workers.AttributeSetValueCriteria;
import org.tip.puck.net.workers.AttributeWorker;

public class AttributeSetValueInputDialog
extends JDialog {
    private static final long serialVersionUID = 7208254679850378876L;
    private final JPanel contentPanel = new JPanel();
    private AttributeSetValueCriteria dialogCriteria;
    private static AttributeSetValueCriteria lastCriteria = new AttributeSetValueCriteria();
    private JComboBox cmbbxTarget;
    private JComboBox cmbbxLabel;
    private JTextField txtfldValue;

    public AttributeSetValueInputDialog(List<String> relationModelNames, final AttributeDescriptors attributeDescriptors) {
        ArrayList<String> targetLabels = new ArrayList<String>();
        targetLabels.add("ALL");
        targetLabels.add("CORPUS");
        targetLabels.add("INDIVIDUALS");
        targetLabels.add("FAMILIES");
        targetLabels.add("RELATIONS");
        if (relationModelNames != null) {
            for (String name : relationModelNames) {
                targetLabels.add(name);
            }
        }
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.setModal(true);
        this.setAlwaysOnTop(true);
        this.setTitle("Set Attribute Value Input");
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(AttributeSetValueInputDialog.class.getResource("/org/tip/puckgui/favicon-16x16.jpg")));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                AttributeSetValueInputDialog.this.dialogCriteria = null;
                AttributeSetValueInputDialog.this.setVisible(false);
            }
        });
        this.setBounds(100, 100, 420, 167);
        this.getContentPane().setLayout(new BorderLayout());
        this.contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)this.contentPanel, "Center");
        this.contentPanel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormFactory.RELATED_GAP_COLSPEC}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC}));
        JLabel lblTarget = new JLabel("Target:");
        this.contentPanel.add((Component)lblTarget, "2, 2, right, default");
        this.cmbbxTarget = new JComboBox<Object>(targetLabels.toArray());
        this.cmbbxTarget.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                if (event.getStateChange() == 1) {
                    StringList labels;
                    switch (AttributeSetValueInputDialog.this.cmbbxTarget.getSelectedIndex()) {
                        case 0: {
                            labels = attributeDescriptors.labels();
                            break;
                        }
                        case 1: {
                            labels = attributeDescriptors.findByScope(AttributeDescriptor.Scope.CORPUS).labels();
                            break;
                        }
                        case 2: {
                            labels = attributeDescriptors.findByScope(AttributeDescriptor.Scope.INDIVIDUALS).labels();
                            break;
                        }
                        case 3: {
                            labels = attributeDescriptors.findByScope(AttributeDescriptor.Scope.FAMILIES).labels();
                            break;
                        }
                        case 4: {
                            labels = attributeDescriptors.findByScope(AttributeDescriptor.Scope.RELATION).labels();
                            break;
                        }
                        default: {
                            labels = attributeDescriptors.findByRelationModelName((String)AttributeSetValueInputDialog.this.cmbbxTarget.getSelectedItem()).labels();
                        }
                    }
                    Collections.sort(labels);
                    AttributeSetValueInputDialog.this.cmbbxLabel.setModel(new DefaultComboBoxModel<Object>(labels.toArray()));
                    AttributeSetValueInputDialog.this.cmbbxLabel.setSelectedIndex(-1);
                }
            }
        });
        this.contentPanel.add((Component)this.cmbbxTarget, "4, 2, fill, default");
        JLabel lblLabel = new JLabel("Label:");
        this.contentPanel.add((Component)lblLabel, "2, 4, right, default");
        this.cmbbxLabel = new JComboBox<Object>(attributeDescriptors.labelsSorted().toArray());
        this.cmbbxLabel.setEditable(true);
        this.contentPanel.add((Component)this.cmbbxLabel, "4, 4, fill, default");
        JLabel lblNewLabel = new JLabel("Value:");
        this.contentPanel.add((Component)lblNewLabel, "2, 6, right, default");
        this.txtfldValue = new JTextField();
        this.contentPanel.add((Component)this.txtfldValue, "4, 6");
        this.txtfldValue.setColumns(10);
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new FlowLayout(1));
        this.getContentPane().add((Component)buttonPane, "South");
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AttributeSetValueInputDialog.this.dialogCriteria = null;
                AttributeSetValueInputDialog.this.setVisible(false);
            }
        });
        cancelButton.setActionCommand("Cancel");
        buttonPane.add(cancelButton);
        JButton okButton = new JButton("Set Value");
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AttributeSetValueCriteria criteria = AttributeSetValueInputDialog.this.getCriteria();
                if (StringUtils.isBlank((CharSequence)criteria.getLabel())) {
                    String title = "Invalid input";
                    String message = "Please, enter a label not empty.";
                    JOptionPane.showMessageDialog(null, message, title, 0);
                } else {
                    lastCriteria = criteria;
                    AttributeSetValueInputDialog.this.dialogCriteria = criteria;
                    AttributeSetValueInputDialog.this.setVisible(false);
                }
            }
        });
        okButton.setActionCommand("OK");
        buttonPane.add(okButton);
        this.getRootPane().setDefaultButton(okButton);
        this.setCriteria(lastCriteria);
    }

    public AttributeSetValueCriteria getCriteria() {
        String optionalName;
        AttributeWorker.Scope scope;
        AttributeSetValueCriteria result = new AttributeSetValueCriteria();
        switch (this.cmbbxTarget.getSelectedIndex()) {
            case 0: {
                scope = AttributeWorker.Scope.ALL;
                optionalName = null;
                break;
            }
            case 1: {
                scope = AttributeWorker.Scope.CORPUS;
                optionalName = null;
                break;
            }
            case 2: {
                scope = AttributeWorker.Scope.INDIVIDUALS;
                optionalName = null;
                break;
            }
            case 3: {
                scope = AttributeWorker.Scope.FAMILIES;
                optionalName = null;
                break;
            }
            case 4: {
                scope = AttributeWorker.Scope.RELATIONS;
                optionalName = null;
                break;
            }
            default: {
                scope = AttributeWorker.Scope.RELATION;
                optionalName = (String)this.cmbbxTarget.getSelectedItem();
            }
        }
        result.setScope(scope);
        result.setOptionalRelationName(optionalName);
        result.setLabel((String)this.cmbbxLabel.getSelectedItem());
        result.setTargetValue(this.txtfldValue.getText());
        return result;
    }

    public AttributeSetValueCriteria getDialogCriteria() {
        AttributeSetValueCriteria result = this.dialogCriteria;
        return result;
    }

    private void setCriteria(AttributeSetValueCriteria source) {
        if (source != null) {
            switch (source.getScope()) {
                case ALL: {
                    this.cmbbxTarget.setSelectedIndex(0);
                    break;
                }
                case CORPUS: {
                    this.cmbbxTarget.setSelectedIndex(1);
                    break;
                }
                case INDIVIDUALS: {
                    this.cmbbxTarget.setSelectedIndex(2);
                    break;
                }
                case FAMILIES: {
                    this.cmbbxTarget.setSelectedIndex(3);
                    break;
                }
                case RELATIONS: {
                    this.cmbbxTarget.setSelectedIndex(4);
                    break;
                }
                default: {
                    this.cmbbxTarget.setSelectedItem(source.getOptionalRelationName());
                }
            }
            this.cmbbxLabel.setSelectedItem(source.getLabel());
            this.txtfldValue.setText(source.getTargetValue());
        }
    }

    public static void main(String[] args) {
        AttributeSetValueInputDialog.showDialog(null, null);
    }

    public static AttributeSetValueCriteria showDialog(List<String> relationModelNames, AttributeDescriptors attributeDescriptors) {
        AttributeSetValueInputDialog dialog = new AttributeSetValueInputDialog(relationModelNames, attributeDescriptors);
        dialog.setLocationRelativeTo(null);
        dialog.pack();
        dialog.setVisible(true);
        AttributeSetValueCriteria result = dialog.getDialogCriteria();
        return result;
    }
}

