/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puckgui.models;

import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractListModel;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.tip.puck.net.relations.Relation;
import org.tip.puck.net.relations.Relations;

public class RelationsModel
extends AbstractListModel {
    private static final long serialVersionUID = 6934494508049569439L;
    private Relations source;
    private List<Relation> delegate;
    private int lastSearchIndex;
    private String lastSearchPattern;

    public RelationsModel(Relations source) {
        this.source = source;
        this.delegate = source == null ? new ArrayList<Relation>(0) : this.source.toListSortedByTypeId();
        this.lastSearchIndex = -1;
        this.lastSearchPattern = null;
    }

    @Override
    public Object getElementAt(int index) {
        Relation result = this.delegate.get(index);
        return result;
    }

    @Override
    public int getSize() {
        int result = this.delegate.size();
        return result;
    }

    public Relations getSource() {
        return this.source;
    }

    public int indexOf(Relation relation) {
        int result;
        if (this.source == null) {
            result = -1;
        } else {
            boolean ended = false;
            result = -1;
            int index = 0;
            while (!ended) {
                if (index < this.delegate.size()) {
                    if (this.delegate.get(index) == relation) {
                        ended = true;
                        result = index;
                        continue;
                    }
                    ++index;
                    continue;
                }
                ended = true;
                result = -1;
            }
        }
        return result;
    }

    public Relation nextSearched(String pattern) {
        Relation result;
        if (StringUtils.isBlank((CharSequence)pattern)) {
            result = null;
        } else if (NumberUtils.isDigits((String)pattern)) {
            int relationId = Integer.parseInt(pattern);
            result = (Relation)this.source.getById(relationId);
            this.resetSearch();
        } else {
            List<Relation> foundRelations = this.source.searchByName(pattern);
            if (foundRelations.isEmpty()) {
                this.resetSearch();
                result = null;
            } else if (this.lastSearchPattern == null || !this.lastSearchPattern.equals(pattern)) {
                this.lastSearchIndex = 0;
                this.lastSearchPattern = pattern;
                result = foundRelations.get(0);
            } else {
                ++this.lastSearchIndex;
                if (this.lastSearchIndex >= foundRelations.size()) {
                    this.lastSearchIndex = 0;
                }
                result = foundRelations.get(this.lastSearchIndex);
            }
        }
        return result;
    }

    public int nextSearchedIndex(String pattern) {
        int result = this.indexOf(this.nextSearched(pattern));
        return result;
    }

    public void resetSearch() {
        this.lastSearchIndex = -1;
        this.lastSearchPattern = null;
    }

    public void setSource(Relations source) {
        this.resetSearch();
        this.fireIntervalRemoved(this, 0, this.delegate.size());
        this.source = source;
        this.delegate = this.source.toListSortedByTypeId();
        this.fireIntervalAdded(this, 0, this.delegate.size());
    }
}

