/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.visualization.layouts.hierarchical.datastructs.chain;

import java.util.Iterator;
import java.util.Set;
import org.gephi.graph.api.Node;
import org.tip.puck.visualization.layouts.GraphSource;
import org.tip.puck.visualization.layouts.hierarchical.datastructs.chain.NodeLayoutData;

public class ColoredChain {
    private final Node top;
    private Node bottom;
    private int height;

    public static ColoredChain createDownChain(Node firstNode, GraphSource graphSource) {
        ColoredChain chain = new ColoredChain(firstNode);
        chain.populateDownChain(graphSource);
        return chain;
    }

    private ColoredChain(Node top) {
        this.top = top;
        this.bottom = top;
        this.height = 1;
    }

    public Node[] getNodes(GraphSource graphSource) {
        Node[] list = new Node[this.height];
        list[0] = this.top;
        int i = 1;
        while (i < this.height) {
            Node next;
            Set<Node> children = graphSource.getChildren(list[i - 1]);
            list[i] = next = children.iterator().next();
            ++i;
        }
        return list;
    }

    public Node getBottomNode() {
        return this.bottom;
    }

    public Node getTopNode() {
        return this.top;
    }

    public int getHeight() {
        return this.height;
    }

    public int hashCode() {
        int hash = 7;
        hash = 61 * hash + (this.top != null ? this.top.hashCode() : 0);
        hash = 61 * hash + (this.bottom != null ? this.bottom.hashCode() : 0);
        hash = 61 * hash + this.height;
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ColoredChain other = (ColoredChain)obj;
        if (!(this.top == other.top || this.top != null && this.top.equals(other.top))) {
            return false;
        }
        if (!(this.bottom == other.bottom || this.bottom != null && this.bottom.equals(other.bottom))) {
            return false;
        }
        return this.height == other.height;
    }

    private void populateDownChain(GraphSource graphSource) {
        boolean canGo = true;
        while (canGo) {
            Node otherParent;
            Node last = this.bottom;
            Set<Node> children = graphSource.getChildren(last);
            if (children.isEmpty()) {
                canGo = false;
                continue;
            }
            if (children.size() == 1) {
                Iterator<Node> it = children.iterator();
                Node child = it.next();
                otherParent = graphSource.getOtherParent(child, last);
                if (otherParent == null) {
                    this.bottom = child;
                    ++this.height;
                    continue;
                }
                canGo = false;
                NodeLayoutData.color(child, NodeLayoutData.Color.RED);
                continue;
            }
            for (Node child : children) {
                otherParent = graphSource.getOtherParent(child, last);
                if (otherParent == null) continue;
                NodeLayoutData.color(child, NodeLayoutData.Color.RED);
            }
            canGo = false;
        }
    }
}

