/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.spacetime;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.tip.puck.net.Individuals;
import org.tip.puck.net.relations.Relation;
import org.tip.puck.net.relations.Relations;
import org.tip.puck.net.workers.RelationValuator;
import org.tip.puck.spacetime.Ordinal;
import org.tip.puck.spacetime.Sequences;
import org.tip.puck.spacetime.Slice;
import org.tip.puck.spacetime.SpaceTimeCriteria;
import org.tip.puck.util.NumberablesHashMap;
import org.tip.puck.util.Value;

public class Slices
extends NumberablesHashMap<Slice> {
    private String idLabel;
    private String dateLabel;
    private String placeLabel;
    private String startDateLabel;
    private String endDateLabel;
    Map<String, Individuals> membersByRelationId = new TreeMap<String, Individuals>();
    private String relationModelName;
    private Relations relations;
    private Relations allRelations;
    private Sequences groupSequences = new Sequences();
    private Sequences indiSequences = new Sequences();

    public Slices(SpaceTimeCriteria criteria) {
        this.relationModelName = criteria.getRelationModelName();
        this.dateLabel = criteria.getDateLabel();
        this.idLabel = criteria.getLocalUnitLabel();
        this.placeLabel = criteria.getPlaceLabel();
        this.startDateLabel = criteria.getStartDateLabel();
        this.endDateLabel = criteria.getEndDateLabel();
    }

    public Slice getByOrdinal(Ordinal ordinal) {
        Slice result = null;
        if (ordinal != null) {
            result = (Slice)this.getById(ordinal.getYear());
        }
        return result;
    }

    public Map<String, Individuals> membersByRelationId() {
        return this.membersByRelationId;
    }

    public List<String> idValues() {
        ArrayList<String> result = new ArrayList<String>(this.membersByRelationId.keySet());
        Collections.sort(result);
        return result;
    }

    public List<Integer> ids() {
        ArrayList<Integer> result = new ArrayList<Integer>(this.data.keySet());
        Collections.sort(result);
        return result;
    }

    public String idLabel() {
        return this.idLabel;
    }

    public void setIdLabel(String idLabel) {
        this.idLabel = idLabel;
    }

    public String relationModelName() {
        return this.relationModelName;
    }

    public void setRelationModelName(String relationModelName) {
        this.relationModelName = relationModelName;
    }

    public Relations relations() {
        return this.relations;
    }

    public void setRelations(Relations relations) {
        this.relations = relations;
    }

    public Relations allRelations() {
        return this.allRelations;
    }

    public void setAllRelations(Relations allRelations) {
        this.allRelations = allRelations;
    }

    public Sequences groupSequences() {
        return this.groupSequences;
    }

    public void setGroupSequences(Sequences sequences) {
        this.groupSequences = sequences;
    }

    public Sequences indiSequences() {
        return this.indiSequences;
    }

    public void setIndiSequences(Sequences indiSequences) {
        this.indiSequences = indiSequences;
    }

    public Relations relations(int time) {
        Relations result = null;
        Slice slice = (Slice)this.getById(time);
        if (slice != null) {
            result = slice.relations();
        }
        return result;
    }

    public Relations allRelations(int time) {
        Relations result = new Relations();
        for (Relation relation : this.allRelations) {
            String dateValue = relation.getAttributeValue(this.dateLabel);
            if (!StringUtils.isNumeric((CharSequence)dateValue) || Integer.parseInt(dateValue) != time) continue;
            result.put(relation);
        }
        return result;
    }

    public String dateLabel() {
        return this.dateLabel;
    }

    public void setDateLabel(String dateLabel) {
        this.dateLabel = dateLabel;
    }

    public String placeLabel() {
        return this.placeLabel;
    }

    public void setPlaceLabel(String placeLabel) {
        this.placeLabel = placeLabel;
    }

    public String startDateLabel() {
        return this.startDateLabel;
    }

    public void setStartDateLabel(String startDateLabel) {
        this.startDateLabel = startDateLabel;
    }

    public String endDateLabel() {
        return this.endDateLabel;
    }

    public void setEndDateLabel(String endDateLabel) {
        this.endDateLabel = endDateLabel;
    }

    public Integer time(Relation relation) {
        Value timeValue = RelationValuator.get(relation, this.dateLabel);
        Integer result = timeValue != null ? Integer.valueOf(timeValue.intValue()) : null;
        return result;
    }

    public Individuals members() {
        Individuals result = new Individuals();
        for (Slice slice : this) {
            result.add(slice.members());
        }
        return result;
    }
}

