/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.spacetime;

import org.apache.commons.lang3.StringUtils;
import org.tip.puck.net.Gender;
import org.tip.puck.net.Individual;
import org.tip.puck.net.Individuals;
import org.tip.puck.net.relations.Actor;
import org.tip.puck.net.relations.Relation;
import org.tip.puck.segmentation.Segmentation;
import org.tip.puck.spacetime.Ordinal;
import org.tip.puck.spacetime.Sequence;
import org.tip.puck.spacetime.Slice;
import org.tip.puck.spacetime.Slices;
import org.tip.puck.spacetime.SpaceTimeCriteria;

public class SliceMaker {
    public static Slices createSlices(Segmentation segmentation, SpaceTimeCriteria criteria) {
        Slices result = new Slices(criteria);
        result.setRelations(segmentation.getCurrentRelations().getByModelName(result.relationModelName()));
        result.setAllRelations(segmentation.getAllRelations().getByModelName(result.relationModelName()));
        Integer[] integerArray = criteria.getDates();
        int n = integerArray.length;
        int n2 = 0;
        while (n2 < n) {
            int time = integerArray[n2];
            result.put(new Slice(new Ordinal(time), result.idLabel()));
            ++n2;
        }
        for (Relation relation : result.relations()) {
            Integer time = result.time(relation);
            if (time == null || !result.ids().contains(time)) continue;
            Slice slice = (Slice)result.getById(time);
            slice.put(relation);
            for (Actor actor : relation.actors()) {
                Individual member = actor.getIndividual();
                slice.relationsByIndividuals().put(member, relation);
                String idValue = relation.getAttributeValue(result.idLabel());
                if (idValue == null || !result.ids().contains(time)) continue;
                Individuals members = result.membersByRelationId().get(idValue);
                if (members == null) {
                    members = new Individuals();
                    result.membersByRelationId().put(idValue, members);
                }
                members.put(member);
            }
            String idValue = relation.getAttributeValue(result.idLabel());
            if (idValue != null && StringUtils.isNumeric((CharSequence)idValue)) {
                Integer id = Integer.parseInt(idValue);
                Sequence groupSequence = (Sequence)result.groupSequences().getById(id);
                if (groupSequence == null) {
                    groupSequence = new Sequence(id);
                    groupSequence.setEgo(new Individual(id, "" + id, Gender.UNKNOWN));
                    result.groupSequences().put(groupSequence);
                }
                groupSequence.put(new Ordinal(time), relation);
            }
            for (Actor actor : relation.actors()) {
                Individual ego = actor.getIndividual();
                Sequence indiSequence = (Sequence)result.indiSequences().getById(ego.getId());
                if (indiSequence == null) {
                    indiSequence = new Sequence(ego.getId());
                    indiSequence.setEgo(ego);
                    result.indiSequences().put(indiSequence);
                }
                indiSequence.put(new Ordinal(time), relation);
            }
        }
        return result;
    }

    public static Slice createSlice(Individuals source, String relationModelName, String egoRoleName, String attributeLabel, String dateLabel, Integer time) {
        Slice result = new Slice();
        for (Individual ego : source) {
            for (Relation relation : ego.relations().getByModelName(relationModelName)) {
                if (!relation.hasActor(ego, egoRoleName) || !relation.hasAttributeValue(attributeLabel) || !relation.hasTime(dateLabel, time)) continue;
                result.put(ego, relation);
            }
        }
        return result;
    }
}

