/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.spacetime;

import fr.devinsy.util.StringList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.tip.puck.PuckException;
import org.tip.puck.graphs.Graph;
import org.tip.puck.graphs.Link;
import org.tip.puck.graphs.Node;
import org.tip.puck.graphs.workers.NodeValuator;
import org.tip.puck.net.Gender;
import org.tip.puck.net.Individual;
import org.tip.puck.net.relations.Relation;
import org.tip.puck.partitions.Cluster;
import org.tip.puck.partitions.Partition;
import org.tip.puck.partitions.PartitionMaker;
import org.tip.puck.spacetime.CorrelationMatrix;
import org.tip.puck.spacetime.Sequence;
import org.tip.puck.spacetime.SequenceCensus;
import org.tip.puck.spacetime.Sequences;
import org.tip.puck.spacetime.SpaceTimeCriteria;
import org.tip.puck.util.MathUtils;
import org.tip.puck.util.NumberedValues;
import org.tip.puck.util.PuckUtils;
import org.tip.puck.util.Value;
import org.tip.puck.util.Values;

public class SequencesCensus {
    private Sequences sequences;
    private Map<String, NumberedValues> valuesMap;
    private List<String> labels;
    private Map<String, StringList> pajekBuffers;
    private Map<String, CorrelationMatrix> eventSequenceMatrices;
    private Map<String, CorrelationMatrix> subSequenceMatrices;
    private Map<String, Map<Integer, Partition<Node<Individual>>>> componentsMap;
    private CorrelationMatrix relationConnectionMatrix;
    private Map<SpaceTimeCriteria.RelationClassificationType, Partition<Link<Individual>>> linkPartitions;
    private Map<SpaceTimeCriteria.RelationClassificationType, Map<Value, Double[]>> similaritiesMaps;
    Map<SpaceTimeCriteria.RelationClassificationType, Map<String, Integer>> nrValues;

    public SequencesCensus(Sequences sequences, SpaceTimeCriteria criteria) throws PuckException {
        int i;
        ArrayList<String[]> pairsList;
        List<String> singlesList;
        Value singlesValue;
        Individual ego;
        TreeMap<Individual, List<String[]>> pairs;
        Object singles;
        String eventTypeName;
        this.sequences = sequences;
        this.labels = criteria.getCensusOperationLabels();
        this.valuesMap = new HashMap<String, NumberedValues>();
        for (String label : this.labels) {
            if (label.contains("SIMILARITY")) {
                if (this.similaritiesMaps == null) {
                    this.similaritiesMaps = new HashMap<SpaceTimeCriteria.RelationClassificationType, Map<Value, Double[]>>();
                    this.linkPartitions = new HashMap<SpaceTimeCriteria.RelationClassificationType, Partition<Link<Individual>>>();
                }
                SpaceTimeCriteria.RelationClassificationType relationClassificationType = SpaceTimeCriteria.RelationClassificationType.valueOf(label.substring(label.lastIndexOf("_") + 1));
                this.similaritiesMaps.put(relationClassificationType, new HashMap());
                this.linkPartitions.put(relationClassificationType, new Partition());
            }
            this.valuesMap.put(label, new NumberedValues());
        }
        this.pajekBuffers = new HashMap<String, StringList>();
        for (String title : criteria.getNetworkTitles()) {
            this.pajekBuffers.put(title, new StringList());
        }
        for (String networkTitle : criteria.getNetworkTitles()) {
            if (!networkTitle.contains("Ego Network") && !networkTitle.contains("Parcours Network")) continue;
            if (this.componentsMap == null) {
                this.componentsMap = new HashMap<String, Map<Integer, Partition<Node<Individual>>>>();
            }
            this.componentsMap.put(networkTitle, new HashMap());
        }
        this.eventSequenceMatrices = new HashMap<String, CorrelationMatrix>();
        this.subSequenceMatrices = new HashMap<String, CorrelationMatrix>();
        this.nrValues = new HashMap<SpaceTimeCriteria.RelationClassificationType, Map<String, Integer>>();
        for (SpaceTimeCriteria.RelationClassificationType relationClassificationType : criteria.getMainRelationClassificationTypes()) {
            this.nrValues.put(relationClassificationType, new HashMap());
        }
        for (Sequence sequence : sequences) {
            SequenceCensus census = new SequenceCensus(sequence, criteria);
            for (String label : this.labels) {
                if (label.contains("SIMILARITY")) {
                    SpaceTimeCriteria.RelationClassificationType relationClassificationType = SpaceTimeCriteria.RelationClassificationType.valueOf(label.substring(label.lastIndexOf("_") + 1));
                    this.linkPartitions.get((Object)relationClassificationType).add(census.getParcoursLinkPartition(relationClassificationType));
                }
                this.valuesMap.get(label).put(sequence.getEgo().getId(), census.getValue(label));
            }
            if (this.componentsMap != null) {
                for (String networkTitle : criteria.getNetworkTitles()) {
                    Map<Integer, Partition<Node<Individual>>> components = this.componentsMap.get(networkTitle);
                    if (components == null) continue;
                    if (networkTitle.contains("Ego Network")) {
                        components.put(sequence.getEgo().getId(), census.getComponents("Nonmediated Ego Network"));
                        continue;
                    }
                    if (!networkTitle.contains("Parcours Network")) continue;
                    Object relationClassificationType = SpaceTimeCriteria.RelationClassificationType.valueOf(networkTitle.substring(networkTitle.lastIndexOf("_") + 1));
                    components.put(sequence.getEgo().getId(), census.getComponents("Parcours Network_" + relationClassificationType));
                }
            }
            for (String title : criteria.getNetworkTitles()) {
                if (title.equals("Event Type Network") || title.equals("Sequence Type Network")) continue;
                census.writePajekNetwork(this.pajekBuffers.get(title), title);
            }
        }
        if (criteria.getNetworkTitles().contains("Event Type Network")) {
            for (SpaceTimeCriteria.RelationClassificationType relationClassificationType : criteria.getMainRelationClassificationTypes()) {
                eventTypeName = relationClassificationType.toString();
                singles = new TreeMap();
                pairs = new TreeMap<Individual, List<String[]>>();
                for (Sequence sequence : sequences) {
                    ego = sequence.getEgo();
                    singlesValue = (Value)this.valuesMap.get("PROFILE_" + eventTypeName).get(ego.getId());
                    if (singlesValue == null) continue;
                    singlesList = singlesValue.listValue();
                    pairsList = new ArrayList<String[]>();
                    i = 1;
                    while (i < singlesList.size()) {
                        pairsList.add(new String[]{singlesList.get(i - 1), singlesList.get(i)});
                        ++i;
                    }
                    singles.put(ego, singlesList);
                    pairs.put(ego, pairsList);
                }
                this.eventSequenceMatrices.put(eventTypeName, new CorrelationMatrix("Event Type Network", eventTypeName, (Map<Individual, List<String>>)singles, pairs));
            }
        }
        if (criteria.getNetworkTitles().contains("Sequence Type Network")) {
            for (SpaceTimeCriteria.RelationClassificationType relationClassificationType : criteria.getMainRelationClassificationTypes()) {
                eventTypeName = relationClassificationType.toString();
                singles = new TreeMap();
                pairs = new TreeMap();
                for (Sequence sequence : sequences) {
                    ego = sequence.getEgo();
                    singlesValue = (Value)this.valuesMap.get("PROFILE_" + eventTypeName).get(ego.getId());
                    if (singlesValue == null) continue;
                    singlesList = PuckUtils.cumulateList(singlesValue.listValue());
                    pairsList = new ArrayList();
                    i = 1;
                    while (i < singlesList.size()) {
                        pairsList.add(new String[]{singlesList.get(i - 1), singlesList.get(i)});
                        ++i;
                    }
                    singles.put(ego, singlesList);
                    pairs.put(ego, pairsList);
                }
                this.subSequenceMatrices.put(eventTypeName, new CorrelationMatrix("Sequence Type Network", eventTypeName, (Map<Individual, List<String>>)singles, pairs));
            }
        }
        if (this.labels.contains("CONNECTED_NETWORK_RELATIONS")) {
            TreeMap<Individual, List<String>> singles2 = new TreeMap<Individual, List<String>>();
            TreeMap<Individual, List<String[]>> pairs2 = new TreeMap<Individual, List<String[]>>();
            for (Sequence sequence : sequences) {
                Value pairsValue;
                Individual ego2 = sequence.getEgo();
                Value singlesValue2 = (Value)this.valuesMap.get("NETWORK_RELATIONS").get(ego2.getId());
                if (singlesValue2 != null) {
                    singles2.put(ego2, singlesValue2.listValue());
                }
                if ((pairsValue = (Value)this.valuesMap.get("CONNECTED_NETWORK_RELATIONS").get(ego2.getId())) == null) continue;
                pairs2.put(ego2, pairsValue.listValue());
            }
            this.relationConnectionMatrix = new CorrelationMatrix("Component connections", null, singles2, pairs2);
        }
        for (String networkTitle : criteria.getNetworkTitles()) {
            if (!networkTitle.contains("Parcours Network")) continue;
            for (SpaceTimeCriteria.RelationClassificationType relationClassificationType : this.linkPartitions.keySet()) {
                Partition<Link<Individual>> linkPartition = this.linkPartitions.get((Object)relationClassificationType);
                Map<Value, Double[]> similaritiesMap = this.similaritiesMaps.get((Object)relationClassificationType);
                for (Value linkValue : linkPartition.getValues()) {
                    Double[] values = new Double[]{0.0, 0.0, 0.0, 0.0, 0.0};
                    Double[] sums = new Double[]{0.0, 0.0, 0.0, 0.0, 0.0};
                    for (Link<Individual> link : linkPartition.getCluster(linkValue).getItems()) {
                        int idx;
                        Individual ego3 = link.getSourceNode().getReferent();
                        Individual alter = link.getTargetNode().getReferent();
                        int egoGender = ego3.getGender().toInt();
                        int alterGender = alter.getGender().toInt();
                        int n = idx = egoGender + 2 * alterGender;
                        values[n] = values[n] + link.getWeight();
                        values[4] = values[4] + link.getWeight();
                        int n2 = idx;
                        sums[n2] = sums[n2] + 1.0;
                        sums[4] = sums[4] + 1.0;
                    }
                    int idx = 0;
                    while (idx < sums.length) {
                        values[idx] = MathUtils.percent(values[idx], 100.0 * sums[idx]);
                        ++idx;
                    }
                    similaritiesMap.put(linkValue, values);
                }
            }
        }
        for (SpaceTimeCriteria.RelationClassificationType relationClassificationType : criteria.getMainRelationClassificationTypes()) {
            Gender gender;
            Gender[] genderArray;
            Map<String, Map<Value, Integer>> partitionNumbersMaps;
            ArrayList<String> partitionLabels;
            CorrelationMatrix matrix;
            if (criteria.getNetworkTitles().contains("Event Type Network")) {
                matrix = this.eventSequenceMatrices.get(relationClassificationType.toString());
                Graph<Cluster<String>>[] eventTypeNetworks = matrix.getSequenceNetworks();
                partitionLabels = new ArrayList<String>();
                partitionLabels.add(relationClassificationType.toString());
                partitionNumbersMaps = SequencesCensus.getPartitionNumbersMaps(partitionLabels, eventTypeNetworks[2]);
                for (String label : partitionLabels) {
                    if (partitionNumbersMaps.get(label) == null) continue;
                    this.nrValues.get((Object)relationClassificationType).put(label, partitionNumbersMaps.get(label).size());
                }
                partitionLabels.add("SIZE");
                genderArray = Gender.values();
                int n = genderArray.length;
                int n3 = 0;
                while (n3 < n) {
                    gender = genderArray[n3];
                    this.pajekBuffers.get("Event Type Network").addAll((Collection)PuckUtils.writePajekNetwork(eventTypeNetworks[gender.toInt()], partitionLabels, partitionNumbersMaps));
                    ++n3;
                }
            }
            if (!criteria.getNetworkTitles().contains("Sequence Type Network")) continue;
            matrix = this.subSequenceMatrices.get(relationClassificationType.toString());
            Graph<Cluster<String>>[] sequenceTypeNetworks = matrix.getSequenceNetworks();
            matrix.getDepthPartitions();
            partitionLabels = new ArrayList();
            partitionLabels.add(relationClassificationType.toString());
            partitionNumbersMaps = SequencesCensus.getPartitionNumbersMaps(partitionLabels, sequenceTypeNetworks[2]);
            for (String label : partitionLabels) {
                this.nrValues.get((Object)relationClassificationType).put(label, partitionNumbersMaps.get(label).size());
            }
            partitionLabels.add("SIZE");
            partitionLabels.add("STEP");
            genderArray = Gender.values();
            int n = genderArray.length;
            int n4 = 0;
            while (n4 < n) {
                gender = genderArray[n4];
                this.pajekBuffers.get("Sequence Type Network").addAll((Collection)PuckUtils.writePajekNetwork(sequenceTypeNetworks[gender.toInt()], partitionLabels, partitionNumbersMaps));
                ++n4;
            }
        }
    }

    public static <E> Map<String, Map<Value, Integer>> getPartitionNumbersMaps(List<String> labels, Graph<E> model) {
        HashMap<String, Map<Value, Integer>> result = new HashMap<String, Map<Value, Integer>>();
        for (String label : labels) {
            Values values = NodeValuator.get(model, label);
            if (values.isNumeric()) continue;
            Partition<Value> partition = PartitionMaker.create(label, values);
            result.put(label, PartitionMaker.getPartitionNumbersMap(partition));
        }
        return result;
    }

    public Map<String, StringList> getPajekBuffers() {
        return this.pajekBuffers;
    }

    public Map<Integer, Partition<Node<Individual>>> getComponents(String networkTitle) {
        return this.componentsMap.get(networkTitle);
    }

    public NumberedValues getValues(String label) {
        return this.valuesMap.get(label);
    }

    public Graph<Cluster<String>> getSequenceNetwork(String title, SpaceTimeCriteria.RelationClassificationType relationClassificationType, Partition<String> partition) {
        if (this.sequences == null) {
            throw new IllegalArgumentException("Null parameter detected.");
        }
        Graph<Cluster<String>> result = new Graph<Cluster<String>>(String.valueOf(title) + "_" + (Object)((Object)relationClassificationType));
        for (Cluster<String> cluster : partition.getClusters().toListSortedByDescendingSize()) {
            if (cluster.isNull()) continue;
            result.addNode(cluster);
        }
        for (Sequence sequence : this.sequences) {
            Cluster<String> previous = null;
            for (Relation event : sequence.getEvents().values()) {
                Cluster<String> next = partition.getCluster(String.valueOf(sequence.getEgo().getId()) + " " + event.getTypedId());
                if (previous != null) {
                    result.incArcWeight(previous, next);
                }
                previous = next;
            }
        }
        for (Node node : result.getNodes()) {
            Value clusterValue;
            Cluster referent = (Cluster)node.getReferent();
            if (referent == null || (clusterValue = referent.getValue()) == null) continue;
            String value = clusterValue.toString();
            if (value.lastIndexOf("-") > -1) {
                value = value.substring(value.lastIndexOf("-") + 1);
            }
            node.setAttribute(relationClassificationType.toString(), value);
        }
        return result;
    }

    public Integer getNrValues(SpaceTimeCriteria.RelationClassificationType relationClassificationType, String label) {
        Integer result = relationClassificationType == null || label == null || this.nrValues.get((Object)relationClassificationType) == null ? null : this.nrValues.get((Object)relationClassificationType).get(label);
        return result;
    }

    public Set<Relation> events() {
        HashSet<Relation> result = new HashSet<Relation>();
        for (Sequence sequence : this.sequences) {
            for (Relation event : sequence.getEvents().values()) {
                result.add(event);
            }
        }
        return result;
    }

    public int nrEvents() {
        return this.events().size();
    }

    public int nrSequences() {
        return this.sequences.size();
    }

    public Map<Value, Double[]> getSimilaritiesMap(SpaceTimeCriteria.RelationClassificationType relationClassificationType) {
        return this.similaritiesMaps.get((Object)relationClassificationType);
    }

    public CorrelationMatrix getRelationConnectionMatrix() {
        return this.relationConnectionMatrix;
    }

    public CorrelationMatrix getEventSequenceMatrix(String eventTypeName) {
        CorrelationMatrix result = this.eventSequenceMatrices == null || eventTypeName == null ? null : this.eventSequenceMatrices.get(eventTypeName);
        return result;
    }

    public CorrelationMatrix getSubSequenceMatrix(String eventTypeName) {
        CorrelationMatrix result = this.subSequenceMatrices == null || eventTypeName == null ? null : this.subSequenceMatrices.get(eventTypeName);
        return result;
    }
}

