/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.spacetime;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.tip.puck.net.relations.Relation;
import org.tip.puck.spacetime.SequenceCensus;
import org.tip.puck.spacetime.SpaceTimeCriteria;

public class SequenceProfile {
    int nrLoops;
    int nrDirectReturns;
    int nrCycles;
    List<String> profile = new ArrayList<String>();
    Set<String> support = new HashSet<String>();
    Set<String> centers = new HashSet<String>();

    public SequenceProfile(List<Relation> events, Map<SpaceTimeCriteria.RelationClassificationType, Map<Relation, String>> map, SpaceTimeCriteria.RelationClassificationType type) {
        int i = 0;
        for (Relation event : events) {
            if (!SequenceCensus.isBirth(event) || type == SpaceTimeCriteria.RelationClassificationType.PLACE) {
                String place = map.get((Object)type).get(event);
                this.profile.add(place);
                this.support.add(place);
                String previousPlace = null;
                boolean closed = false;
                int j = i - 1;
                while (j > -1) {
                    previousPlace = this.profile.get(j);
                    boolean bl = closed = previousPlace != null && previousPlace.equals(place);
                    if (closed) {
                        this.centers.add(place);
                        if (j == i - 1) {
                            ++this.nrLoops;
                            break;
                        }
                        if (j == i - 2) {
                            ++this.nrDirectReturns;
                            break;
                        }
                        ++this.nrCycles;
                        break;
                    }
                    --j;
                }
            }
            ++i;
        }
    }

    public List<String> getCentersAsList() {
        ArrayList<String> result = new ArrayList<String>(this.centers);
        Collections.sort(result);
        return result;
    }

    public Set<String> getSupport() {
        return this.support;
    }

    public List<String> getSupportAsList() {
        ArrayList<String> result = new ArrayList<String>(this.support);
        Collections.sort(result);
        return result;
    }

    public int getNrDirectReturns() {
        return this.nrDirectReturns;
    }

    public int getNrCycles() {
        return this.nrCycles;
    }

    public int getNrLoops() {
        return this.nrLoops;
    }

    public List<String> getProfile() {
        return this.profile;
    }
}

