/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.spacetime;

import java.util.Comparator;
import org.tip.puck.net.relations.Actor;
import org.tip.puck.net.relations.Relation;
import org.tip.puck.spacetime.SpaceTimeCriteria;

public class EventComparator
implements Comparator<Relation> {
    String dateLabel;
    String startPlaceLabel;
    String endPlaceLabel;

    public EventComparator(SpaceTimeCriteria criteria) {
        this.dateLabel = criteria.getDateLabel();
        this.startPlaceLabel = criteria.getStartPlaceLabel();
        this.endPlaceLabel = criteria.getEndPlaceLabel();
    }

    @Override
    public int compare(Relation event1, Relation event2) {
        int result = 0;
        if (event1.getId() != event2.getId()) {
            String date1 = event1.getAttributeValue(this.dateLabel);
            String date2 = event2.getAttributeValue(this.dateLabel);
            if (date1 == null) {
                System.err.println("Null date " + event1);
                date1 = "";
            }
            if (date2 == null) {
                System.err.println("Null date " + event2);
                date2 = "";
            }
            if ((result = date1.compareTo(date2)) == 0) {
                for (Actor actor1 : event1.actors()) {
                    for (Actor actor2 : event2.actors()) {
                        int newResult;
                        if (!actor1.equals(actor2)) continue;
                        String order1 = actor1.attributes().getValue("ORDER");
                        String order2 = actor1.attributes().getValue("ORDER");
                        if (order1 == null || order2 == null || (newResult = order1.compareTo(order2)) == 0) continue;
                        if (result == 0) {
                            result = newResult;
                            continue;
                        }
                        System.err.println("Inconsistent Time Order " + event1 + " for " + actor1);
                    }
                }
                if (result == 0) {
                    String startPlace1 = event1.getAttributeValue(this.startPlaceLabel);
                    String endPlace1 = event1.getAttributeValue(this.startPlaceLabel);
                    String startPlace2 = event2.getAttributeValue(this.startPlaceLabel);
                    String endPlace2 = event2.getAttributeValue(this.startPlaceLabel);
                    result = endPlace1 != null && endPlace1.equals(startPlace2) ? -1 : (endPlace2 != null && endPlace2.equals(startPlace1) ? 1 : new Integer(event1.getId()).compareTo(event2.getId()));
                }
            }
        }
        return result;
    }
}

