/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.net.workers;

import fr.devinsy.util.StringList;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.net.Attribute;
import org.tip.puck.net.Family;
import org.tip.puck.net.Individual;
import org.tip.puck.net.Net;
import org.tip.puck.net.relations.Relation;
import org.tip.puck.net.workers.IndividualValuator;
import org.tip.puck.report.Report;
import org.tip.puck.segmentation.Segmentation;
import org.tip.puck.util.Chronometer;

public class ControlReporter {
    private static final Logger logger = LoggerFactory.getLogger(ControlReporter.class);

    private static String add(String string1, String string2, String sep) {
        if (StringUtils.isBlank((CharSequence)string1)) {
            sep = "";
        }
        String result = String.valueOf(string1) + sep + string2;
        return result;
    }

    public static void checkCycles(StringList control, Individual ego, Individual firstEgo, int k, String str) {
        if (k == 0 || ego.getId() < firstEgo.getId()) {
            return;
        }
        String[] parentType = new String[]{"F", "M", "X"};
        str = String.valueOf(str) + " " + ego.getName() + " (" + ego.getId() + ")";
        if (ego.equals(firstEgo)) {
            control.appendln(str);
        }
        for (Individual alter : ego.getParents()) {
            ControlReporter.checkCycles(control, alter, firstEgo, k - 1, String.valueOf(str) + " - " + parentType[alter.getGender().toInt()]);
        }
    }

    public static void checkCycles(StringList control, Individual ego, int k) {
        String[] parentType = new String[]{"F", "M", "X"};
        for (Individual alter : ego.getParents()) {
            ControlReporter.checkCycles(control, alter, ego, k, String.valueOf(ego.getName()) + " (" + ego.getId() + ") - " + parentType[alter.getGender().toInt()]);
        }
    }

    public static Report reportAutoMarriages(Segmentation segmentation, ResourceBundle bundle) {
        Chronometer chrono = new Chronometer();
        int errorCount = 0;
        StringList errors = new StringList();
        for (Individual individual : segmentation.getCurrentIndividuals()) {
            if (!individual.spouses().contains(individual)) continue;
            errors.appendln("" + individual);
            ++errorCount;
        }
        Report result = new Report();
        result.setTitle("Checks for Auto-Marriages.");
        result.setOrigin("Control reporter");
        result.setTarget(segmentation.getLabel());
        errors.add(0, (Object)(String.valueOf(errorCount) + " " + Report.translate(bundle, "Auto-Marriages") + "\n"));
        result.outputs().append(errors.toString());
        result.setStatus(errorCount);
        result.setTimeSpent(chrono.stop().interval());
        return result;
    }

    public static Report reportControl(Net net, ResourceBundle bundle, ControlType controlType) {
        Report result = ControlReporter.reportControl(new Segmentation(net), bundle, controlType);
        return result;
    }

    public static Report reportControl(Segmentation segmentation, ResourceBundle bundle, ControlType controlType) {
        Report result;
        switch (controlType) {
            case CYCLIC_DESCENT_CASES: {
                result = ControlReporter.reportCyclicDescentCases(segmentation, bundle);
                break;
            }
            case FEMALE_FATHERS_OR_MALE_MOTHERS: {
                result = ControlReporter.reportFemaleFathersOrMaleMothers(segmentation, bundle);
                break;
            }
            case MULTIPLE_FATHERS_OR_MOTHERS: {
                result = ControlReporter.reportMultipleFathersOrMothers(segmentation, bundle);
                break;
            }
            case NAMELESS_PERSONS: {
                result = ControlReporter.reportNamelessPersons(segmentation, bundle);
                break;
            }
            case AUTO_MARRIAGE: {
                result = ControlReporter.reportAutoMarriages(segmentation, bundle);
                break;
            }
            case PARENT_CHILD_MARRIAGES: {
                result = ControlReporter.reportParentChildMarriages(segmentation, bundle);
                break;
            }
            case SAME_SEX_SPOUSES: {
                result = ControlReporter.reportSameSexSpouses(segmentation, bundle);
                break;
            }
            case UNKNOWN_SEX_PERSONS: {
                result = ControlReporter.reportUnknownSexPersons(segmentation, bundle);
                break;
            }
            case INCONSISTENT_DATES: {
                result = ControlReporter.reportInconsistentDates(segmentation, bundle);
                break;
            }
            case MISSING_DATES: {
                result = ControlReporter.reportMissingDates(segmentation, bundle);
                break;
            }
            case MISSING_DATES_COMPACT: {
                result = ControlReporter.reportMissingDatesCompact(segmentation, bundle);
                break;
            }
            case UNKNOWN_SEX_PARENTS_SPOUSES: {
                result = ControlReporter.reportUnknownSexParentsSpouses(segmentation, bundle);
                break;
            }
            default: {
                result = null;
            }
        }
        return result;
    }

    public static Report reportControls(Net net, Locale locale, ControlType ... controlTypes) {
        Report result = ControlReporter.reportControls(new Segmentation(net), locale, controlTypes);
        return result;
    }

    public static Report reportControls(Net net, ResourceBundle bundle) {
        Report result = ControlReporter.reportControls(new Segmentation(net), bundle);
        return result;
    }

    public static Report reportControls(Net net, ResourceBundle bundle, ControlType ... controlTypes) {
        Report result = ControlReporter.reportControls(new Segmentation(net), bundle, controlTypes);
        return result;
    }

    public static Report reportControls(Segmentation segmentation, Locale locale, ControlType ... controlTypes) {
        Report result = ControlReporter.reportControls(segmentation, ResourceBundle.getBundle("org.tip.puckgui.messages", locale), controlTypes);
        return result;
    }

    public static Report reportControls(Segmentation segmentation, ResourceBundle bundle) {
        Report result = ControlReporter.reportControls(segmentation, bundle, ControlType.values());
        return result;
    }

    public static Report reportControls(Segmentation segmentation, ResourceBundle bundle, ControlType ... controlTypes) {
        Chronometer chrono = new Chronometer();
        Report result = new Report();
        result.setTitle("Checks for possible errors (special features).");
        result.setOrigin("Control reporter");
        result.setTarget(segmentation.getLabel());
        ControlType[] controlTypeArray = controlTypes;
        int n = controlTypes.length;
        int n2 = 0;
        while (n2 < n) {
            ControlType type = controlTypeArray[n2];
            result.inputs().add(type.toString(), "true");
            ++n2;
        }
        int errorCount = 0;
        ControlType[] controlTypeArray2 = controlTypes;
        int n3 = controlTypes.length;
        n = 0;
        while (n < n3) {
            ControlType controlType = controlTypeArray2[n];
            Report report = ControlReporter.reportControl(segmentation, bundle, controlType);
            if (report != null && report.status() != 0) {
                errorCount += report.status();
                result.outputs().append(report.outputs());
                result.outputs().appendln();
            }
            ++n;
        }
        result.setStatus(errorCount);
        result.setTimeSpent(chrono.stop().interval());
        return result;
    }

    public static Report reportCyclicDescentCases(Segmentation segmentation, ResourceBundle bundle) {
        Chronometer chrono = new Chronometer();
        StringList errors = new StringList();
        for (Individual individual : segmentation.getCurrentIndividuals()) {
            ControlReporter.checkCycles(errors, individual, 5);
        }
        int errorCount = errors.size() / 2;
        Report result = new Report();
        result.setTitle("Checks for Cases of Cyclic Descent.");
        result.setOrigin("Control reporter");
        result.setTarget(segmentation.getLabel());
        errors.add(0, (Object)(String.valueOf(errorCount) + " " + Report.translate(bundle, "Cases of Cyclic Descent") + "\n"));
        result.outputs().append(errors.toString());
        result.setStatus(errorCount);
        result.setTimeSpent(chrono.stop().interval());
        return result;
    }

    public static Report reportFemaleFathersOrMaleMothers(Segmentation segmentation, ResourceBundle bundle) {
        Chronometer chrono = new Chronometer();
        int errorCount = 0;
        StringList errors = new StringList();
        for (Individual individual : segmentation.getCurrentIndividuals()) {
            Individual mother;
            Individual father = individual.getFather();
            if (father != null && father.getGender().isFemale()) {
                errors.appendln(String.format("%c %s (%d)\t%s %s (%d)", Character.valueOf(father.getGender().toChar()), father.getTrimmedName(), father.getId(), Report.translate(bundle, "for"), individual.getNameTrimmed(), individual.getId()));
                ++errorCount;
            }
            if ((mother = individual.getMother()) == null || !mother.getGender().isMale()) continue;
            errors.appendln(String.format("%c %s (%d)\t%s %s (%d)", Character.valueOf(mother.getGender().toChar()), mother.getNameTrimmed(), mother.getId(), Report.translate(bundle, "for"), individual.getNameTrimmed(), individual.getId()));
            ++errorCount;
        }
        Report result = new Report();
        result.setTitle("Checks for Female Fathers or Male Mothers.");
        result.setOrigin("Control reporter");
        result.setTarget(segmentation.getLabel());
        errors.add(0, (Object)(String.valueOf(errorCount) + " " + Report.translate(bundle, "Female Fathers or Male Mothers") + "\n"));
        result.outputs().append(errors.toString());
        result.setStatus(errorCount);
        result.setTimeSpent(chrono.stop().interval());
        return result;
    }

    public static Report reportInconsistentDates(Segmentation segmentation, ResourceBundle bundle) {
        Chronometer chrono = new Chronometer();
        int errorCount = 0;
        StringList errors = new StringList();
        for (Individual individual : segmentation.getCurrentIndividuals()) {
            Integer birtYear = IndividualValuator.extractYearAsInt(individual.getAttributeValue("BIRT_DATE"));
            Integer deatYear = IndividualValuator.extractYearAsInt(individual.getAttributeValue("DEAT_DATE"));
            if (deatYear != null && birtYear != null && deatYear < birtYear) {
                errors.appendln(String.valueOf(individual.signatureTab()) + "\tdied (" + deatYear + ") before born (" + birtYear + ")");
                ++errorCount;
            }
            if (individual.getFather() != null) {
                Integer fatherDeatYear = IndividualValuator.extractYearAsInt(individual.getFather().getAttributeValue("DEAT_DATE"));
                if (birtYear != null && fatherDeatYear != null && fatherDeatYear != 0 && birtYear > fatherDeatYear) {
                    errors.appendln(String.valueOf(individual.signatureTab()) + "\tborn (" + birtYear + ") after father's death (" + fatherDeatYear + ")");
                    ++errorCount;
                }
                Integer fatherBirtYear = IndividualValuator.extractYearAsInt(individual.getFather().getAttributeValue("BIRT_DATE"));
                if (birtYear != null && fatherBirtYear != null && birtYear - fatherBirtYear < 15) {
                    errors.appendln(String.valueOf(individual.signatureTab()) + "\tborn (" + birtYear + ") to man of age " + (birtYear - fatherBirtYear));
                    ++errorCount;
                }
            }
            if (individual.getMother() != null) {
                Integer motherDeatYear = IndividualValuator.extractYearAsInt(individual.getMother().getAttributeValue("DEAT_DATE"));
                if (birtYear != null && motherDeatYear != null && motherDeatYear != 0 && birtYear > motherDeatYear) {
                    errors.appendln(String.valueOf(individual.signatureTab()) + "\tborn (" + birtYear + ") after mother's death (" + motherDeatYear + ")");
                    ++errorCount;
                }
                Integer motherBirtYear = IndividualValuator.extractYearAsInt(individual.getMother().getAttributeValue("BIRT_DATE"));
                if (birtYear != null && motherBirtYear != null && (birtYear - motherBirtYear < 15 || birtYear - motherBirtYear > 55)) {
                    errors.appendln(String.valueOf(individual.signatureTab()) + "\tborn (" + birtYear + ") to woman of age " + (birtYear - motherBirtYear));
                    ++errorCount;
                }
            }
            if (individual.getOriginFamily() != null) {
                Integer parentMarriageYear = IndividualValuator.extractYearAsInt(individual.getOriginFamily().getAttributeValue("MARR_DATE"));
                if (birtYear != null && parentMarriageYear != null && birtYear < parentMarriageYear) {
                    errors.appendln(String.valueOf(individual.signatureTab()) + "\tborn (" + birtYear + ") before parents' marriage (" + parentMarriageYear + ")");
                    ++errorCount;
                }
            }
            for (Family family : individual.getPersonalFamilies()) {
                Integer marriageYear = IndividualValuator.extractYearAsInt(family.getAttributeValue("MARR_DATE"));
                if (deatYear == null || marriageYear == null || deatYear >= marriageYear) continue;
                errors.appendln(String.valueOf(individual.signatureTab()) + "\tdied (" + deatYear + ") before marriage (" + marriageYear + ")");
                ++errorCount;
            }
            for (Relation relation : individual.relations()) {
                for (Attribute attribute : relation.attributes()) {
                    if (!attribute.getLabel().contains("DATE")) continue;
                    Integer year = IndividualValuator.extractYearAsInt(attribute.getValue());
                    if (year != null && birtYear != null && year < birtYear) {
                        errors.appendln(String.valueOf(individual.signatureTab()) + "\tborn (" + birtYear + ") after participating as " + relation.getRoleNamesAsString(individual) + " in " + relation.getModel().getName() + " " + relation.getName() + " (" + year + ")");
                        ++errorCount;
                    }
                    if (year == null || deatYear == null || year <= deatYear) continue;
                    errors.appendln(String.valueOf(individual.signatureTab()) + "\tdied (" + deatYear + ") before participating as " + relation.getRoleNamesAsString(individual) + " in " + relation.getModel().getName() + " " + relation.getName() + " (" + year + ")");
                    ++errorCount;
                }
            }
        }
        Report result = new Report();
        result.setTitle("Checks for Inconsistent Dates.");
        result.setOrigin("Control reporter");
        result.setTarget(segmentation.getLabel());
        errors.add(0, (Object)(String.valueOf(errorCount) + " " + Report.translate(bundle, "Inconsistent Dates") + "\n"));
        result.outputs().append(errors.toString());
        result.setStatus(errorCount);
        result.setTimeSpent(chrono.stop().interval());
        return result;
    }

    public static Report reportMissingDates(Segmentation segmentation, ResourceBundle bundle) {
        Chronometer chrono = new Chronometer();
        int errorCount = 0;
        StringList errors = new StringList();
        for (Individual individual : segmentation.getCurrentIndividuals()) {
            Integer motherDeatYear;
            Integer fatherDeatYear;
            Integer birtYear = IndividualValuator.extractYearAsInt(individual.getAttributeValue("BIRT_DATE"));
            Integer deatYear = IndividualValuator.extractYearAsInt(individual.getAttributeValue("DEAT_DATE"));
            if (birtYear == null) {
                errors.appendln(String.valueOf(individual.signatureTab()) + "\tbirth date missing");
                ++errorCount;
            }
            if (deatYear != null && deatYear == 0) {
                errors.appendln(String.valueOf(individual.signatureTab()) + "\tdeath date missing");
                ++errorCount;
            }
            if (individual.getFather() != null && (fatherDeatYear = IndividualValuator.extractYearAsInt(individual.getFather().getAttributeValue("DEAT_DATE"))) != null && fatherDeatYear == 0) {
                errors.appendln(String.valueOf(individual.signatureTab()) + "\tfather's death date missing \t(" + individual.getFather() + ")");
                ++errorCount;
            }
            if (individual.getMother() != null && (motherDeatYear = IndividualValuator.extractYearAsInt(individual.getMother().getAttributeValue("DEAT_DATE"))) != null && motherDeatYear == 0) {
                errors.appendln(String.valueOf(individual.signatureTab()) + "\tmother's death date missing \t(" + individual.getMother() + ")");
                ++errorCount;
            }
            for (Individual child : individual.children().toListSortedByBirthYearOrOrder()) {
                Integer childBirtYear = IndividualValuator.extractYearAsInt(child.getAttributeValue("BIRT_DATE"));
                if (childBirtYear != null) continue;
                if (IndividualValuator.extractYearAsInt(child.getAttributeValue("DEAT_DATE")) == null) {
                    errors.appendln(String.valueOf(individual.signatureTab()) + "\tchild birth date missing \t(" + child + ")");
                } else {
                    errors.appendln(String.valueOf(individual.signatureTab()) + "\tchild birth date missing \t(" + child + " (+))");
                }
                ++errorCount;
            }
            for (Family family : individual.getPersonalFamilies().toListSortedByOrder(individual)) {
                Integer marriageYear = IndividualValuator.extractYearAsInt(family.getAttributeValue("MARR_DATE"));
                if (marriageYear != null) continue;
                errors.appendln(String.valueOf(individual.signatureTab()) + "\tmarriage date missing \t(" + family.getOtherParent(individual) + ")");
                ++errorCount;
            }
        }
        Report result = new Report();
        result.setTitle("Checks for Missing Dates.");
        result.setOrigin("Control reporter");
        result.setTarget(segmentation.getLabel());
        errors.add(0, (Object)(String.valueOf(errorCount) + " " + Report.translate(bundle, "Missing Dates") + "\n"));
        result.outputs().append(errors.toString());
        result.setStatus(errorCount);
        result.setTimeSpent(chrono.stop().interval());
        return result;
    }

    public static Report reportMissingDatesCompact(Segmentation segmentation, ResourceBundle bundle) {
        Chronometer chrono = new Chronometer();
        int errorCount = 0;
        StringList errors = new StringList();
        for (Individual individual : segmentation.getCurrentIndividuals()) {
            Integer motherDeatYear;
            Integer fatherDeatYear;
            String line = "";
            Integer birtYear = IndividualValuator.extractYearAsInt(individual.getAttributeValue("BIRT_DATE"));
            Integer deatYear = IndividualValuator.extractYearAsInt(individual.getAttributeValue("DEAT_DATE"));
            if (birtYear == null) {
                line = ControlReporter.add(line, "birth date missing", "");
                ++errorCount;
            }
            if (deatYear != null && deatYear == 0) {
                line = ControlReporter.add(line, "death date missing", "; ");
                ++errorCount;
            }
            if (individual.getFather() != null && (fatherDeatYear = IndividualValuator.extractYearAsInt(individual.getFather().getAttributeValue("DEAT_DATE"))) != null && fatherDeatYear == 0) {
                line = ControlReporter.add(line, "Father's death date missing: " + individual.getFather(), "; ");
                ++errorCount;
            }
            if (individual.getMother() != null && (motherDeatYear = IndividualValuator.extractYearAsInt(individual.getMother().getAttributeValue("DEAT_DATE"))) != null && motherDeatYear == 0) {
                line = ControlReporter.add(line, "Mother's death date missing: " + individual.getMother(), "; ");
                ++errorCount;
            }
            if (!StringUtils.isBlank((CharSequence)line)) {
                errors.appendln(String.valueOf(individual.getId()) + "\t" + individual + "\t" + line);
            }
            line = "";
            String line2 = "";
            for (Individual child : individual.children().toListSortedByBirthYearOrOrder()) {
                Integer childBirtYear = IndividualValuator.extractYearAsInt(child.getAttributeValue("BIRT_DATE"));
                if (childBirtYear != null) continue;
                if (IndividualValuator.extractYearAsInt(child.getAttributeValue("DEAT_DATE")) == null) {
                    line = ControlReporter.add(line, child.toString(), ", ");
                } else {
                    line2 = ControlReporter.add(line2, child.toString(), ", ");
                }
                ++errorCount;
            }
            if (!StringUtils.isBlank((CharSequence)line)) {
                errors.appendln(String.valueOf(individual.getId()) + "\t" + individual + "\tBirth dates missing for children: " + line);
            }
            if (!StringUtils.isBlank((CharSequence)line2)) {
                errors.appendln(String.valueOf(individual.getId()) + "\t" + individual + "\tBirth dates missing for deceased children: " + line2);
            }
            line = "";
            for (Family family : individual.getPersonalFamilies()) {
                Integer marriageYear = IndividualValuator.extractYearAsInt(family.getAttributeValue("MARR_DATE"));
                if (marriageYear != null || family.getOtherParent(individual) == null) continue;
                line = ControlReporter.add(line, family.getOtherParent(individual).toString(), ", ");
                ++errorCount;
            }
            if (StringUtils.isBlank((CharSequence)line)) continue;
            errors.appendln(String.valueOf(individual.getId()) + "\t" + individual + "\tMarriage dates missing for spouses: " + line);
        }
        Report result = new Report();
        result.setTitle("Checks for Missing Dates.");
        result.setOrigin("Control reporter");
        result.setTarget(segmentation.getLabel());
        errors.add(0, (Object)(String.valueOf(errorCount) + " " + Report.translate(bundle, "Missing Dates") + "\n"));
        result.outputs().append(errors.toString());
        result.setStatus(errorCount);
        result.setTimeSpent(chrono.stop().interval());
        return result;
    }

    public static Report reportMultipleFathersOrMothers(Segmentation segmentation, ResourceBundle bundle) {
        Chronometer chrono = new Chronometer();
        int errorCount = 0;
        StringList errors = new StringList();
        for (Individual individual : segmentation.getCurrentIndividuals()) {
            for (Family family : individual.getPersonalFamilies()) {
                Individual parent = family.getParent(individual.getGender());
                if (parent == null || parent == individual) continue;
                errors.appendln(String.format("%c %s (%d)\t%s %s (%d)", Character.valueOf(individual.getGender().toChar()), individual.getTrimmedName(), individual.getId(), Report.translate(bundle, "and"), parent.getNameTrimmed(), parent.getId()));
                ++errorCount;
            }
        }
        Report result = new Report();
        result.setTitle("Checks for Multiple Fathers or Mothers.");
        result.setOrigin("Control reporter");
        result.setTarget(segmentation.getLabel());
        errors.add(0, (Object)(String.valueOf(errorCount) + " " + Report.translate(bundle, "Multiple Fathers/Mothers") + "\n"));
        result.outputs().append(errors.toString());
        result.setStatus(errorCount);
        result.setTimeSpent(chrono.stop().interval());
        return result;
    }

    public static Report reportNamelessPersons(Segmentation segmentation, ResourceBundle bundle) {
        Chronometer chrono = new Chronometer();
        int errorCount = 0;
        StringList errors = new StringList();
        for (Individual individual : segmentation.getCurrentIndividuals()) {
            if (!StringUtils.isBlank((CharSequence)individual.getName())) continue;
            errors.appendln(String.valueOf(individual.getGender().toChar()) + " " + individual.getId());
            ++errorCount;
        }
        Report result = new Report();
        result.setTitle("Checks for Nameless Persons.");
        result.setOrigin("Control reporter");
        result.setTarget(segmentation.getLabel());
        errors.add(0, (Object)(String.valueOf(errorCount) + " " + Report.translate(bundle, "Nameless Persons") + "\n"));
        result.outputs().append(errors.toString());
        result.setStatus(errorCount);
        result.setTimeSpent(chrono.stop().interval());
        return result;
    }

    public static Report reportParentChildMarriages(Segmentation segmentation, ResourceBundle bundle) {
        Chronometer chrono = new Chronometer();
        int errorCount = 0;
        StringList errors = new StringList();
        for (Individual individual : segmentation.getCurrentIndividuals()) {
            for (Individual parent : individual.getParents()) {
                if (!individual.spouses().contains(parent)) continue;
                errors.appendln(String.format("%s (%d) %s %s (%d)", individual.getTrimmedName(), individual.getId(), Report.translate(bundle, "and"), parent.getNameTrimmed(), parent.getId()));
                ++errorCount;
            }
        }
        Report result = new Report();
        result.setTitle("Checks for Parent-Child Marriages.");
        result.setOrigin("Control reporter");
        result.setTarget(segmentation.getLabel());
        errors.add(0, (Object)(String.valueOf(errorCount) + " " + Report.translate(bundle, "Parent-Child Marriages") + "\n"));
        result.outputs().append(errors.toString());
        result.setStatus(errorCount);
        result.setTimeSpent(chrono.stop().interval());
        return result;
    }

    public static Report reportSameSexSpouses(Segmentation segmentation, ResourceBundle bundle) {
        Chronometer chrono = new Chronometer();
        int errorCount = 0;
        StringList errors = new StringList();
        for (Individual individual : segmentation.getCurrentIndividuals()) {
            for (Individual spouse : individual.spouses()) {
                if (individual.getId() > spouse.getId() || individual.getGender() != spouse.getGender()) continue;
                errors.appendln(String.format("%c %s (%d)\t%s %s (%d)", Character.valueOf(spouse.getGender().toChar()), spouse.getTrimmedName(), spouse.getId(), Report.translate(bundle, "for"), individual.getNameTrimmed(), individual.getId()));
                ++errorCount;
            }
        }
        Report result = new Report();
        result.setTitle("Checks for Same-Sex Couples.");
        result.setOrigin("Control reporter");
        result.setTarget(segmentation.getLabel());
        errors.add(0, (Object)(String.valueOf(errorCount) + " " + Report.translate(bundle, "Same-Sex Couples") + "\n"));
        result.outputs().append(errors.toString());
        result.setStatus(errorCount);
        result.setTimeSpent(chrono.stop().interval());
        return result;
    }

    public static Report reportUnknownSexParentsSpouses(Segmentation segmentation, ResourceBundle bundle) {
        Chronometer chrono = new Chronometer();
        int errorCount = 0;
        StringList errors = new StringList();
        for (Individual individual : segmentation.getCurrentIndividuals()) {
            if (!individual.getGender().isUnknown() || individual.isSingle() && individual.isSterile()) continue;
            errors.appendln("" + individual);
            ++errorCount;
        }
        Report result = new Report();
        result.setTitle("Checks for parents or spouses of unknown sex.");
        result.setOrigin("Control reporter");
        result.setTarget(segmentation.getLabel());
        errors.add(0, (Object)(String.valueOf(errorCount) + " " + Report.translate(bundle, "Parents or spouses of unknown Sex") + "\n"));
        result.outputs().append(errors.toString());
        result.setStatus(errorCount);
        result.setTimeSpent(chrono.stop().interval());
        return result;
    }

    public static Report reportUnknownSexPersons(Segmentation segmentation, ResourceBundle bundle) {
        Chronometer chrono = new Chronometer();
        int errorCount = 0;
        StringList errors = new StringList();
        for (Individual individual : segmentation.getCurrentIndividuals()) {
            if (!individual.getGender().isUnknown()) continue;
            errors.appendln("" + individual);
            ++errorCount;
        }
        Report result = new Report();
        result.setTitle("Checks for Persons of unknown Sex.");
        result.setOrigin("Control reporter");
        result.setTarget(segmentation.getLabel());
        errors.add(0, (Object)(String.valueOf(errorCount) + " " + Report.translate(bundle, "Persons of unknown Sex") + "\n"));
        result.outputs().append(errors.toString());
        result.setStatus(errorCount);
        result.setTimeSpent(chrono.stop().interval());
        return result;
    }

    public static enum ControlType {
        UNKNOWN_RELATIVES,
        SAME_SEX_SPOUSES,
        FEMALE_FATHERS_OR_MALE_MOTHERS,
        MULTIPLE_FATHERS_OR_MOTHERS,
        CYCLIC_DESCENT_CASES,
        UNKNOWN_SEX_PERSONS,
        NAMELESS_PERSONS,
        PARENT_CHILD_MARRIAGES,
        AUTO_MARRIAGE,
        INCONSISTENT_DATES,
        MISSING_DATES,
        MISSING_DATES_COMPACT,
        UNKNOWN_SEX_PARENTS_SPOUSES;

    }
}

