/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.net.relations.workers;

import fr.devinsy.util.StringList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import org.apache.commons.lang3.StringUtils;
import org.tip.puck.graphs.Graph;
import org.tip.puck.graphs.Node;
import org.tip.puck.net.Gender;
import org.tip.puck.net.Individual;
import org.tip.puck.net.Net;
import org.tip.puck.net.relations.RelationModel;
import org.tip.puck.net.relations.Role;
import org.tip.puck.net.relations.RoleDefinition;
import org.tip.puck.net.relations.RoleDefinitions;
import org.tip.puck.net.relations.Roles;

public class RelationModelMaker {
    private static void compose(RelationModel model, Individual indi, Gender egoGender, Queue<Individual> queue, List<Individual> visited, List<String> egoNeutral) {
        Roles composition;
        Roles composition2;
        Gender childGender;
        RoleDefinitions roleDefinitions = model.roleDefinitions();
        if (roleDefinitions.getRoleByName(indi.getName()) == null) {
            System.out.println("Ego role missing: " + indi.getName());
        }
        if (indi.getFather() != null && indi.getFather().getName() != null && !visited.contains(indi.getFather())) {
            indi.getFather().setAttribute("EGOGENDER", egoGender.toString());
            indi.getFather().setAttribute("GENERATION", String.valueOf(Integer.parseInt(indi.getAttributeValue("GENERATION")) + 1));
            childGender = indi.getGender();
            if (indi.getName().equals("Ego")) {
                if (egoNeutral.contains("PARENT")) {
                    childGender = null;
                }
                roleDefinitions.addNew(new RoleDefinition(roleDefinitions.size(), model.role(indi.getFather()), RoleDefinition.Primary.PARENT, null, null, Gender.MALE, null, childGender));
            } else {
                for (Role fatherRole : roleDefinitions.getRoles(RoleDefinition.Primary.PARENT, Gender.MALE, null, childGender)) {
                    composition2 = new Roles();
                    composition2.add(roleDefinitions.getRoleByName(indi.getName()));
                    composition2.add(fatherRole);
                    roleDefinitions.addNew(new RoleDefinition(roleDefinitions.size(), model.role(indi.getFather()), null, null, composition2, Gender.MALE, null, egoGender));
                }
            }
            queue.add(indi.getFather());
            visited.add(indi.getFather());
        }
        if (indi.getMother() != null && indi.getMother().getName() != null && !visited.contains(indi.getMother())) {
            indi.getMother().setAttribute("EGOGENDER", egoGender.toString());
            indi.getMother().setAttribute("GENERATION", String.valueOf(Integer.parseInt(indi.getAttributeValue("GENERATION")) + 1));
            childGender = indi.getGender();
            if (indi.getName().equals("Ego")) {
                if (egoNeutral.contains("PARENT")) {
                    childGender = null;
                }
                roleDefinitions.addNew(new RoleDefinition(roleDefinitions.size(), model.role(indi.getMother()), RoleDefinition.Primary.PARENT, null, null, Gender.FEMALE, null, childGender));
            } else {
                for (Role motherRole : roleDefinitions.getRoles(RoleDefinition.Primary.PARENT, Gender.FEMALE, null, childGender)) {
                    composition2 = new Roles();
                    composition2.add(roleDefinitions.getRoleByName(indi.getName()));
                    composition2.add(motherRole);
                    roleDefinitions.addNew(new RoleDefinition(roleDefinitions.size(), model.role(indi.getMother()), null, null, composition2, Gender.FEMALE, null, egoGender));
                }
            }
            queue.add(indi.getMother());
            visited.add(indi.getMother());
        }
        for (Individual sibling : indi.siblings()) {
            Gender siblingGender = indi.getGender();
            if (egoNeutral.contains("SIBLING")) {
                siblingGender = null;
            }
            if (sibling.getName() == null || visited.contains(sibling)) continue;
            sibling.setAttribute("EGOGENDER", egoGender.toString());
            sibling.setAttribute("GENERATION", indi.getAttributeValue("GENERATION"));
            if (indi.getName().equals("Ego")) {
                roleDefinitions.addNew(new RoleDefinition(roleDefinitions.size(), model.role(sibling), RoleDefinition.Primary.SIBLING, null, null, sibling.getGender(), RelationModelMaker.getAlterAge(sibling, indi), siblingGender));
            } else {
                for (Role siblingRole : roleDefinitions.getRoles(RoleDefinition.Primary.SIBLING, sibling.getGender(), RelationModelMaker.getAlterAge(sibling, indi), siblingGender)) {
                    composition = new Roles();
                    composition.add(roleDefinitions.getRoleByName(indi.getName()));
                    composition.add(siblingRole);
                    roleDefinitions.addNew(new RoleDefinition(roleDefinitions.size(), model.role(sibling), null, null, composition, sibling.getGender(), null, egoGender));
                }
            }
            queue.add(sibling);
            visited.add(sibling);
        }
        for (Individual spouse : indi.spouses()) {
            Gender spouseGender = indi.getGender();
            if (spouse.getName() == null || visited.contains(spouse)) continue;
            spouse.setAttribute("EGOGENDER", egoGender.toString());
            spouse.setAttribute("GENERATION", indi.getAttributeValue("GENERATION"));
            if (indi.getName().equals("Ego")) {
                if (egoNeutral.contains("SPOUSE")) {
                    spouseGender = null;
                }
                roleDefinitions.addNew(new RoleDefinition(roleDefinitions.size(), model.role(spouse), RoleDefinition.Primary.SPOUSE, null, null, spouse.getGender(), null, spouseGender));
            } else {
                for (Role spouseRole : roleDefinitions.getRoles(RoleDefinition.Primary.SPOUSE, spouse.getGender(), null, spouseGender)) {
                    composition = new Roles();
                    composition.add(roleDefinitions.getRoleByName(indi.getName()));
                    composition.add(spouseRole);
                    roleDefinitions.addNew(new RoleDefinition(roleDefinitions.size(), model.role(spouse), null, null, composition, spouse.getGender(), null, egoGender));
                }
            }
            queue.add(spouse);
            visited.add(spouse);
        }
        for (Individual child : indi.children()) {
            Roles parentRoles;
            Gender parentGender = indi.getGender();
            if (child.getName() == null || visited.contains(child)) continue;
            child.setAttribute("EGOGENDER", egoGender.toString());
            child.setAttribute("GENERATION", String.valueOf(Integer.parseInt(indi.getAttributeValue("GENERATION")) - 1));
            if (indi.getName().equals("Ego")) {
                if (egoNeutral.contains("CHILD")) {
                    parentGender = null;
                }
                parentRoles = roleDefinitions.getRoles(RoleDefinition.Primary.PARENT, parentGender, null, child.getGender());
                for (Role role : parentRoles) {
                    roleDefinitions.addNew(new RoleDefinition(roleDefinitions.size(), model.role(child), null, role, null, child.getGender(), null, parentGender));
                }
            } else {
                parentRoles = roleDefinitions.getRoles(RoleDefinition.Primary.PARENT, parentGender, null, child.getGender());
                for (Role parentRole : parentRoles) {
                    Role childRole = roleDefinitions.getInverseRole(parentRole, child.getGender(), parentGender);
                    if (childRole != null) {
                        Roles composition3 = new Roles();
                        composition3.add(roleDefinitions.getRoleByName(indi.getName()));
                        composition3.add(childRole);
                        roleDefinitions.addNew(new RoleDefinition(roleDefinitions.size(), model.role(child), null, null, composition3, child.getGender(), RelationModelMaker.getAlterAge(child), egoGender));
                        continue;
                    }
                    System.out.println("Missing " + (Object)((Object)indi.getGender()) + " (" + (Object)((Object)parentGender) + ") " + " parentRole for " + (Object)((Object)child.getGender()) + " child :" + indi + " for " + child);
                }
            }
            queue.add(child);
            visited.add(child);
        }
    }

    private static void composeParents(RelationModel model, Individual indi, Gender egoGender, Queue<Individual> queue, List<Individual> visited, List<String> egoNeutral) {
        Roles composition;
        Gender childGender;
        RoleDefinitions roleDefinitions = model.roleDefinitions();
        if (indi.getFather() != null && indi.getFather().getName() != null && !visited.contains(indi.getFather())) {
            indi.getFather().setAttribute("EGOGENDER", egoGender.toString());
            indi.getFather().setAttribute("GENERATION", String.valueOf(Integer.parseInt(indi.getAttributeValue("GENERATION")) + 1));
            childGender = indi.getGender();
            if (egoNeutral.contains("PARENT")) {
                childGender = null;
            }
            if (indi.getName().equals("Ego")) {
                roleDefinitions.addNew(new RoleDefinition(roleDefinitions.size(), model.role(indi.getFather()), RoleDefinition.Primary.PARENT, null, null, Gender.MALE, null, childGender));
            } else {
                for (Role fatherRole : roleDefinitions.getRoles(RoleDefinition.Primary.PARENT, Gender.MALE, null, childGender)) {
                    composition = new Roles();
                    composition.add(roleDefinitions.getRoleByName(indi.getName()));
                    composition.add(fatherRole);
                    roleDefinitions.addNew(new RoleDefinition(roleDefinitions.size(), model.role(indi.getFather()), null, null, composition, null, null, egoGender));
                }
            }
            queue.add(indi.getFather());
            visited.add(indi.getFather());
        }
        if (indi.getMother() != null && indi.getMother().getName() != null && !visited.contains(indi.getMother())) {
            indi.getMother().setAttribute("EGOGENDER", egoGender.toString());
            indi.getMother().setAttribute("GENERATION", String.valueOf(Integer.parseInt(indi.getAttributeValue("GENERATION")) + 1));
            childGender = indi.getGender();
            if (egoNeutral.contains("PARENT")) {
                childGender = null;
            }
            if (indi.getName().equals("Ego")) {
                roleDefinitions.addNew(new RoleDefinition(roleDefinitions.size(), model.role(indi.getMother()), RoleDefinition.Primary.PARENT, null, null, Gender.FEMALE, null, childGender));
            } else {
                for (Role motherRole : roleDefinitions.getRoles(RoleDefinition.Primary.PARENT, Gender.FEMALE, null, childGender)) {
                    composition = new Roles();
                    composition.add(roleDefinitions.getRoleByName(indi.getName()));
                    composition.add(motherRole);
                    roleDefinitions.addNew(new RoleDefinition(roleDefinitions.size(), model.role(indi.getMother()), null, null, composition, null, null, egoGender));
                }
            }
            queue.add(indi.getMother());
            visited.add(indi.getMother());
        }
    }

    public static RelationModel create(Net net) {
        RelationModel result = new RelationModel(net.getLabel());
        RelationModelMaker.createRoleDefinitions(result, net);
        return result;
    }

    public static RelationModel create(String name, StringList roleDefinitionsList) {
        RelationModel result = new RelationModel(name);
        RelationModelMaker.createRoleDefinitions(result, roleDefinitionsList);
        return result;
    }

    public static RoleDefinitions createRoleDefinitions(RelationModel model, Net net) {
        RoleDefinitions result = new RoleDefinitions();
        model.setRoleDefinitions(result);
        Individual maleEgo = null;
        Individual femaleEgo = null;
        for (Individual indi : net.individuals()) {
            if (!indi.getName().equals("Ego")) continue;
            indi.setAttribute("EGOGENDER", indi.getGender().toString());
            indi.setAttribute("GENERATION", "0");
            if (indi.isMale()) {
                maleEgo = indi;
            } else if (indi.isFemale()) {
                femaleEgo = indi;
            }
            if (maleEgo == null || femaleEgo == null) continue;
            result.setEgoGenderDistinction(true);
            break;
        }
        ArrayList<String> egoNeutral = new ArrayList<String>();
        if (maleEgo != null && maleEgo.isSterile() || femaleEgo != null && femaleEgo.isSterile()) {
            egoNeutral.add("CHILD");
        }
        if (maleEgo != null && maleEgo.isOrphan() || femaleEgo != null && femaleEgo.isOrphan()) {
            egoNeutral.add("PARENT");
        }
        if (maleEgo != null && maleEgo.isSingle() || femaleEgo != null && femaleEgo.isSingle()) {
            egoNeutral.add("SPOUSE");
        }
        if (maleEgo != null && maleEgo.isUnique() || femaleEgo != null && femaleEgo.isUnique()) {
            egoNeutral.add("SIBLING");
        }
        LinkedList<Individual> queue = new LinkedList<Individual>();
        ArrayList<Individual> visited = new ArrayList<Individual>();
        if (maleEgo != null) {
            queue.add(maleEgo);
            visited.add(maleEgo);
            RelationModelMaker.composeParents(model, maleEgo, Gender.MALE, queue, visited, egoNeutral);
        }
        if (femaleEgo != null) {
            queue.add(femaleEgo);
            visited.add(femaleEgo);
            RelationModelMaker.composeParents(model, femaleEgo, Gender.FEMALE, queue, visited, egoNeutral);
        }
        if (maleEgo != null) {
            RelationModelMaker.compose(model, maleEgo, Gender.MALE, queue, visited, egoNeutral);
        }
        if (femaleEgo != null) {
            RelationModelMaker.compose(model, femaleEgo, Gender.FEMALE, queue, visited, egoNeutral);
        }
        System.out.println("Ego environments complete: " + queue);
        while (!queue.isEmpty()) {
            Individual indi = (Individual)queue.remove();
            Gender egoGender = Gender.valueOf(indi.getAttributeValue("EGOGENDER"));
            RelationModelMaker.compose(model, indi, egoGender, queue, visited, egoNeutral);
        }
        return result;
    }

    public static RoleDefinitions createRoleDefinitions(RelationModel model, StringList roleDefinitionsList) {
        RoleDefinitions result = new RoleDefinitions();
        model.setRoleDefinitions(result);
        int id = 0;
        for (String roleDefinitionLine : roleDefinitionsList) {
            String[] items = roleDefinitionLine.split("\t");
            ++id;
            Role role = null;
            RoleDefinition.Primary primary = null;
            Role inversion = null;
            Roles composition = new Roles();
            RoleDefinition.AlterAge alterAge = null;
            Gender alterGender = null;
            Gender egoGender = null;
            int idx = 0;
            while (idx < items.length) {
                String item = items[idx];
                if (!StringUtils.isEmpty((CharSequence)item)) {
                    switch (idx) {
                        case 0: {
                            role = model.role(item);
                            break;
                        }
                        case 1: {
                            primary = RoleDefinition.Primary.valueOf(item);
                            break;
                        }
                        case 2: {
                            inversion = model.role(item);
                            break;
                        }
                        case 3: {
                            composition.add(model.role(item));
                            break;
                        }
                        case 4: {
                            composition.add(model.role(item));
                            break;
                        }
                        case 5: {
                            alterGender = Gender.valueOf(item);
                            break;
                        }
                        case 6: {
                            alterAge = RoleDefinition.AlterAge.valueOf(item);
                            break;
                        }
                        case 7: {
                            egoGender = Gender.valueOf(item);
                        }
                    }
                }
                ++idx;
            }
            result.add(new RoleDefinition(id, role, primary, inversion, composition, alterGender, alterAge, egoGender));
        }
        return result;
    }

    private static RoleDefinition.AlterAge getAlterAge(Individual indi) {
        RoleDefinition.AlterAge result = null;
        if (indi.getAttributeValue("GENERATION").equals("0") && indi.getBirthOrder() != null) {
            if (indi.getBirthOrder() == 3) {
                result = RoleDefinition.AlterAge.YOUNGER;
            } else if (indi.getBirthOrder() == 1) {
                result = RoleDefinition.AlterAge.ELDER;
            }
        }
        return result;
    }

    private static RoleDefinition.AlterAge getAlterAge(Individual alter, Individual ego) {
        RoleDefinition.AlterAge result = null;
        if (alter == null || ego == null) {
            result = null;
        } else if (alter.isYoungerThan(ego)) {
            result = RoleDefinition.AlterAge.YOUNGER;
        } else if (alter.isElderThan(ego)) {
            result = RoleDefinition.AlterAge.ELDER;
        }
        return result;
    }

    public static Graph<Role> relationModelGraph(RelationModel model) {
        Graph<Role> result = new Graph<Role>();
        HashMap<Role, String> arcTypes = new HashMap<Role, String>();
        model.roleDefinitions().isEgoGenderDistinction();
        Role ego = new Role("Ego");
        result.addNode(ego);
        for (Role role : model.roles()) {
            result.addNode(role);
        }
        for (RoleDefinition definition : model.roleDefinitions().toSortedList()) {
            if (definition.primary() == null) continue;
            switch (definition.primary()) {
                case PARENT: {
                    if (definition.alterGender().isMale()) {
                        arcTypes.put(definition.role(), "FATHER");
                        result.addArc(ego, definition.role(), 1.0);
                        break;
                    }
                    if (!definition.alterGender().isFemale()) break;
                    arcTypes.put(definition.role(), "MOTHER");
                    result.addArc(ego, definition.role(), -1.0);
                    break;
                }
                case SIBLING: {
                    arcTypes.put(definition.role(), "SIBLING");
                    result.addEdge(ego, definition.role(), -1.0);
                    break;
                }
                case SPOUSE: {
                    arcTypes.put(definition.role(), "SPOUSE");
                    result.addEdge(ego, definition.role(), 1.0);
                }
            }
        }
        for (RoleDefinition definition : model.roleDefinitions().toSortedList()) {
            String arcType;
            Node<Role> egoNode;
            Node<Role> alterNode;
            if (definition.inversion() != null) {
                alterNode = result.getNode(definition.role());
                egoNode = result.getNode(definition.inversion());
                arcType = (String)arcTypes.get(definition.inversion());
                if (arcType.equals("FATHER")) {
                    result.addArc(alterNode, egoNode, 1.0);
                } else if (arcType.equals("MOTHER")) {
                    result.addArc(alterNode, egoNode, -1.0);
                }
            }
            if (definition.composition() == null) continue;
            alterNode = result.getNode(definition.role());
            egoNode = result.getNode((Role)definition.composition().get(0));
            arcType = (String)arcTypes.get(definition.composition().get(1));
            if (arcType != null) {
                if (arcType.equals("FATHER")) {
                    result.addArc(egoNode, alterNode, 1.0);
                    continue;
                }
                if (arcType.equals("MOTHER")) {
                    result.addArc(egoNode, alterNode, -1.0);
                    continue;
                }
                if (arcType.equals("SPOUSE")) {
                    result.addEdge(egoNode, alterNode, 1.0);
                    continue;
                }
                if (!arcType.equals("SIBLING")) continue;
                result.addEdge(egoNode, alterNode, -1.0);
                continue;
            }
            for (Gender egoGender : model.roleDefinitions().getAlterGenders((Role)definition.composition().get(0))) {
                for (Gender alterGender : model.roleDefinitions().getAlterGenders((Role)definition.composition().get(1))) {
                    if (definition.alterGender() == null || !definition.alterGender().equals((Object)alterGender)) continue;
                    Role inverseRole = model.roleDefinitions().getInverseRole((Role)definition.composition().get(1), egoGender, alterGender);
                    arcType = (String)arcTypes.get(inverseRole);
                    if (arcType.equals("FATHER")) {
                        result.addArc(alterNode, egoNode, 1.0);
                        continue;
                    }
                    if (!arcType.equals("MOTHER")) continue;
                    result.addArc(alterNode, egoNode, -1.0);
                }
            }
        }
        return result;
    }
}

