/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.net;

import java.util.ArrayList;
import java.util.List;
import org.tip.puck.net.Gender;

public enum KinType {
    CHILD,
    SPOUSE,
    PARENT,
    WIFE(Gender.FEMALE),
    HUSBAND(Gender.MALE),
    MOTHER(Gender.FEMALE),
    FATHER(Gender.MALE),
    DAUGHTER(Gender.FEMALE),
    SON(Gender.MALE),
    UNKNOWN;

    private Gender gender;

    private KinType() {
        this.gender = Gender.UNKNOWN;
    }

    public static List<KinType> basicTypes() {
        ArrayList<KinType> result = new ArrayList<KinType>();
        result.add(CHILD);
        result.add(SPOUSE);
        result.add(PARENT);
        return result;
    }

    private KinType(Gender gender) {
        this.gender = gender;
    }

    public Gender getGender() {
        return this.gender;
    }

    public String signature() {
        String result;
        switch (this) {
            case CHILD: {
                result = "children";
                break;
            }
            case SPOUSE: {
                result = "spouses";
                break;
            }
            case PARENT: {
                result = "parents";
                break;
            }
            default: {
                result = null;
            }
        }
        return result;
    }

    public KinType inverse() {
        KinType result;
        switch (this) {
            case CHILD: {
                result = PARENT;
                break;
            }
            case PARENT: {
                result = CHILD;
                break;
            }
            default: {
                result = this;
            }
        }
        return result;
    }

    public String toString(Gender gender) {
        return this.gendered(gender).toString();
    }

    public KinType gendered(Gender gender) {
        KinType result;
        block0 : switch (gender) {
            case MALE: {
                switch (this) {
                    case CHILD: {
                        result = SON;
                        break block0;
                    }
                    case SPOUSE: {
                        result = HUSBAND;
                        break block0;
                    }
                    case PARENT: {
                        result = FATHER;
                        break block0;
                    }
                }
                result = null;
                break;
            }
            case FEMALE: {
                switch (this) {
                    case CHILD: {
                        result = DAUGHTER;
                        break block0;
                    }
                    case SPOUSE: {
                        result = WIFE;
                        break block0;
                    }
                    case PARENT: {
                        result = MOTHER;
                        break block0;
                    }
                }
                result = null;
                break;
            }
            default: {
                result = null;
            }
        }
        return result;
    }

    public KinType ungendered() {
        KinType result;
        switch (this) {
            case SPOUSE: 
            case WIFE: 
            case HUSBAND: {
                result = SPOUSE;
                break;
            }
            case PARENT: 
            case MOTHER: 
            case FATHER: {
                result = PARENT;
                break;
            }
            case CHILD: 
            case DAUGHTER: 
            case SON: {
                result = CHILD;
                break;
            }
            default: {
                result = this;
            }
        }
        return result;
    }

    public Integer toInt() {
        Integer result;
        switch (this) {
            case CHILD: {
                result = -1;
                break;
            }
            case SPOUSE: {
                result = 0;
                break;
            }
            case PARENT: {
                result = 1;
                break;
            }
            default: {
                result = null;
            }
        }
        return result;
    }

    public static KinType getRelation(int ord) {
        KinType result = KinType.values()[ord];
        return result;
    }

    public static KinType valueOf(String string) {
        return Enum.valueOf(KinType.class, string);
    }
}

