/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.io.paj;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import oldcore.calc.partitions.Partition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.net.Family;
import org.tip.puck.net.Gender;
import org.tip.puck.net.Individual;
import org.tip.puck.net.Net;

public class PAJFileOldcore {
    private static final Logger logger = LoggerFactory.getLogger(PAJFileOldcore.class);

    public void writePartition(PrintWriter out, Partition<Individual> partition, PartitionType type) {
        out.println("*Parition " + partition.getLabel());
        out.println("*vertices " + partition.nrItems());
        for (Individual individual : partition.getValues().keySet()) {
            switch (type) {
                case BY_INDEX: {
                    out.println(partition.getClusterIndex(individual));
                    break;
                }
                case BY_VALUE: {
                    out.println(partition.getVal(individual));
                    break;
                }
                case AS_VECTOR: {
                    out.println(partition.getVal(individual));
                }
            }
        }
    }

    public void writePartitions(PrintWriter out, List<Partition<Individual>> part, PartitionType type) throws IOException {
        logger.debug("Write partition data.");
        for (Partition<Individual> p : part) {
            this.writePartition(out, p, type);
        }
    }

    private static String arcLine(Individual ego, Individual alter) {
        String result = String.valueOf(ego.getId()) + " " + alter.getId() + " " + PAJFileOldcore.filiationIndex(ego.getGender(), alter.getGender());
        return result;
    }

    private static int filiationIndex(Gender parentGender, Gender childGender) {
        int result = 0;
        if (parentGender == Gender.MALE) {
            switch (childGender) {
                case MALE: {
                    result = 5;
                    break;
                }
                case FEMALE: {
                    result = 4;
                    break;
                }
                case UNKNOWN: {
                    result = 7;
                }
            }
        }
        if (parentGender == Gender.FEMALE) {
            switch (childGender) {
                case MALE: {
                    result = 3;
                    break;
                }
                case FEMALE: {
                    result = 2;
                    break;
                }
                case UNKNOWN: {
                    result = 6;
                }
            }
        }
        return result;
    }

    private static String shape(Gender gender) {
        String result;
        switch (gender) {
            case MALE: {
                result = "triangle";
                break;
            }
            case FEMALE: {
                result = "ellipse";
                break;
            }
            default: {
                result = "diamond";
            }
        }
        return result;
    }

    private static String vertexLine(Individual individual) {
        String result = String.valueOf(individual.getId()) + " '" + individual.getName() + "' " + PAJFileOldcore.shape(individual.getGender());
        return result;
    }

    public static void write(PrintWriter out, Net net) {
        logger.debug("Write network data.");
        out.println("*Network " + net.getLabel());
        out.println("*vertices " + net.size());
        for (Individual individual : net.individuals().toSortedList()) {
            out.println(PAJFileOldcore.vertexLine(individual));
        }
        out.println("*arcs");
        for (Family family : net.families()) {
            Individual husband = family.getHusband();
            Individual wife = family.getWife();
            if (husband != null && wife != null && family.isMarried()) {
                out.println(String.valueOf(wife.getId()) + " " + husband.getId() + " " + 1);
            }
            if (!family.isFertile()) continue;
            if (husband != null) {
                for (Individual child : family.getChildren()) {
                    out.println(PAJFileOldcore.arcLine(husband, child));
                }
            }
            if (wife == null) continue;
            for (Individual child : family.getChildren()) {
                out.println(PAJFileOldcore.arcLine(wife, child));
            }
        }
        out.println();
    }

    private static enum PartitionType {
        BY_INDEX,
        BY_VALUE,
        AS_VECTOR;

    }
}

