/*
 * Decompiled with CFR 0.152.
 */
package org.tip.puck.io.csv;

import com.vividsolutions.jts.geom.Coordinate;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tip.puck.PuckException;
import org.tip.puck.geo.Place;
import org.tip.puck.graphs.Graph;
import org.tip.puck.graphs.Node;

public class CSVFile {
    private static final Logger logger = LoggerFactory.getLogger(CSVFile.class);
    public static final String DEFAULT_CHARSET_NAME = "UTF-8";
    public static final int MAX_LINE_SIZE = 2048;

    public static HashMap<String, Place> load(File csvFile, Graph<?> graph) throws PuckException {
        HashMap<String, Place> returnHashedPlaces = new HashMap<String, Place>();
        try {
            BufferedReader br = new BufferedReader(new FileReader(csvFile.getAbsolutePath()));
            returnHashedPlaces = CSVFile.readLines(br, returnHashedPlaces, graph);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return returnHashedPlaces;
    }

    public static HashMap<String, Place> readLines(BufferedReader reader, HashMap<String, Place> hashPlaces, Graph<?> placesGraph) throws IOException {
        String nextLine;
        Graph graphPlaces = new Graph("GraphPlaces");
        ArrayList<String> places = new ArrayList<String>();
        for (Node<?> node : placesGraph.getNodes()) {
            places.add(node.getLabel());
        }
        int i = 0;
        while ((nextLine = reader.readLine()) != null) {
            String[] columnDetail = nextLine.split("\t", -1);
            Coordinate c = new Coordinate(Double.parseDouble(columnDetail[4]), Double.parseDouble(columnDetail[5]));
            hashPlaces.put(columnDetail[1], new Place(Integer.parseInt(columnDetail[0]), columnDetail[1], columnDetail[1], columnDetail[2], columnDetail[3], columnDetail[8], c));
            ++i;
        }
        System.out.println("End csv file" + hashPlaces.size());
        return hashPlaces;
    }
}

